/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.configurator;

import java.awt.Font;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.View;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import ru.softlogic.app.Commander;
import ru.softlogic.application.UncaughtExceptionListener;
import ru.softlogic.configurator.ApplicationView;
import ru.softlogic.configurator.resources.B;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.ProcessExecutor;
import ru.softlogic.system.util.os.OsApi;

public class Application
extends SingleFrameApplication {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startup() {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtExceptionListener());
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        UIManager.put("ScrollBar.width", 50);
        Properties prop = new Properties();
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader((InputStream)new FileInputStream(PathUtils.getAppHome() + File.separator + "trademark" + File.separator + "info.properties"), "utf-8");
            prop.load(isr);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(isr);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(isr);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)isr);
        String pr = prop.getProperty("skin", "org.pushingpixels.substance.api.skin.MarinerSkin");
        try {
            SubstanceLookAndFeel.setSkin((String)pr);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        OsApi.getInstance().setExecutor(new ProcessExecutor());
        UIManager.put("ScrollBar.width", 50);
        this.show((View)new ApplicationView(this));
    }

    protected void configureWindow(Window root) {
    }

    public static Application getApplication() {
        return (Application)Application.getInstance(Application.class);
    }

    public static void main(String[] args) {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            Commander commander = new Commander(null);
            Application.launch(Application.class, (String[])args);
        }
        catch (Exception ex) {
            Font font = new Font("Tahoma", 0, 23);
            UIDefaults uiDefaults = UIManager.getLookAndFeelDefaults();
            for (Object key : uiDefaults.keySet()) {
                String str_key;
                if (!(key instanceof String) || (str_key = (String)key).indexOf(".font") == -1) continue;
                UIManager.put(str_key, font);
            }
            Logger.getLogger((String)"start").error((Object)B.get("main.start.err"));
            JOptionPane.showMessageDialog(null, B.get("main.start.err"), B.get("dialog.error"), 0);
            return;
        }
    }
}

