/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util.hwd;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.hwd.LinuxSerialExtractor;
import ru.softlogic.system.util.hwd.SerialExtractor;

public class WindowsSerialExtractor
implements SerialExtractor {
    @Override
    public String getHddSerial() {
        String appHome = PathUtils.getAppHome();
        return this.getHddSerialNative(appHome.substring(0, appHome.indexOf(":")));
    }

    @Override
    public String getProcessorName() {
        return this.getProcessorNameNative();
    }

    private native String getHddSerialNative(String var1);

    private native String getProcessorNameNative();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Logger log = Logger.getLogger((String)"app");
        log.setAdditivity(false);
        File f = null;
        OutputStream os = null;
        InputStream is = null;
        try {
            int bt;
            f = File.createTempFile("hwdlogic", ".dll");
            os = new FileOutputStream(f);
            log.info((Object)("Architecture of THe OS: " + System.getProperty("os.arch")));
            String osArch = System.getProperty("os.arch");
            String realArch = osArch.endsWith("64") ? "64" : "32";
            is = realArch.equals("64") ? LinuxSerialExtractor.class.getResourceAsStream("hwdlogic64.dll") : LinuxSerialExtractor.class.getResourceAsStream("hwdlogic.dll");
            while ((bt = is.read()) != -1) {
                os.write(bt);
            }
            os.flush();
        }
        catch (IOException ex) {
            log.error((Object)ex, (Throwable)ex);
            log.error((Object)(LocBundle.getMessageLog((String)"rma.utils.ioerrldnatl") + " hwdlogic.dll"), (Throwable)ex);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception ex) {}
            try {
                os.close();
            }
            catch (Exception ex) {}
        }
        if (f != null) {
            System.load(f.getAbsolutePath());
        }
        try {
            if (f != null) {
                File[] listFiles;
                File dir = f.getParentFile();
                for (File file : listFiles = dir.listFiles()) {
                    if (!file.getName().contains("hwdlogic") || file.getName().equals(f.getName())) continue;
                    try {
                        file.delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)ex, (Throwable)ex);
        }
        f.deleteOnExit();
    }
}

