/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util.hwd;

import ru.softlogic.system.util.OsDetector;
import ru.softlogic.system.util.hwd.LinuxSerialExtractor;
import ru.softlogic.system.util.hwd.MacosSerialExtractor;
import ru.softlogic.system.util.hwd.SerialExtractor;
import ru.softlogic.system.util.hwd.VoidSerialExtractor;
import ru.softlogic.system.util.hwd.WindowsSerialExtractor;

public class SerialExtractorApi
implements SerialExtractor {
    private static SerialExtractorApi instance = new SerialExtractorApi();
    private String hddSerial;
    private String processorName;
    private SerialExtractor extractor;

    private SerialExtractorApi() {
        switch (OsDetector.current()) {
            case 2: {
                this.extractor = new WindowsSerialExtractor();
                break;
            }
            case 1: {
                this.extractor = new LinuxSerialExtractor();
                break;
            }
            case 3: {
                this.extractor = new MacosSerialExtractor();
            }
            default: {
                this.extractor = new VoidSerialExtractor();
            }
        }
    }

    public static SerialExtractorApi getInstance() {
        return instance;
    }

    @Override
    public String getHddSerial() {
        if (this.hddSerial == null) {
            this.hddSerial = this.extractor.getHddSerial();
        }
        return this.hddSerial;
    }

    @Override
    public String getProcessorName() {
        if (this.processorName == null) {
            this.processorName = this.extractor.getProcessorName();
        }
        return this.processorName;
    }

    public long getConfigurationId() {
        return 0L;
    }
}

