/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util.hwd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.system.util.hwd.SerialExtractor;

public class LinuxSerialExtractor
implements SerialExtractor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getHddSerial() {
        HashMap<String, String> mounts = new HashMap<String, String>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader("/etc/mtab"));
            String data = null;
            while ((data = br.readLine()) != null) {
                String[] strs = data.split(" |  ");
                if (strs.length < 2 || !strs[0].startsWith("/")) continue;
                mounts.put(strs[1], strs[0]);
            }
            String drive = null;
            if (mounts.get("/home") != null) {
                drive = (String)mounts.get("/home");
            } else if (mounts.get("/") != null) {
                drive = (String)mounts.get("/");
            }
            if (drive != null) {
                int pos;
                for (pos = drive.length() - 1; pos > 0 && Character.isDigit(drive.charAt(pos)); --pos) {
                }
                drive = drive.substring(0, pos + 1);
                String serial = null;
                serial = drive.startsWith("/dev/h") ? this.getIdeSerialNative(drive) : this.getScsiSerialNative(drive);
                if (serial != null) {
                    serial = serial.trim();
                }
                String string = serial;
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProcessorName() {
        String string;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader("/proc/cpuinfo"));
            String data = null;
            while ((data = br.readLine()) != null) {
                if (!data.startsWith("model name")) continue;
                String[] strs = data.split(":");
                if (strs.length != 2) continue;
                String string2 = strs[1].trim();
                return string2;
            }
            string = "";
            return string;
        }
        catch (Exception ex) {
            string = "";
            return string;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
    }

    private native String getIdeSerialNative(String var1);

    private native String getScsiSerialNative(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Logger log = Logger.getLogger((String)"app");
        log.setAdditivity(false);
        OutputStream os = null;
        InputStream is = null;
        File f = null;
        try {
            int bt;
            f = File.createTempFile("libhwdlogic", "so");
            os = new FileOutputStream(f);
            is = LinuxSerialExtractor.class.getResourceAsStream("libhwdlogic.so");
            while ((bt = is.read()) != -1) {
                os.write(bt);
            }
            os.flush();
        }
        catch (IOException ex) {
            log.error((Object)(LocBundle.getMessageLog((String)"rma.utils.ioerrldnatl") + " libhwdlogic.so"), (Throwable)ex);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
            try {
                os.close();
            }
            catch (Exception exception) {}
        }
        if (f != null) {
            System.load(f.getAbsolutePath());
        }
        f.deleteOnExit();
    }
}

