/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class PathUtils {
    public static String getAppDrive() {
        File file = new File(PathUtils.getAppHome());
        while (file.getParentFile() != null) {
            file = file.getParentFile();
        }
        return file.getPath().replace("\\", "");
    }

    public static String getAppHome() {
        String appHome = System.getProperty("app.home");
        if (appHome == null || appHome.isEmpty()) {
            File file = new File(new PathUtils().getPath());
            return new File(file.getParent()).getParent();
        }
        return appHome;
    }

    private String getPath() {
        try {
            return URLDecoder.decode(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath(), "utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            return this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        }
    }
}

