/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.events;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import ru.softlogic.rma.RmaAppContext;
import ru.softlogic.rma.app.Configuration;
import ru.softlogic.rma.connector.model.CurrentUser;

public class SessionEventDispatcher
extends EventQueue {
    long timeOfLastAction;
    RmaAppContext context;

    public SessionEventDispatcher(RmaAppContext context) {
        this.context = context;
    }

    @Override
    public void dispatchEvent(AWTEvent awtEvent) {
        if (CurrentUser.getInstance().getUserId() != null) {
            if (awtEvent.getID() != 1200) {
                this.timeOfLastAction = System.currentTimeMillis();
            }
            long lifeTime = Configuration.getInstance().getData().getSessionLifeTime();
            if (System.currentTimeMillis() - this.timeOfLastAction > lifeTime * 1000L * 60L) {
                this.context.sessionExpired();
                CurrentUser.getInstance().clear();
            }
        } else {
            this.timeOfLastAction = System.currentTimeMillis();
        }
        super.dispatchEvent(awtEvent);
    }
}

