/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.utils;

import rmai18n.LocBundle;

public class StateUtil {
    public static String formatState(short state) {
        switch (state) {
            case 0: {
                return LocBundle.getMessage((String)"rma.utils.statenew");
            }
            case 10: {
                return "\u041f\u043b\u0430\u0442\u0451\u0436 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d";
            }
            case 20: {
                return "\u0413\u043e\u0442\u043e\u0432 \u043a \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044e";
            }
            case 30: {
                return "\u041f\u0440\u0435\u0434\u0432\u0430\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430";
            }
            case 40: {
                return "\u0413\u043e\u0442\u043e\u0432 \u043a \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044e";
            }
            case 60: {
                return "\u041f\u0440\u043e\u0432\u0435\u0434\u0451\u043d";
            }
            case 70: {
                return "\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0441\u0440\u0435\u0434\u0441\u0442\u0432";
            }
            case 80: {
                return "\u041e\u0448\u0438\u0431\u043a\u0430";
            }
            case 90: {
                return LocBundle.getMessage((String)"rma.utils.statecorrect");
            }
        }
        return LocBundle.getMessage((String)"rma.utils.unknown");
    }

    public static String formatAsbState(short state) {
        switch (state) {
            case 2: {
                return LocBundle.getMessage((String)"rma.model.yes");
            }
        }
        return LocBundle.getMessage((String)"rma.model.no");
    }

    public static String formatSubstate(short state, short substate) {
        switch (state) {
            case 0: {
                switch (substate) {
                    case 0: 
                    case 1: 
                    case 2: {
                        return LocBundle.getMessage((String)"rma.utils.sstatenew");
                    }
                }
                return LocBundle.getMessage((String)"rma.utils.unknown");
            }
            case 10: {
                switch (substate) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 8: 
                    case 9: {
                        return "\u0417\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d";
                    }
                }
                return LocBundle.getMessage((String)"rma.utils.unknown");
            }
            case 20: {
                switch (substate) {
                    case 1: {
                        return LocBundle.getMessage((String)"rma.utils.sstatewroffready");
                    }
                    case 2: {
                        return LocBundle.getMessage((String)"rma.utils.sstatewroffbulk");
                    }
                    case 3: {
                        return LocBundle.getMessage((String)"rma.utils.sstatewroffsingle");
                    }
                    case 4: {
                        return LocBundle.getMessage((String)"rma.utils.sstatewrofferr");
                    }
                }
                return LocBundle.getMessage((String)"rma.utils.unknown");
            }
            case 40: {
                switch (substate) {
                    case 1: {
                        return LocBundle.getMessage((String)"rma.utils.sstateprocready");
                    }
                    case 2: {
                        return LocBundle.getMessage((String)"rma.utils.sstateprocprov");
                    }
                    case 3: {
                        return LocBundle.getMessage((String)"rma.utils.sstateprocrun");
                    }
                    case 4: {
                        return LocBundle.getMessage((String)"rma.utils.sstateprocerr");
                    }
                    case 5: {
                        return LocBundle.getMessage((String)"rma.utils.sstateunkwn");
                    }
                }
                return LocBundle.getMessage((String)"rma.utils.unknown");
            }
            case 60: {
                return "\u0423\u0441\u043f\u0435\u0445";
            }
            case 70: {
                switch (substate) {
                    case 1: {
                        return LocBundle.getMessage((String)"rma.utils.sstateenrready");
                    }
                    case 2: {
                        return LocBundle.getMessage((String)"rma.utils.sstateenrrun");
                    }
                }
                return LocBundle.getMessage((String)"rma.utils.unknown");
            }
            case 80: {
                switch (substate) {
                    case 1: {
                        return LocBundle.getMessage((String)"rma.utils.sstatecnluser");
                    }
                    case 2: {
                        return LocBundle.getMessage((String)"rma.utils.sstatecnlagent");
                    }
                    case 3: {
                        return LocBundle.getMessage((String)"rma.utils.sstatecnlsupp");
                    }
                    case 4: {
                        return LocBundle.getMessage((String)"rma.utils.sstateerrmoney");
                    }
                    case 5: {
                        return LocBundle.getMessage((String)"rma.utils.sstateerrprov");
                    }
                    case 7: {
                        return "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u0438\u0440\u0443\u0435\u043c\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430";
                    }
                }
                return LocBundle.getMessage((String)"rma.utils.unknown");
            }
            case 90: {
                return LocBundle.getMessage((String)"rma.utils.sstatesucc");
            }
        }
        return LocBundle.getMessage((String)"rma.utils.unknown");
    }

    public static String formatError(Short error) {
        if (error == null) {
            return LocBundle.getMessage((String)"rma.utils.errcnull");
        }
        switch (error) {
            case -2: {
                return LocBundle.getMessage((String)"rma.utils.errcopntfnd");
            }
            case -1: {
                return LocBundle.getMessage((String)"rma.utils.errceerirttodb");
            }
            case 0: {
                return LocBundle.getMessage((String)"rma.utils.errcno");
            }
            case 1: {
                return LocBundle.getMessage((String)"rma.utils.errcnumbincornod");
            }
            case 2: {
                return LocBundle.getMessage((String)"rma.utils.errcnumbincord");
            }
            case 3: {
                return LocBundle.getMessage((String)"rma.utils.errcsummout");
            }
            case 4: {
                return LocBundle.getMessage((String)"rma.utils.errcprovserv");
            }
            case 5: {
                return LocBundle.getMessage((String)"rma.utils.errcauth");
            }
            case 6: {
                return LocBundle.getMessage((String)"rma.utils.errcoperserv");
            }
            case 7: {
                return LocBundle.getMessage((String)"rma.utils.errcproverr");
            }
            case 8: {
                return LocBundle.getMessage((String)"rma.utils.errcmoney");
            }
            case 9: {
                return LocBundle.getMessage((String)"rma.utils.errcparams");
            }
            case 10: {
                return LocBundle.getMessage((String)"rma.utils.errcfatalprov");
            }
            case 12: {
                return LocBundle.getMessage((String)"rma.utils.errcmoneynod");
            }
            case 13: {
                return LocBundle.getMessage((String)"rma.utils.errctimeout");
            }
            case 14: {
                return LocBundle.getMessage((String)"rma.utils.errccnlpayer");
            }
            case 15: {
                return LocBundle.getMessage((String)"rma.utils.errcmoneyagent");
            }
            case 16: {
                return LocBundle.getMessage((String)"rma.utils.errccnlsup");
            }
        }
        return LocBundle.getMessage((String)"rma.utils.errcunkwn");
    }

    public static String formatFinal(short finalStatus) {
        return finalStatus == 1 ? "\u0414\u0430" : "\u041d\u0435\u0442";
    }

    public static String formatServerError(int serverError) {
        switch (serverError) {
            case 0: {
                return LocBundle.getMessage((String)"rma.utils.servsucc");
            }
            case 1: {
                return LocBundle.getMessage((String)"rma.utils.servaden");
            }
            case 2: {
                return LocBundle.getMessage((String)"rma.utils.servnopoint");
            }
            case 3: {
                return LocBundle.getMessage((String)"rma.utils.servnokassa");
            }
            case 4: {
                return LocBundle.getMessage((String)"rma.utils.servserverr");
            }
            case 5: {
                return LocBundle.getMessage((String)"rma.utils.servtoold");
            }
        }
        return LocBundle.getMessage((String)"rma.utils.errcunkwn");
    }

    public static boolean isCancelled(short state, short substate) {
        return state == 80 && (substate == 1 || substate == 2 || substate == 3);
    }

    public static boolean isFinalState(short state, short substate) {
        return state != 60 && state != 80;
    }
}

