/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jxls.common.Context;
import org.jxls.util.JxlsHelper;
import ru.softlogic.rma.connector.model.CurrentUser;
import ru.softlogic.rma.connector.model.Dealer;
import ru.softlogic.rma.connector.model.Operator;
import ru.softlogic.rma.connector.model.Point;
import ru.softlogic.rma.connector.model.References;
import ru.softlogic.rma.connector.model.ShiftInfo;
import ru.softlogic.rma.connector.model.directory.shift.ShiftTypeCodes;
import ru.softlogic.rma.persistence.BalanceRecord;
import ru.softlogic.rma.persistence.Record;
import ru.softlogic.rma.persistence.v2.PersistenceManager;
import ru.softlogic.rma.utils.PathUtils;
import ru.softlogic.rma.utils.StateUtil;
import ru.softlogic.rma.utils.SumFormatter;

public class ReportGenerator {
    private References references;

    public void generateBalance(Date dateBegin, Date dateEnd) throws Exception {
    }

    public void setReferences(References references) {
        this.references = references;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateXLSReportFroShift(ShiftInfo inf, String operatorName) throws Exception {
        Dealer dealer = null;
        Operator operator = null;
        Point point = null;
        if (this.references != null) {
            dealer = this.references.getDealer();
            operator = this.references.getOperator();
            point = this.references.getPoint();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.YYYY HH-mm");
        SimpleDateFormat sdf1 = new SimpleDateFormat("dd.MM.yyyy");
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.put("point", point);
        beans.put("operator", operator);
        beans.put("dealer", dealer);
        beans.put("shiftTyte", ShiftTypeCodes.OPERATING.equals(inf.getShiftType()) ? "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u0430\u044f" : "\u0412\u043d\u0435\u043e\u043f\u0435\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u0430\u044f");
        beans.put("shiftId", inf.getIdShift());
        beans.put("currentKassir", operatorName);
        beans.put("openKassirName", inf.getOpenKassirName());
        beans.put("closeKassirName", inf.getCloseKassirName() == null ? "-" : inf.getCloseKassirName());
        beans.put("operatingDayName", inf.getOperDay());
        beans.put("openDate", sdf.format(inf.getStartTime()));
        beans.put("closeDate", inf.getState() == 0 ? "-" : sdf.format(inf.getCloseTime()));
        beans.put("balanceInfo", dealer);
        beans.put("sumFormatter", SumFormatter.class);
        beans.put("rowCounter", new RowCounter());
        List<BalanceRecord> records = null;
        records = PersistenceManager.getInstance().selectBalanceInfoForShift(inf.getIdShiftServer(), CurrentUser.getInstance().getUserId());
        beans.put("records", records);
        String template = PathUtils.getAppHome() + File.separator + "resources/templates/shifts.xlsx";
        String result = PathUtils.getTmpPath() + "result-reports" + sdf1.format(new Date()) + ".xlsx";
        if (new File(template).exists()) {
            InputStream is = null;
            OutputStream os = null;
            try {
                Context context = new Context(beans);
                is = new FileInputStream(template);
                os = new FileOutputStream(result);
                JxlsHelper.getInstance().processTemplate(is, os, context);
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.flush();
                    os.close();
                }
            }
        } else {
            throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0448\u0430\u0431\u043b\u043e\u043d");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateXLSReportShiftOperations(ShiftInfo inf, String operatorName) throws Exception {
        Dealer dealer = null;
        Operator operator = null;
        Point point = null;
        if (this.references != null) {
            dealer = this.references.getDealer();
            operator = this.references.getOperator();
            point = this.references.getPoint();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.YYYY HH-mm");
        SimpleDateFormat sdf1 = new SimpleDateFormat("dd.MM.yyyy");
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.put("point", point);
        beans.put("operator", operator);
        beans.put("dealer", dealer);
        beans.put("shiftTyte", ShiftTypeCodes.OPERATING.equals(inf.getShiftType()) ? "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u0430\u044f" : "\u0412\u043d\u0435\u043e\u043f\u0435\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u0430\u044f");
        beans.put("shiftId", inf.getIdShift());
        beans.put("currentKassir", operatorName);
        beans.put("openKassirName", inf.getOpenKassirName());
        beans.put("closeKassirName", inf.getCloseKassirName() == null ? "-" : inf.getCloseKassirName());
        beans.put("operatingDayName", inf.getOperDay());
        beans.put("openDate", sdf.format(inf.getStartTime()));
        beans.put("closeDate", inf.getState() == 0 ? "-" : sdf.format(inf.getCloseTime()));
        beans.put("balanceInfo", dealer);
        beans.put("sumFormatter", SumFormatter.class);
        beans.put("rowCounter", new RowCounter());
        beans.put("stateUtils", StateUtil.class);
        beans.put("sdf", new SimpleDateFormat("YYYY-MM-dd HH:mm:ss"));
        List<Record> records = null;
        records = PersistenceManager.getInstance().getOperationsByShift(inf.getIdShiftServer());
        beans.put("records", records);
        String template = PathUtils.getAppHome() + File.separator + "/resources/templates/operations.xlsx";
        String result = PathUtils.getTmpPath() + "operations-reports" + sdf1.format(new Date()) + ".xlsx";
        if (new File(template).exists()) {
            InputStream is = null;
            OutputStream os = null;
            try {
                Context context = new Context(beans);
                is = new FileInputStream(template);
                os = new FileOutputStream(result);
                JxlsHelper.getInstance().processTemplate(is, os, context);
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.flush();
                    os.close();
                }
            }
        } else {
            throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0448\u0430\u0431\u043b\u043e\u043d");
        }
        return result;
    }

    public class RowCounter {
        int rowNum = 1;

        public int next() {
            return this.rowNum++;
        }
    }
}

