/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import ru.softlogic.rma.connector.model.References;
import ru.softlogic.rma.utils.PathUtils;
import ru.softlogic.rma.version.RmaVersion;

public class ReferenceUtil {
    public static References read() {
        String path = PathUtils.getAppHome() + File.separator + "data" + File.separator + "reference";
        References refs = null;
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(path));){
            Object loadedObj = ois.readObject();
            refs = (References)loadedObj;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return refs;
    }

    public static void save(References ref) {
        if (ref == null) {
            return;
        }
        String path = PathUtils.getAppHome() + File.separator + "data";
        new File(path).mkdir();
        path = path + File.separator + "reference";
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(path));){
            oos.writeObject(ref);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void add(References refs) throws IOException {
        if (refs == null) {
            throw new IllegalArgumentException("Need dictionaries");
        }
        References old = ReferenceUtil.update(ReferenceUtil.read(), refs);
        old.setSoftware(RmaVersion.getVersion());
    }

    public static References update(References old, References refs) {
        if (old == null) {
            old = new References();
        }
        if (refs == null) {
            return old;
        }
        if (refs.getDealer() != null) {
            old.setDealer(refs.getDealer());
        }
        if (refs.getMenu() != null) {
            old.setMenu(refs.getMenu());
        }
        if (refs.getChanges() != null) {
            old.setChanges(refs.getChanges());
            old.mergeMenuChanges();
        }
        if (refs.getOperator() != null) {
            old.setOperator(refs.getOperator());
        }
        if (refs.getPersonalNumbers() != null) {
            old.setPersonalNumbers(refs.getPersonalNumbers());
        }
        if (refs.getPoint() != null) {
            old.setPoint(refs.getPoint());
        }
        if (refs.getUpdateLogin() != null) {
            old.setUpdateLogin(refs.getUpdateLogin());
        }
        if (refs.getUpdatePassword() != null) {
            old.setUpdatePassword(refs.getUpdatePassword());
        }
        if (refs.getUpdateUrl() != null) {
            old.setUpdateUrl(refs.getUpdateUrl());
        }
        if (refs.getAuth() != null) {
            old.setAuth(refs.getAuth());
        }
        if (refs.getPd4Records() != null) {
            old.setPd4Records(refs.getPd4Records());
        }
        if (refs.getSheduleReference() != null) {
            old.setSheduleReference(refs.getSheduleReference());
        }
        if (refs.getShiftTypeReference() != null) {
            old.setShiftTypeReference(refs.getShiftTypeReference());
        }
        if (refs.getPersons() != null) {
            old.setPersons(refs.getPersons());
        }
        old.setVersion(refs.getVersion());
        return old;
    }
}

