/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.utils;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.rma.connector.model.Payment;
import ru.softlogic.rma.persistence.Record;
import ru.softlogic.rma.persistence.RmaAttribute;

public class RecordsUtils {
    public static Record merge(Record[] records) {
        Record record = new Record();
        int sumIncome = 0;
        int sumOutcome = 0;
        int sumComm = 0;
        HashMap<String, RmaAttribute> attrs = new HashMap<String, RmaAttribute>();
        int count = 1;
        for (Record rec : records) {
            sumIncome += rec.getSumIncome();
            sumOutcome += rec.getSumOutcome();
            sumComm += rec.getSumComm();
            RmaAttribute id1Attr = new RmaAttribute();
            id1Attr.setKey("acc" + count);
            id1Attr.setKeyTitle(rec.getAccountTitle());
            id1Attr.setValue(rec.getAccount());
            id1Attr.setValueTitle(rec.getAccountValueTitle());
            attrs.put(id1Attr.getKey(), id1Attr);
            attrs.putAll(rec.getAttributes());
            ++count;
        }
        record.setServiceId(records[0].getServiceId());
        record.setServiceName(records[0].getServiceName());
        record.setCommissionId(records[0].getCommissionId());
        record.setDoc(records[0].getDoc());
        record.setCreated(records[0].getCreated());
        record.setAccount(records[0].getAccount());
        record.setAccountTitle(records[0].getAccountTitle());
        record.setAccountValueTitle(records[0].getAccountValueTitle());
        record.setAccount2(records[0].getAccount2());
        record.setAccount2Title(records[0].getAccount2Title());
        record.setAccount2ValueTitle(records[0].getAccount2ValueTitle());
        record.setSumOutcome(sumOutcome);
        record.setSumIncome(sumIncome);
        record.setSumComm(sumComm);
        record.setAttributes(attrs);
        record.setComment(records[0].getComment());
        record.setDocType(records[0].getDocType());
        record.setState(records[0].getState());
        record.setSubstate(records[0].getSubstate());
        record.setLocalState(records[0].getLocalState());
        record.setId(records[0].getId());
        record.setSumFee(records[0].getSumFee());
        record.setCrc(records[0].getCrc());
        record.setIdShift(records[0].getIdShift());
        return record;
    }

    private Payment[] rec2pay(Record[] records) {
        Payment[] payments = new Payment[records.length];
        for (int i = 0; i < records.length; ++i) {
            payments[i] = RecordsUtils.rec2pay(records[i]);
        }
        return payments;
    }

    public static Payment rec2pay(Record rec) {
        Payment pay = new Payment();
        pay.setId(rec.getId());
        pay.setPid(rec.getParentId());
        pay.setDoc(rec.getDoc());
        pay.setCreated(rec.getCreated());
        pay.setService(rec.getServiceId());
        pay.setState(rec.getState());
        pay.setAccount(rec.getAccount());
        pay.setAccount2(rec.getAccount2());
        pay.setForm(RecordsUtils.atrMap2StrMap(rec.getAttributes()));
        pay.setCommission(rec.getCommissionId());
        pay.setSumIncome(rec.getSumIncome());
        pay.setSumOutcome(rec.getSumOutcome());
        pay.setSumComm(rec.getSumComm());
        pay.setSumFee(rec.getSumFee());
        pay.setComment(rec.getComment());
        pay.setIdUser(rec.getIdPerson());
        pay.setIdShift(rec.getIdShift());
        LinkedList<InputElement> elements = new LinkedList<InputElement>();
        for (String key : rec.getAttributes().keySet()) {
            RmaAttribute attr = rec.getAttributes().get(key);
            elements.add(new InputElement(attr.getKey(), attr.getKeyTitle(), attr.getValue(), attr.getValueTitle(), 0));
        }
        pay.setInputElements(elements);
        return pay;
    }

    public static Map<String, String> atrMap2StrMap(Map<String, RmaAttribute> attributes) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String key : attributes.keySet()) {
            map.put(key, attributes.get(key).getValue());
        }
        return map;
    }
}

