/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.utils;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import rmai18n.LocBundle;
import ru.softlogic.rma.utils.PathUtils;

public class RSParser {
    private static RSParser instance = new RSParser();
    private List<String> regexes;
    private List<String> budgetRegexes;
    private String currentRegex;
    private String currentBudgetRegex;

    private RSParser() {
        this.init(new File(PathUtils.getAppHome() + File.separator + "resources" + File.separator + "addforms" + File.separator + "rs.xml"));
    }

    private void init(File file) {
        Logger log = Logger.getLogger((String)"pay");
        this.currentRegex = "";
        this.currentBudgetRegex = "";
        log.info((Object)(LocBundle.getMessageLog((String)"rma.univers.fndfilefields") + " " + file.getAbsolutePath()));
        if (file != null && file.exists() && file.canRead()) {
            try {
                log.debug((Object)LocBundle.getMessageLog((String)"rma.univers.tryreadfilefields"));
                SAXReader reader = new SAXReader();
                Document document = reader.read(file);
                this.regexes = new LinkedList<String>();
                List regexsList = document.selectNodes("rss/rs");
                if (regexsList != null) {
                    for (Node field : regexsList) {
                        this.regexes.add(field.valueOf("@regex"));
                    }
                }
                log.info((Object)("\u041f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u043e " + this.regexes.size() + " \u0441\u0447\u0435\u0442\u043e\u0432."));
                this.budgetRegexes = new LinkedList<String>();
                List budgetRegexsList = document.selectNodes("rss/recipient-acc");
                if (budgetRegexsList != null) {
                    for (Node field : budgetRegexsList) {
                        this.budgetRegexes.add(field.valueOf("@regex"));
                    }
                }
                log.info((Object)("\u041f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u043e " + this.budgetRegexes.size() + " \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u044b\u0445 \u0441\u0447\u0435\u0442\u043e\u0432."));
                log.info((Object)"\u0424\u0430\u0439\u043b rs.xml \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d.");
                return;
            }
            catch (Exception ex) {
                log.error((Object)(LocBundle.getMessageLog((String)"rma.univers.fieldreaderr") + " "), (Throwable)ex);
            }
        } else {
            log.info((Object)LocBundle.getMessageLog((String)"rma.univers.fndfilefieldserr"));
        }
        this.regexes = null;
        this.budgetRegexes = null;
    }

    public static RSParser getInstance() {
        return instance;
    }

    public boolean checkRS(String recipientRS) {
        if (recipientRS == null) {
            return false;
        }
        if (this.regexes == null) {
            return false;
        }
        if (!this.currentRegex.isEmpty() && recipientRS.matches(this.currentRegex)) {
            return true;
        }
        for (String regex : this.regexes) {
            if (!recipientRS.matches(regex)) continue;
            this.currentRegex = regex;
            return true;
        }
        this.currentRegex = "";
        return false;
    }

    public boolean checkBudgetRS(String recipientRS) {
        if (recipientRS == null) {
            return false;
        }
        if (this.budgetRegexes == null) {
            return false;
        }
        if (!this.currentBudgetRegex.isEmpty() && recipientRS.matches(this.currentBudgetRegex)) {
            return true;
        }
        for (String regex : this.budgetRegexes) {
            if (!recipientRS.matches(regex)) continue;
            this.currentBudgetRegex = regex;
            return true;
        }
        this.currentBudgetRegex = "";
        return false;
    }
}

