/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.utils;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;

public class ObjectReadWriteStream {
    private RandomAccessFile file;

    public ObjectReadWriteStream(String fileName) throws FileNotFoundException {
        try {
            this.file = new RandomAccessFile(fileName, "rwd");
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("Can't create file: " + fileName);
        }
    }

    public void writeObject(Serializable object) throws IOException {
        this.file.setLength(0L);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream outputStream = new ObjectOutputStream(baos);
        outputStream.writeObject(object);
        outputStream.close();
        this.file.write(baos.toByteArray());
    }

    public Object readObject() {
        try {
            this.file.seek(0L);
            ObjectInputStream inputStream = new ObjectInputStream(new RandomInputStream());
            Object result = inputStream.readObject();
            inputStream.close();
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void close() throws IOException {
        this.file.close();
    }

    private class RandomInputStream
    extends InputStream {
        private RandomInputStream() {
        }

        @Override
        public int read() throws IOException {
            return ObjectReadWriteStream.this.file.read();
        }
    }

    private class RandomOutputStream
    extends OutputStream {
        private RandomOutputStream() {
        }

        @Override
        public void write(int i) throws IOException {
            ObjectReadWriteStream.this.file.write(i);
        }
    }
}

