/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.utils;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import ru.softlogic.rma.utils.PathUtils;

public class ImageFactory {
    private static ImageFactory instance = new ImageFactory();
    private Map<String, ImageIcon> images = new HashMap<String, ImageIcon>();

    private ImageFactory() {
    }

    public static ImageFactory getInstance() {
        return instance;
    }

    public Icon getLogo(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        ImageIcon imageIcon = this.images.get(name);
        if (imageIcon == null) {
            BufferedImage image = null;
            try {
                image = ImageIO.read(new File(PathUtils.getAppHome() + File.separator + "img" + File.separator + name));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (image != null) {
                imageIcon = new ImageIcon(image);
                this.images.put(name, imageIcon);
            }
        }
        return imageIcon;
    }
}

