/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;

public class FontResizer {
    public static void process(Integer scale) {
        if (scale == null) {
            return;
        }
        for (Window f : JFrame.getWindows()) {
            FontResizer.process(f, scale);
        }
    }

    public static void process(Container container, Integer scale) {
        if (container == null || scale == null) {
            return;
        }
        for (Component c : container.getComponents()) {
            if (c == null) continue;
            if (c instanceof JComponent) {
                JComponent jc = (JComponent)c;
                Font f = c.getFont();
                if (f != null) {
                    TitledBorder tb;
                    c.setFont(f.deriveFont((float)(f.getSize() * scale) * 1.0f / 100.0f));
                    if (jc.getBorder() != null && jc.getBorder() instanceof TitledBorder && (f = (tb = (TitledBorder)jc.getBorder()).getTitleFont()) != null) {
                        tb.setTitleFont(f.deriveFont((float)(f.getSize() * scale) * 1.0f / 100.0f));
                    }
                }
            }
            if (c instanceof JTabbedPane) {
                JTabbedPane jTabbedPane = (JTabbedPane)c;
            }
            if (!(c instanceof Container)) continue;
            FontResizer.process((Container)c, scale);
        }
    }

    public static void process(JFrame frame, Integer scale) {
        if (frame == null || scale == null) {
            return;
        }
        FontResizer.process(frame.getRootPane(), scale);
        if (frame.getJMenuBar() != null) {
            JMenuBar menuBar = frame.getJMenuBar();
            Font font = menuBar.getFont();
            if (font != null) {
                menuBar.setFont(font.deriveFont((float)(font.getSize() * scale) * 1.0f / 100.0f));
            }
            for (int i = 0; i < menuBar.getMenuCount(); ++i) {
                JMenu menu = menuBar.getMenu(i);
                if (menu == null) continue;
                for (int j = 0; j < menu.getItemCount(); ++j) {
                    JMenuItem mi = menu.getItem(j);
                    if (mi == null || (font = mi.getFont()) == null) continue;
                    mi.setFont(font.deriveFont((float)(font.getSize() * scale) * 1.0f / 100.0f));
                }
            }
        }
    }

    public static void process(JMenuBar menuBar, int scale) {
        if (menuBar == null) {
            return;
        }
        Font font = menuBar.getFont();
        if (font != null) {
            menuBar.setFont(font.deriveFont((float)(font.getSize() * scale) * 1.0f / 100.0f));
        }
        for (int i = 0; i < menuBar.getMenuCount(); ++i) {
            JMenu menu = menuBar.getMenu(i);
            for (int j = 0; j < menu.getItemCount(); ++j) {
                JMenuItem mi = menu.getItem(i);
                font = mi.getFont();
                if (font == null) continue;
                mi.setFont(font.deriveFont((float)(font.getSize() * scale) * 1.0f / 100.0f));
            }
        }
    }
}

