/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import ru.softlogic.rma.utils.FileUtilException;

public class FileUtil {
    public static File checkDir(String path) throws FileUtilException {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("Wrong path");
        }
        try {
            File file = new File(path);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    throw new FileUtilException("This is not directory");
                }
                if (!file.canExecute()) {
                    throw new FileUtilException("Directory is not available for viewing");
                }
                if (!file.canRead()) {
                    throw new FileUtilException("Directory is not available for reading");
                }
                if (!file.canWrite()) {
                    throw new FileUtilException("Directory is not available for writing");
                }
            } else if (!file.mkdirs()) {
                throw new FileUtilException("Can not create directory");
            }
            return file;
        }
        catch (Throwable ex) {
            throw new FileUtilException(ex.getMessage());
        }
    }

    public static File checkFile(String path) throws FileUtilException {
        if (path == null) {
            throw new IllegalArgumentException("Wrong path");
        }
        try {
            File file = new File(path);
            if (file.exists()) {
                if (!file.isFile()) {
                    throw new FileUtilException("This is not file");
                }
                if (!file.canRead()) {
                    throw new FileUtilException("File is not available for reading");
                }
                if (!file.canWrite()) {
                    throw new FileUtilException("File is not available for writing");
                }
            } else {
                FileUtil.checkDir(file.getParent());
                if (!file.createNewFile()) {
                    throw new FileUtilException("Can not create file");
                }
            }
            return file;
        }
        catch (Throwable ex) {
            throw new FileUtilException(ex.getMessage());
        }
    }

    public static String readFile(File file) throws FileUtilException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception ex) {
            throw new FileUtilException(ex);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void writeFile(File file, String content) throws FileUtilException {
        FileUtil.checkFile(file.getAbsolutePath());
        BufferedWriter br = null;
        try {
            br = new BufferedWriter(new FileWriter(file));
            br.write(content, 0, content.length());
            br.flush();
        }
        catch (Exception ex) {
            throw new FileUtilException(ex);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void writeFile(File file, InputStream from) throws FileUtilException {
        FileUtil.checkFile(file.getAbsolutePath());
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = from.read(buf)) > -1) {
                fos.write(buf, 0, len);
            }
        }
        catch (Exception ex) {
            throw new FileUtilException(ex);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
            if (from != null) {
                try {
                    from.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static boolean mkParentDirs(File file) throws FileUtilException {
        if (!file.getParentFile().exists()) {
            if (FileUtil.mkParentDirs(file.getParentFile())) {
                return file.getParentFile().mkdir();
            }
            throw new FileUtilException("Can not create directory " + file.getParentFile().getAbsolutePath());
        }
        return true;
    }
}

