/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.utils;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import rmai18n.LocBundle;
import ru.softlogic.rma.utils.PathUtils;

public class EditFieldsParser {
    private Map<String, List<String>> fields;

    public EditFieldsParser() {
        this.init(new File(PathUtils.getAppHome() + File.separator + "resources" + File.separator + "addforms" + File.separator + "edit_fields.xml"));
    }

    private void init(File file) {
        Logger log = Logger.getLogger((String)"pay");
        LinkedList<String> generalFields = new LinkedList<String>();
        HashMap<String, List<String>> serviceFields = new HashMap<String, List<String>>();
        log.info((Object)(LocBundle.getMessageLog((String)"rma.univers.fndfilefields") + " " + file.getAbsolutePath()));
        if (file != null && file.exists() && file.canRead()) {
            try {
                log.debug((Object)LocBundle.getMessageLog((String)"rma.univers.tryreadfilefields"));
                SAXReader reader = new SAXReader();
                Document document = reader.read(file);
                List fieldsList = document.selectNodes("edit/field");
                if (fieldsList != null) {
                    for (Node field : fieldsList) {
                        generalFields.add(field.valueOf("@name"));
                    }
                    serviceFields.put("general", generalFields);
                }
                Element root = document.getRootElement();
                Iterator i = root.elementIterator("service");
                while (i.hasNext()) {
                    Element service = (Element)i.next();
                    if (serviceFields.get(service.valueOf("@service-id")) != null) continue;
                    fieldsList.clear();
                    fieldsList = service.selectNodes("field");
                    if (fieldsList == null) continue;
                    LinkedList<String> flist = new LinkedList<String>();
                    for (Node field : fieldsList) {
                        flist.add(field.valueOf("@name"));
                    }
                    serviceFields.put(service.valueOf("@service-id"), flist);
                }
                log.info((Object)(LocBundle.getMessageLog((String)"rma.univers.readfilefieldsok") + serviceFields));
                this.fields = serviceFields;
                return;
            }
            catch (Exception ex) {
                log.error((Object)(LocBundle.getMessageLog((String)"rma.univers.fieldreaderr") + " "), (Throwable)ex);
            }
        } else {
            log.info((Object)LocBundle.getMessageLog((String)"rma.univers.fndfilefieldserr"));
        }
        this.fields = null;
    }

    public boolean checkField(String idService, String idFields) {
        List<String> flist;
        if (this.fields == null || this.fields.isEmpty()) {
            return false;
        }
        if (this.fields.get(idService) != null) {
            if (!this.fields.get(idService).isEmpty()) {
                return this.fields.get(idService).contains(idFields);
            }
            return false;
        }
        return this.fields.get("general") != null && !this.fields.get("general").isEmpty() && (flist = this.fields.get("general")).contains(idFields);
    }
}

