/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.rma.utils.FileUtil;
import ru.softlogic.rma.utils.PathUtils;
import ru.softlogic.rma.utils.ThreadUtil;

public class DocSequence {
    private short value;
    private int lastYear;
    private String point;

    public DocSequence(String point) {
        this.point = point;
    }

    public short nextDoc() throws Exception {
        RandomAccessFile raf = null;
        FileLock lock = null;
        try {
            File f = new File(PathUtils.getAppHome() + File.separator + "sequences" + File.separator + this.point + File.separator + "doc_seq");
            if (!f.exists()) {
                try {
                    FileUtil.mkParentDirs(f);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            raf = new RandomAccessFile(PathUtils.getAppHome() + File.separator + "sequences" + File.separator + this.point + File.separator + "doc_seq", "rw");
            FileChannel channel = raf.getChannel();
            try {
                lock = this.tryToLock(channel);
                if (lock == null) {
                    throw new Exception(LocBundle.getMessageEx((String)"rma.doc_seq.cantlock"));
                }
                this.load(raf);
                this.value = (short)(this.value + 1);
                if (this.value < 1) {
                    this.value = 1;
                }
                if (this.lastYear != new GregorianCalendar().get(1)) {
                    this.value = 1;
                    this.lastYear = new GregorianCalendar().get(1);
                }
                this.save(raf);
                short s = this.value;
                return s;
            }
            catch (IOException ex) {
                try {
                    Logger.getLogger((String)"app").error((Object)ex, (Throwable)ex);
                    throw new Exception(LocBundle.getMessageEx((String)"rma.doc_seq.cantlock"));
                }
                catch (FileNotFoundException ex2) {
                    Logger.getLogger((String)"app").error((Object)ex2, (Throwable)ex2);
                    throw new Exception(LocBundle.getMessageEx((String)"rma.doc_seq.cantlock"));
                }
            }
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException iOException) {}
            }
            if (lock != null) {
                try {
                    lock.release();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public short getCurrent() {
        return this.value;
    }

    private void load(RandomAccessFile raf) {
        try {
            this.value = raf.readShort();
            this.lastYear = raf.readInt();
        }
        catch (Exception ex) {
            this.value = 0;
            this.lastYear = new GregorianCalendar().get(1);
            Logger.getLogger((String)"app").error((Object)ex, (Throwable)ex);
        }
    }

    private void save(RandomAccessFile raf) throws IOException {
        raf.seek(0L);
        raf.writeShort(this.value);
        raf.writeInt(this.lastYear);
    }

    private FileLock tryToLock(FileChannel channel) {
        for (int i = 0; i < 20; ++i) {
            try {
                FileLock lock = channel.tryLock();
                if (lock != null) {
                    return lock;
                }
                ThreadUtil.sleep(300L);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackDoc() {
        RandomAccessFile raf = null;
        FileLock lock = null;
        try {
            File f = new File(PathUtils.getAppHome() + File.separator + "sequences" + File.separator + this.point + File.separator + "doc_seq");
            if (!f.exists()) {
                try {
                    FileUtil.mkParentDirs(f);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            raf = new RandomAccessFile(PathUtils.getAppHome() + File.separator + "sequences" + File.separator + this.point + File.separator + "doc_seq", "rw");
            FileChannel channel = raf.getChannel();
            try {
                lock = this.tryToLock(channel);
                if (lock != null) {
                    this.load(raf);
                } else {
                    Exception ex = new Exception(LocBundle.getMessageEx((String)"rma.doc_seq.cantlock"));
                    Logger.getLogger((String)"app").error((Object)ex, (Throwable)ex);
                }
                this.value = (short)(this.value - 1);
                if (this.value < 0) {
                    this.value = 0;
                }
                this.save(raf);
            }
            catch (IOException ex) {
                Logger.getLogger((String)"app").error((Object)ex, (Throwable)ex);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger((String)"app").error((Object)ex, (Throwable)ex);
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException iOException) {}
            }
            if (lock != null) {
                try {
                    lock.release();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

