/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.zip.CRC32;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.rma.app.CommissionCalculator;
import ru.softlogic.rma.app.Configuration;
import ru.softlogic.rma.connector.model.Commission;
import ru.softlogic.rma.connector.model.Menu;
import ru.softlogic.rma.connector.model.MenuItem;
import ru.softlogic.rma.connector.model.PersonalNumber;
import ru.softlogic.rma.connector.model.References;
import ru.softlogic.rma.connector.model.ServiceType;
import ru.softlogic.rma.connector.model.SumResult;
import ru.softlogic.rma.persistence.Record;
import ru.softlogic.rma.persistence.RmaAttribute;
import ru.softlogic.rma.persistence.v2.PersistenceManager;
import ru.softlogic.rma.shift.ShiftManager;
import ru.softlogic.rma.utils.SumFormatter;

public class CsvLoader {
    public int load(File f, Menu menu, References references) throws Exception {
        Logger log = Logger.getLogger((String)"app");
        log.setAdditivity(false);
        if (f == null) {
            throw new Exception("File Not Selected");
        }
        if (menu == null) {
            throw new Exception("No dictionary of services ");
        }
        if (!f.isFile() || !f.canRead()) {
            throw new Exception("Can not read file");
        }
        BufferedReader br = null;
        LinkedList<CsvRecord> records = null;
        try {
            br = new BufferedReader(new FileReader(f));
            String line = null;
            records = new LinkedList<CsvRecord>();
            while ((line = br.readLine()) != null) {
                log.info((Object)(LocBundle.getMessageLog((String)"rma.utils.workline") + " " + line));
                String[] strs = line.split(";");
                if (strs != null && strs.length > 1 && strs[1].length() > 0 && strs[1].length() < 40) {
                    CsvRecord r;
                    if (strs.length == 3) {
                        try {
                            r = new CsvRecord();
                            r.setIdService(Short.parseShort(strs[0].trim()));
                            r.setNumber(strs[1].trim());
                            r.setSum((int)Math.round(Double.parseDouble(strs[2].trim()) * 100.0));
                            records.add(r);
                        }
                        catch (Throwable tw) {
                            log.error((Object)LocBundle.getMessageLog((String)"rma.utils.worklineerr"), tw);
                        }
                        continue;
                    }
                    if (strs.length != 4 && strs.length != 5) continue;
                    try {
                        r = new CsvRecord();
                        r.setIdService(Short.parseShort(strs[0].trim()));
                        r.setNumber(strs[1].trim());
                        HashMap<String, RmaAttribute> attributes = new HashMap<String, RmaAttribute>();
                        Properties prop = new Properties();
                        prop.load(new StringReader(strs[2].trim().replaceAll("&", "\n").replaceAll("\"", "")));
                        for (String key : prop.stringPropertyNames()) {
                            if (key.equals("id2")) {
                                r.setNumber2(prop.getProperty(key));
                                continue;
                            }
                            RmaAttribute atr = new RmaAttribute();
                            atr.setKey(key);
                            atr.setKeyTitle(key);
                            atr.setValue(prop.getProperty(key));
                            atr.setValueTitle(prop.getProperty(key));
                            attributes.put(atr.getKey(), atr);
                        }
                        if (!attributes.isEmpty()) {
                            r.setAttributes(attributes);
                        }
                        if (strs.length == 5) {
                            Integer sumOut = null;
                            try {
                                sumOut = (int)Math.round(Double.parseDouble(strs[4]) * 100.0);
                                r.setSum2(sumOut);
                            }
                            catch (Exception ex) {
                                r.setSum((int)Math.round(Double.parseDouble(strs[3]) * 100.0));
                            }
                        } else {
                            r.setSum((int)Math.round(Double.parseDouble(strs[3]) * 100.0));
                        }
                        records.add(r);
                    }
                    catch (Throwable tw) {
                        log.error((Object)("Error in line with id1=" + strs[1].trim()));
                        log.error((Object)LocBundle.getMessageLog((String)"rma.utils.worklineerr"), tw);
                    }
                    continue;
                }
                log.error((Object)LocBundle.getMessageLog((String)"rma.utils.worklineparerr"));
                throw new IOException(LocBundle.getMessage((String)"rma.utils.worklineparerr2"));
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (records != null && records.size() > 0) {
            HashMap<Short, MenuItem> menuItems = new HashMap<Short, MenuItem>();
            for (ServiceType st : menu.getTypes()) {
                if (st.getItems() == null) continue;
                for (MenuItem mi : st.getItems()) {
                    menuItems.put(mi.getService().getId(), mi);
                }
            }
            Random rnd = new Random();
            Map<String, PersonalNumber> personalNumbers = references == null ? null : references.getPersonalNumbersAsMap();
            for (CsvRecord record : records) {
                log.info((Object)(LocBundle.getMessageLog((String)"rma.univers.do") + ": " + record));
                Commission personalCommission = null;
                MenuItem mi = (MenuItem)menuItems.get(record.getIdService());
                if (1 == mi.getService().getProviderType() && personalNumbers != null && personalNumbers.get(record.number) != null) {
                    if (personalNumbers.get(record.number).getType() == 1) {
                        log.error((Object)LocBundle.getMessage((String)"rma.mobile.blacknumb"));
                        continue;
                    }
                    personalCommission = personalNumbers.get(record.number).getCommission();
                }
                if (mi != null) {
                    int sumOut;
                    log.info((Object)LocBundle.getMessageLog((String)"rma.utils.uploadtodb"));
                    if (record.getSum2() == null) {
                        SumResult sr = CommissionCalculator.calculate(record.getSum(), mi.getCommission(), mi.getService().getCommission(), mi.getService().getMinCommission(), personalCommission, null);
                        sumOut = sr.getOut();
                    } else {
                        sumOut = record.getSum2();
                    }
                    int sumIn = record.getSum() != null ? record.getSum() : CommissionCalculator.calculateIncome(record.getSum2(), mi.getCommission(), mi.getService().getCommission(), mi.getService().getMinCommission(), personalCommission, null);
                    Record rec = new Record();
                    rec.setDoc((short)rnd.nextInt(16000));
                    rec.setCreated(new Date());
                    rec.setServiceId(record.getIdService());
                    rec.setServiceName(mi.getService().getName());
                    rec.setAccount(record.getNumber());
                    rec.setAccountTitle("id1");
                    rec.setAccountValueTitle(record.getNumber());
                    rec.setCommissionId(mi.getCommission().getId());
                    rec.setSumIncome(sumIn);
                    rec.setSumOutcome(sumOut);
                    rec.setSumComm(sumIn - sumOut);
                    rec.setDocType(Configuration.getInstance().getData().getDocType());
                    rec.setSumFee(mi.getFee() != null ? (long)CommissionCalculator.calculateFee(rec.getSumOutcome(), mi.getFee()) : 0L);
                    rec.setIdShift(ShiftManager.getInstance().getShiftId());
                    String control = "" + (record.getNumber() != null ? record.getNumber() : "") + new SimpleDateFormat("ddMMyyyHHmmss").format(rec.getCreated()) + SumFormatter.format(sumIn) + SumFormatter.format(sumOut) + SumFormatter.format(sumIn - sumOut);
                    CRC32 cs = new CRC32();
                    cs.reset();
                    cs.update(control.getBytes());
                    long crc = cs.getValue();
                    rec.setCrc(crc);
                    if (record.getAttributes() != null) {
                        rec.setAttributes(record.getAttributes());
                    }
                    if (record.getNumber2() != null) {
                        rec.setAccount2(record.getNumber2());
                        rec.setAccount2Title("id2");
                        rec.setAccount2ValueTitle(record.getNumber2());
                    }
                    rec.setIdShift(ShiftManager.getInstance().getShiftId());
                    rec.setLocalState((short)0);
                    PersistenceManager.getInstance().addOperation(rec);
                    continue;
                }
                log.error((Object)LocBundle.getMessageLog((String)"rma.utils.noservindict"));
            }
            return records.size();
        }
        log.info((Object)LocBundle.getMessageLog((String)"rma.utils.nolines"));
        return 0;
    }

    private class CsvRecord {
        private short idService;
        private String number;
        private Integer sum = null;
        private String number2 = null;
        private Integer sum2 = null;
        private Map<String, RmaAttribute> attributes = null;

        public Map<String, RmaAttribute> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, RmaAttribute> attributes) {
            this.attributes = attributes;
        }

        public String getNumber2() {
            return this.number2;
        }

        public void setNumber2(String number2) {
            this.number2 = number2;
        }

        public Integer getSum2() {
            return this.sum2;
        }

        public void setSum2(int sum2) {
            this.sum2 = sum2;
        }

        public short getIdService() {
            return this.idService;
        }

        public void setIdService(short idService) {
            this.idService = idService;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public Integer getSum() {
            return this.sum;
        }

        public void setSum(int sum) {
            this.sum = sum;
        }

        public String toString() {
            return "CsvRecord[id-srv=" + this.idService + ",number=" + this.number + ",number2=" + this.number2 + ",sum_income=" + this.sum + ",sum_outcome=" + this.sum2 + ",attributes=" + this.attributes + "]";
        }
    }
}

