/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.rma.model.add.BankRecord;
import ru.softlogic.rma.utils.PathUtils;

public class BikReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, BankRecord> read() {
        Logger log = Logger.getLogger((String)"app");
        HashMap<String, BankRecord> records = new HashMap<String, BankRecord>();
        BufferedReader reader = null;
        try {
            String filepath = PathUtils.getAppHome() + File.separator + "resources" + File.separator + "bik2.csv";
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filepath), "UTF-8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                BankRecord rec;
                String[] split = line.split(";");
                if (split.length == 2) {
                    rec = new BankRecord(split[0].trim(), split[1].trim(), "");
                } else if (split.length == 3) {
                    rec = new BankRecord(split[0].trim(), split[1].trim(), split[2].trim());
                } else {
                    log.error((Object)MessageFormat.format(LocBundle.getMessageLog((String)"util.bankreader.errorline"), line));
                    continue;
                }
                records.put(rec.getBik(), rec);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        return records;
    }
}

