/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.utils;

public class BikAccountVerifier {
    private static int[] KOEFS = new int[]{7, 1, 3, 7, 1, 3, 7, 1, 3, 7, 1, 3, 7, 1, 3, 7, 1, 3, 7, 1, 3, 7, 1};
    public static final int RKC = 1;
    public static final int KREDIT = 2;
    public static final int KVAL = 3;

    public static boolean verify(String bic, String account, int type) {
        if (bic == null || account == null) {
            return true;
        }
        if (account.length() != 20) {
            throw new IllegalArgumentException("\u0414\u043b\u0438\u043d\u0430 \u0441\u0447\u0435\u0442\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c 20 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
        }
        StringBuilder sb = new StringBuilder();
        if (type == 1) {
            sb.append("0").append(bic.charAt(4)).append(bic.charAt(5));
        } else {
            sb.append(bic.substring(6));
        }
        if (type == 3) {
            account = account.replace('A', '0');
            account = account.replace('B', '1');
            account = account.replace('C', '2');
            account = account.replace('E', '3');
            account = account.replace('H', '4');
            account = account.replace('K', '5');
            account = account.replace('M', '6');
            account = account.replace('P', '7');
            account = account.replace('T', '8');
            account = account.replace('X', '9');
        }
        sb.append(account.substring(0, 8)).append("0").append(account.substring(9));
        int[] mas = BikAccountVerifier.strToMas(sb.toString());
        int summ = 0;
        for (int i = 0; i < 23; ++i) {
            summ += mas[i] * KOEFS[i] % 10;
        }
        summ %= 10;
        summ *= 3;
        return (account.charAt(8) + "").equals((summ %= 10) + "");
    }

    private static int[] strToMas(String src) {
        int[] mas = new int[src.length()];
        int i = 0;
        try {
            for (i = 0; i < mas.length; ++i) {
                mas[i] = Integer.parseInt(src.charAt(i) + "");
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u0441\u0438\u043c\u0432\u043e\u043b \u0441\u0442\u0440\u043e\u043a\u0438: " + src + " \u0432 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 " + i);
        }
        return mas;
    }
}

