/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.update;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import rmai18n.LocBundle;
import ru.softlogic.rma.connector.HeaderListener;
import ru.softlogic.rma.connector.model.Header;
import ru.softlogic.rma.connector.model.References;
import ru.softlogic.rma.update.UpdateFile;
import ru.softlogic.rma.update.UpdateListener;
import ru.softlogic.rma.utils.FileUtil;
import ru.softlogic.rma.utils.FileUtilException;
import ru.softlogic.rma.utils.PathUtils;
import ru.softlogic.rma.utils.ThreadUtil;

public class SoftwareUpdater
implements Runnable,
HeaderListener {
    private Boolean canUpdate;
    private Logger log = Logger.getLogger((String)"update");
    private Date lastCheck;
    private String updateUrl;
    private String updateLogin;
    private String updatePassword;
    private UpdateListener updateListener;

    public SoftwareUpdater() {
        this.log.setAdditivity(false);
    }

    public void setUpdateListener(UpdateListener ul) {
        this.updateListener = ul;
    }

    private boolean onStartDownload(long size) {
        return this.updateListener.onStartDownload(size);
    }

    private void onProgress(String name, long size) {
        this.updateListener.onProgress(name, size);
    }

    private boolean onError(String e) {
        return this.updateListener.onError(e);
    }

    private void onSuccess() {
        this.updateListener.onSuccess();
    }

    public void setReferences(References ref) {
        this.updateUrl = ref.getUpdateUrl();
        this.updateLogin = ref.getUpdateLogin();
        this.updatePassword = ref.getUpdatePassword();
    }

    @Override
    public void run() {
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.update.startth"));
        ThreadUtil.sleep(60000L);
        int hours = 3;
        block4: while (!Thread.currentThread().isInterrupted()) {
            block18: {
                if (this.canUpdate != null && this.canUpdate.booleanValue() && (this.lastCheck == null || new Date().getTime() - this.lastCheck.getTime() > 60000L)) {
                    try {
                        File updateDir = new File(PathUtils.getAppHome() + "/update");
                        File flag = new File(PathUtils.getAppHome() + File.separator + "updated.ready");
                        FileUtil.checkDir(updateDir.getAbsolutePath());
                        File listFile = new File(updateDir, "list.xml");
                        listFile.delete();
                        this.lastCheck = new Date();
                        if (this.canUpdate == null || !this.canUpdate.booleanValue()) break block18;
                        if (this.updateUrl != null && this.updateUrl.length() > 0) {
                            String vPath = "rma/";
                            if (!this.updateUrl.endsWith("/")) {
                                vPath = "/" + vPath;
                            }
                            String listingUrl = this.updateUrl + vPath + "list.xml";
                            this.log.info((Object)(LocBundle.getMessageLog((String)"rma.update.downldlist") + " " + listingUrl));
                            if (this.downloadFile(listingUrl, this.updateLogin, this.updatePassword, listFile, null, 0L) == null) {
                                List<UpdateFile> downloadList = this.getDownloadList(updateDir, listFile);
                                if (downloadList.size() > 0) {
                                    long size = 0L;
                                    for (UpdateFile updateFile : downloadList) {
                                        size += updateFile.getSize();
                                    }
                                    if (this.onStartDownload(size)) {
                                        size = 0L;
                                        boolean firstTime = true;
                                        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.update.needtodown") + " " + downloadList));
                                        for (UpdateFile uf : downloadList) {
                                            File file;
                                            block19: {
                                                this.onProgress(uf.getName(), size);
                                                file = new File(updateDir, uf.getName());
                                                try {
                                                    if (!file.exists()) {
                                                        FileUtil.mkParentDirs(file);
                                                        break block19;
                                                    }
                                                    if (!firstTime) break block19;
                                                    file.delete();
                                                }
                                                catch (FileUtilException fue) {
                                                    this.log.error((Object)fue.getMessage(), (Throwable)fue);
                                                    continue;
                                                }
                                            }
                                            this.log.info((Object)(LocBundle.getMessageLog((String)"rma.update.downldfile") + " " + file.getName()));
                                            String res = null;
                                            res = this.downloadFile(this.updateUrl + vPath + uf.getName(), this.updateLogin, this.updatePassword, file, uf.getName(), size);
                                            this.log.info((Object)(LocBundle.getMessageLog((String)"rma.adv.result") + " " + res));
                                            if (res == null) {
                                                this.onProgress(uf.getName(), size += uf.getSize());
                                                continue;
                                            }
                                            if (!this.onError(res)) break;
                                            this.lastCheck = null;
                                            continue block4;
                                        }
                                        if ((downloadList = this.getDownloadList(updateDir, listFile)).size() > 0) {
                                            this.log.error((Object)LocBundle.getMessageLog((String)"rma.update.aupdateerr"));
                                            hours = 1;
                                            this.onError(LocBundle.getMessageLog((String)"rma.update.ntallfiles"));
                                        } else {
                                            this.log.info((Object)LocBundle.getMessageLog((String)"rma.update.succ"));
                                            flag.createNewFile();
                                            listFile.delete();
                                            hours = 3;
                                            this.onSuccess();
                                        }
                                    } else {
                                        this.log.info((Object)LocBundle.getMessageLog((String)"rma.update.disagry"));
                                    }
                                }
                                listFile.delete();
                                break block18;
                            }
                            this.log.error((Object)LocBundle.getMessageLog((String)"rma.update.downldlisterr"));
                            hours = 1;
                            break block18;
                        }
                        this.log.error((Object)(LocBundle.getMessageLog((String)"rma.update.nourl") + " " + this.updateUrl));
                    }
                    catch (Exception e) {
                        this.log.error((Object)LocBundle.getMessageLog((String)"rma.update.exception"), (Throwable)e);
                    }
                }
            }
            ThreadUtil.sleep(60000L);
        }
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.agent.stopth"));
    }

    private List<UpdateFile> getDownloadList(File updateDir, File listFile) {
        ArrayList<UpdateFile> result = new ArrayList<UpdateFile>();
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(listFile);
            Element root = document.getRootElement();
            Iterator i = root.elementIterator();
            while (i.hasNext()) {
                Element element = (Element)i.next();
                File file = new File(updateDir, element.valueOf("@name"));
                long crc = Long.parseLong(element.valueOf("@crc"));
                if (file.exists() && crc == this.calculateChecksum(file)) continue;
                result.add(new UpdateFile(element.valueOf("@name"), Long.parseLong(element.valueOf("@size"))));
            }
        }
        catch (Exception e) {
            this.log.error((Object)LocBundle.getMessageLog((String)"rma.update.readlisterr"), (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String downloadFile(String url, String login, String password, File saveFile, String name, long size) {
        FileOutputStream fos = null;
        HttpURLConnection conn = null;
        int code = 0;
        int cnt = 0;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setConnectTimeout(40000);
            if (conn instanceof HttpsURLConnection) {
                this.makeEasySSL((HttpsURLConnection)conn);
            }
            if (saveFile.length() > 0L) {
                conn.setRequestProperty("Range", "bytes=" + saveFile.length() + "-");
            }
            if (login != null && password != null && login.length() > 0) {
                String authorization = login + ":" + password;
                String encodedAuthorization = new String(Base64.encodeBase64((byte[])authorization.getBytes()));
                conn.setRequestProperty("Authorization", "Basic " + encodedAuthorization);
            }
            code = conn.getResponseCode();
            this.log.info((Object)("-- code = " + code));
            this.log.info((Object)("-- message = " + conn.getResponseMessage()));
            this.log.info((Object)("-- header = " + conn.getHeaderFields()));
        }
        catch (IOException e) {
            this.log.error((Object)(LocBundle.getMessageLog((String)"rma.update.connerr") + " " + url), (Throwable)e);
            return LocBundle.getMessageLog((String)"rma.update.connerr") + " " + url;
        }
        if (code == 200 || code == 206) {
            try {
                InputStream is = conn.getInputStream();
                fos = new FileOutputStream(saveFile, true);
                byte[] buf = new byte[10];
                int l = 0;
                while ((l = is.read(buf)) >= 0) {
                    fos.write(buf, 0, l);
                    cnt += l;
                    if (name == null) continue;
                    this.onProgress(name, size + (long)cnt);
                }
            }
            catch (Exception e) {
                this.log.error((Object)MessageFormat.format(LocBundle.getMessageLog((String)"rma.update.downerr"), url, cnt), (Throwable)e);
                String string = MessageFormat.format(LocBundle.getMessageLog((String)"rma.update.downerr"), url, cnt) + ", " + e.getMessage();
                return string;
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        this.log.error((Object)MessageFormat.format(LocBundle.getMessageLog((String)"rma.update.cantdwnldfile"), url, code));
        return MessageFormat.format(LocBundle.getMessageLog((String)"rma.update.cantdwnldfile"), url, code);
        if (conn != null) {
            conn.disconnect();
        }
        return null;
    }

    private long calculateChecksum(File file) {
        try {
            CRC32 cs = new CRC32();
            cs.reset();
            FileInputStream fis = new FileInputStream(file);
            byte[] buf = new byte[1024];
            int l = 0;
            while ((l = fis.read(buf)) >= 0) {
                cs.update(buf, 0, l);
            }
            fis.close();
            return cs.getValue();
        }
        catch (Exception ex) {
            this.log.error((Object)LocBundle.getMessageLog((String)"rma.update.calccrcerr"), (Throwable)ex);
            return 0L;
        }
    }

    private void makeEasySSL(HttpsURLConnection conn) {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        HostnameVerifier verifier = new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            conn.setSSLSocketFactory(sc.getSocketFactory());
            conn.setHostnameVerifier(verifier);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onHeader(Header header) {
        boolean newCanUpdate;
        boolean bl = newCanUpdate = (header.getFlags() & Header.FLAG_UPDATE) > 0;
        if (this.canUpdate == null || newCanUpdate != this.canUpdate) {
            this.log.info((Object)(LocBundle.getMessageLog((String)"rma.update.flgch") + " " + newCanUpdate));
            this.canUpdate = newCanUpdate;
        }
    }
}

