/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.shift;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.rma.connector.model.Shift;
import ru.softlogic.rma.persistence.v2.PersistenceManager;

public class ShiftManager {
    private static ShiftManager instance = new ShiftManager();
    private final SimpleDateFormat timeFormatter = new SimpleDateFormat("YYYY-MM-dd HH:mm");
    private Shift shift;
    private boolean useShiftMechanism;

    private ShiftManager() {
    }

    public boolean isUseShiftMechanism() {
        return this.useShiftMechanism;
    }

    public void setUseShiftMechanism(boolean useShiftMechanism) {
        this.useShiftMechanism = useShiftMechanism;
    }

    public long getShiftId() {
        return this.shift == null ? -1L : this.shift.getIdServer();
    }

    public static ShiftManager getInstance() {
        return instance;
    }

    public Shift getShift() {
        return this.shift;
    }

    public void setShift(Shift shift) {
        this.shift = shift;
    }

    public void checkShift() throws ShiftException {
        if (!this.useShiftMechanism) {
            return;
        }
        Shift curShift = this.shift;
        try {
            if (curShift == null) {
                curShift = PersistenceManager.getInstance().getCurrentShift();
            }
        }
        catch (Exception ex) {
            Logger.getLogger((String)"app").error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 ShiftMannager, message=" + ex.getMessage()));
        }
        if (this.shift == null) {
            if (curShift != null) {
                if (curShift.getStatus() == 0 && this.checkBouds(curShift)) {
                    String time = this.timeFormatter.format(curShift.getDayEnd());
                    throw new ShiftException(MessageFormat.format(LocBundle.getMessage((String)"rma.msg.error.closeshift"), time));
                }
                if (curShift.getStatus() == 0) {
                    throw new ShiftException(LocBundle.getMessage((String)"rma.msg.error.notaddedtoshift"));
                }
                throw new ShiftException(LocBundle.getMessage((String)"rma.msg.error.notshiftinfo"));
            }
            throw new ShiftException(LocBundle.getMessage((String)"rma.msg.error.notshiftinfo"));
        }
        if (this.checkBouds(this.shift)) {
            String time = this.timeFormatter.format(curShift.getDayEnd());
            throw new ShiftException(MessageFormat.format(LocBundle.getMessage((String)"rma.msg.error.closeshift"), time));
        }
    }

    public boolean checkBouds(Shift shift) {
        Date current = new Date();
        return !shift.getDayBegin().before(current) || !shift.getDayEnd().after(current);
    }

    public class ShiftException
    extends Exception {
        public ShiftException(String message) {
            super(message);
        }
    }
}

