/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.yandex;

public class YandexValidator {
    public boolean validate(String account) {
        if (account.matches("^[1-9][0-9]*(([0-9][1-9]$)|([1-9][0-9]$))")) {
            int N = Character.digit(account.charAt(0), 10);
            int len = account.length();
            if (len >= 12) {
                String X = account.substring(1, 1 + N);
                if (X.equals("1001")) {
                    String Y = account.substring(1 + N, 1 + N + len - N - 3);
                    String Z = account.substring(len - 2);
                    return Y.length() <= 20 && this.getAccountNumberRedundancy(X, Y).equals(Z);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private int[] strToArray(String str, int num) {
        int[] result = new int[num];
        int length = str.length();
        for (int i = 0; i < num; ++i) {
            result[i] = i >= length ? 0 : Character.digit(str.charAt(length - i - 1), 10);
        }
        return result;
    }

    private String getAccountNumberRedundancy(String X, String Y) {
        int[] XA = this.strToArray(X, 10);
        int[] YA = this.strToArray(Y, 20);
        int val = 0;
        int A = 70;
        for (int i = 0; i < 30; ++i) {
            int T = 0;
            T = i < 20 ? (YA[i] == 0 ? 10 : YA[i]) : (XA[i - 20] == 0 ? 10 : XA[i - 20]);
            val = (val + T * A % 99) % 99;
            A = A * 13 % 99;
        }
        return String.format("%02d", val + 1);
    }
}

