/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.yandex;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.rma.RmaAppContext;
import ru.softlogic.rma.RmaPaymentJob;
import ru.softlogic.rma.app.Configuration;
import ru.softlogic.rma.app.docs.LetterNumberDocument;
import ru.softlogic.rma.app.docs.SumDocument;
import ru.softlogic.rma.app.docs.listener.SumIncomeListener;
import ru.softlogic.rma.app.docs.listener.SumOutcomeListener;
import ru.softlogic.rma.connector.model.MenuItem;
import ru.softlogic.rma.persistence.Record;
import ru.softlogic.rma.providers.InitData;
import ru.softlogic.rma.providers.ServiceProvider;
import ru.softlogic.rma.providers.panels.SumPanelHelper;
import ru.softlogic.rma.providers.yandex.YandexProviderPanel;
import ru.softlogic.rma.providers.yandex.YandexValidator;
import ru.softlogic.rma.utils.FontResizer;
import ru.softlogic.rma.utils.GuiUtils;
import ru.softlogic.rma.utils.SumFormatter;

public class YandexProvider
implements ServiceProvider {
    private RmaAppContext context;
    private MenuItem menuItem;
    private YandexProviderPanel panel = new YandexProviderPanel();
    private SumDocument sumIncomeDocument;
    private SumIncomeListener sumIncomeListener;
    private SumDocument sumOutcomeDocument;
    private SumOutcomeListener sumOutcomeListener;
    private YandexValidator validator;
    private Logger log;
    private boolean printOnly;
    private ProcessActionListener processActionListener;

    public YandexProvider() {
        FontResizer.process(this.panel, Configuration.getInstance().getData().getSoftwareFontSize());
        this.sumIncomeListener = new SumIncomeListener(this.panel.getSumPanel().getSumOutcomeField(), this.panel.getSumPanel().getSumCommField());
        this.sumIncomeDocument = new SumDocument();
        this.sumIncomeDocument.addDocumentListener(this.sumIncomeListener);
        this.panel.getSumPanel().getSumIncomeField().setDocument(this.sumIncomeDocument);
        this.sumOutcomeListener = new SumOutcomeListener(this.panel.getSumPanel().getSumIncomeField(), this.panel.getSumPanel().getSumCommField());
        this.sumOutcomeDocument = new SumDocument();
        this.sumOutcomeDocument.addDocumentListener(this.sumOutcomeListener);
        this.panel.getSumPanel().getSumOutcomeField().setDocument(this.sumOutcomeDocument);
        this.panel.getSumPanel().getHelpLabelPanel().setVisible(false);
        this.sumIncomeListener.setSumOutcomeListener(this.sumOutcomeListener);
        this.sumOutcomeListener.setSumIncomeListener(this.sumIncomeListener);
        this.panel.getSumPanel().getCommentField().setDocument(new LetterNumberDocument(100));
        this.panel.getSumPanel().getCancelButton().addActionListener(new CancelActionListener());
        this.processActionListener = new ProcessActionListener();
        this.panel.getSumPanel().getPayButton().addActionListener(this.processActionListener);
        this.validator = new YandexValidator();
        this.log = Logger.getLogger((String)"pay");
        this.log.setAdditivity(false);
    }

    @Override
    public void init(InitData initData) {
        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.view.gotopay") + " " + this.menuItem));
        this.context = initData.getContext();
        this.menuItem = initData.getMenuItem();
        this.sumIncomeListener.init(this.menuItem, null);
        this.sumOutcomeListener.init(this.menuItem, null);
        this.panel.getNumberField().setText("");
        this.panel.getSumPanel().getSumIncomeField().setText("");
        this.panel.getSumPanel().getSumOutcomeField().setText("");
        this.panel.getSumPanel().getSumCommField().setText("");
        this.panel.getSumPanel().getCommentField().setText("");
        this.panel.getSumPanel().getPrintRequestCheckBox().setEnabled(initData.getPrintRequest() != null);
        this.panel.getSumPanel().getPrintRequestCheckBox().setSelected(Boolean.TRUE.equals(initData.getPrintRequest()));
        this.panel.getSumPanel().getPrintDocumentCheckBox().setEnabled(initData.getPrintDocument() != null);
        this.panel.getSumPanel().getPrintDocumentCheckBox().setSelected(Boolean.TRUE.equals(initData.getPrintDocument()));
        this.panel.getSumPanel().getPayButton().setEnabled(true);
        GuiUtils.requestFocus(this.panel.getNumberField());
        if (initData.getRecord() != null) {
            this.panel.getSumPanel().getSumIncomeField().getDocument().removeDocumentListener(this.sumIncomeListener);
            this.panel.getSumPanel().getSumOutcomeField().getDocument().removeDocumentListener(this.sumOutcomeListener);
            this.panel.getSumPanel().getCommentField().setText(initData.getRecord().getComment());
            this.panel.getSumPanel().getSumCommField().setText(SumFormatter.format(initData.getRecord().getSumComm()));
            this.panel.getSumPanel().getSumIncomeField().setText(SumFormatter.format(initData.getRecord().getSumIncome()));
            this.panel.getSumPanel().getSumOutcomeField().setText(SumFormatter.format(initData.getRecord().getSumOutcome()));
            this.panel.getNumberField().setText(initData.getRecord().getAccount());
            this.panel.getSumPanel().getSumIncomeField().getDocument().addDocumentListener(this.sumIncomeListener);
            this.panel.getSumPanel().getSumOutcomeField().getDocument().addDocumentListener(this.sumOutcomeListener);
        }
        this.panel.getNumberField().setEditable(!initData.isReadMode());
        this.panel.getSumPanel().getCommentField().setEditable(!initData.isReadMode());
        this.panel.getSumPanel().getSumCommField().setEditable(!initData.isReadMode());
        this.panel.getSumPanel().getSumIncomeField().setEditable(!initData.isReadMode());
        this.panel.getSumPanel().getSumOutcomeField().setEditable(!initData.isReadMode());
        this.panel.getSumPanel().getCancelButton().setEnabled(!initData.isReadMode());
        this.panel.getSumPanel().getPayButton().setEnabled(!initData.isReadMode());
        this.panel.getSumPanel().getCheckButton().setEnabled(!initData.isReadMode());
        this.panel.getSumPanel().getPrintDocumentCheckBox().setEnabled(initData.isReadMode() ? !initData.isReadMode() : !initData.isPrintForbidChange());
        this.panel.getSumPanel().getPrintRequestCheckBox().setEnabled(initData.isReadMode() ? !initData.isReadMode() : !initData.isPrintForbidChange());
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    private class CancelActionListener
    implements ActionListener {
        private CancelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            YandexProvider.this.context.toMainMenu();
        }
    }

    private class ProcessActionListener
    implements ActionListener {
        private ProcessActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            YandexProvider.this.panel.getSumPanel().getPayButton().setEnabled(false);
            String number = YandexProvider.this.panel.getNumberField().getText();
            int sumIncome = SumFormatter.parce(YandexProvider.this.panel.getSumPanel().getSumIncomeField().getText(), 0);
            int sumOutcome = SumFormatter.parce(YandexProvider.this.panel.getSumPanel().getSumOutcomeField().getText(), 0);
            YandexProvider.this.log.info((Object)MessageFormat.format(LocBundle.getMessageLog((String)"rma.hk.trytopay"), number, YandexProvider.this.panel.getSumPanel().getSumIncomeField().getText(), YandexProvider.this.panel.getSumPanel().getSumOutcomeField().getText()));
            try {
                if (!YandexProvider.this.validator.validate(number)) {
                    GuiUtils.requestFocus(YandexProvider.this.panel.getNumberField());
                    JOptionPane.showMessageDialog(YandexProvider.this.context.getMainFrame(), LocBundle.getMessage((String)"rma.mobile.numbntfnd2"), LocBundle.getMessage((String)"rma.hk.erronaddpay"), 0);
                    YandexProvider.this.panel.getSumPanel().getPayButton().setEnabled(true);
                    return;
                }
                if (!SumPanelHelper.verify(YandexProvider.this.context.getMainFrame(), YandexProvider.this.menuItem, YandexProvider.this.panel.getSumPanel())) {
                    YandexProvider.this.panel.getSumPanel().getPayButton().setEnabled(true);
                    return;
                }
                RmaPaymentJob job = new RmaPaymentJob();
                Record record = new Record();
                job.setRecord(record);
                record.setServiceId(YandexProvider.this.menuItem.getService().getId());
                record.setServiceName(YandexProvider.this.menuItem.getService().getName());
                record.setCommissionId(YandexProvider.this.menuItem.getCommission().getId());
                record.setAccount(number);
                record.setAccountTitle(LocBundle.getMessageLog((String)"rma.univers.yandexnumb"));
                record.setAccountValueTitle(number);
                record.setSumIncome(sumIncome);
                record.setSumOutcome(sumOutcome);
                record.setComment(YandexProvider.this.panel.getSumPanel().getCommentField().getText());
                job.setPrintDocument(YandexProvider.this.panel.getSumPanel().getPrintDocumentCheckBox().isSelected());
                job.setPrintRequest(YandexProvider.this.panel.getSumPanel().getPrintRequestCheckBox().isSelected());
                job.setMenuItem(YandexProvider.this.menuItem);
                if (!YandexProvider.this.context.toPayment(job)) {
                    YandexProvider.this.panel.getSumPanel().getPayButton().setEnabled(true);
                }
            }
            catch (Exception ex) {
                YandexProvider.this.panel.getSumPanel().getPayButton().setEnabled(true);
                YandexProvider.this.log.info((Object)(LocBundle.getMessageLog((String)"rma.adv.dopayerr") + " " + ex.getMessage()));
                JOptionPane.showMessageDialog(YandexProvider.this.context.getMainFrame(), ex.getMessage(), LocBundle.getMessage((String)"rma.adv.dopayerr"), 0);
            }
        }
    }
}

