/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.universal.general;

import info.clearthought.layout.TableLayout;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.apache.log4j.Logger;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import rmai18n.LocBundle;
import ru.softlogic.input.model.field.Field;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.field.text.KeyboardType;
import ru.softlogic.input.model.field.text.TextField;
import ru.softlogic.rma.RmaApp;
import ru.softlogic.rma.app.components.JScrollPopupMenu;
import ru.softlogic.rma.app.components.MultipleMaskTextField;
import ru.softlogic.rma.app.docs.DigitalNumberDocument;
import ru.softlogic.rma.app.docs.LetterNumberDocument;
import ru.softlogic.rma.model.add.BankRecord;
import ru.softlogic.rma.model.add.PD4Record;
import ru.softlogic.rma.providers.panels.SumPanel;
import ru.softlogic.rma.providers.universal.form.SetField;
import ru.softlogic.rma.providers.universal.general.ACManager;
import ru.softlogic.rma.providers.universal.general.ComboBoxTextItem;
import ru.softlogic.rma.providers.universal.general.ControlData;
import ru.softlogic.rma.utils.MessageUtils;
import ru.softlogic.rma.utils.RSParser;

public class IdentificationDialog
extends JDialog {
    private Logger log;
    private List<JComponent> controls;
    private Font defaultLabelFont;
    private String destination;
    private ACManager acm;
    private JPanel buttonsPanel;
    private JButton cancelButton;
    private JPanel contentPanel;
    private JButton okButton;

    public IdentificationDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.log = Logger.getLogger((String)"uni");
        this.log.setAdditivity(false);
        this.controls = new LinkedList<JComponent>();
        ResourceMap resourceMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getResourceMap(SumPanel.class);
        this.defaultLabelFont = resourceMap.getFont("sumIncomeLabel.font");
        this.acm = new ACManager();
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    private void initComponents() {
        this.contentPanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        this.contentPanel.setName("contentPanel");
        GroupLayout contentPanelLayout = new GroupLayout(this.contentPanel);
        this.contentPanel.setLayout(contentPanelLayout);
        contentPanelLayout.setHorizontalGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 565, Short.MAX_VALUE));
        contentPanelLayout.setVerticalGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 311, Short.MAX_VALUE));
        this.buttonsPanel.setName("buttonsPanel");
        ResourceMap resourceMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getResourceMap(IdentificationDialog.class);
        this.okButton.setText(resourceMap.getString("okButton.text", new Object[0]));
        this.okButton.setName("okButton");
        this.buttonsPanel.add(this.okButton);
        this.cancelButton.setText(resourceMap.getString("cancelButton.text", new Object[0]));
        this.cancelButton.setName("cancelButton");
        this.buttonsPanel.add(this.cancelButton);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.contentPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.buttonsPanel, GroupLayout.Alignment.LEADING, -1, 565, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.contentPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonsPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    public boolean showFields(List<IdentityField> fields, Map<IdentityField, Object> values) {
        for (IdentityField ff : values.keySet()) {
            this.log.info((Object)(ff + "->" + values.get(ff)));
        }
        this.contentPanel.setVisible(false);
        this.contentPanel.removeAll();
        this.controls.clear();
        this.contentPanel.setVisible(true);
        TableLayout layout = new TableLayout(new double[]{0.0, -2.0, 6.0, -1.0, 10.0, -2.0, 6.0, -1.0, 0.0}, new double[0]);
        this.contentPanel.setLayout((LayoutManager)layout);
        return this._showFields(fields, values, layout);
    }

    private boolean _showFields(List<IdentityField> fields, Map<IdentityField, Object> values, TableLayout layout) {
        boolean focusSet = false;
        if (fields == null) {
            return true;
        }
        boolean firstCell = false;
        HashMap<String, MultipleMaskTextField> flds = new HashMap<String, MultipleMaskTextField>();
        LocalPopupComponentListener popListener = new LocalPopupComponentListener();
        for (IdentityField ff : fields) {
            if (ff instanceof TextField) {
                if (!firstCell) {
                    layout.insertRow(layout.getNumRow(), 6.0);
                    layout.insertRow(layout.getNumRow(), 22.0);
                }
                TextField field = (TextField)ff;
                JLabel label = new JLabel(MessageUtils.process((IdentityField)field));
                label.setFont(this.defaultLabelFont);
                label.setToolTipText(field.getMessage());
                if (field.getExampleValue() == null || field.getExampleValue().length() < 25) {
                    if (firstCell) {
                        this.contentPanel.add((Component)label, "5," + (layout.getNumRow() - 1) + ",r,f");
                    } else {
                        this.contentPanel.add((Component)label, "1," + (layout.getNumRow() - 1) + ",r,f");
                    }
                } else {
                    if (firstCell) {
                        layout.insertRow(layout.getNumRow(), 6.0);
                        layout.insertRow(layout.getNumRow(), 22.0);
                    }
                    this.contentPanel.add((Component)label, "1," + (layout.getNumRow() - 1) + ",r,f");
                }
                MultipleMaskTextField formTextField = new MultipleMaskTextField(this.createDocument(field.getKeyboard().getType(), field.getMaxLength(), field.getPrefix(), field.getKeyboard().getExtraCharacter() == null || Character.isWhitespace(field.getKeyboard().getExtraCharacter().charValue()) ? null : field.getKeyboard().getExtraCharacter()), field.getPrefix(), field.getViewFormatter());
                if (this.acm.getPd4records() != null && ("corr_bik".equals(field.getId()) || "recipient_acc".equals(field.getId()) || "corr_name".equals(field.getId()) || "corr_oktmo".equals(field.getId()) || "corr_kbk".equals(field.getId()) || "corr_inn".equals(field.getId()))) {
                    formTextField.addMouseListener(popListener);
                    formTextField.addFocusListener(popListener);
                    formTextField.addKeyListener(popListener);
                    JScrollPopupMenu menu = new JScrollPopupMenu(formTextField);
                    menu.setPopupListener(popListener);
                    formTextField.add(menu);
                    formTextField.setComponentPopupMenu(menu);
                    formTextField.getDocument().addDocumentListener(new LocalPopupFieldDocumentListener(formTextField));
                } else if ("corr_bik".equals(field.getId()) && (values.get(field) == null || values.get(field).toString().isEmpty())) {
                    formTextField.getDocument().addDocumentListener(new LocalPopupFieldDocumentListener(formTextField));
                }
                formTextField.putClientProperty("field", field);
                formTextField.setToolTipText(field.getMessage());
                formTextField.setEditable(!field.isReadOnly());
                if ("corr_acc".equals(field.getId()) || "corr_bank_name".equals(field.getId())) {
                    formTextField.setEditable(false);
                }
                HashSet<AWTKeyStroke> forwardKeys = new HashSet<AWTKeyStroke>(this.getFocusTraversalKeys(0));
                forwardKeys.add(KeyStroke.getKeyStroke(10, 0));
                formTextField.setFocusTraversalKeys(0, forwardKeys);
                formTextField.setFocusable(formTextField.isEditable());
                flds.put(field.getId(), formTextField);
                this.controls.add(formTextField);
                if (field.getExampleValue() == null || field.getExampleValue().length() < 25) {
                    if (firstCell) {
                        this.contentPanel.add((Component)formTextField, "7," + (layout.getNumRow() - 1));
                        firstCell = false;
                    } else {
                        this.contentPanel.add((Component)formTextField, "3," + (layout.getNumRow() - 1));
                        firstCell = true;
                    }
                } else {
                    this.contentPanel.add((Component)formTextField, "3," + (layout.getNumRow() - 1) + ",7," + (layout.getNumRow() - 1));
                }
                if (values.get(field) != null) {
                    String val = (String)values.get(field);
                    this.log.debug((Object)(LocBundle.getMessageLog((String)"rma.univers.setfldval") + " " + val));
                    formTextField.setText(val);
                    continue;
                }
                if (focusSet) continue;
                this.log.debug((Object)LocBundle.getMessageLog((String)"rma.univers.setfocus"));
                formTextField.requestFocus();
                focusSet = true;
                continue;
            }
            if (!(ff instanceof SetField)) continue;
            JLabel lab = new JLabel();
            lab.putClientProperty("field", ff);
            this.controls.add(lab);
        }
        this.acm.setFields(flds);
        return true;
    }

    private Document createDocument(KeyboardType type, int maxLen, String prefix, Character xbutton) {
        if (KeyboardType.Digital.equals((Object)type)) {
            return new DigitalNumberDocument(maxLen, prefix, xbutton);
        }
        return new LetterNumberDocument(maxLen, prefix);
    }

    public List<ControlData> getData() {
        LinkedList<ControlData> result = new LinkedList<ControlData>();
        for (JComponent control : this.controls) {
            if (control instanceof MultipleMaskTextField) {
                MultipleMaskTextField textField = (MultipleMaskTextField)control;
                TextField tif = (TextField)textField.getClientProperty("field");
                String val = textField.getText();
                this.log.info((Object)(LocBundle.getMessageLog((String)"rma.univers.add") + " " + tif + "->" + val));
                result.add(new ControlData((Field)tif, val, control));
                continue;
            }
            if (control instanceof JComboBox) {
                JComboBox comboBox = (JComboBox)control;
                if (!(comboBox.getClientProperty("field") instanceof SelectorField)) continue;
                SelectorField selector = (SelectorField)comboBox.getClientProperty("field");
                SelectorItem item = null;
                if (comboBox.getSelectedItem() != null) {
                    item = ((ComboBoxTextItem)comboBox.getSelectedItem()).getItem();
                }
                this.log.info((Object)(LocBundle.getMessageLog((String)"rma.univers.add") + " " + selector + "->" + item));
                result.add(new ControlData((Field)selector, item, control));
                continue;
            }
            if (!(control instanceof JLabel)) continue;
            SetField sf = (SetField)((Object)control.getClientProperty("field"));
            this.log.info((Object)(LocBundle.getMessageLog((String)"rma.univers.add") + " " + (Object)((Object)sf)));
            result.add(new ControlData((Field)sf, sf.getValue(), control));
        }
        return result;
    }

    public void setPD4Records(PD4Record[] pd4Records) {
    }

    public void setBankRecords(Map<String, BankRecord> bankRecords) {
        this.acm.setBankRecords(bankRecords);
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    private class LocalPopupFieldDocumentListener
    implements DocumentListener {
        private JTextField field;

        public LocalPopupFieldDocumentListener(JTextField field) {
            this.field = field;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            IdentificationDialog.this.acm.processPopup(this.field);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            IdentificationDialog.this.acm.processPopup(this.field);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }

    private class LocalPopupComponentListener
    extends MouseAdapter
    implements FocusListener,
    KeyListener,
    Runnable {
        private LocalPopupComponentListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JTextField tf;
            if (e.getClickCount() >= 2 && e.getSource() instanceof JTextField && (tf = (JTextField)e.getSource()).getComponentPopupMenu() != null) {
                JScrollPopupMenu popup = (JScrollPopupMenu)tf.getComponentPopupMenu();
                if (popup.isVisible()) {
                    popup.hide();
                    tf.setFocusTraversalKeysEnabled(true);
                } else if (((JScrollPopupMenu)tf.getComponentPopupMenu()).getItemsCount() > 0) {
                    popup.show();
                    tf.setFocusTraversalKeysEnabled(false);
                }
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() instanceof JComponent) {
                IdentificationDialog.this.acm.processPopup((JComponent)e.getSource());
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (e.getSource() instanceof JTextField) {
                boolean needIdentification;
                TextField tif;
                JTextField tf = (JTextField)e.getSource();
                if (tf.getComponentPopupMenu() != null) {
                    tf.getComponentPopupMenu().setVisible(false);
                    tf.setFocusTraversalKeysEnabled(true);
                }
                if (tf.getClientProperty("field") instanceof TextField && "recipient_acc".equals((tif = (TextField)tf.getClientProperty("field")).getId()) && (needIdentification = RSParser.getInstance().checkRS(tf.getText()))) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(IdentificationDialog.this, LocBundle.getMessage((String)"rma.needidentification"), LocBundle.getMessage((String)"rma.needidentificationtitle"), 1);
                        }
                    });
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                        }
                    });
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            JTextField tf;
            if ((e.getKeyCode() == 38 || e.getKeyCode() == 40 || e.getKeyCode() == 10 || e.getKeyCode() == 32 || e.getKeyCode() == 27) && e.getSource() instanceof JTextField && (tf = (JTextField)e.getSource()).getComponentPopupMenu() != null) {
                JScrollPopupMenu popup = (JScrollPopupMenu)tf.getComponentPopupMenu();
                if (e.getKeyCode() == 32 && e.isControlDown()) {
                    if (popup.isVisible()) {
                        popup.hide();
                        tf.setFocusTraversalKeysEnabled(true);
                    } else if (((JScrollPopupMenu)tf.getComponentPopupMenu()).getItemsCount() > 0) {
                        popup.show();
                        tf.setFocusTraversalKeysEnabled(false);
                    }
                } else if (e.getKeyCode() == 27) {
                    if (popup.isVisible()) {
                        popup.hide();
                        tf.setFocusTraversalKeysEnabled(true);
                    }
                } else if (e.getKeyCode() == 38 && popup.isVisible()) {
                    popup.prevSelection();
                } else if (e.getKeyCode() == 40 && popup.isVisible()) {
                    popup.nextSelection();
                } else if (e.getKeyCode() == 10 && popup.isVisible()) {
                    popup.selectCurrent();
                    tf.setFocusTraversalKeysEnabled(true);
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void run() {
            IdentificationDialog.this.acm.processAutoComplete();
        }
    }
}

