/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.universal.general;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.ModelEnvironment;
import ru.softlogic.input.model.field.Field;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.field.selector.custom.SequenceCustomData;
import ru.softlogic.input.model.field.text.TextField;
import ru.softlogic.input.model.form.Form;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.rma.Environment;
import ru.softlogic.rma.RmaAppContext;
import ru.softlogic.rma.RmaCancelOperationDialog;
import ru.softlogic.rma.RmaPaymentJob;
import ru.softlogic.rma.app.Configuration;
import ru.softlogic.rma.app.components.MultipleMaskTextField;
import ru.softlogic.rma.app.docs.LetterNumberDocument;
import ru.softlogic.rma.app.docs.SumDocument;
import ru.softlogic.rma.app.docs.listener.SumIncomeListener;
import ru.softlogic.rma.app.docs.listener.SumOutcomeListener;
import ru.softlogic.rma.connector.model.CurrentUser;
import ru.softlogic.rma.connector.model.MenuItem;
import ru.softlogic.rma.connector.model.References;
import ru.softlogic.rma.connector.ws.stub.VerifyResult;
import ru.softlogic.rma.connector.ws.stub.VerifyResultType;
import ru.softlogic.rma.model.add.BankRecord;
import ru.softlogic.rma.model.add.PD4Fields;
import ru.softlogic.rma.model.keeperpayments.KeeperPayment;
import ru.softlogic.rma.persistence.DocType;
import ru.softlogic.rma.persistence.PersistenceException;
import ru.softlogic.rma.persistence.Record;
import ru.softlogic.rma.persistence.RmaAttribute;
import ru.softlogic.rma.persistence.v2.PersistenceManager;
import ru.softlogic.rma.print.PrintMode;
import ru.softlogic.rma.print.queue.RequestData;
import ru.softlogic.rma.providers.FildsChangedListener;
import ru.softlogic.rma.providers.InitData;
import ru.softlogic.rma.providers.PrintCallBackListener;
import ru.softlogic.rma.providers.ProviderHelper;
import ru.softlogic.rma.providers.VerifyResultListener;
import ru.softlogic.rma.providers.panels.PrintCheckBoxsPanel;
import ru.softlogic.rma.providers.panels.SumPanelHelper;
import ru.softlogic.rma.providers.universal.ChildProvider;
import ru.softlogic.rma.providers.universal.form.SetField;
import ru.softlogic.rma.providers.universal.general.ControlData;
import ru.softlogic.rma.providers.universal.general.GeneralPanel;
import ru.softlogic.rma.providers.universal.general.InterfaceListener;
import ru.softlogic.rma.shift.ShiftManager;
import ru.softlogic.rma.utils.ConvertUtils;
import ru.softlogic.rma.utils.EditFieldsParser;
import ru.softlogic.rma.utils.GuiUtils;
import ru.softlogic.rma.utils.IM7FormUtils;
import ru.softlogic.rma.utils.RSParser;
import ru.softlogic.rma.utils.SumFormatter;

public class GeneralProvider
implements ChildProvider,
VerifyResultListener {
    private RmaAppContext context;
    private MenuItem menuItem;
    private SumDocument sumIncomeDocument;
    private SumIncomeListener sumIncomeListener;
    private SumDocument sumOutcomeDocument;
    private SumOutcomeListener sumOutcomeListener;
    private Form form;
    private GeneralPanel panel;
    private Map<Field, Object> values;
    private InterfaceListener interfaceListener = new LocalInterfaceListener();
    private boolean showAll;
    private Logger log;
    private ProcessActionListener processActionListener;
    private References references;
    private Map<String, BankRecord> bankRecords;
    private boolean needIdentification;
    private JPanel printContentPanel;
    private short typeCashSourcePayment;
    private Integer sum1;
    private Integer sum2;
    private Map<String, Object> verifiedIElements;
    private Map<String, Object> formContext;
    private boolean needBudgetFields;
    private List<IdentityField> formFields;
    private RmaPaymentJob currentJob = null;
    private PrintCallBackListener printResultListener;
    private boolean isPrinted;
    private boolean isFieldsChanged;

    public GeneralProvider() {
        this.panel = new GeneralPanel();
        this.panel.addListener(this.interfaceListener);
        this.panel.getSumPanel().getCheckButton().addActionListener(new LocalCheckListener());
        this.sumIncomeListener = new SumIncomeListener(this.panel.getSumPanel().getSumOutcomeField(), this.panel.getSumPanel().getSumCommField());
        this.sumIncomeDocument = new SumDocument();
        this.sumIncomeDocument.addDocumentListener(this.sumIncomeListener);
        this.panel.getSumPanel().getSumIncomeField().setDocument(this.sumIncomeDocument);
        this.sumOutcomeListener = new SumOutcomeListener(this.panel.getSumPanel().getSumIncomeField(), this.panel.getSumPanel().getSumCommField());
        this.sumOutcomeDocument = new SumDocument();
        this.sumOutcomeDocument.addDocumentListener(this.sumOutcomeListener);
        this.panel.getSumPanel().getSumOutcomeField().setDocument(this.sumOutcomeDocument);
        this.sumIncomeListener.setSumOutcomeListener(this.sumOutcomeListener);
        this.sumOutcomeListener.setSumIncomeListener(this.sumIncomeListener);
        LocalSumOutcomeFieldsListener sumFiledsListener = new LocalSumOutcomeFieldsListener();
        this.sumIncomeListener.setChangeListener(sumFiledsListener);
        this.sumOutcomeListener.setChangeListener(sumFiledsListener);
        this.panel.getSumPanel().getCommentField().setDocument(new LetterNumberDocument(100));
        this.panel.getSumPanel().getCancelButton().addActionListener(new CancelActionListener());
        this.processActionListener = new ProcessActionListener();
        this.panel.getSumPanel().getPayButton().addActionListener(this.processActionListener);
        this.panel.getSumPanel().getPrintButton().addActionListener(new LocalPrintRequestListener());
        this.values = new HashMap<Field, Object>();
        this.formContext = new HashMap<String, Object>();
        this.log = Logger.getLogger((String)"pay");
        this.log.setAdditivity(false);
        this.needIdentification = false;
        try {
            this.sum1 = Integer.parseInt(Environment.getInstance().getProperty("sum1")) * 100;
        }
        catch (Exception ex) {
            this.log.info((Object)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0441\u043f\u0430\u0440\u0441\u0438\u0442\u044c sum1. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e null");
            this.sum1 = null;
        }
        try {
            this.sum2 = Integer.parseInt(Environment.getInstance().getProperty("sum2")) * 100;
        }
        catch (Exception ex) {
            this.log.info((Object)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0441\u043f\u0430\u0440\u0441\u0438\u0442\u044c sum2. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e null");
            this.sum2 = null;
        }
        this.printResultListener = new PrintCallBackListener(){

            @Override
            public void onPrintResult(boolean isPrinted) {
                GeneralProvider.this.isPrinted = isPrinted;
                GeneralProvider.this.panel.getSumPanel().getPrintButton().setEnabled(!isPrinted);
                GeneralProvider.this.panel.getSumPanel().getPayButton().setEnabled(isPrinted);
            }
        };
    }

    @Override
    public void init(InitData initData, Form form, Form pd4, Form sum1, Form sum2, Form sum3, Form card, Form acc) {
        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.univers.gotopaygen") + " " + this.menuItem));
        this.references = initData.getReferences();
        this.verifiedIElements = null;
        this.typeCashSourcePayment = this.references.getPoint().getTypeCashSourcePoint();
        this.form = form;
        Record last = KeeperPayment.getInstanse().getLastRecord();
        this.values.clear();
        this.formContext.clear();
        this.formFields = ((ScreenDescription)form.getScreenSequence().getScreens().get(0)).getSequence().getFields();
        if (form.getScreenSequence().getFields() != null) {
            for (InputElement ie : form.getScreenSequence().getFields()) {
                SetField sf = new SetField();
                sf.setId(ie.getKey());
                sf.setValue(ie.getValue());
                sf.setMessage("");
                sf.setTitle(ie.getKeyTitle());
                this.formFields.add(sf);
            }
        }
        if (initData.getParams() != null) {
            this.formContext.putAll(initData.getParams());
        }
        ProviderHelper.prefillStore(form.getPrefillItem(), initData.getReferences(), this.formContext);
        if (!this.formContext.isEmpty()) {
            for (IdentityField field : this.formFields) {
                if (field instanceof SetField) {
                    this.values.put((Field)field, ((SetField)field).getValue());
                    continue;
                }
                if (this.formContext.get(field.getId()) != null) {
                    Object param = this.formContext.get(field.getId());
                    if (param instanceof String) {
                        this.values.put((Field)field, this.formContext.get(field.getId()));
                    } else if (param instanceof InputElement) {
                        this.values.put((Field)field, ((InputElement)this.formContext.get(field.getId())).getValue());
                    } else {
                        this.values.put((Field)field, this.formContext.get(field.getId()));
                    }
                    this.formContext.remove(field.getId());
                    continue;
                }
                if (!"fio".equals(field.getId()) && !"adr".equals(field.getId()) && !"client_tel".equals(field.getId()) || last == null || last.getAttributes().get(field.getId()) == null) continue;
                this.values.put((Field)field, last.getAttributes().get(field.getId()).getValue());
            }
        }
        try {
            HashMap data = initData.getParams() != null ? initData.getParams() : new HashMap();
            ((ScreenDescription)form.getScreenSequence().getScreens().get(0)).getSequence().initFields(new ModelEnvironment(data, null, 0.0, null));
        }
        catch (InitException ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
        this.context = initData.getContext();
        this.panel.setBankRecords(initData.getBankRecords());
        this.bankRecords = initData.getBankRecords();
        this.menuItem = initData.getMenuItem();
        this.sumIncomeListener.init(this.menuItem, null);
        this.sumOutcomeListener.init(this.menuItem, null);
        this.panel.initPanel(initData.getReferences());
        if (initData.getRecord() != null) {
            this.panel.getSumPanel().getSumIncomeField().getDocument().removeDocumentListener(this.sumIncomeListener);
            this.panel.getSumPanel().getSumOutcomeField().getDocument().removeDocumentListener(this.sumOutcomeListener);
            this.panel.getSumPanel().getCommentField().setText(initData.getRecord().getComment());
            this.panel.getSumPanel().getSumCommField().setText(SumFormatter.format(initData.getRecord().getSumComm()));
            this.panel.getSumPanel().getSumIncomeField().setText(SumFormatter.format(initData.getRecord().getSumIncome()));
            this.panel.getSumPanel().getSumOutcomeField().setText(SumFormatter.format(initData.getRecord().getSumOutcome()));
            this.panel.getSumPanel().getSumIncomeField().getDocument().addDocumentListener(this.sumIncomeListener);
            this.panel.getSumPanel().getSumOutcomeField().getDocument().addDocumentListener(this.sumOutcomeListener);
            this.initFields(initData, this.getCurrentFields(null));
        } else if (PD4Fields.isPD4InForm(IM7FormUtils.getFieldsFromForm(form))) {
            this.log.info((Object)">>> setPD4f");
            this.panel.setPD4Records(this.references == null || this.menuItem.getService().getBankBik() != null && !this.menuItem.getService().getBankBik().trim().isEmpty() ? null : this.references.getPd4Records());
        } else {
            this.panel.setPD4Records(null);
        }
        if (initData.isReadMode()) {
            this.panel.setPD4Records(null);
        }
        this.panel.getSumPanel().getHelpLabelPanel().setVisible(false);
        this.needIdentification = RSParser.getInstance().checkRS(initData.getMenuItem().getService().getBankRs());
        this.needBudgetFields = RSParser.getInstance().checkBudgetRS(initData.getMenuItem().getService().getBankRs());
        for (IdentityField ff : this.formFields) {
            if (!(ff instanceof SetField) || !"recipient_acc".equals(ff.getId())) continue;
            this.needBudgetFields |= RSParser.getInstance().checkBudgetRS(((SetField)ff).getValue());
        }
        this.panel.getSumPanel().getPayButton().setEnabled(true);
        this.interfaceListener.onChange(this.values);
        this.panel.getSumPanel().getCommentField().setEditable(!initData.isReadMode());
        this.panel.getSumPanel().getSumCommField().setEditable(!initData.isReadMode());
        this.panel.getSumPanel().getSumIncomeField().setEditable(!initData.isReadMode());
        this.panel.getSumPanel().getSumOutcomeField().setEditable(!initData.isReadMode());
        this.panel.getSumPanel().getPayButton().setEnabled(!initData.isReadMode());
        this.panel.getSumPanel().getCheckButton().setEnabled(!initData.isReadMode());
        if (this.printContentPanel instanceof PrintCheckBoxsPanel) {
            PrintCheckBoxsPanel pchb = (PrintCheckBoxsPanel)this.printContentPanel;
            pchb.getPrintRequestCheckBox().setEnabled(false);
            pchb.getPrintRequestCheckBox().setSelected(false);
            pchb.getPrintDocumentCheckBox().setEnabled(initData.getPrintDocument() != null);
            pchb.getPrintDocumentCheckBox().setSelected(Boolean.TRUE.equals(initData.getPrintDocument()));
            pchb.getPrintDocumentCheckBox().setEnabled(initData.isReadMode() ? !initData.isReadMode() : !initData.isPrintForbidChange());
            pchb.getPrintRequestCheckBox().setEnabled(initData.isReadMode() ? !initData.isReadMode() : !initData.isPrintForbidChange());
        }
        this.panel.getClearAllButton().setEnabled(!initData.isReadMode());
        this.panel.getSumPanel().getPrintButton().setEnabled(true);
        this.panel.getSumPanel().getPayButton().setEnabled(false);
        this.isPrinted = false;
        this.panel.setContext(this.context);
        if (this.menuItem.getService().getVerifyType() == 0 || this.menuItem.getService().getVerifyType() == 1 || this.menuItem.getService().getProcessingType() == 2) {
            this.panel.getSumPanel().getCheckButton().setEnabled(true);
        } else {
            this.panel.getSumPanel().getCheckButton().setEnabled(false);
        }
        this.isFieldsChanged = false;
        this.panel.getSumPanel().setChangedListener(new LocalChangedFieldsListener());
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    private void initFields(InitData initData, List<IdentityField> fields) {
        Record rec = initData.getRecord();
        EditFieldsParser eparser = new EditFieldsParser();
        for (IdentityField field : fields) {
            TextField tfield;
            if (field instanceof TextField) {
                tfield = (TextField)field;
                tfield.setReadOnly(!eparser.checkField(initData.getMenuItem().getService().getCode() + "", tfield.getId()));
                tfield.setSecure(this.showAll);
                if (tfield.getId().equalsIgnoreCase("id1")) {
                    this.values.put((Field)field, rec.getAccount());
                    continue;
                }
                if (tfield.getId().equalsIgnoreCase("id2")) {
                    this.values.put((Field)field, rec.getAccount2());
                    continue;
                }
                if (rec.getAttributes() == null) continue;
                this.values.put((Field)field, rec.getAttributes().get(tfield.getId()).getValue());
                continue;
            }
            if (!(field instanceof SelectorField)) continue;
            tfield = (SelectorField)field;
            for (SelectorItem tsi : tfield.getItems()) {
                if (tfield.getId().equalsIgnoreCase("id1") && rec.getAccount().equalsIgnoreCase(tsi.getValue())) {
                    this.values.put((Field)field, tsi);
                } else if (tfield.getId().equalsIgnoreCase("id2") && rec.getAccount2().equalsIgnoreCase(tsi.getValue())) {
                    this.values.put((Field)field, tsi);
                } else if (rec.getAttributes() != null && rec.getAttributes().get(tfield.getId()) != null && rec.getAttributes().get(tfield.getId()).getValue().equalsIgnoreCase(tsi.getValue())) {
                    this.values.put((Field)field, tsi);
                }
                if (tsi.getCustomData().get("#sequence") == null || ((ScreenDescription)((SequenceCustomData)tsi.getCustomData().get("#sequence")).getScreenSequence().getScreens().get(0)).getSequence().getFields().isEmpty()) continue;
                this.initFields(initData, ((ScreenDescription)((SequenceCustomData)tsi.getCustomData().get("#sequence")).getScreenSequence().getScreens().get(0)).getSequence().getFields());
            }
        }
    }

    private List<IdentityField> getCurrentFields(Map<Field, Object> values) {
        if (this.verifiedIElements != null && this.verifiedIElements.get("#need-more-fields") != null) {
            return this.formFields(this.formFields, null, values);
        }
        boolean fields1 = false;
        boolean fields2 = false;
        int sumOutcome = SumFormatter.parce(this.panel.getSumPanel().getSumOutcomeField().getText(), 0);
        if (this.sum2 != null && sumOutcome >= this.sum2) {
            fields2 = true;
        } else if (this.sum1 != null && (sumOutcome >= this.sum1 || this.needIdentification)) {
            fields1 = true;
        }
        List<IdentityField> fields = null;
        fields = fields2 ? this.formFields(this.formFields, null, values) : (fields1 ? this.formFields(this.formFields, null, values) : this.formFields(this.formFields, null, values));
        if (this.needBudgetFields) {
            fields = this.formFields(fields, null, values);
        }
        return fields;
    }

    private List<IdentityField> formFields(Collection<IdentityField> formMain, Map<String, IdentityField> mapAdditionally, Map<Field, Object> values) {
        LinkedList<IdentityField> flds = new LinkedList<IdentityField>();
        if (mapAdditionally != null) {
            for (IdentityField ff : formMain) {
                if (!(ff instanceof SetField) && ff instanceof TextField) {
                    if (mapAdditionally.get(ff.getId()) != null) {
                        flds.add(mapAdditionally.get(ff.getId()));
                        continue;
                    }
                    flds.add(ff);
                    continue;
                }
                flds.add(ff);
            }
            for (IdentityField ff2 : mapAdditionally.values()) {
                if (flds.contains(ff2)) continue;
                flds.add(ff2);
            }
        } else {
            flds.addAll(formMain);
        }
        if (values != null) {
            HashMap<Field, Object> maptmp = new HashMap<Field, Object>();
            for (Field ffV : values.keySet()) {
                for (Field field : flds) {
                    if (!(field instanceof IdentityField)) continue;
                    IdentityField fldi = (IdentityField)field;
                    IdentityField ffVi = (IdentityField)ffV;
                    if (!fldi.getId().equals(ffVi.getId()) || field.equals(ffV)) continue;
                    maptmp.put(field, values.get(ffV));
                }
            }
            values.putAll(maptmp);
        }
        return flds;
    }

    private Map<Field, Object> getCurrentValues(Map<Field, Object> values) {
        return values;
    }

    @Override
    public void onVerifyResultError(String error) {
        this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438: " + error));
        this.panel.getSumPanel().getPayButton().setEnabled(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onVerifyResult(VerifyResult result, Map<String, Object> ielements) {
        if (result != null && result.getRt() == VerifyResultType.OK) {
            int sumIncome = SumFormatter.parce(this.panel.getSumPanel().getSumIncomeField().getText(), 0);
            int sumOutcome = SumFormatter.parce(this.panel.getSumPanel().getSumOutcomeField().getText(), 0);
            int sumCome = SumFormatter.parce(this.panel.getSumPanel().getSumCommField().getText(), 0);
            this.verifiedIElements = ielements;
            try {
                if (this.references.getPoint().getTypeCashSourcePoint() == 0) {
                    if (ielements.get("fioORCardId") == null || ((InputElement)ielements.get("fioORCardId")).getValue().isEmpty()) {
                        int res = JOptionPane.showConfirmDialog(this.context.getMainFrame(), "\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0430\u043b\u0438\u0447\u043d\u044b\u043c\u0438?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u043e\u043f\u043b\u0430\u0442\u0443 \u043d\u0430\u043b\u0438\u0447\u043d\u044b\u043c\u0438", 0, 1);
                        if (res != 0) return;
                        this.typeCashSourcePayment = 1;
                    } else {
                        this.typeCashSourcePayment = (short)2;
                    }
                }
                RmaPaymentJob job = this.getJob(ielements, sumIncome, sumOutcome, sumCome);
                job.getRecord().setTypeCashSource(this.typeCashSourcePayment);
                if (this.context.toPayment(job)) return;
                this.panel.getSumPanel().getPayButton().setEnabled(true);
                return;
            }
            catch (Exception ex) {
                this.panel.getSumPanel().getPayButton().setEnabled(true);
                this.log.info((Object)(LocBundle.getMessageLog((String)"rma.adv.dopayerr") + " " + ex.getMessage()), (Throwable)ex);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(GeneralProvider.this.context.getMainFrame(), ex.getMessage(), LocBundle.getMessage((String)"rma.adv.dopayerr"), 0);
                    }
                });
            }
            return;
        } else {
            this.verifiedIElements = null;
            this.panel.getSumPanel().getPayButton().setEnabled(true);
        }
    }

    private void checkFields(Map<String, Object> ielements, boolean userReplaces, List<ControlData> data) throws Exception {
        SelectorItem tsi;
        SelectorField textSelector;
        TextField inputField;
        Field ff;
        if (!this.showAll) {
            throw new Exception(LocBundle.getMessageEx((String)"rma.prov.feelall"));
        }
        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.univers.workflds") + " "));
        HashMap<String, String> tvs = new HashMap<String, String>();
        for (ControlData cd : data) {
            ff = cd.getField();
            if (ff instanceof TextField) {
                inputField = (TextField)ff;
                tvs.put(inputField.getId(), (String)cd.getData());
                continue;
            }
            if (!(ff instanceof SelectorField)) continue;
            textSelector = (SelectorField)ff;
            tsi = (SelectorItem)cd.getData();
            tvs.put(textSelector.getId(), tsi == null ? "" : tsi.getValue());
        }
        for (ControlData cd : data) {
            this.log.info((Object)("\t" + cd));
            ff = cd.getField();
            if (ff instanceof TextField) {
                inputField = (TextField)ff;
                String number = (String)cd.getData();
                boolean valid = false;
                if (inputField.getValidator() != null) {
                    valid = inputField.getValidator().validate(number);
                }
                if (!valid) {
                    if (inputField.getFailRegex() != null && !inputField.getFailRegex().isEmpty() && number.matches(inputField.getFailRegex())) {
                        ielements.put("#invalid", new InputElement("#invalid", "#invalid", "true"));
                    } else {
                        GuiUtils.requestFocus(cd.getComponent());
                        if (inputField.getExampleValue() != null && !inputField.getExampleValue().trim().isEmpty()) {
                            throw new Exception(MessageFormat.format(LocBundle.getMessageEx((String)"rma.prov.wrongnumb2"), inputField.getTitle(), inputField.getExampleValue()));
                        }
                        throw new Exception(MessageFormat.format(LocBundle.getMessageEx((String)"rma.prov.wrongnumb"), inputField.getTitle()));
                    }
                }
                ielements.put(inputField.getId(), new InputElement(inputField.getId(), inputField.getTitle(), number, ((MultipleMaskTextField)cd.getComponent()).getTextTitle(), inputField.getFlags()));
                continue;
            }
            if (ff instanceof SelectorField) {
                textSelector = (SelectorField)ff;
                if (cd.getData() == null) {
                    GuiUtils.requestFocus(cd.getComponent());
                    throw new Exception(MessageFormat.format(LocBundle.getMessageEx((String)"rma.prov.wrongnumb"), textSelector.getTitle()));
                }
                tsi = (SelectorItem)cd.getData();
                ielements.put(textSelector.getId(), new InputElement(textSelector.getId(), textSelector.getTitle(), tsi.getValue(), tsi.getTitle(), textSelector.getFlags()));
                continue;
            }
            if (!(ff instanceof SetField)) continue;
            SetField sf = (SetField)ff;
            String val = sf.getValue() == null ? "" : sf.getValue();
            for (String key : tvs.keySet()) {
                val = val.replace("${" + key + "}", (CharSequence)tvs.get(key));
            }
            if (("id1".equals(sf.getId()) || "id2".equals(sf.getId())) && val.length() > 40) {
                val = val.substring(0, 40);
            }
            ielements.put(sf.getId(), new InputElement(sf.getId(), sf.getTitle(), val, val, sf.getFlags()));
        }
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.univers.resform"));
        this.log.info((Object)("\t" + ielements));
    }

    private RmaPaymentJob getJob(Map<String, Object> ielements, int sumIncome, int sumOutcome, int sumComm) {
        return this.getJob(ielements, sumIncome, sumOutcome, sumComm, DocType.Stamp);
    }

    private RmaPaymentJob getJob(Map<String, Object> ielements, int sumIncome, int sumOutcome, int sumComm, DocType docType) {
        RmaPaymentJob job = new RmaPaymentJob();
        Record record = new Record();
        record.setProviderName(this.menuItem.getService().getProv().getName());
        job.setRecord(record);
        record.setServiceId(this.menuItem.getService().getId());
        record.setServiceName(this.menuItem.getService().getName());
        record.setCommissionId(this.menuItem.getCommission().getId());
        InputElement id1 = (InputElement)ielements.get("id1");
        InputElement id2 = (InputElement)ielements.get("id2");
        record.setAccount(id1 != null ? id1.getValue() : null);
        record.setAccountTitle(id1 != null ? id1.getKeyTitle() : null);
        record.setAccountValueTitle(id1 != null ? id1.getValueTitle() : null);
        record.setAccount2(id2 != null ? id2.getValue() : null);
        record.setAccount2Title(id2 != null ? id2.getKeyTitle() : null);
        record.setAccount2ValueTitle(id2 != null ? id2.getValueTitle() : null);
        record.setCreated(new Date());
        ielements.remove("id1");
        ielements.remove("id2");
        LinkedHashMap<String, RmaAttribute> attrs = new LinkedHashMap<String, RmaAttribute>();
        for (String key : ielements.keySet()) {
            if (key.startsWith("#")) continue;
            RmaAttribute atr = new RmaAttribute();
            atr.setKey(key);
            atr.setKeyTitle(((InputElement)ielements.get(key)).getKeyTitle());
            atr.setValue(((InputElement)ielements.get(key)).getValue());
            atr.setValueTitle(((InputElement)ielements.get(key)).getValueTitle());
            attrs.put(key, atr);
        }
        attrs.putAll(ConvertUtils.inpElmMap2AtrMap(this.formContext));
        record.setAttributes(attrs);
        record.setSumIncome(sumIncome);
        record.setSumOutcome(sumOutcome);
        record.setSumComm(record.getSumIncome() - record.getSumOutcome());
        record.setComment(this.panel.getSumPanel().getCommentField().getText());
        record.setDocType(Configuration.getInstance().getData().getDocType());
        record.setIdShift(ShiftManager.getInstance().getShiftId());
        job.setPrintDocument(this.panel.getSumPanel().getPrintDocumentCheckBox().isSelected());
        job.setPrintRequest(this.panel.getSumPanel().getPrintRequestCheckBox().isSelected());
        job.setMenuItem(this.menuItem);
        job.setOperatorName(CurrentUser.getInstance().getKassirFio());
        return job;
    }

    private class LocalPrintRequestListener
    implements ActionListener {
        private LocalPrintRequestListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String comment = null;
            if (!SumPanelHelper.verify(GeneralProvider.this.context.getMainFrame(), GeneralProvider.this.menuItem, GeneralProvider.this.panel.getSumPanel())) {
                GeneralProvider.this.panel.getSumPanel().getPrintButton().setEnabled(true);
                GeneralProvider.this.panel.getSumPanel().getPayButton().setEnabled(false);
                return;
            }
            if (GeneralProvider.this.isFieldsChanged) {
                RmaCancelOperationDialog dialog = new RmaCancelOperationDialog((Frame)GeneralProvider.this.context.getMainFrame(), true);
                dialog.setTitle(LocBundle.getMessage((String)"rma.canseloperating.postprintchanges"));
                dialog.setVisible(true);
                if (dialog.isCanselled()) {
                    GeneralProvider.this.log.info((Object)"\u0423\u043d\u0438\u0432\u0435\u0440\u0441\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440, \u041a\u0430\u0441\u0441\u0438\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b\u0441\u044f \u0432\u0432\u043e\u0434\u0438\u0442\u044c \u043f\u0440\u0438\u0447\u0438\u043d\u044b \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438");
                    return;
                }
                comment = dialog.getComment();
            }
            GeneralProvider.this.log.info((Object)LocBundle.getMessageLog((String)"rma.beginprintrequest"));
            int sumIncome = SumFormatter.parce(GeneralProvider.this.panel.getSumPanel().getSumIncomeField().getText(), 0);
            int sumOutcome = SumFormatter.parce(GeneralProvider.this.panel.getSumPanel().getSumOutcomeField().getText(), 0);
            int sumComm = SumFormatter.parce(GeneralProvider.this.panel.getSumPanel().getSumCommField().getText(), 0);
            HashMap<String, Object> ielements = new HashMap<String, Object>();
            try {
                GeneralProvider.this.checkFields(ielements, false, GeneralProvider.this.panel.getData());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(GeneralProvider.this.context.getMainFrame(), ex.getMessage(), LocBundle.getMessageLog((String)"rma.view.verifyerr"), 0);
                return;
            }
            if (GeneralProvider.this.menuItem.getService().getVerifyType() == 0) {
                GeneralProvider.this.log.info((Object)"\u0414\u0435\u043b\u0430\u044e \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438");
                GeneralProvider.this.context.toVerify(GeneralProvider.this.menuItem.getService().getId(), ielements, new VerifyAfterPayResultListener(comment), true);
            } else {
                GeneralProvider.this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0431\u0435\u0437 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438");
                RmaPaymentJob job = GeneralProvider.this.getJob(ielements, sumIncome, sumOutcome, sumComm, null);
                job.getRecord().setComment(comment);
                job.setPrintMode(PrintMode.Default);
                job.getRecord().setPrintInfo(3);
                GeneralProvider.this.currentJob = job;
                GeneralProvider.this.context.addRequestPrint(new RequestData(job, GeneralProvider.this.references), GeneralProvider.this.printResultListener);
            }
        }
    }

    private class LocalSumOutcomeFieldsListener
    implements Runnable {
        private int value = 0;

        private LocalSumOutcomeFieldsListener() {
        }

        @Override
        public void run() {
            boolean needReinit;
            if (GeneralProvider.this.sum1 == null && GeneralProvider.this.sum2 == null) {
                return;
            }
            int sumOutcome = SumFormatter.parce(GeneralProvider.this.panel.getSumPanel().getSumOutcomeField().getText(), 0);
            boolean bl = needReinit = this.value < GeneralProvider.this.sum1 && sumOutcome >= GeneralProvider.this.sum1 || this.value < GeneralProvider.this.sum2 && sumOutcome >= GeneralProvider.this.sum2 || this.value >= GeneralProvider.this.sum1 && sumOutcome < GeneralProvider.this.sum1 || this.value >= GeneralProvider.this.sum2 && sumOutcome < GeneralProvider.this.sum2;
            if (needReinit) {
                this.value = sumOutcome;
                Component focusOwner = FocusManager.getCurrentManager().getFocusOwner();
                GeneralProvider.this.panel.reinitFields(null);
                if (focusOwner instanceof JComponent) {
                    GuiUtils.requestFocus((JComponent)focusOwner);
                }
            }
        }
    }

    private class VerifyClientListener
    implements VerifyResultListener {
        private VerifyClientListener() {
        }

        @Override
        public void onVerifyResultError(String error) {
        }

        @Override
        public void onVerifyResult(VerifyResult result, Map<String, Object> ielements) {
            if (result != null && result.getRt() == VerifyResultType.OK) {
                System.out.println("\u041e\u041a");
            }
        }
    }

    private class LocalCheckListener
    implements ActionListener {
        private LocalCheckListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GeneralProvider.this.log.info((Object)LocBundle.getMessageLog((String)"rma.mobile.ndonlinever"));
            if (!SumPanelHelper.verify(GeneralProvider.this.context.getMainFrame(), GeneralProvider.this.menuItem, GeneralProvider.this.panel.getSumPanel())) {
                GeneralProvider.this.panel.getSumPanel().getPayButton().setEnabled(false);
                GeneralProvider.this.panel.getSumPanel().getPrintButton().setEnabled(true);
                return;
            }
            HashMap<String, Object> ielements = new HashMap<String, Object>();
            try {
                GeneralProvider.this.checkFields(ielements, false, GeneralProvider.this.panel.getData());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(GeneralProvider.this.context.getMainFrame(), ex.getMessage(), LocBundle.getMessageLog((String)"rma.view.verifyerr"), 0);
                return;
            }
            GeneralProvider.this.context.toVerify(GeneralProvider.this.menuItem.getService().getId(), ielements, new VerifyClientListener(), false);
        }
    }

    private class LocalInterfaceListener
    implements InterfaceListener {
        private LocalInterfaceListener() {
        }

        @Override
        public void onChange(final Map<Field, Object> values) {
            Logger logUni = Logger.getLogger((String)"uni");
            logUni.info((Object)(LocBundle.getMessageLog((String)"rma.univers.newctrlsst") + " "));
            Integer sumPurchase = null;
            for (Field ff : values.keySet()) {
                SelectorItem tsi;
                logUni.info((Object)("\t" + ff + "->" + values.get(ff)));
                if (!(ff instanceof SelectorField) || (tsi = (SelectorItem)values.get(ff)).getData() == null || tsi.getData().getSum() == null) continue;
                sumPurchase = tsi.getData().getSum().getSum();
                GeneralProvider.this.log.info((Object)(LocBundle.getMessageLog((String)"rma.univers.setnewsumm") + " " + sumPurchase));
            }
            GeneralProvider.this.panel.getSumPanel().getSumOutcomeField().setEnabled(sumPurchase == null);
            GeneralProvider.this.panel.getSumPanel().getSumIncomeField().setEnabled(sumPurchase == null);
            if (sumPurchase != null) {
                GeneralProvider.this.log.info((Object)(LocBundle.getMessageLog((String)"rma.univers.summtoscr") + " " + SumFormatter.format(sumPurchase)));
                GeneralProvider.this.panel.getSumPanel().getSumOutcomeField().setText(SumFormatter.format(sumPurchase));
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GeneralProvider.this.log.info((Object)"\u0412\u044b\u0432\u043e\u0436\u0443 \u043f\u043e\u043b\u044f");
                    GeneralProvider.this.showAll = GeneralProvider.this.panel.showFields(GeneralProvider.this.getCurrentFields(values), GeneralProvider.this.getCurrentValues(values));
                    GeneralProvider.this.log.debug((Object)(GeneralProvider.this.showAll ? LocBundle.getMessageLog((String)"rma.univers.showallflds") : LocBundle.getMessageLog((String)"rma.univers.showntallflds")));
                }
            });
        }

        @Override
        public void setNeedIdentification(boolean _needIdentification) {
            GeneralProvider.this.needIdentification = _needIdentification;
        }

        @Override
        public void setNeedBudgetFields(boolean _needBudgetFields) {
            GeneralProvider.this.needBudgetFields = _needBudgetFields;
            GeneralProvider.this.log.info((Object)(">>> [GeneralProvider - listener] needBudgetFields=" + GeneralProvider.this.needBudgetFields));
        }

        @Override
        public void onChangeClientField(String idField, String valueField) {
            GeneralProvider.this.log.info((Object)LocBundle.getMessageLog((String)"rma.mobile.ndonlineverfio"));
            HashMap<String, Object> ielements = new HashMap<String, Object>();
            ielements.put(idField, new InputElement(idField, idField, valueField, valueField, 0));
            ielements.put("id1", new InputElement("id1", "id1", "id1", "id1", 0));
            GeneralProvider.this.context.toVerify(GeneralProvider.this.menuItem.getService().getId(), ielements, new VerifyClientListener(), true);
        }
    }

    public class CancelActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            GeneralProvider.this.log.info((Object)("\u0423\u043d\u0438\u0432\u0435\u0440\u0441\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440, \u0424\u043b\u0430\u0433 \u043f\u0435\u0447\u0430\u0442\u0438 = " + GeneralProvider.this.isPrinted));
            if (GeneralProvider.this.isPrinted && GeneralProvider.this.currentJob != null) {
                RmaCancelOperationDialog dialog = new RmaCancelOperationDialog((Frame)GeneralProvider.this.context.getMainFrame(), true);
                dialog.setTitle(LocBundle.getMessage((String)"rma.canseloperating.postprintchanges"));
                dialog.setVisible(true);
                if (dialog.isCanselled()) {
                    GeneralProvider.this.log.info((Object)"\u0423\u043d\u0438\u0432\u0435\u0440\u0441\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440, \u041a\u0430\u0441\u0441\u0438\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b\u0441\u044f \u043e\u0442 \u043e\u0442\u043c\u0435\u043d\u044b \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438");
                    return;
                }
                String comment = dialog.getComment();
                GeneralProvider.this.log.info((Object)("\u0423\u043d\u0438\u0432\u0435\u0440\u0441\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440, \u041a\u0430\u0441\u0441\u0438\u0440 \u0432\u0432\u0451\u043b " + comment));
                try {
                    GeneralProvider.this.currentJob.getRecord().setComment(comment);
                    GeneralProvider.this.currentJob.getRecord().setState((short)80);
                    GeneralProvider.this.currentJob.getRecord().setSubstate((short)2);
                    PersistenceManager.getInstance().canselByCart(GeneralProvider.this.currentJob.getRecord(), CurrentUser.getInstance().getUserId());
                    GeneralProvider.this.context.clearPrintedOperationData();
                }
                catch (PersistenceException ex) {
                    GeneralProvider.this.log.error((Object)"\u0423\u043d\u0438\u0432\u0435\u0440\u0441\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440, \u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043c\u0435\u043d\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u043e\u0442 \u043e\u0442\u043a\u0430\u0437\u0435", (Throwable)ex);
                }
            }
            GeneralProvider.this.context.toMainMenu();
        }
    }

    public class LocalChangedFieldsListener
    implements FildsChangedListener {
        @Override
        public void fieldsChanged() {
            GeneralProvider.this.isFieldsChanged = GeneralProvider.this.isPrinted;
        }
    }

    private class VerifyAfterPayResultListener
    implements VerifyResultListener {
        String comment;

        public VerifyAfterPayResultListener(String comment) {
            this.comment = comment;
        }

        @Override
        public void onVerifyResultError(String error) {
        }

        @Override
        public void onVerifyResult(VerifyResult result, Map<String, Object> ielements) {
            if (result.getRt() == VerifyResultType.OK) {
                GeneralProvider.this.log.info((Object)"\u0421 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0432\u0435\u0440\u043d\u0443\u043b\u0441\u044f \u0443\u0441\u043f\u0435\u0445, \u043f\u0435\u0440\u0435\u043d\u043e\u0448\u0443 \u0432 \u043a\u043e\u0440\u0437\u0438\u043d\u0443");
                int sumIncome = SumFormatter.parce(GeneralProvider.this.panel.getSumPanel().getSumIncomeField().getText(), 0);
                int sumOutcome = SumFormatter.parce(GeneralProvider.this.panel.getSumPanel().getSumOutcomeField().getText(), 0);
                int sumCome = SumFormatter.parce(GeneralProvider.this.panel.getSumPanel().getSumCommField().getText(), 0);
                RmaPaymentJob job = GeneralProvider.this.getJob(ielements, sumIncome, sumOutcome, sumCome, null);
                job.setPrintMode(PrintMode.Default);
                job.getRecord().setPrintInfo(3);
                GeneralProvider.this.currentJob = job;
                GeneralProvider.this.currentJob.getRecord().setComment(this.comment);
                GeneralProvider.this.context.addRequestPrint(new RequestData(job, GeneralProvider.this.references), GeneralProvider.this.printResultListener);
            }
        }
    }

    private class ProcessActionListener
    implements ActionListener {
        private ProcessActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GeneralProvider.this.log.info((Object)MessageFormat.format(LocBundle.getMessageLog((String)"rma.hk.trytopay"), "", GeneralProvider.this.panel.getSumPanel().getSumIncomeField().getText(), GeneralProvider.this.panel.getSumPanel().getSumOutcomeField().getText()));
            try {
                if (GeneralProvider.this.currentJob == null) {
                    throw new IllegalArgumentException("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0440\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
                }
                if (!SumPanelHelper.verify(GeneralProvider.this.context.getMainFrame(), GeneralProvider.this.menuItem, GeneralProvider.this.panel.getSumPanel())) {
                    GeneralProvider.this.panel.getSumPanel().getPayButton().setEnabled(false);
                    GeneralProvider.this.panel.getSumPanel().getPrintButton().setEnabled(true);
                    return;
                }
                GeneralProvider.this.context.toPayment(GeneralProvider.this.currentJob);
                GeneralProvider.this.context.clearPrintedOperationData();
            }
            catch (Exception ex) {
                GeneralProvider.this.panel.getSumPanel().getPayButton().setEnabled(true);
                GeneralProvider.this.log.info((Object)(LocBundle.getMessageLog((String)"rma.adv.dopayerr") + " " + ex.getMessage()), (Throwable)ex);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(GeneralProvider.this.context.getMainFrame(), ex.getMessage(), LocBundle.getMessage((String)"rma.adv.dopayerr"), 0);
                    }
                });
            }
        }
    }
}

