/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.universal.general;

import info.clearthought.layout.TableLayout;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.FocusManager;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.Document;
import org.apache.log4j.Logger;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import rmai18n.LocBundle;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.Field;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.barcode.BarcodeData;
import ru.softlogic.input.model.field.barcode.BarcodeException;
import ru.softlogic.input.model.field.numeric.NumericField;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.field.selector.custom.RedirectCustomData;
import ru.softlogic.input.model.field.selector.custom.SequenceCustomData;
import ru.softlogic.input.model.field.text.KeyboardType;
import ru.softlogic.input.model.field.text.TextField;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.rma.RmaApp;
import ru.softlogic.rma.RmaAppContext;
import ru.softlogic.rma.app.Configuration;
import ru.softlogic.rma.app.components.JScrollPopupMenu;
import ru.softlogic.rma.app.components.MultipleMaskTextField;
import ru.softlogic.rma.app.docs.DigitalNumberDocument;
import ru.softlogic.rma.app.docs.LetterNumberDocument;
import ru.softlogic.rma.connector.model.References;
import ru.softlogic.rma.model.add.BankRecord;
import ru.softlogic.rma.model.add.PD4Fields;
import ru.softlogic.rma.model.add.PD4Record;
import ru.softlogic.rma.providers.advanced.Helper;
import ru.softlogic.rma.providers.panels.PrintButtonsPanel;
import ru.softlogic.rma.providers.panels.SumPanel;
import ru.softlogic.rma.providers.panels.SumPanel1;
import ru.softlogic.rma.providers.universal.form.BarcodeField;
import ru.softlogic.rma.providers.universal.form.SetField;
import ru.softlogic.rma.providers.universal.general.ACManager;
import ru.softlogic.rma.providers.universal.general.ComboBoxTextItem;
import ru.softlogic.rma.providers.universal.general.ControlData;
import ru.softlogic.rma.providers.universal.general.InterfaceListener;
import ru.softlogic.rma.utils.FontResizer;
import ru.softlogic.rma.utils.MessageUtils;
import ru.softlogic.rma.utils.RSParser;
import ru.softlogic.rma.utils.SumFormatter;

public class GeneralPanel1
extends JPanel {
    private References references;
    private Font defaultLabelFont;
    private Font defaultFieldFont;
    private JPanel panel1;
    private Logger log;
    private LocalItemListener itemListener;
    private List<InterfaceListener> listeners;
    private List<JComponent> controls;
    private SumPanel1 sumPanel;
    private LocalFocusListener focusListener;
    private RmaAppContext context;
    private ACManager acm;
    private JButton clearAllButton;
    private String idCurrFocusField;
    private JPanel contentPanel;
    private JScrollPane jScrollPane1;

    public GeneralPanel1() {
        this.initComponents();
        this.panel1 = new JPanel();
        this.panel1.setLayout((LayoutManager)new TableLayout(new double[]{0.0, 140.0, 6.0, -1.0, 7.0, 0.0}, new double[0]));
        this.sumPanel = new SumPanel1();
        this.sumPanel.getPrintContentPanel().add((Component)new PrintButtonsPanel(), "South");
        FontResizer.process(this.sumPanel, Configuration.getInstance().getData().getSoftwareFontSize());
        GroupLayout layout = new GroupLayout(this.contentPanel);
        this.contentPanel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.panel1, 0, 100, Short.MAX_VALUE).addComponent(this.sumPanel, 0, 100, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.panel1, -2, -2, -2).addGap(10, 10, 10).addComponent(this.sumPanel, -2, -2, Short.MAX_VALUE)));
        ResourceMap resourceMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getResourceMap(SumPanel.class);
        this.defaultFieldFont = this.sumPanel.getSumIncomeField().getFont();
        this.defaultLabelFont = this.sumPanel.getSumIncomeLabel().getFont();
        this.log = Logger.getLogger((String)"uni");
        this.log.setAdditivity(false);
        this.itemListener = new LocalItemListener();
        this.listeners = new LinkedList<InterfaceListener>();
        this.controls = new LinkedList<JComponent>();
        this.focusListener = new LocalFocusListener();
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(10);
        this.acm = new ACManager();
        this.acm.setFields(new HashMap<String, MultipleMaskTextField>());
        this.clearAllButton = new JButton(LocBundle.getMessage((String)"clear.all"));
        this.clearAllButton.addActionListener(new LocalClearAllListener());
        this.clearAllButton.setFocusable(false);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", new LocalScrollListener());
        this.jScrollPane1.setInputMap(1, new InputMap());
    }

    public boolean showFields(List<IdentityField> fields, Map<Field, Object> values) {
        for (Field ff : values.keySet()) {
            this.log.info((Object)(ff + "->" + values.get(ff)));
        }
        this.contentPanel.setVisible(false);
        this.panel1.removeAll();
        this.controls.clear();
        this.contentPanel.setVisible(true);
        TableLayout layout = new TableLayout(new double[]{0.0, 170.0, 6.0, -1.0, 7.0, 0.0}, new double[0]);
        this.panel1.setLayout((LayoutManager)layout);
        return this._showFields(fields, values, layout);
    }

    private boolean _showFields(List<IdentityField> fields, Map<Field, Object> values, TableLayout layout) {
        boolean focusSet = false;
        if (fields == null) {
            return true;
        }
        LocalPopupComponentListener popListener = new LocalPopupComponentListener();
        this.acm.getFields().clear();
        if (PD4Fields.isPD4InForm(fields)) {
            layout.insertRow(layout.getNumRow(), 6.0);
            layout.insertRow(layout.getNumRow(), 22.0);
            this.panel1.add((Component)this.clearAllButton, "1," + (layout.getNumRow() - 1) + ",f,f");
        }
        for (Field field : fields) {
            JLabel label;
            Object field2;
            if (field instanceof TextField) {
                String val;
                layout.insertRow(layout.getNumRow(), 6.0);
                layout.insertRow(layout.getNumRow(), (double)this.defaultFieldFont.getSize() * 1.8);
                field2 = (TextField)field;
                label = new JLabel(MessageUtils.process((IdentityField)field2));
                label.setFont(this.defaultLabelFont);
                label.setToolTipText(field2.getMessage());
                this.panel1.add((Component)label, "1," + (layout.getNumRow() - 1) + ",r,f");
                MultipleMaskTextField formTextField = new MultipleMaskTextField(this.createDocument(field2.getKeyboard().getType(), field2.getMaxLength(), field2.getPrefix(), field2.getKeyboard().getExtraCharacter() == null || Character.isWhitespace(field2.getKeyboard().getExtraCharacter().charValue()) ? null : field2.getKeyboard().getExtraCharacter()), field2.getPrefix(), field2.getViewFormatter());
                if (this.acm.getPd4records() != null && ("corr_bik".equals(field2.getId()) || "recipient_acc".equals(field2.getId()) || "corr_name".equals(field2.getId()) || "corr_oktmo".equals(field2.getId()) || "corr_kbk".equals(field2.getId()))) {
                    formTextField.addMouseListener(popListener);
                    formTextField.addFocusListener(popListener);
                    formTextField.addKeyListener(popListener);
                    JScrollPopupMenu menu = new JScrollPopupMenu(formTextField);
                    menu.setPopupListener(popListener);
                    formTextField.add(menu);
                    formTextField.setComponentPopupMenu(menu);
                    formTextField.getDocument().addDocumentListener(new LocalPopupFieldDocumentListener(formTextField));
                } else if ("corr_bik".equals(field2.getId())) {
                    formTextField.getDocument().addDocumentListener(new LocalPopupFieldDocumentListener(formTextField));
                }
                formTextField.putClientProperty("field", field2);
                formTextField.setToolTipText(field2.getMessage());
                formTextField.setEditable(!field2.isReadOnly());
                formTextField.addFocusListener(this.focusListener);
                if ("corr_acc".equals(field2.getId()) || "corr_bank_name".equals(field2.getId())) {
                    formTextField.setEditable(false);
                }
                formTextField.setFocusable(formTextField.isEditable());
                HashSet<AWTKeyStroke> forwardKeys = new HashSet<AWTKeyStroke>(this.getFocusTraversalKeys(0));
                forwardKeys.add(KeyStroke.getKeyStroke(10, 0));
                formTextField.setFocusTraversalKeys(0, forwardKeys);
                this.acm.getFields().put(field2.getId(), formTextField);
                this.controls.add(formTextField);
                this.panel1.add((Component)formTextField, "3," + (layout.getNumRow() - 1));
                if (values.get(field2) != null) {
                    val = (String)values.get(field2);
                    this.log.debug((Object)(LocBundle.getMessageLog((String)"rma.univers.setfldval") + " " + val));
                    formTextField.setText(val);
                } else if (field2.getDefaultValue() != null && !field2.getDefaultValue().isEmpty()) {
                    val = field2.getDefaultValue();
                    this.log.debug((Object)(LocBundle.getMessageLog((String)"rma.univers.setflddefval") + " " + val));
                    formTextField.setText(val);
                } else if (this.idCurrFocusField != null && !this.idCurrFocusField.isEmpty() && this.idCurrFocusField.equals(field2.getId()) || !focusSet) {
                    this.log.debug((Object)LocBundle.getMessageLog((String)"rma.univers.setfocus"));
                    formTextField.requestFocus();
                    focusSet = true;
                }
                formTextField.setFont(this.defaultFieldFont);
                continue;
            }
            if (field instanceof SetField) {
                JLabel lab = new JLabel();
                lab.putClientProperty("field", field);
                this.controls.add(lab);
                continue;
            }
            if (field instanceof NumericField) {
                this.log.error((Object)LocBundle.getMessageLog((String)"rma.univers.nonuminp"));
                continue;
            }
            if (field instanceof SelectorField) {
                this.log.debug((Object)LocBundle.getMessageLog((String)"rma.univers.dotxtsel"));
                layout.insertRow(layout.getNumRow(), 6.0);
                layout.insertRow(layout.getNumRow(), (double)this.defaultFieldFont.getSize() * 1.8);
                field2 = (SelectorField)field;
                label = new JLabel(MessageUtils.process((IdentityField)field2));
                label.setFont(this.defaultLabelFont);
                label.setToolTipText(field2.getMessage());
                this.panel1.add((Component)label, "1," + (layout.getNumRow() - 1) + ",r,f");
                JComboBox<ComboBoxTextItem> comboBox = new JComboBox<ComboBoxTextItem>();
                comboBox.addFocusListener(this.focusListener);
                comboBox.putClientProperty("field", field2);
                boolean hasCases = false;
                ComboBoxTextItem[] items = new ComboBoxTextItem[field2.getItems().size()];
                for (int i = 0; i < field2.getItems().size(); ++i) {
                    SelectorItem tsi = (SelectorItem)field2.getItems().get(i);
                    this.log.debug((Object)(LocBundle.getMessageLog((String)"rma.univers.do") + " " + tsi));
                    items[i] = new ComboBoxTextItem(tsi);
                    if (hasCases || tsi.getCustomData().get("#sequence") == null || ((ScreenDescription)((SequenceCustomData)tsi.getCustomData().get("#sequence")).getScreenSequence().getScreens().get(0)).getSequence().getFields().isEmpty()) continue;
                    hasCases = true;
                    this.log.debug((Object)LocBundle.getMessageLog((String)"rma.univers.stflgbch"));
                }
                comboBox.setModel(new DefaultComboBoxModel<ComboBoxTextItem>(items));
                comboBox.setSelectedItem(null);
                comboBox.setToolTipText(field2.getMessage());
                comboBox.addPopupMenuListener(new LocalComboBoxItemsPopupListener());
                comboBox.addKeyListener(new LocalComboBoxKeyListener());
                SelectorItem tsi = null;
                this.panel1.add(comboBox, "3," + (layout.getNumRow() - 1));
                if (values.get(field2) != null) {
                    tsi = (SelectorItem)values.get(field2);
                    this.log.debug((Object)(LocBundle.getMessageLog((String)"rma.univers.setval") + " " + tsi));
                    comboBox.setSelectedItem(new ComboBoxTextItem(tsi));
                } else if (field2.getSelectedIndex() != null) {
                    comboBox.setSelectedIndex(field2.getSelectedIndex());
                } else if (this.idCurrFocusField != null && !this.idCurrFocusField.isEmpty() && this.idCurrFocusField.equals(field2.getId()) || !focusSet) {
                    comboBox.requestFocus();
                    focusSet = true;
                }
                this.controls.add(comboBox);
                comboBox.addItemListener(this.itemListener);
                if (!hasCases) continue;
                if (tsi != null) {
                    this.log.debug((Object)LocBundle.getMessageLog((String)"rma.univers.seltdsel"));
                    if (this._showFields(((ScreenDescription)((SequenceCustomData)tsi.getCustomData().get("#sequence")).getScreenSequence().getScreens().get(0)).getSequence().getFields(), values, layout)) continue;
                    return false;
                }
                this.log.debug((Object)LocBundle.getMessageLog((String)"rma.univers.ntseltdsel"));
                return false;
            }
            if (!(field instanceof BarcodeField) || !Configuration.getInstance().getData().isBarcodeScannerPresent()) continue;
            this.log.debug((Object)LocBundle.getMessageLog((String)"rma.univers.dobarcodeel"));
            layout.insertRow(layout.getNumRow(), 6.0);
            layout.insertRow(layout.getNumRow(), (double)this.defaultFieldFont.getSize() * 1.8);
            field2 = (BarcodeField)field;
            label = new JLabel(LocBundle.getMessage((String)"rma.univers.barcode"));
            label.setFont(this.defaultLabelFont);
            this.panel1.add((Component)label, "1," + (layout.getNumRow() - 1) + ",r,f");
            JPanel bp = new JPanel((LayoutManager)new TableLayout(new double[]{-1.0, 25.0}, new double[]{-2.0}));
            bp.setOpaque(false);
            JTextField tf = new JTextField();
            tf.setFont(this.defaultFieldFont);
            tf.setToolTipText(LocBundle.getMessage((String)"rma.univers.barcodepopup"));
            JLabel icon = new JLabel();
            bp.add((Component)tf, "0,0");
            bp.add((Component)icon, "1,0");
            this.panel1.add((Component)bp, "3," + (layout.getNumRow() - 1));
            tf.addKeyListener(new LocalBarcodeActionListener((BarcodeField)((Object)field2), icon));
            ResourceMap resourceMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getResourceMap();
            icon.setIcon(resourceMap.getIcon("RmaView.successBarcode.icon"));
            if ((this.idCurrFocusField == null || this.idCurrFocusField.isEmpty() || !this.idCurrFocusField.equals(field2.getId())) && focusSet) continue;
            this.log.debug((Object)LocBundle.getMessageLog((String)"rma.univers.setfocus"));
            tf.requestFocus();
            focusSet = true;
        }
        return true;
    }

    public void addListener(InterfaceListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public List<ControlData> getData() {
        LinkedList<ControlData> result = new LinkedList<ControlData>();
        for (JComponent control : this.controls) {
            if (control instanceof MultipleMaskTextField) {
                MultipleMaskTextField textField = (MultipleMaskTextField)control;
                TextField tif = (TextField)textField.getClientProperty("field");
                String val = textField.getText();
                this.log.info((Object)(LocBundle.getMessageLog((String)"rma.univers.add") + " " + tif + "->" + val));
                result.add(new ControlData((Field)tif, val, control));
                continue;
            }
            if (control instanceof JComboBox) {
                JComboBox comboBox = (JComboBox)control;
                if (!(comboBox.getClientProperty("field") instanceof SelectorField)) continue;
                SelectorField selector = (SelectorField)comboBox.getClientProperty("field");
                SelectorItem item = null;
                if (comboBox.getSelectedItem() != null) {
                    item = ((ComboBoxTextItem)comboBox.getSelectedItem()).getItem();
                }
                this.log.info((Object)(LocBundle.getMessageLog((String)"rma.univers.add") + " " + selector + "->" + item));
                result.add(new ControlData((Field)selector, item, control));
                continue;
            }
            if (!(control instanceof JLabel)) continue;
            SetField sf = (SetField)((Object)control.getClientProperty("field"));
            this.log.info((Object)(LocBundle.getMessageLog((String)"rma.univers.add") + " " + (Object)((Object)sf)));
            result.add(new ControlData((Field)sf, sf.getValue(), control));
        }
        return result;
    }

    void setContext(RmaAppContext context) {
        this.context = context;
    }

    public void reinitFields(Object source) {
        HashMap<Field, Object> result = new HashMap<Field, Object>();
        for (JComponent control : this.controls) {
            JComboBox comboBox;
            TextField tif;
            JTextField textField;
            if (control instanceof MultipleMaskTextField) {
                textField = (MultipleMaskTextField)control;
                tif = (TextField)textField.getClientProperty("field");
                this.log.info((Object)(LocBundle.getMessageLog((String)"rma.univers.add") + " " + tif + "->" + ((MultipleMaskTextField)textField).getText()));
                if (((MultipleMaskTextField)textField).getText() == null || ((MultipleMaskTextField)textField).getText().isEmpty()) continue;
                result.put((Field)tif, ((MultipleMaskTextField)textField).getText());
                continue;
            }
            if (control instanceof JTextField) {
                textField = (JTextField)control;
                tif = (TextField)textField.getClientProperty("field");
                this.log.info((Object)(LocBundle.getMessageLog((String)"rma.univers.add") + " " + tif + "->" + textField.getText()));
                result.put((Field)tif, textField.getText());
                continue;
            }
            if (!(control instanceof JComboBox) || !((comboBox = (JComboBox)control).getClientProperty("field") instanceof SelectorField)) continue;
            SelectorField selector = (SelectorField)comboBox.getClientProperty("field");
            if (comboBox.getSelectedItem() == null) continue;
            SelectorItem item = ((ComboBoxTextItem)comboBox.getSelectedItem()).getItem();
            this.log.info((Object)(LocBundle.getMessageLog((String)"rma.univers.add") + " " + selector + "->" + item));
            result.put((Field)selector, item);
        }
        for (InterfaceListener l : this.listeners) {
            l.onChange(result);
        }
    }

    void setPD4Records(PD4Record[] pD4Record) {
        this.acm.setPD4Records(pD4Record);
    }

    void setBankRecords(Map<String, BankRecord> bankRecords) {
        this.acm.setBankRecords(bankRecords);
    }

    public JButton getClearAllButton() {
        return this.clearAllButton;
    }

    public boolean showCardFields(Collection<IdentityField> fields, Map<Field, Object> values) {
        for (Field ff : values.keySet()) {
            this.log.info((Object)(ff + "->" + values.get(ff)));
        }
        this.contentPanel.setVisible(false);
        this.sumPanel.getCardPanel().removeAll();
        this.contentPanel.setVisible(true);
        TableLayout layout = new TableLayout(new double[]{0.0, 170.0, 6.0, -1.0, 7.0, 0.0}, new double[0]);
        this.sumPanel.getCardPanel().setLayout((LayoutManager)layout);
        LinkedList<IdentityField> fields1 = new LinkedList<IdentityField>();
        fields1.addAll(fields);
        return this._showCardFields(fields1, values, layout, this.sumPanel.getCardPanel());
    }

    private boolean _showCardFields(List<IdentityField> fields, Map<Field, Object> values, TableLayout layout, JPanel panel1) {
        boolean focusSet = false;
        if (fields == null) {
            return true;
        }
        LocalPopupComponentListener popListener = new LocalPopupComponentListener();
        this.acm.getFields().clear();
        if (PD4Fields.isPD4InForm(fields)) {
            layout.insertRow(layout.getNumRow(), 6.0);
            layout.insertRow(layout.getNumRow(), 22.0);
            panel1.add((Component)this.clearAllButton, "1," + (layout.getNumRow() - 1) + ",f,f");
        }
        layout.insertRow(layout.getNumRow(), 15.0);
        for (Field field : fields) {
            JLabel label;
            Object field2;
            if (field instanceof TextField) {
                String val;
                layout.insertRow(layout.getNumRow(), 6.0);
                layout.insertRow(layout.getNumRow(), (double)this.defaultFieldFont.getSize() * 1.8);
                field2 = (TextField)field;
                label = new JLabel(MessageUtils.process((IdentityField)field2));
                label.setFont(this.defaultLabelFont);
                label.setToolTipText(field2.getMessage());
                panel1.add((Component)label, "1," + (layout.getNumRow() - 1) + ",r,f");
                MultipleMaskTextField formTextField = new MultipleMaskTextField(this.createDocument(field2.getKeyboard().getType(), field2.getMaxLength(), field2.getPrefix(), field2.getKeyboard().getExtraCharacter() == null || Character.isWhitespace(field2.getKeyboard().getExtraCharacter().charValue()) ? null : field2.getKeyboard().getExtraCharacter()), field2.getPrefix(), field2.getViewFormatter());
                if (this.acm.getPd4records() != null && ("corr_bik".equals(field2.getId()) || "recipient_acc".equals(field2.getId()) || "corr_name".equals(field2.getId()) || "corr_oktmo".equals(field2.getId()) || "corr_kbk".equals(field2.getId()))) {
                    formTextField.addMouseListener(popListener);
                    formTextField.addFocusListener(popListener);
                    formTextField.addKeyListener(popListener);
                    JScrollPopupMenu menu = new JScrollPopupMenu(formTextField);
                    menu.setPopupListener(popListener);
                    formTextField.add(menu);
                    formTextField.setComponentPopupMenu(menu);
                    formTextField.getDocument().addDocumentListener(new LocalPopupFieldDocumentListener(formTextField));
                } else if ("corr_bik".equals(field2.getId())) {
                    formTextField.getDocument().addDocumentListener(new LocalPopupFieldDocumentListener(formTextField));
                }
                formTextField.putClientProperty("field", field2);
                formTextField.setToolTipText(field2.getMessage());
                formTextField.setEditable(!field2.isReadOnly());
                formTextField.addFocusListener(this.focusListener);
                if ("corr_acc".equals(field2.getId()) || "corr_bank_name".equals(field2.getId())) {
                    formTextField.setEditable(false);
                }
                formTextField.setFocusable(formTextField.isEditable());
                HashSet<AWTKeyStroke> forwardKeys = new HashSet<AWTKeyStroke>(this.getFocusTraversalKeys(0));
                forwardKeys.add(KeyStroke.getKeyStroke(10, 0));
                formTextField.setFocusTraversalKeys(0, forwardKeys);
                this.acm.getFields().put(field2.getId(), formTextField);
                this.controls.add(formTextField);
                panel1.add((Component)formTextField, "3," + (layout.getNumRow() - 1));
                if (values.get(field2) != null) {
                    val = (String)values.get(field2);
                    this.log.debug((Object)(LocBundle.getMessageLog((String)"rma.univers.setfldval") + " " + val));
                    formTextField.setText(val);
                } else if (field2.getDefaultValue() != null && !field2.getDefaultValue().isEmpty()) {
                    val = field2.getDefaultValue();
                    this.log.debug((Object)(LocBundle.getMessageLog((String)"rma.univers.setflddefval") + " " + val));
                    formTextField.setText(val);
                } else if (this.idCurrFocusField != null && !this.idCurrFocusField.isEmpty() && this.idCurrFocusField.equals(field2.getId()) || !focusSet) {
                    this.log.debug((Object)LocBundle.getMessageLog((String)"rma.univers.setfocus"));
                }
                formTextField.setFont(this.defaultFieldFont);
                continue;
            }
            if (field instanceof SetField) {
                JLabel lab = new JLabel();
                lab.putClientProperty("field", field);
                this.controls.add(lab);
                continue;
            }
            if (field instanceof NumericField) {
                this.log.error((Object)LocBundle.getMessageLog((String)"rma.univers.nonuminp"));
                continue;
            }
            if (field instanceof SelectorField) {
                this.log.debug((Object)LocBundle.getMessageLog((String)"rma.univers.dotxtsel"));
                layout.insertRow(layout.getNumRow(), 6.0);
                layout.insertRow(layout.getNumRow(), (double)this.defaultFieldFont.getSize() * 1.8);
                field2 = (SelectorField)field;
                label = new JLabel(MessageUtils.process((IdentityField)field2));
                label.setFont(this.defaultLabelFont);
                label.setToolTipText(field2.getMessage());
                panel1.add((Component)label, "1," + (layout.getNumRow() - 1) + ",r,f");
                JComboBox<ComboBoxTextItem> comboBox = new JComboBox<ComboBoxTextItem>();
                comboBox.addFocusListener(this.focusListener);
                comboBox.putClientProperty("field", field2);
                boolean hasCases = false;
                ComboBoxTextItem[] items = new ComboBoxTextItem[field2.getItems().size()];
                for (int i = 0; i < field2.getItems().size(); ++i) {
                    SelectorItem tsi = (SelectorItem)field2.getItems().get(i);
                    this.log.debug((Object)(LocBundle.getMessageLog((String)"rma.univers.do") + " " + tsi));
                    items[i] = new ComboBoxTextItem(tsi);
                    if (hasCases || tsi.getCustomData().get("#sequence") == null || ((ScreenDescription)((SequenceCustomData)tsi.getCustomData().get("#sequence")).getScreenSequence().getScreens().get(0)).getSequence().getFields().isEmpty()) continue;
                    hasCases = true;
                    this.log.debug((Object)LocBundle.getMessageLog((String)"rma.univers.stflgbch"));
                }
                comboBox.setModel(new DefaultComboBoxModel<ComboBoxTextItem>(items));
                comboBox.setSelectedItem(null);
                comboBox.setToolTipText(field2.getMessage());
                comboBox.addPopupMenuListener(new LocalComboBoxItemsPopupListener());
                comboBox.addKeyListener(new LocalComboBoxKeyListener());
                SelectorItem tsi = null;
                panel1.add(comboBox, "3," + (layout.getNumRow() - 1));
                if (values.get(field2) != null) {
                    tsi = (SelectorItem)values.get(field2);
                    this.log.debug((Object)(LocBundle.getMessageLog((String)"rma.univers.setval") + " " + tsi));
                    comboBox.setSelectedItem(new ComboBoxTextItem(tsi));
                } else if (this.idCurrFocusField != null && !this.idCurrFocusField.isEmpty() && this.idCurrFocusField.equals(field2.getId()) || !focusSet) {
                    comboBox.requestFocus();
                    focusSet = true;
                }
                this.controls.add(comboBox);
                comboBox.addItemListener(this.itemListener);
                if (!hasCases) continue;
                if (tsi != null) {
                    this.log.debug((Object)LocBundle.getMessageLog((String)"rma.univers.seltdsel"));
                    if (this._showFields(((ScreenDescription)((SequenceCustomData)tsi.getCustomData().get("#sequence")).getScreenSequence().getScreens().get(0)).getSequence().getFields(), values, layout)) continue;
                    return false;
                }
                this.log.debug((Object)LocBundle.getMessageLog((String)"rma.univers.ntseltdsel"));
                return false;
            }
            if (!(field instanceof BarcodeField) || !Configuration.getInstance().getData().isBarcodeScannerPresent()) continue;
            this.log.debug((Object)LocBundle.getMessageLog((String)"rma.univers.dobarcodeel"));
            layout.insertRow(layout.getNumRow(), 6.0);
            layout.insertRow(layout.getNumRow(), (double)this.defaultFieldFont.getSize() * 1.8);
            field2 = (BarcodeField)field;
            label = new JLabel(LocBundle.getMessage((String)"rma.univers.barcode"));
            label.setFont(this.defaultLabelFont);
            panel1.add((Component)label, "1," + (layout.getNumRow() - 1) + ",r,f");
            JPanel bp = new JPanel((LayoutManager)new TableLayout(new double[]{-1.0, 25.0}, new double[]{-2.0}));
            bp.setOpaque(false);
            JTextField tf = new JTextField();
            tf.setFont(this.defaultFieldFont);
            tf.setToolTipText(LocBundle.getMessage((String)"rma.univers.barcodepopup"));
            JLabel icon = new JLabel();
            bp.add((Component)tf, "0,0");
            bp.add((Component)icon, "1,0");
            panel1.add((Component)bp, "3," + (layout.getNumRow() - 1));
            tf.addKeyListener(new LocalBarcodeActionListener((BarcodeField)((Object)field2), icon));
            ResourceMap resourceMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getResourceMap();
            icon.setIcon(resourceMap.getIcon("RmaView.successBarcode.icon"));
            if ((this.idCurrFocusField == null || this.idCurrFocusField.isEmpty() || !this.idCurrFocusField.equals(field2.getId())) && focusSet) continue;
            this.log.debug((Object)LocBundle.getMessageLog((String)"rma.univers.setfocus"));
            tf.requestFocus();
            focusSet = true;
        }
        layout.insertRow(layout.getNumRow(), 20.0);
        return true;
    }

    private Document createDocument(KeyboardType type, int maxLen, String prefix, Character xbutton) {
        if (KeyboardType.Digital.equals((Object)type)) {
            return new DigitalNumberDocument(maxLen, prefix, xbutton);
        }
        return new LetterNumberDocument(maxLen, prefix);
    }

    public SumPanel1 getSumPanel() {
        return this.sumPanel;
    }

    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    public void initPanel(References references) {
        this.references = references;
        this.sumPanel.getSumIncomeField().setText("");
        this.sumPanel.getSumOutcomeField().setText("");
        this.sumPanel.getSumCommField().setText("");
        this.sumPanel.getCommentField().setText("");
        this.sumPanel.getCardPanel().setVisible(references.getPoint().getTypeCashSourcePoint() != 1);
    }

    private String getPrefix(String prefix) {
        if (prefix != null) {
            if ("$city".equals(prefix)) {
                if (this.references != null && this.references.getPoint() != null) {
                    return this.references.getPoint().getCityName();
                }
            } else if ("$city.code".equals(prefix) && this.references != null && this.references.getPoint() != null) {
                return this.references.getPoint().getCityCode();
            }
        }
        return prefix;
    }

    private String getNextFocusField(String nameField) {
        String id = "";
        Iterator<JComponent> iter = this.controls.iterator();
        while (iter.hasNext()) {
            TextField tif1;
            JComponent jcomp = iter.next();
            if (!(jcomp.getClientProperty("field") instanceof TextField) || !nameField.equals((tif1 = (TextField)jcomp.getClientProperty("field")).getId())) continue;
            JComponent comp = null;
            do {
                try {
                    comp = iter.next();
                }
                catch (NoSuchElementException neex) {
                    id = null;
                    break;
                }
            } while (!(comp instanceof MultipleMaskTextField) && !(comp instanceof JComboBox) || !this.canBeFocus(comp));
            if (comp == null || !(comp.getClientProperty("field") instanceof IdentityField)) break;
            IdentityField iff = (IdentityField)comp.getClientProperty("field");
            id = iff.getId();
            break;
        }
        return id;
    }

    private boolean canBeFocus(Component component) {
        return component.isEnabled() && component.isDisplayable() && component.isVisible() && component.isFocusable();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.contentPanel = new JPanel();
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setPreferredSize(new Dimension(311, 394));
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3));
        this.jScrollPane1.setFocusable(false);
        this.contentPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.contentPanel.setMinimumSize(new Dimension(23, 25));
        GroupLayout contentPanelLayout = new GroupLayout(this.contentPanel);
        this.contentPanel.setLayout(contentPanelLayout);
        contentPanelLayout.setHorizontalGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 485, Short.MAX_VALUE));
        contentPanelLayout.setVerticalGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 379, Short.MAX_VALUE));
        this.jScrollPane1.setViewportView(this.contentPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 309, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 392, Short.MAX_VALUE));
    }

    private class LocalScrollListener
    implements PropertyChangeListener {
        private LocalScrollListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!(evt.getNewValue() instanceof JComponent)) {
                return;
            }
            JComponent focused = (JComponent)evt.getNewValue();
            if (GeneralPanel1.this.contentPanel.isAncestorOf(focused)) {
                int y = 0;
                JComponent comp = focused;
                while (comp != null && comp.getParent() != null && comp.getParent() != GeneralPanel1.this.contentPanel) {
                    y += comp.getBounds().y;
                    if (comp.getParent() instanceof JComponent) {
                        comp = (JComponent)comp.getParent();
                        continue;
                    }
                    comp = null;
                }
                if (comp != null) {
                    y += comp.getBounds().y;
                }
                Rectangle bounds = focused.getBounds();
                bounds.y = y;
                GeneralPanel1.this.contentPanel.scrollRectToVisible(bounds);
            }
        }
    }

    private class LocalBarcodeActionListener
    extends KeyAdapter {
        private BarcodeField bf;
        private JLabel icon;

        public LocalBarcodeActionListener(BarcodeField bf, JLabel icon) {
            if (bf == null) {
                throw new NullPointerException();
            }
            this.bf = bf;
            this.icon = icon;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10 && e.getSource() instanceof JTextField) {
                ResourceMap resourceMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getResourceMap();
                JTextField tf = (JTextField)e.getSource();
                String code = tf.getText();
                tf.setText("");
                try {
                    BarcodeData bd = this.bf.getParser().parse(code);
                    if (bd != null && bd.getElements() != null) {
                        HashMap<String, JComponent> components = new HashMap<String, JComponent>();
                        for (JComponent control : GeneralPanel1.this.controls) {
                            if (control instanceof MultipleMaskTextField) {
                                MultipleMaskTextField textField = (MultipleMaskTextField)control;
                                TextField tif = (TextField)textField.getClientProperty("field");
                                components.put(tif.getId(), control);
                                continue;
                            }
                            if (!(control instanceof JLabel)) continue;
                            SetField sf = (SetField)((Object)control.getClientProperty("field"));
                            components.put(sf.getId(), control);
                        }
                        for (InputElement ie : bd.getElements()) {
                            JComponent comp = (JComponent)components.get(ie.getKey());
                            if (comp == null) {
                                if ("#sum".equals(ie.getKey())) {
                                    if ("units".equals(this.bf.getSumType())) {
                                        try {
                                            GeneralPanel1.this.sumPanel.getSumOutcomeField().setText(SumFormatter.format(Double.parseDouble(ie.getValue())));
                                        }
                                        catch (Exception tif) {}
                                        continue;
                                    }
                                    if (!"decimal".equals(this.bf.getSumType())) continue;
                                    try {
                                        GeneralPanel1.this.sumPanel.getSumOutcomeField().setText(SumFormatter.format(Integer.parseInt(ie.getValue())));
                                    }
                                    catch (Exception tif) {}
                                    continue;
                                }
                                JLabel lab = new JLabel();
                                SetField sf = new SetField();
                                sf.setId(ie.getKey());
                                sf.setTitle(ie.getKeyTitle());
                                sf.setValue(ie.getValue());
                                lab.putClientProperty("field", (Object)sf);
                                GeneralPanel1.this.controls.add(lab);
                                continue;
                            }
                            if (comp instanceof MultipleMaskTextField) {
                                MultipleMaskTextField textField = (MultipleMaskTextField)comp;
                                textField.setText(ie.getValue());
                                continue;
                            }
                            if (!(comp instanceof JLabel)) continue;
                            SetField sf = (SetField)((Object)comp.getClientProperty("field"));
                            sf.setValue(ie.getValue());
                        }
                    }
                    this.icon.setIcon(resourceMap.getIcon("RmaView.successBarcode.icon"));
                    this.icon.setToolTipText(LocBundle.getMessage((String)"rma.univers.barcodesucc"));
                }
                catch (BarcodeException be) {
                    this.icon.setIcon(resourceMap.getIcon("RmaView.errorBarcode.icon"));
                    this.icon.setToolTipText(LocBundle.getMessage((String)"rma.univers.barcodeerr"));
                    GeneralPanel1.this.log.error((Object)be);
                }
            }
        }
    }

    private class LocalClearAllListener
    implements ActionListener {
        private LocalClearAllListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GeneralPanel1.this.acm.disableProcess();
            for (MultipleMaskTextField mf : GeneralPanel1.this.acm.getFields().values()) {
                mf.setText("");
            }
            GeneralPanel1.this.acm.enableProcess();
            if (FocusManager.getCurrentManager().getFocusOwner() instanceof JComponent) {
                GeneralPanel1.this.acm.processPopup((JComponent)FocusManager.getCurrentManager().getFocusOwner());
            }
        }
    }

    private class LocalPopupFieldDocumentListener
    implements DocumentListener {
        private JTextField field;

        public LocalPopupFieldDocumentListener(JTextField field) {
            this.field = field;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            GeneralPanel1.this.acm.processPopup(this.field);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            GeneralPanel1.this.acm.processPopup(this.field);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }

    private class LocalPopupComponentListener
    extends MouseAdapter
    implements FocusListener,
    KeyListener,
    Runnable {
        private LocalPopupComponentListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JTextField tf;
            if (e.getClickCount() >= 2 && e.getSource() instanceof JTextField && (tf = (JTextField)e.getSource()).getComponentPopupMenu() != null) {
                JScrollPopupMenu popup = (JScrollPopupMenu)tf.getComponentPopupMenu();
                if (popup.isVisible()) {
                    popup.hide();
                    tf.setFocusTraversalKeysEnabled(true);
                } else if (((JScrollPopupMenu)tf.getComponentPopupMenu()).getItemsCount() > 0) {
                    popup.show();
                    tf.setFocusTraversalKeysEnabled(false);
                }
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() instanceof JComponent) {
                GeneralPanel1.this.acm.processPopup((JComponent)e.getSource());
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (e.getSource() instanceof JTextField) {
                TextField tif;
                JTextField tf = (JTextField)e.getSource();
                if (tf.getComponentPopupMenu() != null) {
                    tf.getComponentPopupMenu().setVisible(false);
                    tf.setFocusTraversalKeysEnabled(true);
                }
                if (tf.getClientProperty("field") instanceof TextField && "recipient_acc".equals((tif = (TextField)tf.getClientProperty("field")).getId())) {
                    final boolean needIdentification = RSParser.getInstance().checkRS(tf.getText());
                    for (InterfaceListener il : GeneralPanel1.this.listeners) {
                        il.setNeedIdentification(needIdentification);
                    }
                    GeneralPanel1.this.idCurrFocusField = GeneralPanel1.this.getNextFocusField("recipient_acc");
                    GeneralPanel1.this.reinitFields(null);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (needIdentification) {
                                JOptionPane.showMessageDialog(GeneralPanel1.this, LocBundle.getMessage((String)"rma.needidentification"), LocBundle.getMessage((String)"rma.needidentificationtitle"), 1);
                            }
                        }
                    });
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            JTextField tf;
            if ((e.getKeyCode() == 38 || e.getKeyCode() == 40 || e.getKeyCode() == 10 || e.getKeyCode() == 32 || e.getKeyCode() == 27) && e.getSource() instanceof JTextField && (tf = (JTextField)e.getSource()).getComponentPopupMenu() != null) {
                JScrollPopupMenu popup = (JScrollPopupMenu)tf.getComponentPopupMenu();
                if (e.getKeyCode() == 32 && e.isControlDown()) {
                    if (popup.isVisible()) {
                        popup.hide();
                        tf.setFocusTraversalKeysEnabled(true);
                    } else if (((JScrollPopupMenu)tf.getComponentPopupMenu()).getItemsCount() > 0) {
                        popup.show();
                        tf.setFocusTraversalKeysEnabled(false);
                    }
                } else if (e.getKeyCode() == 27) {
                    if (popup.isVisible()) {
                        popup.hide();
                        tf.setFocusTraversalKeysEnabled(true);
                    }
                } else if (e.getKeyCode() == 38 && popup.isVisible()) {
                    popup.prevSelection();
                } else if (e.getKeyCode() == 40 && popup.isVisible()) {
                    popup.nextSelection();
                } else if (e.getKeyCode() == 10 && popup.isVisible()) {
                    popup.selectCurrent();
                    tf.setFocusTraversalKeysEnabled(true);
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void run() {
            GeneralPanel1.this.acm.processAutoComplete();
        }
    }

    private class LocalComboBoxKeyListener
    extends KeyAdapter {
        private LocalComboBoxKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            JComboBox box;
            if (e.getSource() instanceof JComboBox && !(box = (JComboBox)e.getSource()).isPopupVisible()) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 40) {
                    FocusManager.getCurrentManager().focusNextComponent(box);
                } else if (e.getKeyCode() == 38) {
                    FocusManager.getCurrentManager().focusPreviousComponent(box);
                }
            }
        }
    }

    private class LocalComboBoxItemsPopupListener
    implements PopupMenuListener {
        private LocalComboBoxItemsPopupListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            JComboBox box;
            if (e.getSource() instanceof JComboBox && (box = (JComboBox)e.getSource()).getSelectedIndex() > -1) {
                Object src = ((JComboBox)e.getSource()).getClientProperty("field");
                if (src instanceof SelectorField) {
                    GeneralPanel1.this.log.debug((Object)LocBundle.getMessageLog((String)"rma.univers.textselch"));
                    SelectorItem tsi = ((ComboBoxTextItem)box.getSelectedItem()).getItem();
                    GeneralPanel1.this.log.debug((Object)(LocBundle.getMessageLog((String)"rma.univers.newvaltxtsel") + " " + src + "->" + tsi));
                    GeneralPanel1.this.log.debug((Object)LocBundle.getMessageLog((String)"rma.univers.ndupdpanel"));
                    if (tsi.getCustomData() != null && tsi.getCustomData().get("#redirect") != null && GeneralPanel1.this.context != null) {
                        short code = ((RedirectCustomData)tsi.getCustomData().get("#redirect")).getService();
                        GeneralPanel1.this.context.openService(code, Helper.extractData(GeneralPanel1.this.controls));
                    }
                    GeneralPanel1.this.reinitFields(e.getSource());
                } else {
                    GeneralPanel1.this.log.debug((Object)(LocBundle.getMessageLog((String)"rma.univers.selunknel") + " " + src));
                }
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    private class LocalFocusListener
    implements FocusListener {
        private LocalFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getComponent() instanceof MultipleMaskTextField) {
                MultipleMaskTextField tf = (MultipleMaskTextField)e.getComponent();
                TextField tif = (TextField)tf.getClientProperty("field");
                if (tif.getHelp() != null && !tif.getHelp().isEmpty()) {
                    String text = tif.getHelp().replaceAll("<terminal>.*</terminal>", "").replaceAll("<keeper>.*</keeper>", "").replaceAll("<rma>", "").replaceAll("</rma>", "");
                    GeneralPanel1.this.sumPanel.getHelpLabel().setText("<html>" + text);
                    GeneralPanel1.this.sumPanel.getHelpLabelPanel().setVisible(true);
                } else {
                    GeneralPanel1.this.sumPanel.getHelpLabelPanel().setVisible(false);
                }
            } else if (e.getComponent() instanceof JComboBox) {
                // empty if block
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            GeneralPanel1.this.sumPanel.getHelpLabelPanel().setVisible(false);
        }
    }

    private class LocalItemListener
    implements ItemListener {
        private LocalItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() instanceof JComboBox) {
                JComboBox box = (JComboBox)e.getSource();
                if (e.getStateChange() == 1 && !box.isPopupVisible()) {
                    Object src = ((JComboBox)e.getSource()).getClientProperty("field");
                    if (src instanceof SelectorField) {
                        GeneralPanel1.this.log.debug((Object)LocBundle.getMessageLog((String)"rma.univers.textselch"));
                        SelectorItem tsi = ((ComboBoxTextItem)e.getItem()).getItem();
                        GeneralPanel1.this.log.debug((Object)(LocBundle.getMessageLog((String)"rma.univers.newvaltxtsel") + " " + src + "->" + tsi));
                        GeneralPanel1.this.log.debug((Object)LocBundle.getMessageLog((String)"rma.univers.ndupdpanel"));
                        if (tsi.getCustomData() != null && tsi.getCustomData().get("#redirect") != null && GeneralPanel1.this.context != null) {
                            short code = ((RedirectCustomData)tsi.getCustomData().get("#redirect")).getService();
                            GeneralPanel1.this.context.openService(code, Helper.extractData(GeneralPanel1.this.controls));
                        }
                        GeneralPanel1.this.reinitFields(e.getSource());
                    } else {
                        GeneralPanel1.this.log.debug((Object)(LocBundle.getMessageLog((String)"rma.univers.selunknel") + " " + src));
                    }
                }
            }
        }
    }
}

