/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.universal.general;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import ru.softlogic.input.model.field.text.TextField;
import ru.softlogic.rma.app.components.JScrollPopupMenu;
import ru.softlogic.rma.app.components.MultipleMaskTextField;
import ru.softlogic.rma.model.add.BankRecord;
import ru.softlogic.rma.model.add.PD4Fields;
import ru.softlogic.rma.model.add.PD4Record;
import ru.softlogic.rma.model.add.PD4RecordComparator;
import ru.softlogic.rma.providers.universal.general.ChangePD4FieldsListener;

public class ACManager {
    private Map<String, Set<PD4Record>> bikRecords = new HashMap<String, Set<PD4Record>>();
    private Map<String, Set<PD4Record>> rsRecords = new HashMap<String, Set<PD4Record>>();
    private Map<String, Set<PD4Record>> recipientRecords = new HashMap<String, Set<PD4Record>>();
    private Map<String, Set<PD4Record>> okatoRecords = new HashMap<String, Set<PD4Record>>();
    private Map<String, Set<PD4Record>> kbkRecords = new HashMap<String, Set<PD4Record>>();
    private Map<String, Set<PD4Record>> innRecords = new HashMap<String, Set<PD4Record>>();
    private PD4Record[] pd4records;
    private Map<String, MultipleMaskTextField> fields;
    private Map<String, BankRecord> bankRecords;
    private boolean disableProcess = false;
    private ChangePD4FieldsListener changeListener;

    public void setBankRecords(Map<String, BankRecord> bankRecords) {
        this.bankRecords = bankRecords;
    }

    public void setPD4Records(PD4Record[] pd4Records) {
        this.bikRecords.clear();
        this.rsRecords.clear();
        this.okatoRecords.clear();
        this.kbkRecords.clear();
        this.innRecords.clear();
        this.pd4records = pd4Records;
        if (pd4Records != null) {
            for (PD4Record rec : pd4Records) {
                if (rec.getBik() != null) {
                    if (this.bikRecords.get(rec.getBik()) == null) {
                        this.bikRecords.put(rec.getBik(), new HashSet());
                    }
                    this.bikRecords.get(rec.getBik()).add(rec);
                }
                if (rec.getRs() != null) {
                    if (this.rsRecords.get(rec.getRs()) == null) {
                        this.rsRecords.put(rec.getRs(), new HashSet());
                    }
                    this.rsRecords.get(rec.getRs()).add(rec);
                }
                if (rec.getName() != null) {
                    if (this.recipientRecords.get(rec.getName()) == null) {
                        this.recipientRecords.put(rec.getName(), new HashSet());
                    }
                    this.recipientRecords.get(rec.getName()).add(rec);
                }
                if (rec.getOkato() != null) {
                    if (this.okatoRecords.get(rec.getOkato()) == null) {
                        this.okatoRecords.put(rec.getOkato(), new HashSet());
                    }
                    this.okatoRecords.get(rec.getOkato()).add(rec);
                }
                if (rec.getKbk() != null) {
                    if (this.kbkRecords.get(rec.getKbk()) == null) {
                        this.kbkRecords.put(rec.getKbk(), new HashSet());
                    }
                    this.kbkRecords.get(rec.getKbk()).add(rec);
                }
                if (rec.getInn() == null) continue;
                if (this.innRecords.get(rec.getInn()) == null) {
                    this.innRecords.put(rec.getInn(), new HashSet());
                }
                this.innRecords.get(rec.getInn()).add(rec);
            }
        }
    }

    public PD4Record[] getPd4records() {
        return this.pd4records;
    }

    public void setFields(Map<String, MultipleMaskTextField> flds) {
        this.fields = flds;
    }

    public Map<String, MultipleMaskTextField> getFields() {
        return this.fields;
    }

    public void processPopup(JComponent comp) {
        if (this.disableProcess) {
            return;
        }
        HashSet<PD4Record> currentRecs = new HashSet<PD4Record>();
        if (this.pd4records != null) {
            currentRecs.addAll(Arrays.asList(this.pd4records));
        }
        if (this.fields != null) {
            if (comp == this.fields.get("corr_bik")) {
                if (this.isValid(this.fields.get("corr_bik"))) {
                    if (this.bankRecords != null && this.bankRecords.get(this.fields.get("corr_bik").getText()) != null) {
                        BankRecord bankRec = this.bankRecords.get(this.fields.get("corr_bik").getText());
                        if (this.fields.get("corr_bank_name") != null) {
                            this.fields.get("corr_bank_name").setText(bankRec.getName());
                        }
                        if (this.fields.get("corr_acc") != null) {
                            this.fields.get("corr_acc").setText(bankRec.getKs());
                        }
                    }
                } else {
                    if (this.fields.get("corr_bank_name") != null) {
                        this.fields.get("corr_bank_name").setText("");
                    }
                    if (this.fields.get("corr_acc") != null) {
                        this.fields.get("corr_acc").setText("");
                    }
                }
            }
            if (this.isValid(this.fields.get("corr_bik"))) {
                if (this.bikRecords.get(this.fields.get("corr_bik").getText()) != null) {
                    currentRecs.retainAll((Collection)this.bikRecords.get(this.fields.get("corr_bik").getText()));
                } else {
                    currentRecs.clear();
                }
            }
            if (this.isValid(this.fields.get("recipient_acc"))) {
                if (this.rsRecords.get(this.fields.get("recipient_acc").getText()) != null) {
                    currentRecs.retainAll((Collection)this.rsRecords.get(this.fields.get("recipient_acc").getText()));
                } else {
                    currentRecs.clear();
                }
            }
            if (this.isValid(this.fields.get("corr_name")) && this.recipientRecords.get(this.fields.get("corr_name").getText()) != null) {
                currentRecs.retainAll((Collection)this.recipientRecords.get(this.fields.get("corr_name").getText()));
            }
            if (this.isValid(this.fields.get("corr_inn")) && this.innRecords.get(this.fields.get("corr_inn").getText()) != null) {
                currentRecs.retainAll((Collection)this.innRecords.get(this.fields.get("corr_inn").getText()));
            }
            if (this.isValid(this.fields.get("corr_oktmo")) && !this.fields.get("corr_oktmo").getText().trim().isEmpty() && this.okatoRecords.get(this.fields.get("corr_oktmo").getText()) != null) {
                currentRecs.retainAll((Collection)this.okatoRecords.get(this.fields.get("corr_oktmo").getText()));
            }
            if (this.isValid(this.fields.get("corr_kbk")) && !this.fields.get("corr_kbk").getText().trim().isEmpty() && this.kbkRecords.get(this.fields.get("corr_kbk").getText()) != null) {
                currentRecs.retainAll((Collection)this.kbkRecords.get(this.fields.get("corr_kbk").getText()));
            }
            if (comp instanceof JTextField) {
                JTextField tf = (JTextField)comp;
                String txt = tf.getText();
                if (txt == null) {
                    txt = "";
                }
                if (tf.getComponentPopupMenu() != null) {
                    PD4RecordComparator comparator = null;
                    comparator = comp == this.fields.get("corr_bik") ? new PD4RecordComparator("corr_bik") : (comp == this.fields.get("recipient_acc") ? new PD4RecordComparator("recipient_acc") : (comp == this.fields.get("corr_name") ? new PD4RecordComparator("corr_name") : (comp == this.fields.get("corr_oktmo") ? new PD4RecordComparator("corr_oktmo") : (comp == this.fields.get("corr_kbk") ? new PD4RecordComparator("corr_kbk") : (comp == this.fields.get("corr_inn") ? new PD4RecordComparator("corr_inn") : new PD4RecordComparator(""))))));
                    TreeSet<PD4Record> recs = new TreeSet<PD4Record>(comparator);
                    recs.addAll(currentRecs);
                    JScrollPopupMenu popup = (JScrollPopupMenu)tf.getComponentPopupMenu();
                    popup.clearItems();
                    for (PD4Record rec : recs) {
                        if (comp == this.fields.get("corr_bik") && rec.getBik() != null && rec.getBik().startsWith(txt)) {
                            tf.getComponentPopupMenu().add(new JMenuItem(rec.getBik()));
                            continue;
                        }
                        if (comp == this.fields.get("recipient_acc") && rec.getRs() != null && rec.getRs().startsWith(txt)) {
                            tf.getComponentPopupMenu().add(new JMenuItem(rec.getRs()));
                            continue;
                        }
                        if (comp == this.fields.get("corr_name") && rec.getName() != null && rec.getName().toLowerCase().startsWith(txt.toLowerCase())) {
                            tf.getComponentPopupMenu().add(new JMenuItem(rec.getName()));
                            continue;
                        }
                        if (comp == this.fields.get("corr_oktmo") && rec.getOkato() != null && rec.getOkato().startsWith(txt)) {
                            tf.getComponentPopupMenu().add(new JMenuItem(rec.getOkato()));
                            continue;
                        }
                        if (comp == this.fields.get("corr_kbk") && rec.getKbk() != null && rec.getKbk().startsWith(txt)) {
                            tf.getComponentPopupMenu().add(new JMenuItem(rec.getKbk()));
                            continue;
                        }
                        if (comp != this.fields.get("corr_inn") || rec.getInn() == null || !rec.getInn().startsWith(txt)) continue;
                        tf.getComponentPopupMenu().add(new JMenuItem(rec.getInn()));
                    }
                    if (popup.getItemsCount() == 0) {
                        popup.hide();
                    } else if (popup.isVisible()) {
                        popup.hide();
                        popup.show();
                    }
                }
            }
        }
    }

    public void processAutoComplete() {
        HashSet<PD4Record> currentRecs = new HashSet<PD4Record>();
        if (this.pd4records != null) {
            currentRecs.addAll(Arrays.asList(this.pd4records));
        }
        if (this.fields != null) {
            if (this.isValid(this.fields.get("corr_bik"))) {
                if (this.bikRecords.get(this.fields.get("corr_bik").getText()) != null) {
                    currentRecs.retainAll((Collection)this.bikRecords.get(this.fields.get("corr_bik").getText()));
                } else {
                    currentRecs.clear();
                }
            }
            if (this.isValid(this.fields.get("recipient_acc"))) {
                if (this.rsRecords.get(this.fields.get("recipient_acc").getText()) != null) {
                    currentRecs.retainAll((Collection)this.rsRecords.get(this.fields.get("recipient_acc").getText()));
                } else {
                    currentRecs.clear();
                }
            }
            if (this.isValid(this.fields.get("corr_name")) && this.recipientRecords.get(this.fields.get("corr_name").getText()) != null) {
                currentRecs.retainAll((Collection)this.recipientRecords.get(this.fields.get("corr_name").getText()));
            }
            if (this.isValid(this.fields.get("corr_inn")) && this.innRecords.get(this.fields.get("corr_inn").getText()) != null) {
                currentRecs.retainAll((Collection)this.innRecords.get(this.fields.get("corr_inn").getText()));
            }
            if (this.isValid(this.fields.get("corr_oktmo")) && !this.fields.get("corr_oktmo").getText().trim().isEmpty() && this.okatoRecords.get(this.fields.get("corr_oktmo").getText()) != null) {
                currentRecs.retainAll((Collection)this.okatoRecords.get(this.fields.get("corr_oktmo").getText()));
            }
            if (this.isValid(this.fields.get("corr_kbk")) && !this.fields.get("corr_kbk").getText().trim().isEmpty() && this.kbkRecords.get(this.fields.get("corr_kbk").getText()) != null) {
                currentRecs.retainAll((Collection)this.kbkRecords.get(this.fields.get("corr_kbk").getText()));
            }
            if (!currentRecs.isEmpty()) {
                PD4Record rec = (PD4Record)currentRecs.iterator().next();
                if (this.fields.get("corr_inn") != null && PD4Fields.isSingleValue(currentRecs, "corr_inn")) {
                    this.fields.get("corr_inn").setText(rec.getInn());
                }
                if (this.fields.get("corr_kpp") != null && PD4Fields.isSingleValue(currentRecs, "corr_kpp")) {
                    this.fields.get("corr_kpp").setText(rec.getKpp());
                }
                if (this.fields.get("pay_purpose") != null && PD4Fields.isSingleValue(currentRecs, "pay_purpose")) {
                    this.fields.get("pay_purpose").setText(rec.getDestination());
                }
                if (this.fields.get("corr_bik") != null && PD4Fields.isSingleValue(currentRecs, "corr_bik")) {
                    this.fields.get("corr_bik").setText(rec.getBik());
                }
                if (this.fields.get("recipient_acc") != null && PD4Fields.isSingleValue(currentRecs, "recipient_acc")) {
                    this.fields.get("recipient_acc").setText(rec.getRs());
                    this.changeListener.onChange("recipient_acc", rec.getRs());
                }
                if (this.fields.get("corr_name") != null && PD4Fields.isSingleValue(currentRecs, "corr_name")) {
                    this.fields.get("corr_name").setText(rec.getName());
                }
                if (this.fields.get("corr_oktmo") != null && PD4Fields.isSingleValue(currentRecs, "corr_oktmo")) {
                    this.fields.get("corr_oktmo").setText(rec.getOkato());
                }
                if (this.fields.get("corr_kbk") != null && PD4Fields.isSingleValue(currentRecs, "corr_kbk")) {
                    this.fields.get("corr_kbk").setText(rec.getKbk());
                }
            }
        }
    }

    private boolean isValid(MultipleMaskTextField tf) {
        if (tf == null) {
            return false;
        }
        if (tf.getClientProperty("field") instanceof TextField) {
            TextField tif = (TextField)tf.getClientProperty("field");
            String number = tf.getText();
            return tif.getValidator().validate(number);
        }
        return false;
    }

    void disableProcess() {
        this.disableProcess = true;
    }

    void enableProcess() {
        this.disableProcess = false;
    }

    public void setChangeListener(ChangePD4FieldsListener changeListener) {
        this.changeListener = changeListener;
    }
}

