/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.mobile;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.rma.connector.model.MenuItem;
import ru.softlogic.rma.connector.model.PersonalNumber;
import ru.softlogic.rma.connector.model.Service;
import ru.softlogic.rma.connector.model.ServiceType;
import ru.softlogic.rma.providers.mobile.CapacityElement;
import ru.softlogic.rma.providers.mobile.Provider;

public class MobileValidator {
    private List<CapacityElement> elements;
    private Map<Integer, Provider> providers;
    private Map<Short, String> regions;
    private Provider currentProvider;
    private String currentRegion;
    private Set<Integer> services;
    private PersonalNumber[] personalNumbers;
    private Logger log = Logger.getLogger((String)"pay");

    public void setElements(List<CapacityElement> elements, Map<Integer, Provider> providers, Map<Short, String> regions) {
        this.elements = elements;
        this.providers = providers;
        this.regions = regions;
    }

    public Provider getCurrentProvider() {
        return this.currentProvider;
    }

    public String getCurrentRegion() {
        return this.currentRegion;
    }

    public void init(ServiceType[] serviceTypes, PersonalNumber[] personalNumbers) {
        this.personalNumbers = personalNumbers;
        this.services = new HashSet<Integer>();
        if (serviceTypes != null && serviceTypes.length > 0) {
            for (ServiceType st : serviceTypes) {
                if (st.getItems() == null) continue;
                for (MenuItem mi : st.getItems()) {
                    Service srv = mi.getService();
                    if (srv == null || srv.getProviderType() != 1) continue;
                    this.services.add(srv.getCode());
                    if (srv.getChildServices() == null || srv.getChildServices().size() <= 0) continue;
                    this.services.addAll(srv.getChildServices());
                }
            }
        }
    }

    public void init(MenuItem menuItem, PersonalNumber[] personalNumbers) {
        this.personalNumbers = personalNumbers;
        this.services = new HashSet<Integer>();
        this.services.add(menuItem.getService().getCode());
        if (menuItem.getService().getChildServices() != null && menuItem.getService().getChildServices().size() > 0) {
            this.services.addAll(menuItem.getService().getChildServices());
        }
    }

    public boolean validate(String data) {
        this.currentProvider = null;
        this.currentRegion = null;
        if (this.elements != null && this.elements.size() > 0 && data.length() > 4) {
            String fullDataBegin = null;
            String fullDataEnd = null;
            if (data.length() < 10) {
                fullDataBegin = data;
                fullDataEnd = data;
                for (int i = 0; i < 10 - data.length(); ++i) {
                    fullDataBegin = fullDataBegin + "0";
                    fullDataEnd = fullDataEnd + "9";
                }
            } else {
                fullDataBegin = data;
                fullDataEnd = data;
            }
            for (CapacityElement el : this.elements) {
                if (!this.services.contains(el.getService()) || !el.includeRange(fullDataBegin, fullDataEnd)) continue;
                this.currentProvider = this.providers.get(el.getService());
                this.currentRegion = this.regions.get(el.getRegion());
                if (this.personalNumbers != null && this.personalNumbers.length > 0) {
                    for (PersonalNumber pn : this.personalNumbers) {
                        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.mobile.vernumb") + " " + pn));
                        if (!data.equals(pn.getNumber()) || pn.getType() != 1) continue;
                        this.log.info((Object)LocBundle.getMessageLog((String)"rma.mobile.numbinbllist"));
                        return false;
                    }
                }
                return fullDataBegin.equals(fullDataEnd);
            }
            return false;
        }
        return data.length() == 10;
    }
}

