/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.mobile;

import info.clearthought.layout.TableLayout;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.text.Document;
import org.apache.log4j.Logger;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import rmai18n.LocBundle;
import ru.softlogic.input.model.field.Field;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.text.KeyboardType;
import ru.softlogic.input.model.field.text.TextField;
import ru.softlogic.rma.Environment;
import ru.softlogic.rma.RmaApp;
import ru.softlogic.rma.app.components.JScrollPopupMenu;
import ru.softlogic.rma.app.components.MultipleMaskTextField;
import ru.softlogic.rma.app.docs.DigitalNumberDocument;
import ru.softlogic.rma.app.docs.LetterNumberDocument;
import ru.softlogic.rma.providers.panels.SumPanel;
import ru.softlogic.rma.providers.universal.general.ControlData;
import ru.softlogic.rma.utils.MessageUtils;

public class MobileProviderPanel
extends JPanel {
    private SumPanel sumPanel;
    private JPanel cardPanel;
    private Logger logger;
    private LocalFocusListener focusListener;
    private Font defaultLabelFont;
    private Font defaultFieldFont;
    private List<JComponent> controls;
    private MultipleMaskTextField numberField;
    private JPanel contentPanel;
    private JLabel numberLabel;
    private JLabel operator;
    private JLabel operatorLabel;
    private JLabel region;
    private JLabel regionLabel;

    public MobileProviderPanel() {
        this.initComponents();
        ResourceMap resourceMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getResourceMap(MobileProviderPanel.class);
        this.numberField = new MultipleMaskTextField(new DigitalNumberDocument(Environment.getInstance().getIntProperty("mobile_len", 10)), null, Environment.getInstance().getProperty("mobile_mask"), null);
        this.numberField.setToolTipText(resourceMap.getString("numberField.toolTipText", new Object[0]));
        GroupLayout layout = (GroupLayout)this.getLayout();
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.regionLabel, -1, -1, Short.MAX_VALUE).addComponent(this.operatorLabel, -1, -1, Short.MAX_VALUE).addComponent(this.numberLabel, -1, 140, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.operator, -1, 136, Short.MAX_VALUE).addComponent(this.region, -1, 136, Short.MAX_VALUE).addComponent(this.numberField, GroupLayout.Alignment.TRAILING, -1, 136, Short.MAX_VALUE))).addComponent(this.contentPanel, -1, 288, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numberLabel).addComponent(this.numberField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.operatorLabel).addComponent(this.operator)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.regionLabel).addComponent(this.region, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.contentPanel, -1, 344, Short.MAX_VALUE)));
        this.sumPanel = new SumPanel();
        this.contentPanel.add(this.sumPanel);
        HashSet<AWTKeyStroke> forwardKeys = new HashSet<AWTKeyStroke>(this.getFocusTraversalKeys(0));
        forwardKeys.add(KeyStroke.getKeyStroke(10, 0));
        this.numberField.setFocusTraversalKeys(0, forwardKeys);
        this.logger = Logger.getLogger((String)"uni");
        this.logger.setAdditivity(false);
        this.controls = new LinkedList<JComponent>();
        this.focusListener = new LocalFocusListener();
        this.defaultFieldFont = this.sumPanel.getSumIncomeField().getFont();
        this.defaultLabelFont = this.sumPanel.getSumIncomeLabel().getFont();
        this.numberField.getDocument().addDocumentListener(this.sumPanel.getTextDocumentListener());
    }

    public boolean showCardFields(Collection<IdentityField> fields, Map<Field, Object> values) {
        for (Field ff : values.keySet()) {
            this.logger.info((Object)(ff + "->" + values.get(ff)));
        }
        this.contentPanel.setVisible(false);
        this.sumPanel.getCardPanel().removeAll();
        this.contentPanel.setVisible(true);
        TableLayout layout = new TableLayout(new double[]{0.0, 170.0, 6.0, -1.0, 7.0, 0.0}, new double[0]);
        this.sumPanel.getCardPanel().setLayout((LayoutManager)layout);
        LinkedList<IdentityField> fields1 = new LinkedList<IdentityField>();
        fields1.addAll(fields);
        return this._showCardFields(fields1, values, layout, this.sumPanel.getCardPanel());
    }

    private boolean _showCardFields(List<IdentityField> fields, Map<Field, Object> values, TableLayout layout, JPanel panel1) {
        boolean focusSet = false;
        if (fields == null) {
            return true;
        }
        LocalPopupComponentListener popListener = new LocalPopupComponentListener();
        layout.insertRow(layout.getNumRow(), 15.0);
        for (Field field : fields) {
            String val;
            if (!(field instanceof TextField)) continue;
            layout.insertRow(layout.getNumRow(), 6.0);
            layout.insertRow(layout.getNumRow(), (double)this.defaultFieldFont.getSize() * 1.8);
            TextField field2 = (TextField)field;
            JLabel label = new JLabel(MessageUtils.process((IdentityField)field2));
            label.setFont(this.defaultLabelFont);
            label.setToolTipText(field2.getMessage());
            panel1.add((Component)label, "1," + (layout.getNumRow() - 1) + ",r,f");
            MultipleMaskTextField formTextField = new MultipleMaskTextField(this.createDocument(field2.getKeyboard().getType(), field2.getMaxLength(), field2.getPrefix(), field2.getKeyboard().getExtraCharacter() == null || Character.isWhitespace(field2.getKeyboard().getExtraCharacter().charValue()) ? null : field2.getKeyboard().getExtraCharacter()), field2.getPrefix(), field2.getViewFormatter());
            formTextField.putClientProperty("field", field2);
            formTextField.setToolTipText(field2.getMessage());
            formTextField.setEditable(!field2.isReadOnly());
            formTextField.addFocusListener(this.focusListener);
            if ("corr_acc".equals(field2.getId()) || "corr_bank_name".equals(field2.getId())) {
                formTextField.setEditable(false);
            }
            formTextField.setFocusable(formTextField.isEditable());
            HashSet<AWTKeyStroke> forwardKeys = new HashSet<AWTKeyStroke>(this.getFocusTraversalKeys(0));
            forwardKeys.add(KeyStroke.getKeyStroke(10, 0));
            formTextField.setFocusTraversalKeys(0, forwardKeys);
            this.controls.add(formTextField);
            panel1.add((Component)formTextField, "3," + (layout.getNumRow() - 1));
            if (values.get(field2) != null) {
                val = (String)values.get(field2);
                this.logger.debug((Object)(LocBundle.getMessageLog((String)"rma.univers.setfldval") + " " + val));
                formTextField.setText(val);
            } else if (field2.getDefaultValue() != null && !field2.getDefaultValue().isEmpty()) {
                val = field2.getDefaultValue();
                this.logger.debug((Object)(LocBundle.getMessageLog((String)"rma.univers.setflddefval") + " " + val));
                formTextField.setText(val);
            }
            formTextField.setFont(this.defaultFieldFont);
        }
        layout.insertRow(layout.getNumRow(), 20.0);
        return true;
    }

    public List<ControlData> getData() {
        LinkedList<ControlData> result = new LinkedList<ControlData>();
        for (JComponent control : this.controls) {
            if (!(control instanceof MultipleMaskTextField)) continue;
            MultipleMaskTextField textField = (MultipleMaskTextField)control;
            TextField tif = (TextField)textField.getClientProperty("field");
            String val = textField.getText();
            this.logger.info((Object)(LocBundle.getMessageLog((String)"rma.univers.add") + " " + tif + "->" + val));
            result.add(new ControlData((Field)tif, val, control));
        }
        return result;
    }

    private Document createDocument(KeyboardType type, int maxLen, String prefix, Character xbutton) {
        if (KeyboardType.Digital.equals((Object)type)) {
            return new DigitalNumberDocument(maxLen, prefix, xbutton);
        }
        return new LetterNumberDocument(maxLen, prefix);
    }

    public SumPanel getSumPanel() {
        return this.sumPanel;
    }

    private void initComponents() {
        this.numberLabel = new JLabel();
        this.contentPanel = new JPanel();
        this.operatorLabel = new JLabel();
        this.operator = new JLabel();
        this.regionLabel = new JLabel();
        this.region = new JLabel();
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.numberLabel.setFont(new Font("Tahoma", 1, 12));
        this.numberLabel.setHorizontalAlignment(4);
        ResourceMap resourceMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getResourceMap(MobileProviderPanel.class);
        this.numberLabel.setText(resourceMap.getString("MobileProviderPanel.numberLabel.text", new Object[0]));
        this.contentPanel.setLayout(new BorderLayout());
        this.operatorLabel.setFont(new Font("Tahoma", 1, 12));
        this.operatorLabel.setHorizontalAlignment(4);
        this.operatorLabel.setText(resourceMap.getString("MobileProviderPanel.operatorLabel.text", new Object[0]));
        this.operator.setText("jLabel3");
        this.operator.setMaximumSize(new Dimension(34, 15));
        this.operator.setMinimumSize(new Dimension(34, 15));
        this.operator.setPreferredSize(new Dimension(34, 15));
        this.regionLabel.setFont(new Font("Tahoma", 1, 12));
        this.regionLabel.setHorizontalAlignment(4);
        this.regionLabel.setText(resourceMap.getString("MobileProviderPanel.regionLabel.text", new Object[0]));
        this.region.setText("jLabel5");
        this.region.setMaximumSize(new Dimension(48, 15));
        this.region.setMinimumSize(new Dimension(48, 15));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.regionLabel, -1, -1, Short.MAX_VALUE).addComponent(this.operatorLabel, -1, -1, Short.MAX_VALUE).addComponent(this.numberLabel, -1, 140, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.operator, -1, 142, Short.MAX_VALUE).addComponent(this.region, -1, 142, Short.MAX_VALUE))).addComponent(this.contentPanel, -1, 288, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.numberLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.operatorLabel).addComponent(this.operator, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.regionLabel).addComponent(this.region, -2, -1, -2)).addGap(22, 22, 22).addComponent(this.contentPanel, -1, 338, Short.MAX_VALUE)));
        layout.linkSize(1, this.operator, this.operatorLabel, this.region, this.regionLabel);
    }

    public MultipleMaskTextField getNumberField() {
        return this.numberField;
    }

    public JLabel getOperator() {
        return this.operator;
    }

    public JLabel getRegion() {
        return this.region;
    }

    private class LocalFocusListener
    implements FocusListener {
        private LocalFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getComponent() instanceof MultipleMaskTextField) {
                MultipleMaskTextField tf = (MultipleMaskTextField)e.getComponent();
                TextField tif = (TextField)tf.getClientProperty("field");
                if (tif.getHelp() != null && !tif.getHelp().isEmpty()) {
                    String text = tif.getHelp().replaceAll("<terminal>.*</terminal>", "").replaceAll("<keeper>.*</keeper>", "").replaceAll("<rma>", "").replaceAll("</rma>", "");
                    MobileProviderPanel.this.sumPanel.getHelpLabel().setText("<html>" + text);
                    MobileProviderPanel.this.sumPanel.getHelpLabelPanel().setVisible(true);
                } else {
                    MobileProviderPanel.this.sumPanel.getHelpLabelPanel().setVisible(false);
                }
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            MobileProviderPanel.this.sumPanel.getHelpLabelPanel().setVisible(false);
        }
    }

    private class LocalPopupComponentListener
    extends MouseAdapter
    implements FocusListener,
    KeyListener,
    Runnable {
        private LocalPopupComponentListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JTextField tf;
            if (e.getClickCount() >= 2 && e.getSource() instanceof JTextField && (tf = (JTextField)e.getSource()).getComponentPopupMenu() != null) {
                JScrollPopupMenu popup = (JScrollPopupMenu)tf.getComponentPopupMenu();
                if (popup.isVisible()) {
                    popup.hide();
                    tf.setFocusTraversalKeysEnabled(true);
                } else if (((JScrollPopupMenu)tf.getComponentPopupMenu()).getItemsCount() > 0) {
                    popup.show();
                    tf.setFocusTraversalKeysEnabled(false);
                }
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() instanceof JComponent) {
                // empty if block
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (e.getSource() instanceof JTextField) {
                JTextField tf = (JTextField)e.getSource();
                if (tf.getComponentPopupMenu() != null) {
                    tf.getComponentPopupMenu().setVisible(false);
                    tf.setFocusTraversalKeysEnabled(true);
                }
                if (tf.getClientProperty("field") instanceof TextField) {
                    TextField textField = (TextField)tf.getClientProperty("field");
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            JTextField tf;
            if ((e.getKeyCode() == 38 || e.getKeyCode() == 40 || e.getKeyCode() == 10 || e.getKeyCode() == 32 || e.getKeyCode() == 27) && e.getSource() instanceof JTextField && (tf = (JTextField)e.getSource()).getComponentPopupMenu() != null) {
                JScrollPopupMenu popup = (JScrollPopupMenu)tf.getComponentPopupMenu();
                if (e.getKeyCode() == 32 && e.isControlDown()) {
                    if (popup.isVisible()) {
                        popup.hide();
                        tf.setFocusTraversalKeysEnabled(true);
                    } else if (((JScrollPopupMenu)tf.getComponentPopupMenu()).getItemsCount() > 0) {
                        popup.show();
                        tf.setFocusTraversalKeysEnabled(false);
                    }
                } else if (e.getKeyCode() == 27) {
                    if (popup.isVisible()) {
                        popup.hide();
                        tf.setFocusTraversalKeysEnabled(true);
                    }
                } else if (e.getKeyCode() == 38 && popup.isVisible()) {
                    popup.prevSelection();
                } else if (e.getKeyCode() == 40 && popup.isVisible()) {
                    popup.nextSelection();
                } else if (e.getKeyCode() == 10 && popup.isVisible()) {
                    popup.selectCurrent();
                    tf.setFocusTraversalKeysEnabled(true);
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void run() {
        }
    }
}

