/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.mobile;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.Field;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.text.TextField;
import ru.softlogic.input.model.form.Form;
import ru.softlogic.rma.Environment;
import ru.softlogic.rma.RmaAppContext;
import ru.softlogic.rma.RmaCancelOperationDialog;
import ru.softlogic.rma.RmaPaymentJob;
import ru.softlogic.rma.app.CommissionCalculator;
import ru.softlogic.rma.app.Configuration;
import ru.softlogic.rma.app.components.MultipleMaskTextField;
import ru.softlogic.rma.app.docs.SumDocument;
import ru.softlogic.rma.app.docs.listener.SumIncomeListener;
import ru.softlogic.rma.app.docs.listener.SumOutcomeListener;
import ru.softlogic.rma.connector.model.CurrentUser;
import ru.softlogic.rma.connector.model.Menu;
import ru.softlogic.rma.connector.model.MenuItem;
import ru.softlogic.rma.connector.model.PersonalNumber;
import ru.softlogic.rma.connector.model.References;
import ru.softlogic.rma.connector.model.SumResult;
import ru.softlogic.rma.connector.ws.stub.VerifyResult;
import ru.softlogic.rma.connector.ws.stub.VerifyResultType;
import ru.softlogic.rma.model.add.BankRecord;
import ru.softlogic.rma.persistence.DocType;
import ru.softlogic.rma.persistence.PersistenceException;
import ru.softlogic.rma.persistence.Record;
import ru.softlogic.rma.persistence.RmaAttribute;
import ru.softlogic.rma.persistence.v2.PersistenceManager;
import ru.softlogic.rma.print.PrintMode;
import ru.softlogic.rma.print.queue.RequestData;
import ru.softlogic.rma.providers.FildsChangedListener;
import ru.softlogic.rma.providers.InitData;
import ru.softlogic.rma.providers.PrintCallBackListener;
import ru.softlogic.rma.providers.ServiceProvider;
import ru.softlogic.rma.providers.VerifyResultListener;
import ru.softlogic.rma.providers.mobile.CapacityUpdater;
import ru.softlogic.rma.providers.mobile.MobileProviderPanel;
import ru.softlogic.rma.providers.mobile.MobileValidator;
import ru.softlogic.rma.providers.mobile.Provider;
import ru.softlogic.rma.providers.panels.SumPanelHelper;
import ru.softlogic.rma.providers.universal.general.ControlData;
import ru.softlogic.rma.providers.universal.general.PD4Dialog;
import ru.softlogic.rma.shift.ShiftManager;
import ru.softlogic.rma.utils.FontResizer;
import ru.softlogic.rma.utils.GuiUtils;
import ru.softlogic.rma.utils.IM7FormUtils;
import ru.softlogic.rma.utils.PathUtils;
import ru.softlogic.rma.utils.SumFormatter;

public class MobileProvider
implements ServiceProvider,
VerifyResultListener {
    private RmaAppContext context;
    private MenuItem menuItem;
    private MobileProviderPanel panel = new MobileProviderPanel();
    private SumDocument sumIncomeDocument;
    private SumIncomeListener sumIncomeListener;
    private SumDocument sumOutcomeDocument;
    private SumOutcomeListener sumOutcomeListener;
    private MobileValidator validator;
    private Logger log;
    private boolean validNumber;
    private Provider current;
    private Menu menu;
    private ProcessActionListener processActionListener;
    private Map<String, PersonalNumber> personalNumbers;
    private Map<String, IdentityField> cardFields;
    private PD4Dialog pd4Dialog;
    private Map<String, IdentityField> pd4Fields;
    private Form pd4Form;
    private Map<Field, Object> values;
    private Map<String, BankRecord> bankRecords;
    private Map<String, Object> verifiedIElements;
    private Form cardForm;
    private List<JComponent> controls;
    private References references;
    private short typeCashSourcePayment;
    private boolean showAll;
    private RmaPaymentJob currentJob;
    private PrintCallBackListener printResultListener;
    private boolean isPrinted;
    private boolean isFieldsChanged;

    public MobileProvider() {
        FontResizer.process(this.panel, Configuration.getInstance().getData().getSoftwareFontSize());
        this.sumIncomeListener = new SumIncomeListener(this.panel.getSumPanel().getSumOutcomeField(), this.panel.getSumPanel().getSumCommField());
        this.sumIncomeDocument = new SumDocument();
        this.sumIncomeDocument.addDocumentListener(this.sumIncomeListener);
        this.panel.getSumPanel().getSumIncomeField().setDocument(this.sumIncomeDocument);
        this.sumOutcomeListener = new SumOutcomeListener(this.panel.getSumPanel().getSumIncomeField(), this.panel.getSumPanel().getSumCommField());
        this.sumOutcomeDocument = new SumDocument();
        this.sumOutcomeDocument.addDocumentListener(this.sumOutcomeListener);
        this.panel.getSumPanel().getSumOutcomeField().setDocument(this.sumOutcomeDocument);
        this.sumIncomeListener.setSumOutcomeListener(this.sumOutcomeListener);
        this.sumOutcomeListener.setSumIncomeListener(this.sumIncomeListener);
        this.panel.getSumPanel().getCheckButton().addActionListener(new LocalCheckListener());
        this.panel.getNumberField().getDocument().putProperty("formmatedtextfield", this.panel.getNumberField());
        this.panel.getNumberField().getDocument().addDocumentListener(new ValidateDocumentListener());
        ActionListener[] actionListeners = this.panel.getSumPanel().getCancelButton().getActionListeners();
        this.panel.getSumPanel().getCancelButton().addActionListener(new CancelActionListener());
        this.processActionListener = new ProcessActionListener();
        this.panel.getSumPanel().getPayButton().addActionListener(this.processActionListener);
        this.panel.getSumPanel().getPrintButton().addActionListener(new LocalPrintRequestListener());
        this.validator = new MobileValidator();
        Thread thread = new Thread(new CapacityUpdater(this.validator));
        thread.setDaemon(true);
        thread.start();
        this.cardFields = new HashMap<String, IdentityField>();
        this.controls = new LinkedList<JComponent>();
        this.pd4Fields = new HashMap<String, IdentityField>();
        this.values = new HashMap<Field, Object>();
        this.log = Logger.getLogger((String)"pay");
        this.log.setAdditivity(false);
        this.printResultListener = new PrintCallBackListener(){

            @Override
            public void onPrintResult(boolean isPrinted) {
                MobileProvider.this.isPrinted = isPrinted;
                MobileProvider.this.panel.getSumPanel().getPrintButton().setEnabled(!isPrinted);
                MobileProvider.this.panel.getSumPanel().getPayButton().setEnabled(isPrinted);
            }
        };
    }

    @Override
    public void init(InitData initData) {
        this.context = initData.getContext();
        this.menuItem = initData.getMenuItem();
        this.log.info((Object)">>>>----------------");
        this.log.info((Object)("System.getProperty(\"app.home\") = " + System.getProperty("app.home")));
        this.log.info((Object)">>>>----------------");
        this.references = initData.getReferences();
        this.bankRecords = initData.getBankRecords();
        this.verifiedIElements = null;
        this.typeCashSourcePayment = this.references.getPoint().getTypeCashSourcePoint();
        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.mobile.gotopay") + " " + this.menuItem));
        if (initData.getReferences() != null) {
            this.personalNumbers = initData.getReferences().getPersonalNumbersAsMap();
        }
        this.menu = initData.getMenu();
        this.validator.init(initData.getMenu().getTypes(), null);
        this.sumIncomeListener.init(this.menuItem, null);
        this.sumOutcomeListener.init(this.menuItem, null);
        this.panel.getNumberField().setText("");
        this.panel.getOperator().setText("");
        this.panel.getRegion().setText("");
        this.panel.getSumPanel().getSumIncomeField().setText("");
        this.panel.getSumPanel().getSumOutcomeField().setText("");
        this.panel.getSumPanel().getSumCommField().setText("");
        this.panel.getSumPanel().getCommentField().setText("");
        this.panel.getSumPanel().getPrintRequestCheckBox().setEnabled(initData.getPrintRequest() != null);
        this.panel.getSumPanel().getPrintRequestCheckBox().setSelected(Boolean.TRUE.equals(initData.getPrintRequest()));
        this.panel.getSumPanel().getPrintDocumentCheckBox().setEnabled(initData.getPrintDocument() != null);
        this.panel.getSumPanel().getPrintDocumentCheckBox().setSelected(Boolean.TRUE.equals(initData.getPrintDocument()));
        this.panel.getSumPanel().getPayButton().setEnabled(true);
        GuiUtils.requestFocus(this.panel.getNumberField());
        if (initData.getRecord() != null) {
            this.panel.getSumPanel().getSumIncomeField().getDocument().removeDocumentListener(this.sumIncomeListener);
            this.panel.getSumPanel().getSumOutcomeField().getDocument().removeDocumentListener(this.sumOutcomeListener);
            this.panel.getSumPanel().getCommentField().setText(initData.getRecord().getComment());
            this.panel.getSumPanel().getSumCommField().setText(SumFormatter.format(initData.getRecord().getSumComm()));
            this.panel.getSumPanel().getSumIncomeField().setText(SumFormatter.format(initData.getRecord().getSumIncome()));
            this.panel.getSumPanel().getSumOutcomeField().setText(SumFormatter.format(initData.getRecord().getSumOutcome()));
            this.panel.getNumberField().setText(initData.getRecord().getAccount());
            this.panel.getSumPanel().getSumIncomeField().getDocument().addDocumentListener(this.sumIncomeListener);
            this.panel.getSumPanel().getSumOutcomeField().getDocument().addDocumentListener(this.sumOutcomeListener);
        }
        this.panel.getNumberField().setEditable(!initData.isReadMode());
        this.panel.getSumPanel().getCommentField().setEditable(!initData.isReadMode());
        this.panel.getSumPanel().getSumCommField().setEditable(!initData.isReadMode());
        this.panel.getSumPanel().getSumIncomeField().setEditable(!initData.isReadMode());
        this.panel.getSumPanel().getSumOutcomeField().setEditable(!initData.isReadMode());
        this.panel.getSumPanel().getCancelButton().setEnabled(!initData.isReadMode());
        this.panel.getSumPanel().getPayButton().setEnabled(!initData.isReadMode());
        this.panel.getSumPanel().getCheckButton().setEnabled(!initData.isReadMode());
        this.panel.getSumPanel().getPrintDocumentCheckBox().setEnabled(initData.isReadMode() ? !initData.isReadMode() : !initData.isPrintForbidChange());
        this.panel.getSumPanel().getPrintRequestCheckBox().setEnabled(initData.isReadMode() ? !initData.isReadMode() : !initData.isPrintForbidChange());
        this.panel.getSumPanel().getCardPanel().setVisible(this.references.getPoint().getTypeCashSourcePoint() != 1);
        this.cardForm = IM7FormUtils.tryToLoadForm(new File(PathUtils.getAppHome() + File.separator + "resources" + File.separator + "addforms" + File.separator + "card.xml"), this.log);
        if (this.references.getPoint().getTypeCashSourcePoint() != 1 && this.cardForm != null) {
            this.cardFields.clear();
            for (IdentityField ff : IM7FormUtils.getFieldsFromForm(this.cardForm)) {
                this.cardFields.put(ff.getId(), ff);
            }
        }
        this.showAll = true;
        this.log.debug((Object)(this.showAll ? LocBundle.getMessageLog((String)"rma.univers.showallflds") : LocBundle.getMessageLog((String)"rma.univers.showntallflds")));
        this.isPrinted = false;
        this.panel.getSumPanel().getPrintRequestButton().setVisible(false);
        this.panel.getSumPanel().getPrintButton().setEnabled(true);
        this.panel.getSumPanel().getPayButton().setEnabled(false);
        this.panel.getSumPanel().setChangedListener(new LocalChangedFieldsListener());
        if (this.menuItem.getService().getVerifyType() == 0 || this.menuItem.getService().getVerifyType() == 1 || this.menuItem.getService().getProcessingType() == 2) {
            this.panel.getSumPanel().getCheckButton().setEnabled(true);
        } else {
            this.panel.getSumPanel().getCheckButton().setEnabled(false);
        }
        this.isFieldsChanged = false;
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    private void checkFields(Map<String, Object> ielements, boolean userReplaces, List<ControlData> data) throws Exception {
        if (!this.showAll) {
            throw new Exception(LocBundle.getMessageEx((String)"rma.prov.feelall"));
        }
        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.univers.workflds") + " "));
        for (ControlData cd : data) {
            this.log.info((Object)("\t" + cd));
            Field ff = cd.getField();
            if (!(ff instanceof TextField)) continue;
            TextField inputField = (TextField)ff;
            String number = (String)cd.getData();
            boolean valid = false;
            if (inputField.getValidator() != null) {
                valid = inputField.getValidator().validate(number);
            }
            if (!valid) {
                GuiUtils.requestFocus(cd.getComponent());
                if (inputField.getExampleValue() != null && !inputField.getExampleValue().trim().isEmpty()) {
                    throw new Exception(MessageFormat.format(LocBundle.getMessageEx((String)"rma.prov.wrongnumb2"), inputField.getTitle(), inputField.getExampleValue()));
                }
                throw new Exception(MessageFormat.format(LocBundle.getMessageEx((String)"rma.prov.wrongnumb"), inputField.getTitle()));
            }
            ielements.put(inputField.getId(), new InputElement(inputField.getId(), inputField.getTitle(), number, ((MultipleMaskTextField)cd.getComponent()).getTextTitle(), inputField.getFlags()));
        }
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.univers.resform"));
        this.log.info((Object)("\t" + ielements));
    }

    @Override
    public void onVerifyResultError(String error) {
        this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438: " + error));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onVerifyResult(VerifyResult result, Map<String, Object> ielements) {
        if (result != null && result.getRt() == VerifyResultType.OK) {
            int sumIncome = SumFormatter.parce(this.panel.getSumPanel().getSumIncomeField().getText(), 0);
            int sumOutcome = SumFormatter.parce(this.panel.getSumPanel().getSumOutcomeField().getText(), 0);
            int sumCome = SumFormatter.parce(this.panel.getSumPanel().getSumCommField().getText(), 0);
            try {
                SumResult sumResult;
                RmaPaymentJob job;
                if (this.references.getPoint().getTypeCashSourcePoint() == 0) {
                    if (ielements.get("fioORCardId") == null || ((InputElement)ielements.get("fioORCardId")).getValue().isEmpty()) {
                        int res = JOptionPane.showConfirmDialog(this.context.getMainFrame(), "\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0430\u043b\u0438\u0447\u043d\u044b\u043c\u0438?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u043e\u043f\u043b\u0430\u0442\u0443 \u043d\u0430\u043b\u0438\u0447\u043d\u044b\u043c\u0438", 0, 1);
                        if (res != 0) return;
                        this.typeCashSourcePayment = 1;
                    } else {
                        this.typeCashSourcePayment = (short)2;
                    }
                }
                if (this.context.toPayment(job = this.getJob(ielements, sumIncome, sumOutcome = (sumResult = CommissionCalculator.calculate(SumFormatter.parce(this.panel.getSumPanel().getSumIncomeField().getText()), this.menuItem.getCommission(), this.menuItem.getService().getCommission(), this.menuItem.getService().getMinCommission(), this.sumIncomeListener.getWhiteCommission(), null)).getOut(), sumCome, Configuration.getInstance().getData().getDocType()))) return;
                this.panel.getSumPanel().getPayButton().setEnabled(true);
                return;
            }
            catch (Exception ex) {
                this.panel.getSumPanel().getPayButton().setEnabled(true);
                this.log.info((Object)(LocBundle.getMessageLog((String)"rma.adv.dopayerr") + " " + ex.getMessage()), (Throwable)ex);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(MobileProvider.this.context.getMainFrame(), ex.getMessage(), LocBundle.getMessage((String)"rma.adv.dopayerr"), 0);
                    }
                });
            }
            return;
        } else {
            this.panel.getSumPanel().getPayButton().setEnabled(true);
        }
    }

    private RmaPaymentJob getJob(Map<String, Object> ielements, int sumIncome, int sumOutcome, int sumCome, DocType docType) {
        RmaPaymentJob job = new RmaPaymentJob();
        Record record = new Record();
        record.setProviderName(this.menuItem.getService().getProv().getName());
        job.setRecord(record);
        record.setServiceId(this.menuItem.getService().getId());
        record.setServiceName(this.menuItem.getService().getName());
        record.setCommissionId(this.menuItem.getCommission().getId());
        record.setAccount(this.panel.getNumberField().getText());
        record.setAccountTitle(LocBundle.getMessage((String)"rma.mobile.phone"));
        record.setAccountValueTitle(this.panel.getNumberField().getTextTitle());
        record.setSumIncome(sumIncome);
        record.setSumOutcome(sumOutcome);
        record.setSumComm(sumCome);
        record.setComment(this.panel.getSumPanel().getCommentField().getText());
        record.setDocType(Configuration.getInstance().getData().getDocType());
        record.setCreated(new Date());
        record.setIdShift(ShiftManager.getInstance().getShiftId());
        job.setPrintDocument(this.panel.getSumPanel().getPrintDocumentCheckBox().isSelected());
        job.setPrintRequest(this.panel.getSumPanel().getPrintRequestCheckBox().isSelected());
        job.setMenuItem(this.menuItem);
        job.getRecord().setTypeCashSource(this.typeCashSourcePayment);
        job.setOperatorName(CurrentUser.getInstance().getKassirFio());
        LinkedHashMap<String, RmaAttribute> attrs = new LinkedHashMap<String, RmaAttribute>();
        for (String key : ielements.keySet()) {
            if (key.startsWith("#")) continue;
            RmaAttribute atr = new RmaAttribute();
            atr.setKey(key);
            atr.setKeyTitle(((InputElement)ielements.get(key)).getKeyTitle());
            atr.setValue(((InputElement)ielements.get(key)).getValue());
            atr.setValueTitle(((InputElement)ielements.get(key)).getValueTitle());
            attrs.put(key, atr);
        }
        record.setAttributes(attrs);
        return job;
    }

    private void replaceListener(JComponent component, ActionListener target, ActionListener replacement) {
        if (component instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)component;
            button.removeActionListener(target);
            boolean contain = false;
            for (ActionListener listener : button.getActionListeners()) {
                if (listener != replacement) continue;
                contain = true;
                break;
            }
            if (!contain) {
                button.addActionListener(replacement);
            }
        }
    }

    private class LocalPrintRequestListener
    implements ActionListener {
        String comment;

        private LocalPrintRequestListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MobileProvider.this.log.info((Object)LocBundle.getMessageLog((String)"rma.beginprintrequest"));
            if (!SumPanelHelper.verify(MobileProvider.this.context.getMainFrame(), MobileProvider.this.menuItem, MobileProvider.this.panel.getSumPanel())) {
                MobileProvider.this.panel.getSumPanel().getPrintButton().setEnabled(true);
                MobileProvider.this.panel.getSumPanel().getPayButton().setEnabled(false);
                return;
            }
            if (MobileProvider.this.isFieldsChanged) {
                RmaCancelOperationDialog dialog = new RmaCancelOperationDialog((Frame)MobileProvider.this.context.getMainFrame(), true);
                dialog.setTitle(LocBundle.getMessage((String)"rma.canseloperating.postprintchanges"));
                dialog.setVisible(true);
                if (dialog.isCanselled()) {
                    MobileProvider.this.log.info((Object)"\u041a\u0430\u0441\u0441\u0438\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b\u0441\u044f \u043e\u0442 \u043e\u0442\u043c\u0435\u043d\u044b \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438");
                    return;
                }
                this.comment = dialog.getComment();
            }
            int sumIncome = SumFormatter.parce(MobileProvider.this.panel.getSumPanel().getSumIncomeField().getText(), 0);
            int sumOutcome = SumFormatter.parce(MobileProvider.this.panel.getSumPanel().getSumOutcomeField().getText(), 0);
            int sumCome = SumFormatter.parce(MobileProvider.this.panel.getSumPanel().getSumCommField().getText(), 0);
            LinkedHashMap<String, Object> ielements = new LinkedHashMap<String, Object>();
            try {
                MobileProvider.this.checkFields(ielements, false, MobileProvider.this.panel.getData());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(MobileProvider.this.context.getMainFrame(), ex.getMessage(), LocBundle.getMessageLog((String)"rma.view.verifyerr"), 0);
                return;
            }
            if (Configuration.getInstance().getData().isCheckOnlinePayment() && MobileProvider.this.menuItem.getService().getProcessingType() == 0 && JOptionPane.showConfirmDialog(MobileProvider.this.context.getMainFrame(), "\u0412\u043a\u043b\u044e\u0447\u0435\u043d\u043e \u043e\u043d\u043b\u0430\u0439\u043d \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435, \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c?", LocBundle.getMessage((String)"rma.view.attention"), 0) != 0) {
                MobileProvider.this.log.info((Object)"\u041e\u0442\u043a\u0430\u0437 \u043e\u0442 \u043e\u043d\u043b\u0430\u0439\u043d \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f");
                return;
            }
            if (MobileProvider.this.menuItem.getService().getVerifyType() == 0) {
                MobileProvider.this.log.info((Object)"\u0414\u0435\u043b\u0430\u044e \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438");
                String number = MobileProvider.this.panel.getNumberField().getText();
                if (number == null || !number.matches(Environment.getInstance().getProperty("mobile_regex"))) {
                    JOptionPane.showMessageDialog(MobileProvider.this.context.getMainFrame(), LocBundle.getMessageEx((String)"rma.prov.wrongmobile") + "                 ", LocBundle.getMessage((String)"rma.adv.dopayerr"), 0);
                    return;
                }
                ielements.put("id1", new InputElement("id1", "id1", number, number, 0));
                MobileProvider.this.context.toVerify(MobileProvider.this.menuItem.getService().getId(), ielements, new VerifyAfterPayResultListener(this.comment), true);
            } else {
                MobileProvider.this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0431\u0435\u0437 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438");
                MobileProvider.this.currentJob = MobileProvider.this.getJob(ielements, sumIncome, sumOutcome, sumCome, null);
                MobileProvider.this.currentJob.getRecord().setComment(this.comment);
                MobileProvider.this.currentJob.setPrintMode(PrintMode.Default);
                MobileProvider.this.currentJob.getRecord().setPrintInfo(3);
                MobileProvider.this.context.addRequestPrint(new RequestData(MobileProvider.this.currentJob, MobileProvider.this.references), MobileProvider.this.printResultListener);
            }
        }
    }

    private class VerifyAfterPayResultListener
    implements VerifyResultListener {
        String comment;

        public VerifyAfterPayResultListener(String comment) {
            this.comment = comment;
        }

        @Override
        public void onVerifyResultError(String error) {
        }

        @Override
        public void onVerifyResult(VerifyResult result, Map<String, Object> ielements) {
            if (result.getRt() == VerifyResultType.OK) {
                MobileProvider.this.log.info((Object)"\u0421 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0432\u0435\u0440\u043d\u0443\u043b\u0441\u044f \u0443\u0441\u043f\u0435\u0445, \u043f\u0435\u0447\u0430\u0442\u0430\u044e");
                int sumIncome = SumFormatter.parce(MobileProvider.this.panel.getSumPanel().getSumIncomeField().getText(), 0);
                int sumOutcome = SumFormatter.parce(MobileProvider.this.panel.getSumPanel().getSumOutcomeField().getText(), 0);
                int sumCome = SumFormatter.parce(MobileProvider.this.panel.getSumPanel().getSumCommField().getText(), 0);
                try {
                    MobileProvider.this.checkFields(ielements, false, MobileProvider.this.panel.getData());
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(MobileProvider.this.context.getMainFrame(), ex.getMessage(), LocBundle.getMessageLog((String)"rma.view.verifyerr"), 0);
                    return;
                }
                MobileProvider.this.currentJob = MobileProvider.this.getJob(ielements, sumIncome, sumOutcome, sumCome, null);
                MobileProvider.this.currentJob.setPrintMode(PrintMode.Default);
                MobileProvider.this.currentJob.getRecord().setComment(this.comment);
                MobileProvider.this.currentJob.getRecord().setPrintInfo(3);
                MobileProvider.this.context.addRequestPrint(new RequestData(MobileProvider.this.currentJob, MobileProvider.this.references), MobileProvider.this.printResultListener);
            }
        }
    }

    private class LocalCheckListener
    implements ActionListener {
        private LocalCheckListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MobileProvider.this.log.info((Object)LocBundle.getMessageLog((String)"rma.mobile.ndonlinever"));
            String number = MobileProvider.this.panel.getNumberField().getText();
            if (number == null || !number.matches(Environment.getInstance().getProperty("mobile_regex"))) {
                JOptionPane.showMessageDialog(MobileProvider.this.context.getMainFrame(), LocBundle.getMessageEx((String)"rma.prov.wrongmobile") + "                   ", LocBundle.getMessage((String)"rma.adv.dopayerr"), 0);
                return;
            }
            if (!SumPanelHelper.verify(MobileProvider.this.context.getMainFrame(), MobileProvider.this.menuItem, MobileProvider.this.panel.getSumPanel())) {
                MobileProvider.this.panel.getSumPanel().getPrintButton().setEnabled(true);
                MobileProvider.this.panel.getSumPanel().getPayButton().setEnabled(false);
                return;
            }
            HashMap<String, Object> ielements = new HashMap<String, Object>();
            ielements.put("id1", new InputElement("id1", "id1", number, number, 0));
            MobileProvider.this.context.toVerify(MobileProvider.this.menuItem.getService().getId(), ielements, null, false);
        }
    }

    private class ValidateDocumentListener
    implements DocumentListener {
        private ValidateDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.change(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.change(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.change(e);
        }

        private void change(DocumentEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        String text = MobileProvider.this.panel.getNumberField().getText();
                        MobileProvider.this.sumIncomeListener.setWhiteCommission(null);
                        MobileProvider.this.sumOutcomeListener.setWhiteCommission(null);
                        MobileProvider.this.sumOutcomeListener.setSumIncomeListener(MobileProvider.this.sumIncomeListener);
                        if (MobileProvider.this.personalNumbers != null && MobileProvider.this.personalNumbers.get(text) != null) {
                            MobileProvider.this.sumIncomeListener.setWhiteCommission(((PersonalNumber)MobileProvider.this.personalNumbers.get(text)).getCommission());
                            MobileProvider.this.sumOutcomeListener.setWhiteCommission(((PersonalNumber)MobileProvider.this.personalNumbers.get(text)).getCommission());
                        }
                        MobileProvider.this.log.info((Object)(LocBundle.getMessageLog((String)"rma.mobile.vernumb") + " " + text));
                        MobileProvider.this.validNumber = MobileProvider.this.validator.validate(text);
                        MobileProvider.this.log.info((Object)MessageFormat.format(LocBundle.getMessageLog((String)"rma.mobile.valid"), MobileProvider.this.validNumber, MobileProvider.this.validator.getCurrentProvider(), MobileProvider.this.validator.getCurrentRegion()));
                        if (MobileProvider.this.validator.getCurrentProvider() != null) {
                            MobileProvider.this.current = MobileProvider.this.validator.getCurrentProvider();
                            MobileProvider.this.panel.getOperator().setText(MobileProvider.this.validator.getCurrentProvider().getName());
                        } else {
                            MobileProvider.this.panel.getOperator().setText("");
                        }
                        if (MobileProvider.this.validator.getCurrentRegion() != null) {
                            MobileProvider.this.panel.getRegion().setText(MobileProvider.this.validator.getCurrentRegion());
                        } else {
                            MobileProvider.this.panel.getRegion().setText("");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private class CancelActionListener
    implements ActionListener {
        private CancelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MobileProvider.this.log.info((Object)("\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440, \u0424\u043b\u0430\u0433 \u043f\u0435\u0447\u0430\u0442\u0438 = " + MobileProvider.this.isPrinted));
            if (MobileProvider.this.isPrinted && MobileProvider.this.currentJob != null) {
                RmaCancelOperationDialog dialog = new RmaCancelOperationDialog((Frame)MobileProvider.this.context.getMainFrame(), true);
                dialog.setTitle(LocBundle.getMessage((String)"rma.canseloperating.actuallycancel"));
                dialog.setVisible(true);
                if (dialog.isCanselled()) {
                    MobileProvider.this.log.info((Object)"\u0423\u043d\u0438\u0432\u0435\u0440\u0441\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440, \u041a\u0430\u0441\u0441\u0438\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b\u0441\u044f \u043e\u0442 \u043e\u0442\u043c\u0435\u043d\u044b \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438");
                    return;
                }
                String comment = dialog.getComment();
                MobileProvider.this.log.info((Object)("\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440, \u041a\u0430\u0441\u0441\u0438\u0440 \u0432\u0432\u0451\u043b " + comment));
                try {
                    MobileProvider.this.currentJob.getRecord().setComment(comment);
                    MobileProvider.this.currentJob.getRecord().setState((short)80);
                    MobileProvider.this.currentJob.getRecord().setSubstate((short)2);
                    PersistenceManager.getInstance().canselByCart(MobileProvider.this.currentJob.getRecord(), CurrentUser.getInstance().getUserId());
                    MobileProvider.this.context.clearPrintedOperationData();
                }
                catch (PersistenceException ex) {
                    MobileProvider.this.log.error((Object)"\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440, \u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043c\u0435\u043d\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u043e\u0442 \u043e\u0442\u043a\u0430\u0437\u0435", (Throwable)ex);
                }
            }
            MobileProvider.this.context.toMainMenu();
        }
    }

    public class LocalChangedFieldsListener
    implements FildsChangedListener {
        @Override
        public void fieldsChanged() {
            MobileProvider.this.isFieldsChanged = MobileProvider.this.isPrinted;
        }
    }

    private class ProcessActionListener
    implements ActionListener {
        private ProcessActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (MobileProvider.this.currentJob == null) {
                    throw new IllegalArgumentException("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0440\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0447\u0435\u043a");
                }
                if (!SumPanelHelper.verify(MobileProvider.this.context.getMainFrame(), MobileProvider.this.menuItem, MobileProvider.this.panel.getSumPanel())) {
                    MobileProvider.this.panel.getSumPanel().getPrintButton().setEnabled(true);
                    MobileProvider.this.panel.getSumPanel().getPayButton().setEnabled(false);
                    return;
                }
                MobileProvider.this.log.info((Object)"\u041f\u0435\u0440\u0435\u043d\u043e\u0448\u0443 \u0432 \u043a\u043e\u0440\u0437\u0438\u043d\u0443");
                MobileProvider.this.context.toPayment(MobileProvider.this.currentJob);
                MobileProvider.this.context.clearPrintedOperationData();
            }
            catch (Exception ex) {
                MobileProvider.this.log.info((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u043e\u043c \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0435", (Throwable)ex);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(MobileProvider.this.context.getMainFrame(), ex.getMessage(), "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u043e\u043c \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0435", 0);
                    }
                });
            }
        }
    }
}

