/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.mobile;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import rmai18n.LocBundle;
import ru.softlogic.rma.providers.mobile.CapacityElement;
import ru.softlogic.rma.providers.mobile.MobileValidator;
import ru.softlogic.rma.providers.mobile.Provider;
import ru.softlogic.rma.utils.PathUtils;
import ru.softlogic.rma.utils.SumFormatter;

public class CapacityUpdater
implements Runnable {
    MobileValidator mobileValidator;
    private List<Integer> services;
    private File file;
    private long lastModified;
    private Logger log;

    public CapacityUpdater(MobileValidator mobileValidator) {
        if (mobileValidator == null) {
            throw new IllegalArgumentException("Need MobileValidator");
        }
        this.mobileValidator = mobileValidator;
        this.log = Logger.getLogger((String)"pay");
        this.log.setAdditivity(false);
        String path = PathUtils.getAppHome() + File.separator + "resources" + File.separator + "capacity.xml";
        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.mobile.ldmasksfrom") + " " + path));
        this.file = new File(path);
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public void run() {
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.mobile.runthupdcap"));
        while (!Thread.currentThread().isInterrupted()) {
            long lm = this.file.lastModified();
            if (this.file.exists() && lm != this.lastModified) {
                try {
                    short id;
                    LinkedList<CapacityElement> elements = new LinkedList<CapacityElement>();
                    HashMap<Integer, Provider> providers = new HashMap<Integer, Provider>();
                    HashMap<Short, String> regions = new HashMap<Short, String>();
                    this.log.info((Object)LocBundle.getMessageLog((String)"rma.mobile.streadcap"));
                    SAXReader reader = new SAXReader();
                    Document document = reader.read(this.file);
                    Element root = document.getRootElement();
                    this.log.info((Object)LocBundle.getMessageLog((String)"rma.mobile.readprov"));
                    Element prv = root.element("providers");
                    if (prv == null) {
                        throw new IllegalArgumentException("Providers not found");
                    }
                    Iterator i = prv.elementIterator();
                    while (i.hasNext()) {
                        Element element = (Element)i.next();
                        try {
                            Provider provider = new Provider();
                            id = Integer.parseInt(element.valueOf("@id"));
                            provider.setId(id);
                            provider.setName(element.valueOf("@name"));
                            provider.setLegal(element.valueOf("@legal"));
                            provider.setLogo(element.valueOf("@logo"));
                            String minSum = element.valueOf("@min-sum");
                            if (minSum != null && !minSum.isEmpty()) {
                                provider.setMinSum(SumFormatter.parce(minSum));
                            }
                            String maxSum = element.valueOf("@max-sum");
                            provider.setMaxSum(SumFormatter.parce(maxSum));
                            provider.setActive(Boolean.parseBoolean(element.valueOf("@active")));
                            providers.put(Integer.valueOf(id), provider);
                        }
                        catch (Throwable ex) {
                            this.log.error((Object)LocBundle.getMessageLog((String)"rma.mobile.errparsel"));
                        }
                    }
                    this.log.info((Object)(LocBundle.getMessageLog((String)"rma.mobile.readedprov") + " " + providers.size()));
                    this.log.info((Object)LocBundle.getMessageLog((String)"rma.mobile.readregs"));
                    Element reg = root.element("regions");
                    if (reg == null) {
                        throw new IllegalArgumentException("Regions not found");
                    }
                    Iterator i2 = reg.elementIterator();
                    while (i2.hasNext()) {
                        Element element = (Element)i2.next();
                        id = Short.parseShort(element.valueOf("@id"));
                        String name = element.valueOf("@name");
                        regions.put(id, name);
                    }
                    this.log.info((Object)(LocBundle.getMessageLog((String)"rma.mobile.readedregs") + " " + regions.size()));
                    this.log.info((Object)LocBundle.getMessageLog((String)"rma.mobile.readcap"));
                    Element cap = root.element("capacity");
                    if (cap == null) {
                        throw new IllegalArgumentException("Capacities not found");
                    }
                    Iterator i3 = cap.elementIterator();
                    while (i3.hasNext()) {
                        Element element = (Element)i3.next();
                        int p = Integer.parseInt(element.valueOf("@p"));
                        short r = Short.parseShort(element.valueOf("@r"));
                        String from = element.valueOf("@f");
                        String to = element.valueOf("@t");
                        elements.add(new CapacityElement(from, to, p, r));
                    }
                    this.log.info((Object)(LocBundle.getMessageLog((String)"rma.mobile.readedcap") + " " + elements.size()));
                    this.mobileValidator.setElements(elements, providers, regions);
                    this.lastModified = lm;
                }
                catch (DocumentException ex) {
                    this.log.error((Object)(LocBundle.getMessageLog((String)"rma.mobile.errreaddbnumb") + " "), (Throwable)ex);
                }
            }
            try {
                Thread.sleep(600000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.mobile.stoping"));
    }
}

