/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.hyperkassa;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import rmai18n.LocBundle;
import ru.softlogic.rma.RmaAppContext;
import ru.softlogic.rma.RmaPaymentJob;
import ru.softlogic.rma.app.docs.SumDocument;
import ru.softlogic.rma.app.docs.listener.SumIncomeListener;
import ru.softlogic.rma.app.docs.listener.SumOutcomeListener;
import ru.softlogic.rma.app.helpers.Task;
import ru.softlogic.rma.connector.ConnectorException;
import ru.softlogic.rma.connector.model.HyperKassaPerson;
import ru.softlogic.rma.connector.model.MenuItem;
import ru.softlogic.rma.connector.model.Response;
import ru.softlogic.rma.connector.ws.stub.VerifyResult;
import ru.softlogic.rma.connector.ws.stub.VerifyResultType;
import ru.softlogic.rma.persistence.Record;
import ru.softlogic.rma.providers.InitData;
import ru.softlogic.rma.providers.ServiceProvider;
import ru.softlogic.rma.providers.hyperkassa.ChoiceActionPanel;
import ru.softlogic.rma.providers.hyperkassa.HyperKassaPanel;
import ru.softlogic.rma.providers.hyperkassa.PaymentPanel;
import ru.softlogic.rma.providers.hyperkassa.RegisterPayerPanel;
import ru.softlogic.rma.providers.hyperkassa.RegisterTemplateInfoPanel;
import ru.softlogic.rma.providers.hyperkassa.RegisterTemplatePanel;
import ru.softlogic.rma.providers.panels.SumPanelHelper;
import ru.softlogic.rma.utils.GuiUtils;
import ru.softlogic.rma.utils.SumFormatter;

public class HyperKassaProvider
implements ServiceProvider {
    private HyperKassaPanel mainPanel = new HyperKassaPanel();
    private ChoiceActionPanel choicePanel = new ChoiceActionPanel();
    private RegisterPayerPanel payerPanel;
    private RegisterTemplatePanel templatePanel;
    private RegisterTemplateInfoPanel templateInfoPanel;
    private PaymentPanel paymentPanel;
    private SumDocument sumIncomeDocument;
    private SumIncomeListener sumIncomeListener;
    private SumDocument sumOutcomeDocument;
    private SumOutcomeListener sumOutcomeListener;
    private RmaAppContext context;
    private MenuItem menuItem;
    private Logger log;

    public HyperKassaProvider() {
        this.choicePanel.getRegisterPayerButton().addActionListener(new ToRegisterPayerActionListener());
        this.choicePanel.getRegisterTemplateButton().addActionListener(new ToRegisterTemplateActionListener());
        this.choicePanel.getPayButton().addActionListener(new ToPayActionListener());
        this.choicePanel.getCancelButton().addActionListener(new ToExitActionListener());
        this.payerPanel = new RegisterPayerPanel();
        this.payerPanel.getRegisterButton().addActionListener(new RegisterPayerActionListener());
        this.payerPanel.getCancelButton().addActionListener(new CancelActionListener());
        this.templatePanel = new RegisterTemplatePanel();
        this.templatePanel.getRegisterTemplateButton().addActionListener(new RegisterTemplateActionListener());
        this.templatePanel.getCancelButton().addActionListener(new CancelActionListener());
        this.templateInfoPanel = new RegisterTemplateInfoPanel();
        this.templateInfoPanel.getPaymentButton().addActionListener(new TemplateToPaymentActionListener());
        this.templateInfoPanel.getCancelButton().addActionListener(new CancelActionListener());
        this.paymentPanel = new PaymentPanel();
        this.paymentPanel.getSumPanel().getCheckButton().addActionListener(new PaymentVerifyActionListener());
        this.paymentPanel.getSumPanel().getCancelButton().addActionListener(new CancelActionListener());
        this.paymentPanel.getSumPanel().getPayButton().addActionListener(new PaymentProcessActionListener());
        this.sumIncomeListener = new SumIncomeListener(this.paymentPanel.getSumPanel().getSumOutcomeField(), this.paymentPanel.getSumPanel().getSumCommField());
        this.sumIncomeDocument = new SumDocument();
        this.sumIncomeDocument.addDocumentListener(this.sumIncomeListener);
        this.paymentPanel.getSumPanel().getSumIncomeField().setDocument(this.sumIncomeDocument);
        this.sumOutcomeListener = new SumOutcomeListener(this.paymentPanel.getSumPanel().getSumIncomeField(), this.paymentPanel.getSumPanel().getSumCommField());
        this.sumOutcomeDocument = new SumDocument();
        this.sumOutcomeDocument.addDocumentListener(this.sumOutcomeListener);
        this.paymentPanel.getSumPanel().getSumOutcomeField().setDocument(this.sumOutcomeDocument);
        this.sumIncomeListener.setSumOutcomeListener(this.sumOutcomeListener);
        this.sumOutcomeListener.setSumIncomeListener(this.sumIncomeListener);
        this.log = Logger.getLogger((String)"pay");
    }

    @Override
    public void init(InitData initData) {
        if (initData == null) {
            throw new IllegalArgumentException("");
        }
        this.context = initData.getContext();
        this.menuItem = initData.getMenuItem();
        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.hk.gotopay") + " " + this.menuItem));
        this.sumIncomeListener.init(this.menuItem, null);
        this.sumOutcomeListener.init(this.menuItem, null);
        this.paymentPanel.getSumPanel().getSumIncomeField().setText("");
        this.paymentPanel.getSumPanel().getSumOutcomeField().setText("");
        this.paymentPanel.getSumPanel().getSumCommField().setText("");
        this.paymentPanel.getSumPanel().getCommentField().setText("");
        this.paymentPanel.getSumPanel().getPrintRequestCheckBox().setEnabled(initData.getPrintRequest() != null);
        this.paymentPanel.getSumPanel().getPrintRequestCheckBox().setSelected(Boolean.TRUE.equals(initData.getPrintRequest()));
        this.paymentPanel.getSumPanel().getPrintDocumentCheckBox().setEnabled(initData.getPrintDocument() != null);
        this.paymentPanel.getSumPanel().getPrintDocumentCheckBox().setSelected(Boolean.TRUE.equals(initData.getPrintDocument()));
        this.paymentPanel.getSumPanel().getPayButton().setEnabled(true);
        this.showPanel(this.choicePanel, null);
    }

    @Override
    public JPanel getPanel() {
        return this.mainPanel;
    }

    private void showPanel(final JPanel panel, final JComponent focusable) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                HyperKassaProvider.this.mainPanel.getContentPanel().setVisible(false);
                HyperKassaProvider.this.mainPanel.getContentPanel().removeAll();
                HyperKassaProvider.this.mainPanel.getContentPanel().add(panel);
                HyperKassaProvider.this.mainPanel.getContentPanel().setVisible(true);
            }
        });
        if (focusable != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    focusable.requestFocus();
                }
            });
        }
    }

    private class ToExitActionListener
    implements ActionListener {
        private ToExitActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HyperKassaProvider.this.context.toMainMenu();
        }
    }

    private class CancelActionListener
    implements ActionListener {
        private CancelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HyperKassaProvider.this.showPanel(HyperKassaProvider.this.choicePanel, null);
        }
    }

    private class ToPayActionListener
    implements ActionListener {
        private ToPayActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HyperKassaProvider.this.paymentPanel.init();
            HyperKassaProvider.this.showPanel(HyperKassaProvider.this.paymentPanel, HyperKassaProvider.this.paymentPanel.getTemplateTextField());
        }
    }

    private class ToRegisterTemplateActionListener
    implements ActionListener {
        private ToRegisterTemplateActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HyperKassaProvider.this.templatePanel.init();
            HyperKassaProvider.this.showPanel(HyperKassaProvider.this.templatePanel, HyperKassaProvider.this.templatePanel.getPhoneTextField());
        }
    }

    private class ToRegisterPayerActionListener
    implements ActionListener {
        private ToRegisterPayerActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HyperKassaProvider.this.payerPanel.init();
            HyperKassaProvider.this.showPanel(HyperKassaProvider.this.payerPanel, HyperKassaProvider.this.payerPanel.getPhoneTextField());
        }
    }

    private class PaymentProcessActionListener
    implements ActionListener {
        private PaymentProcessActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HyperKassaProvider.this.paymentPanel.getSumPanel().getPayButton().setEnabled(false);
            String number = HyperKassaProvider.this.paymentPanel.getTemplateTextField().getText();
            int sumIncome = SumFormatter.parce(HyperKassaProvider.this.paymentPanel.getSumPanel().getSumIncomeField().getText(), 0);
            int sumOutcome = SumFormatter.parce(HyperKassaProvider.this.paymentPanel.getSumPanel().getSumOutcomeField().getText(), 0);
            HyperKassaProvider.this.log.info((Object)MessageFormat.format(LocBundle.getMessageLog((String)"rma.hk.trytopay"), number, HyperKassaProvider.this.paymentPanel.getSumPanel().getSumIncomeField().getText(), HyperKassaProvider.this.paymentPanel.getSumPanel().getSumOutcomeField().getText()));
            try {
                if (number.length() != 10) {
                    GuiUtils.requestFocus(HyperKassaProvider.this.paymentPanel.getTemplateTextField());
                    JOptionPane.showMessageDialog(HyperKassaProvider.this.context.getMainFrame(), LocBundle.getMessage((String)"rma.mobile.numbntfnd2"), LocBundle.getMessage((String)"rma.hk.erronaddpay"), 0);
                    HyperKassaProvider.this.paymentPanel.getSumPanel().getPayButton().setEnabled(true);
                    return;
                }
                if (!SumPanelHelper.verify(HyperKassaProvider.this.context.getMainFrame(), HyperKassaProvider.this.menuItem, HyperKassaProvider.this.paymentPanel.getSumPanel())) {
                    HyperKassaProvider.this.paymentPanel.getSumPanel().getPayButton().setEnabled(true);
                    return;
                }
                RmaPaymentJob job = new RmaPaymentJob();
                Record record = new Record();
                job.setRecord(record);
                record.setServiceId(HyperKassaProvider.this.menuItem.getService().getId());
                record.setServiceName(HyperKassaProvider.this.menuItem.getService().getName());
                record.setCommissionId(HyperKassaProvider.this.menuItem.getCommission().getId());
                record.setAccount(number);
                record.setSumIncome(sumIncome);
                record.setSumOutcome(sumOutcome);
                record.setComment(HyperKassaProvider.this.paymentPanel.getSumPanel().getCommentField().getText());
                job.setPrintDocument(HyperKassaProvider.this.paymentPanel.getSumPanel().getPrintDocumentCheckBox().isSelected());
                job.setPrintRequest(HyperKassaProvider.this.paymentPanel.getSumPanel().getPrintRequestCheckBox().isSelected());
                job.setMenuItem(HyperKassaProvider.this.menuItem);
                if (!HyperKassaProvider.this.context.toPayment(job)) {
                    HyperKassaProvider.this.paymentPanel.getSumPanel().getPayButton().setEnabled(true);
                }
            }
            catch (Exception ex) {
                HyperKassaProvider.this.paymentPanel.getSumPanel().getPayButton().setEnabled(true);
                HyperKassaProvider.this.log.info((Object)(LocBundle.getMessageLog((String)"rma.hk.onpayerr") + " "), (Throwable)ex);
                JOptionPane.showMessageDialog(HyperKassaProvider.this.context.getMainFrame(), ex.getMessage(), LocBundle.getMessage((String)"rma.hk.erronaddpay"), 0);
            }
        }
    }

    private class PaymentVerifyActionListener
    implements ActionListener {
        private PaymentVerifyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (HyperKassaProvider.this.paymentPanel.getTemplateTextField().getText().length() != 10) {
                JOptionPane.showMessageDialog(HyperKassaProvider.this.context.getMainFrame(), LocBundle.getMessage((String)"rma.hk.wrongsnumb"), LocBundle.getMessage((String)"rma.hk.attrsvererr"), 0);
                HyperKassaProvider.this.paymentPanel.getTemplateTextField().requestFocus();
                return;
            }
            HyperKassaProvider.this.context.getTaskExecutor().execute(new Task(){

                @Override
                public Object execute() {
                    try {
                        HashMap<String, String> form = new HashMap<String, String>();
                        form.put("id1", HyperKassaProvider.this.paymentPanel.getTemplateTextField().getText());
                        return HyperKassaProvider.this.context.getConnector().verify(HyperKassaProvider.this.menuItem.getService().getId(), form);
                    }
                    catch (ConnectorException ex) {
                        return ex;
                    }
                }

                @Override
                public void onResult(Object object) {
                    if (object instanceof Response) {
                        Response vr = (Response)object;
                        HyperKassaProvider.this.log.info((Object)(LocBundle.getMessageLog((String)"rma.hk.verres") + " " + vr));
                        if (vr.getServiceError() == 0) {
                            if (((VerifyResult)vr.getResult()).getRt() == VerifyResultType.OK) {
                                HyperKassaProvider.this.paymentPanel.getInfoLabel().setForeground(Color.BLACK);
                                if (!((VerifyResult)vr.getResult()).getDi().isEmpty()) {
                                    HyperKassaProvider.this.paymentPanel.getInfoLabel().setText("<html><p align=right>" + ((VerifyResult)vr.getResult()).getDi().get(0).getValue());
                                } else {
                                    HyperKassaProvider.this.paymentPanel.getInfoLabel().setText("<html>" + LocBundle.getMessage((String)"rma.hk.accountntfnd"));
                                }
                            } else if (((VerifyResult)vr.getResult()).getRt() == VerifyResultType.NOT_FOUND) {
                                HyperKassaProvider.this.paymentPanel.getInfoLabel().setForeground(Color.red);
                                HyperKassaProvider.this.paymentPanel.getInfoLabel().setText("<html>" + LocBundle.getMessage((String)"rma.hk.accountntfnd"));
                            } else if (((VerifyResult)vr.getResult()).getRt() == VerifyResultType.PROVIDER_ANSWER_ERROR) {
                                HyperKassaProvider.this.paymentPanel.getInfoLabel().setForeground(Color.red);
                                HyperKassaProvider.this.paymentPanel.getInfoLabel().setText("<html>" + LocBundle.getMessage((String)"rma.hk.proverr"));
                            } else if (((VerifyResult)vr.getResult()).getRt() == VerifyResultType.PROVIDER_PERMIT) {
                                HyperKassaProvider.this.paymentPanel.getInfoLabel().setForeground(Color.red);
                                HyperKassaProvider.this.paymentPanel.getInfoLabel().setText("<html>" + LocBundle.getMessage((String)"rma.hk.paybanned"));
                            } else if (((VerifyResult)vr.getResult()).getRt() == VerifyResultType.VERIFY_NOT_AVAILABLE) {
                                HyperKassaProvider.this.paymentPanel.getInfoLabel().setForeground(Color.red);
                                HyperKassaProvider.this.paymentPanel.getInfoLabel().setText("<html>" + LocBundle.getMessage((String)"rma.hk.verntsupp"));
                            }
                        } else {
                            ErrorInfo info = new ErrorInfo(LocBundle.getMessage((String)"rma.hk.sercconerr"), LocBundle.getMessage((String)"rma.hk.errserv") + vr.getServiceError(), null, null, null, Level.ALL, null);
                            JXErrorPane.showDialog((Component)HyperKassaProvider.this.context.getMainFrame(), (ErrorInfo)info);
                        }
                    } else if (object instanceof Throwable) {
                        Throwable ex = (Throwable)object;
                        HyperKassaProvider.this.log.error((Object)LocBundle.getMessageLog((String)"rma.hk.verexception"), ex);
                        ErrorInfo info = new ErrorInfo(LocBundle.getMessage((String)"rma.hk.sercconerr"), ex.getMessage(), null, null, ex, Level.ALL, null);
                        JXErrorPane.showDialog((Component)HyperKassaProvider.this.context.getMainFrame(), (ErrorInfo)info);
                    }
                }
            });
        }
    }

    private class TemplateToPaymentActionListener
    implements ActionListener {
        private TemplateToPaymentActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HyperKassaProvider.this.paymentPanel.init();
            HyperKassaProvider.this.paymentPanel.getTemplateTextField().setText(HyperKassaProvider.this.templateInfoPanel.getTemplateLabel().getText());
            HyperKassaProvider.this.showPanel(HyperKassaProvider.this.paymentPanel, HyperKassaProvider.this.paymentPanel.getTemplateTextField());
        }
    }

    private class RegisterTemplateActionListener
    implements ActionListener {
        private RegisterTemplateActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (HyperKassaProvider.this.templatePanel.getPhoneTextField().getText().length() != 10) {
                JOptionPane.showMessageDialog(HyperKassaProvider.this.context.getMainFrame(), LocBundle.getMessage((String)"rma.hk.wrongnumb"), LocBundle.getMessage((String)"rma.hk.attrsvererr"), 0);
                HyperKassaProvider.this.templatePanel.getPhoneTextField().requestFocus();
                return;
            }
            if (HyperKassaProvider.this.templatePanel.getBikTextField().getText().length() != 9) {
                JOptionPane.showMessageDialog(HyperKassaProvider.this.context.getMainFrame(), LocBundle.getMessage((String)"rma.hk.bikvererr"), LocBundle.getMessage((String)"rma.hk.attrsvererr"), 0);
                HyperKassaProvider.this.templatePanel.getBikTextField().requestFocus();
                return;
            }
            if (HyperKassaProvider.this.templatePanel.getAccountTextField().getText().length() != 20) {
                JOptionPane.showMessageDialog(HyperKassaProvider.this.context.getMainFrame(), LocBundle.getMessage((String)"rma.hk.accounterr"), LocBundle.getMessage((String)"rma.hk.attrsvererr"), 0);
                HyperKassaProvider.this.templatePanel.getAccountTextField().requestFocus();
                return;
            }
            if (HyperKassaProvider.this.templatePanel.getFioTextField().getText().length() < 3) {
                JOptionPane.showMessageDialog(HyperKassaProvider.this.context.getMainFrame(), LocBundle.getMessage((String)"rma.hk.wrongfio"), LocBundle.getMessage((String)"rma.hk.attrsvererr"), 0);
                HyperKassaProvider.this.templatePanel.getFioTextField().requestFocus();
                return;
            }
            if (HyperKassaProvider.this.templatePanel.getContractTextField().getText().length() < 1) {
                JOptionPane.showMessageDialog(HyperKassaProvider.this.context.getMainFrame(), LocBundle.getMessage((String)"rma.hk.wrongdocn"), LocBundle.getMessage((String)"rma.hk.attrsvererr"), 0);
                HyperKassaProvider.this.templatePanel.getContractTextField().requestFocus();
                return;
            }
        }
    }

    private class RegisterPayerActionListener
    implements ActionListener {
        private RegisterPayerActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (HyperKassaProvider.this.payerPanel.getPhoneTextField().getText().length() != 10) {
                JOptionPane.showMessageDialog(HyperKassaProvider.this.context.getMainFrame(), LocBundle.getMessage((String)"rma.hk.wrongnumb"), LocBundle.getMessage((String)"rma.hk.attrsvererr"), 0);
                HyperKassaProvider.this.payerPanel.getPhoneTextField().requestFocus();
                return;
            }
            if (HyperKassaProvider.this.payerPanel.getLastNameTextField().getText().length() < 2) {
                JOptionPane.showMessageDialog(HyperKassaProvider.this.context.getMainFrame(), LocBundle.getMessage((String)"rma.hk.wrongsname"), LocBundle.getMessage((String)"rma.hk.attrsvererr"), 0);
                HyperKassaProvider.this.payerPanel.getLastNameTextField().requestFocus();
                return;
            }
            if (HyperKassaProvider.this.payerPanel.getFirstNameTextField().getText().length() < 2) {
                JOptionPane.showMessageDialog(HyperKassaProvider.this.context.getMainFrame(), LocBundle.getMessage((String)"rma.hk.wrongname"), LocBundle.getMessage((String)"rma.hk.attrsvererr"), 0);
                HyperKassaProvider.this.payerPanel.getFirstNameTextField().requestFocus();
                return;
            }
            if (HyperKassaProvider.this.payerPanel.getMiddleNameTextField().getText().length() < 2) {
                JOptionPane.showMessageDialog(HyperKassaProvider.this.context.getMainFrame(), LocBundle.getMessage((String)"rma.hk.wronglname"), LocBundle.getMessage((String)"rma.hk.attrsvererr"), 0);
                HyperKassaProvider.this.payerPanel.getMiddleNameTextField().requestFocus();
                return;
            }
            if (HyperKassaProvider.this.payerPanel.getPassportSerialTextField().getText().isEmpty()) {
                JOptionPane.showMessageDialog(HyperKassaProvider.this.context.getMainFrame(), LocBundle.getMessage((String)"rma.hk.wrongpassps"), LocBundle.getMessage((String)"rma.hk.attrsvererr"), 0);
                HyperKassaProvider.this.payerPanel.getPassportSerialTextField().requestFocus();
                return;
            }
            if (HyperKassaProvider.this.payerPanel.getPassportNumberTextField().getText().isEmpty()) {
                JOptionPane.showMessageDialog(HyperKassaProvider.this.context.getMainFrame(), LocBundle.getMessage((String)"rma.hk.wrongpasspn"), LocBundle.getMessage((String)"rma.hk.attrsvererr"), 0);
                HyperKassaProvider.this.payerPanel.getPassportNumberTextField().requestFocus();
                return;
            }
            if (HyperKassaProvider.this.payerPanel.getIssuedOnDatePicker().getDate() == null) {
                JOptionPane.showMessageDialog(HyperKassaProvider.this.context.getMainFrame(), LocBundle.getMessage((String)"rma.hk.wrongpasspd"), LocBundle.getMessage((String)"rma.hk.attrsvererr"), 0);
                HyperKassaProvider.this.payerPanel.getIssuedOnDatePicker().requestFocus();
                return;
            }
            if (HyperKassaProvider.this.payerPanel.getIssuedByTextField().getText().isEmpty()) {
                JOptionPane.showMessageDialog(HyperKassaProvider.this.context.getMainFrame(), LocBundle.getMessage((String)"rma.hk.wrongpasspp"), LocBundle.getMessage((String)"rma.hk.attrsvererr"), 0);
                HyperKassaProvider.this.payerPanel.getIssuedByTextField().requestFocus();
                return;
            }
            if (HyperKassaProvider.this.payerPanel.getBirthDayDatePicker().getDate() == null) {
                JOptionPane.showMessageDialog(HyperKassaProvider.this.context.getMainFrame(), LocBundle.getMessage((String)"rma.hk.wrongbirthd"), LocBundle.getMessage((String)"rma.hk.attrsvererr"), 0);
                HyperKassaProvider.this.payerPanel.getBirthDayDatePicker().requestFocus();
                return;
            }
            if (HyperKassaProvider.this.payerPanel.getBirthPlaceTextField().getText().isEmpty()) {
                JOptionPane.showMessageDialog(HyperKassaProvider.this.context.getMainFrame(), LocBundle.getMessage((String)"rma.hk.wrongbirthp"), LocBundle.getMessage((String)"rma.hk.attrsvererr"), 0);
                HyperKassaProvider.this.payerPanel.getBirthPlaceTextField().requestFocus();
                return;
            }
            if (HyperKassaProvider.this.payerPanel.getCitizenshipTextField().getText().isEmpty()) {
                JOptionPane.showMessageDialog(HyperKassaProvider.this.context.getMainFrame(), LocBundle.getMessage((String)"rma.hk.wrongctzp"), LocBundle.getMessage((String)"rma.hk.attrsvererr"), 0);
                HyperKassaProvider.this.payerPanel.getCitizenshipTextField().requestFocus();
                return;
            }
            if (HyperKassaProvider.this.payerPanel.getAddressTextField().getText().isEmpty()) {
                JOptionPane.showMessageDialog(HyperKassaProvider.this.context.getMainFrame(), LocBundle.getMessage((String)"rma.hk.wrongaddress"), LocBundle.getMessage((String)"rma.hk.attrsvererr"), 0);
                HyperKassaProvider.this.payerPanel.getAddressTextField().requestFocus();
                return;
            }
            HyperKassaProvider.this.context.getTaskExecutor().execute(new Task(){

                @Override
                public Object execute() {
                    HyperKassaPerson p = new HyperKassaPerson();
                    p.setmPhone(HyperKassaProvider.this.payerPanel.getPhoneTextField().getText());
                    p.setFam(HyperKassaProvider.this.payerPanel.getLastNameTextField().getText());
                    p.setName(HyperKassaProvider.this.payerPanel.getFirstNameTextField().getText());
                    p.setSname(HyperKassaProvider.this.payerPanel.getMiddleNameTextField().getText());
                    p.setKd("01");
                    p.setSd(HyperKassaProvider.this.payerPanel.getPassportSerialTextField().getText());
                    p.setNd(HyperKassaProvider.this.payerPanel.getPassportNumberTextField().getText());
                    p.setGd(HyperKassaProvider.this.payerPanel.getIssuedByTextField().getText());
                    p.setDd(HyperKassaProvider.this.payerPanel.getIssuedOnDatePicker().getDate());
                    p.setDr(HyperKassaProvider.this.payerPanel.getBirthDayDatePicker().getDate());
                    p.setMr(HyperKassaProvider.this.payerPanel.getBirthPlaceTextField().getText());
                    p.setCs(HyperKassaProvider.this.payerPanel.getCitizenshipTextField().getText());
                    p.setAmr(HyperKassaProvider.this.payerPanel.getAddressTextField().getText());
                    try {
                        return HyperKassaProvider.this.context.getConnector().hyperReg(HyperKassaProvider.this.menuItem.getService().getId(), p);
                    }
                    catch (ConnectorException ex) {
                        return ex;
                    }
                }

                @Override
                public void onResult(Object object) {
                    if (object instanceof Response) {
                        Response resp = (Response)object;
                        HyperKassaProvider.this.log.info((Object)(LocBundle.getMessageLog((String)"rma.hk.verres") + " " + resp));
                        if (resp.getServiceError() == 0) {
                            JOptionPane.showMessageDialog(HyperKassaProvider.this.context.getMainFrame(), LocBundle.getMessage((String)"rma.hk.regsucc"), LocBundle.getMessage((String)"rma.hk.infomes"), 1);
                            HyperKassaProvider.this.templatePanel.getPhoneTextField().setText(HyperKassaProvider.this.payerPanel.getPhoneTextField().getText());
                            HyperKassaProvider.this.showPanel(HyperKassaProvider.this.templatePanel, HyperKassaProvider.this.templatePanel.getBikTextField());
                        }
                    } else if (object instanceof Throwable) {
                        Throwable ex = (Throwable)object;
                        HyperKassaProvider.this.log.error((Object)LocBundle.getMessageLog((String)"rma.hk.regexception"), ex);
                        ErrorInfo info = new ErrorInfo(LocBundle.getMessage((String)"rma.hk.sercconerr"), ex.getMessage(), null, null, ex, Level.ALL, null);
                        JXErrorPane.showDialog((Component)HyperKassaProvider.this.context.getMainFrame(), (ErrorInfo)info);
                    }
                }
            });
            try {
                System.out.println();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

