/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.advanced.screen.components;

import java.awt.Color;
import java.util.Map;
import javax.swing.JComponent;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.text.KeyboardType;
import ru.softlogic.input.model.field.text.RegexFormatter;
import ru.softlogic.input.model.field.text.TextField;
import ru.softlogic.rma.app.components.MultipleMaskTextField;
import ru.softlogic.rma.app.docs.DigitalNumberDocument;
import ru.softlogic.rma.app.docs.LetterEnNumberDocument;
import ru.softlogic.rma.app.docs.LetterNumberDocument;
import ru.softlogic.rma.providers.advanced.screen.components.InputComponent;

public class TextInputComponent
implements InputComponent {
    private TextField field;
    private MultipleMaskTextField component;

    public TextInputComponent(TextField field) {
        Character xButton;
        this.field = field;
        String defMask = null;
        Map map = null;
        if (field.getDataFormatter() instanceof RegexFormatter) {
            defMask = ((RegexFormatter)field.getDataFormatter()).getDefaultMask();
            map = ((RegexFormatter)field.getDataFormatter()).getMasks();
        }
        Character c = xButton = field.getKeyboard().getExtraCharacter() != null && !Character.isWhitespace(field.getKeyboard().getExtraCharacter().charValue()) ? field.getKeyboard().getExtraCharacter() : null;
        this.component = field.getKeyboard().getType() != null && field.getKeyboard().getType() == KeyboardType.Digital ? new MultipleMaskTextField(new DigitalNumberDocument(field.getMaxLength(), field.getPrefix(), xButton), field.getPrefix(), defMask, map) : (field.getKeyboard().getType() != null && field.getKeyboard().getType() == KeyboardType.Letter ? new MultipleMaskTextField(new LetterEnNumberDocument(field.getMaxLength(), ",.;@"), field.getPrefix(), defMask, map) : new MultipleMaskTextField(new LetterNumberDocument(field.getMaxLength(), field.getPrefix()), field.getPrefix(), defMask, map));
        this.component.setEditable(!field.isReadOnly());
        this.component.setText(field.getValue());
    }

    @Override
    public boolean isValid() {
        boolean valid = this.field.getValidator().validate(this.component.getText());
        if (!valid) {
            this.component.setBackground(Color.RED);
        } else {
            this.component.setBackground(null);
        }
        return valid;
    }

    @Override
    public void putData(Map<String, Object> data) {
        InputElement ie = new InputElement(this.field.getId(), this.field.getTitle(), this.field.getTitle(), this.component.getText(), this.field.getModificator().modify(this.component.getText()), this.component.getTextTitle(), this.field.getFlags());
        data.put(this.field.getId(), ie);
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public String getComponentKey() {
        return this.field.getId();
    }

    @Override
    public boolean isFailValid() {
        if (this.field.getFailRegex() != null && !this.field.getFailRegex().isEmpty()) {
            boolean valid = this.field.getValidator().validate(this.component.getText());
            if (!valid) {
                this.component.setBackground(Color.RED);
            } else {
                this.component.setBackground(Color.YELLOW);
            }
            return valid;
        }
        return false;
    }
}

