/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.advanced.screen.components;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import rmai18n.LocBundle;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.actions.ContextHelper;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.rma.RmaApp;
import ru.softlogic.rma.RmaView;
import ru.softlogic.rma.providers.advanced.screen.components.InputComponent;

public class SelectorVariantInputComponent
implements InputComponent {
    private SelectorField field;
    private JPanel component;
    private ActionListener butListener;
    private JButton nextButton;
    private JButton active;

    public SelectorVariantInputComponent() {
    }

    public SelectorVariantInputComponent(SelectorField field, Map<String, Object> data, JButton nextButton) {
        this.field = field;
        this.nextButton = nextButton;
        this.active = null;
        TableLayout layout = new TableLayout(new double[]{0.1, 0.8, 10.0, 32.0, 0.1}, new double[0]);
        this.component = new JPanel((LayoutManager)layout);
        this.butListener = new ButtonListener();
        ResourceMap resourceMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getResourceMap(RmaView.class);
        HelpListener hl = new HelpListener();
        for (int i = 0; i < field.getItems().size(); ++i) {
            SelectorItem si = (SelectorItem)field.getItems().get(i);
            JButton but = new JButton(si.getTitle());
            but.putClientProperty("value", si.getValue());
            but.putClientProperty("sitem", si);
            but.addActionListener(this.butListener);
            layout.insertRow(layout.getNumRow(), 40.0);
            this.component.add((Component)but, "1," + (layout.getNumRow() - 1));
            JLabel label = new JLabel(resourceMap.getIcon("RmaView.help32icon"));
            label.putClientProperty("text", si.getHelp());
            label.addMouseListener(hl);
            this.component.add((Component)label, "3," + (layout.getNumRow() - 1));
            layout.insertRow(layout.getNumRow(), 15.0);
        }
    }

    public void init(SelectorField field, Map<String, Object> data, JButton nextButton) {
        this.field = field;
        this.nextButton = nextButton;
        this.active = null;
        TableLayout layout = new TableLayout(new double[]{0.12, 0.8, 10.0, 32.0, 0.1}, new double[0]);
        this.component = new JPanel((LayoutManager)layout);
        this.butListener = new ButtonListener();
        ResourceMap resourceMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getResourceMap(RmaView.class);
        HelpListener hl = new HelpListener();
        for (int i = 0; i < field.getItems().size(); ++i) {
            SelectorItem si = (SelectorItem)field.getItems().get(i);
            JButton but = new JButton(si.getTitle());
            but.putClientProperty("value", si.getValue());
            but.putClientProperty("sitem", si);
            but.addActionListener(this.butListener);
            layout.insertRow(layout.getNumRow(), 40.0);
            this.component.add((Component)but, "1," + (layout.getNumRow() - 1));
            JLabel label = new JLabel(resourceMap.getIcon("RmaView.help32icon"));
            label.putClientProperty("text", si.getHelp());
            label.addMouseListener(hl);
            this.component.add((Component)label, "3," + (layout.getNumRow() - 1));
            layout.insertRow(layout.getNumRow(), 15.0);
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void putData(Map<String, Object> data) {
        if (this.active != null) {
            SelectorItem si = (SelectorItem)this.active.getClientProperty("sitem");
            data.put(this.field.getId(), new InputElement(this.field.getId(), this.field.getTitle(), (String)this.active.getClientProperty("value"), this.active.getText(), this.field.getFlags()));
            if (si.getData() != null) {
                Data d = si.getData();
                ContextHelper.mergeData(data, (List)d.getElements());
                if (d.getNestedData() != null) {
                    data.put(d.getNestedData().getId(), d.getNestedData().getData());
                }
                if (d.getSum() != null) {
                    data.put("#sum", d.getSum());
                }
            }
        }
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public String getComponentKey() {
        return this.field.getId();
    }

    @Override
    public boolean isFailValid() {
        return false;
    }

    public class HelpListener
    extends MouseInputAdapter {
        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getSource() instanceof JLabel) {
                JLabel label = (JLabel)e.getSource();
                JOptionPane.showMessageDialog(SelectorVariantInputComponent.this.component, label.getClientProperty("text"), LocBundle.getMessage((String)"rma.hk.infomes"), 1);
            }
        }
    }

    public class ButtonListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JButton) {
                SelectorVariantInputComponent.this.active = (JButton)e.getSource();
                SelectorVariantInputComponent.this.nextButton.doClick();
            }
        }
    }
}

