/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.advanced.screen.components;

import java.awt.Color;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.actions.ContextHelper;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.rma.providers.advanced.panels.ComboBoxItem;
import ru.softlogic.rma.providers.advanced.screen.components.InputComponent;

public class SelectorInputComponent
implements InputComponent {
    private SelectorField field;
    private JComboBox component;

    public SelectorInputComponent(SelectorField field, Map<String, Object> data) {
        this.field = field;
        this.component = new JComboBox();
        ComboBoxItem[] items = new ComboBoxItem[field.getItems().size()];
        for (int i = 0; i < items.length; ++i) {
            ComboBoxItem cbi;
            SelectorItem si = (SelectorItem)field.getItems().get(i);
            items[i] = cbi = new ComboBoxItem(si.getValue(), si.getTitle(), si);
        }
        this.component.setModel(new DefaultComboBoxModel<ComboBoxItem>(items));
        if (data.get(field.getId()) != null && data.get(field.getId()) instanceof InputElement) {
            InputElement ie = (InputElement)data.get(field.getId());
            this.component.setSelectedItem(new ComboBoxItem(ie.getValue(), ie.getValueTitle(), null));
        } else {
            this.component.setSelectedItem(null);
        }
    }

    @Override
    public boolean isValid() {
        boolean valid;
        boolean bl = valid = this.component.getSelectedItem() != null;
        if (!valid) {
            this.component.setBackground(Color.RED);
        } else {
            this.component.setBackground(null);
        }
        return valid;
    }

    @Override
    public void putData(Map<String, Object> data) {
        Object obj = this.component.getSelectedItem();
        if (obj != null) {
            ComboBoxItem cbi = (ComboBoxItem)obj;
            SelectorItem si = cbi.getItem();
            data.put(this.field.getId(), new InputElement(this.field.getId(), this.field.getTitle(), cbi.getValue(), cbi.getTitle(), this.field.getFlags()));
            if (si.getData() != null) {
                Data d = si.getData();
                ContextHelper.mergeData(data, (List)d.getElements());
                if (d.getNestedData() != null) {
                    data.put(d.getNestedData().getId(), d.getNestedData().getData());
                }
                if (d.getSum() != null) {
                    data.put("#sum", d.getSum());
                }
            }
        }
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public String getComponentKey() {
        return this.field.getId();
    }

    @Override
    public boolean isFailValid() {
        return false;
    }
}

