/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.advanced.screen.components;

import java.awt.Color;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTextField;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.numeric.NumericField;
import ru.softlogic.rma.app.docs.NumericDocument;
import ru.softlogic.rma.providers.advanced.screen.components.InputComponent;

public class NumericInputComponent
implements InputComponent {
    private NumericField field;
    private JTextField component;

    public NumericInputComponent(NumericField field) {
        this.field = field;
        this.component = new JTextField();
        this.component.setEditable(!field.isReadOnly());
        this.component.setDocument(new NumericDocument(field.getUnitCount(), field.getDecimalCount()));
        this.component.setText(field.getValue());
    }

    @Override
    public boolean isValid() {
        boolean valid = this.field.getValidator().validate(this.component.getText());
        if (!valid) {
            this.component.setBackground(Color.RED);
        } else {
            this.component.setBackground(null);
        }
        return valid;
    }

    @Override
    public void putData(Map<String, Object> data) {
        InputElement ie = new InputElement(this.field.getId(), this.field.getTitle(), this.field.getTitle(), this.component.getText(), this.field.getModificator().modify(this.component.getText()), this.component.getText(), this.field.getFlags());
        data.put(this.field.getId(), ie);
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public String getComponentKey() {
        return this.field.getId();
    }

    @Override
    public boolean isFailValid() {
        return false;
    }
}

