/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.advanced.screen;

import info.clearthought.layout.TableLayout;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import rmai18n.LocBundle;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.ModelEnvironment;
import ru.softlogic.input.model.advanced.AdvancedScreenDescription;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.field.Field;
import ru.softlogic.input.model.field.FieldType;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.barcode.BarcodeData;
import ru.softlogic.input.model.field.barcode.BarcodeException;
import ru.softlogic.input.model.field.barcode.BarcodeParser;
import ru.softlogic.input.model.field.numeric.NumericField;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.text.TextField;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.UniScreenDescription;
import ru.softlogic.rma.RmaApp;
import ru.softlogic.rma.app.Configuration;
import ru.softlogic.rma.app.components.MultipleMaskTextField;
import ru.softlogic.rma.connector.model.MenuItem;
import ru.softlogic.rma.model.add.BankRecord;
import ru.softlogic.rma.providers.advanced.Helper;
import ru.softlogic.rma.providers.advanced.panels.BarcodePanelMini;
import ru.softlogic.rma.providers.advanced.panels.UniversalPanel;
import ru.softlogic.rma.providers.advanced.screen.ActionsCancelListener;
import ru.softlogic.rma.providers.advanced.screen.AdvancedScreen;
import ru.softlogic.rma.providers.advanced.screen.AdvancedScreenListener;
import ru.softlogic.rma.providers.advanced.screen.components.InputComponent;
import ru.softlogic.rma.providers.advanced.screen.components.NumericInputComponent;
import ru.softlogic.rma.providers.advanced.screen.components.SelectorInputComponent;
import ru.softlogic.rma.providers.advanced.screen.components.TextInputComponent;
import ru.softlogic.rma.providers.universal.form.BarcodeField;
import ru.softlogic.rma.providers.universal.general.ACManager;
import ru.softlogic.rma.providers.universal.general.InterfaceListener;
import ru.softlogic.rma.utils.FontResizer;
import ru.softlogic.rma.utils.GuiUtils;
import ru.softlogic.rma.utils.RSParser;
import sun.awt.CausedFocusEvent;

public class UniversalScreen
implements AdvancedScreen {
    private UniversalPanel panel;
    private AdvancedScreenDescription asd;
    private Set<AdvancedScreenListener> listeners;
    private List<InputComponent> controls;
    private Set<AWTKeyStroke> forwardKeys;
    private Logger log;
    private Color errorColor = new Color(204, 0, 0);
    private Color successColor = new Color(0, 204, 0);
    private ResourceMap resourceMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getResourceMap(BarcodePanelMini.class);
    private LocalFocusListener focusListener;
    private Font defaultLabelFont;
    private Font defaultFieldFont;
    private ACManager acm;
    private List<InterfaceListener> iListeners;

    public UniversalScreen() {
        this.panel = new UniversalPanel();
        FontResizer.process(this.panel, Configuration.getInstance().getData().getSoftwareFontSize());
        this.defaultLabelFont = new Font("Tahoma", 1, 12);
        if (Configuration.getInstance().getData().getSoftwareFontSize() != null) {
            this.defaultLabelFont = this.defaultLabelFont.deriveFont((float)(this.defaultLabelFont.getSize() * Configuration.getInstance().getData().getSoftwareFontSize()) * 1.0f / 100.0f);
        }
        this.defaultFieldFont = this.panel.getTitleLabel().getFont();
        this.forwardKeys = new HashSet<AWTKeyStroke>(this.panel.getFocusTraversalKeys(0));
        this.forwardKeys.add(KeyStroke.getKeyStroke(10, 0));
        this.panel.getNextButton().addActionListener(new LocalNextListener());
        this.panel.getPrevButton().addActionListener(new LocalPrevListener());
        this.panel.getExitButton().addActionListener(new LocalExitListener());
        this.focusListener = new LocalFocusListener();
        this.acm = new ACManager();
        this.acm.setFields(new HashMap<String, MultipleMaskTextField>());
        this.listeners = new HashSet<AdvancedScreenListener>();
        this.iListeners = new LinkedList<InterfaceListener>();
        this.log = Logger.getLogger((String)"pay");
    }

    @Override
    public boolean init(MenuItem menuItem, AdvancedScreenDescription asd, Map<String, Object> data) throws InitException {
        this.asd = asd;
        UniScreenDescription screen = (UniScreenDescription)asd.getDescription();
        if (screen.getSequence().getFields().isEmpty()) {
            throw new InitException("No fields");
        }
        Helper.processActionButton(this.panel.getNextButton(), asd, "next");
        Helper.processActionButton(this.panel.getPrevButton(), asd, "prev");
        Helper.processActionButton(this.panel.getExitButton(), asd, "exit");
        this.panel.getTitleLabel().setText(screen.getTitle());
        JPanel content = this.panel.getContentPanel();
        content.setVisible(false);
        content.removeAll();
        this.controls = new LinkedList<InputComponent>();
        TableLayout layout = new TableLayout(new double[]{0.0, -2.0, 6.0, -1.0, 7.0, 0.0}, new double[0]);
        content.setLayout((LayoutManager)layout);
        int heigth = 0;
        InputComponent focused = null;
        this.acm.getFields().clear();
        ModelEnvironment me = new ModelEnvironment(data, null, 0.0, null);
        for (Field field : screen.getSequence().initFields(me)) {
            if (field.isExist() && !data.containsKey(field.getId())) continue;
            String title = null;
            InputComponent component = null;
            boolean addHeigth = false;
            if (field.getType() == FieldType.Numeric) {
                NumericField nf = (NumericField)field;
                title = nf.getTitle();
                component = new NumericInputComponent(nf);
                component.getComponent().putClientProperty("field", nf);
            } else if (field.getType() == FieldType.Letter) {
                TextField tf = (TextField)field;
                title = tf.getTitle();
                component = new TextInputComponent(tf);
                component.getComponent().putClientProperty("field", tf);
                if (component.getComponent() instanceof MultipleMaskTextField) {
                    MultipleMaskTextField mmtf = (MultipleMaskTextField)component.getComponent();
                    if ("corr_bik".equals(field.getId())) {
                        mmtf.getDocument().addDocumentListener(new LocalPopupFieldDocumentListener(mmtf));
                    }
                    if ("corr_acc".equals(field.getId()) || "corr_bank_name".equals(field.getId())) {
                        mmtf.setEditable(false);
                    }
                    if ("recipient_acc".equals(field.getId())) {
                        mmtf.addFocusListener(new LocalRSFocusListener());
                    }
                    mmtf.putClientProperty("field", field);
                    this.acm.getFields().put(field.getId(), mmtf);
                }
            } else if (field.getType() == FieldType.Selector) {
                SelectorField sf = (SelectorField)field;
                title = sf.getTitle();
                component = new SelectorInputComponent(sf, data);
            }
            component.getComponent().setFont(this.defaultFieldFont);
            if (!(component instanceof BarcodePanelMini)) {
                component.getComponent().setFocusTraversalKeys(0, this.forwardKeys);
                component.getComponent().addFocusListener(this.focusListener);
            }
            if (field.getId().equals(screen.getFocusedField())) {
                focused = component;
            }
            layout.insertRow(layout.getNumRow(), (double)this.defaultFieldFont.getSize() * 1.8 + (double)addHeigth);
            if (title != null) {
                JLabel label = new JLabel(title + ":");
                label.setFont(this.defaultLabelFont);
                content.add((Component)label, "1," + (layout.getNumRow() - 1));
                content.add((Component)component.getComponent(), "3," + (layout.getNumRow() - 1));
            } else {
                content.add((Component)component.getComponent(), "0," + (layout.getNumRow() - 1) + ",3," + (layout.getNumRow() - 1));
            }
            this.controls.add(component);
            heigth += 44;
        }
        if (screen.getBarcodeScanner() != null && Configuration.getInstance().getData().isBarcodeScannerPresent()) {
            BarcodeField bf = new BarcodeField("#barcode", screen.getBarcodeScanner().getParser(), "");
            BarcodePanelMini bpm = new BarcodePanelMini();
            bpm.getBarcodeTextField().setText(bf.getValue());
            bpm.getErrorLabel().setVisible(false);
            bpm.getBarcodeTextField().putClientProperty("barcode_field", (Object)bf);
            bpm.getBarcodeTextField().putClientProperty("barcode_panel", bpm);
            bpm.getBarcodeTextField().addKeyListener(new BarcodeKeyListener());
            screen.getBarcodeScanner();
            layout.insertRow(layout.getNumRow(), -1.0);
            content.add((Component)bpm.getComponent(), "0," + (layout.getNumRow() - 1) + ",3," + (layout.getNumRow() - 1));
            this.controls.add(bpm);
        }
        if (!this.controls.isEmpty()) {
            this.controls.get(this.controls.size() - 1).getComponent().addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    CausedFocusEvent ev;
                    if (e instanceof CausedFocusEvent && (ev = (CausedFocusEvent)e).getCause() == CausedFocusEvent.Cause.TRAVERSAL_FORWARD) {
                        GuiUtils.requestFocus(UniversalScreen.this.panel.getNextButton());
                    }
                }
            });
        } else {
            Action action = asd.getActionMap().getActionByType("skip");
            if (action == null) {
                action = asd.getActionMap().getActionByType("next");
            }
            if (action != null) {
                for (AdvancedScreenListener listener : this.listeners) {
                    listener.onAction((ScreenDescription)screen, new ActionsCancelListener(this.panel.getNextButton(), null), action, new HashMap<String, Object>());
                }
            }
        }
        content.setVisible(true);
        if (!this.controls.isEmpty()) {
            if (focused != null) {
                GuiUtils.requestFocus(focused.getComponent());
            } else {
                GuiUtils.requestFocus(this.controls.get(0).getComponent());
            }
            return true;
        }
        return false;
    }

    @Override
    public void addListener(AdvancedScreenListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void setBankRecords(Map<String, BankRecord> bankRecords) {
        this.acm.setBankRecords(bankRecords);
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    public void addListener(InterfaceListener listener) {
        if (listener != null) {
            this.iListeners.add(listener);
        }
    }

    private void onBarcodeResult(JTextField fld) {
        BarcodeField bf = (BarcodeField)((Object)fld.getClientProperty("barcode_field"));
        BarcodePanelMini bpm = (BarcodePanelMini)fld.getClientProperty("barcode_panel");
        String barcode = fld.getText();
        fld.setText("");
        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.adv.datawasreaded") + " " + barcode));
        BarcodeParser parser = bf.getParser();
        try {
            BarcodeData data = parser.parse(barcode);
            this.log.info((Object)(LocBundle.getMessageLog((String)"rma.adv.barcoderes") + " " + data));
            bpm.setData(data);
            bpm.getErrorLabel().setForeground(this.successColor);
            bpm.getErrorLabel().setText(this.resourceMap.getString("AdvancedProvider.panels.barcode.errorLabel.success", new Object[0]));
            for (InputElement el : data.getElements()) {
                for (InputComponent ic : this.controls) {
                    if (!ic.getComponentKey().equals(el.getKey()) || !(ic.getComponent() instanceof JTextField)) continue;
                    JTextField tf = (JTextField)ic.getComponent();
                    tf.setText(el.getValue());
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append("<html><table>");
            for (InputElement el : data.getElements()) {
                sb.append("<tr><td>").append(el.getKeyTitle()).append(": ").append("</td><td>").append(el.getValueTitle()).append("</td></tr>");
            }
            sb.append("</table>");
            bpm.getDataLabel().setText(sb.toString());
            GuiUtils.requestFocus(this.panel.getNextButton());
        }
        catch (BarcodeException ex) {
            GuiUtils.requestFocus(bpm.getBarcodeTextField());
            this.log.error((Object)(LocBundle.getMessageLog((String)"rma.adv.errparsing") + " " + ex.getMessage()));
            bpm.getErrorLabel().setForeground(this.errorColor);
            bpm.getErrorLabel().setText(this.resourceMap.getString("AdvancedProvider.panels.barcode.errorLabel.error", new Object[0]));
        }
        bpm.getErrorLabel().setVisible(true);
    }

    private class LocalRSFocusListener
    implements FocusListener {
        private LocalRSFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            Field field;
            JTextField tf;
            if (e.getSource() instanceof JTextField && (tf = (JTextField)e.getSource()).getClientProperty("field") instanceof Field && "recipient_acc".equals((field = (Field)tf.getClientProperty("field")).getId())) {
                boolean needIdentification = RSParser.getInstance().checkRS(tf.getText());
                for (InterfaceListener il : UniversalScreen.this.iListeners) {
                    il.setNeedIdentification(needIdentification);
                }
                if (needIdentification) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(UniversalScreen.this.panel, LocBundle.getMessage((String)"rma.needidentification"), LocBundle.getMessage((String)"rma.needidentificationtitle"), 1);
                        }
                    });
                }
            }
        }
    }

    private class LocalPopupFieldDocumentListener
    implements DocumentListener {
        private JTextField field;

        public LocalPopupFieldDocumentListener(JTextField field) {
            this.field = field;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            UniversalScreen.this.acm.processPopup(this.field);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            UniversalScreen.this.acm.processPopup(this.field);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }

    private class LocalFocusListener
    implements FocusListener {
        private LocalFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            JComponent comp;
            if (e.getComponent() instanceof JComponent && (comp = (JComponent)e.getSource()).getClientProperty("field") instanceof IdentityField) {
                IdentityField field = (IdentityField)comp.getClientProperty("field");
                if (field.getHelp() != null && !field.getHelp().trim().isEmpty()) {
                    UniversalScreen.this.panel.getHelpPanel().getHelpLabel().setText(field.getHelp());
                    UniversalScreen.this.panel.getHelpPanel().setVisible(true);
                } else {
                    UniversalScreen.this.panel.getHelpPanel().setVisible(false);
                }
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            UniversalScreen.this.panel.getHelpPanel().setVisible(false);
        }
    }

    private class BarcodeKeyListener
    extends KeyAdapter {
        private BarcodeKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent evt) {
            if (evt.getKeyCode() == 10 && evt.getSource() instanceof JTextField) {
                final JTextField tfield = (JTextField)evt.getSource();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UniversalScreen.this.onBarcodeResult(tfield);
                    }
                });
            }
        }
    }

    private class LocalExitListener
    implements ActionListener {
        private LocalExitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UniversalScreen.this.panel.getExitButton().setEnabled(false);
            Action action = UniversalScreen.this.asd.getActionMap().getActionByType("exit");
            for (AdvancedScreenListener asl : UniversalScreen.this.listeners) {
                asl.onAction(UniversalScreen.this.asd.getDescription(), new ActionsCancelListener(UniversalScreen.this.panel.getExitButton(), ((InputComponent)UniversalScreen.this.controls.get(0)).getComponent()), action, Helper.extractData(UniversalScreen.this.controls));
            }
        }
    }

    private class LocalNextListener
    implements ActionListener {
        private LocalNextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block3: {
                block2: {
                    if (!Helper.checkData(UniversalScreen.this.controls)) break block2;
                    UniversalScreen.this.panel.getNextButton().setEnabled(false);
                    Action action = UniversalScreen.this.asd.getActionMap().getActionByType("next");
                    for (AdvancedScreenListener asl : UniversalScreen.this.listeners) {
                        asl.onAction(UniversalScreen.this.asd.getDescription(), new ActionsCancelListener(UniversalScreen.this.panel.getNextButton(), UniversalScreen.this.controls.isEmpty() ? null : ((InputComponent)UniversalScreen.this.controls.get(0)).getComponent()), action, Helper.extractData(UniversalScreen.this.controls));
                    }
                    break block3;
                }
                if (!Helper.checkFailData(UniversalScreen.this.controls)) break block3;
                UniversalScreen.this.panel.getNextButton().setEnabled(false);
                Action action = UniversalScreen.this.asd.getActionMap().getActionByType("next");
                Map<String, Object> data = Helper.extractData(UniversalScreen.this.controls);
                data.put("#invalid", new InputElement("#invalid", "#invalid", "true"));
                for (AdvancedScreenListener asl : UniversalScreen.this.listeners) {
                    asl.onAction(UniversalScreen.this.asd.getDescription(), new ActionsCancelListener(UniversalScreen.this.panel.getNextButton(), UniversalScreen.this.controls.isEmpty() ? null : ((InputComponent)UniversalScreen.this.controls.get(0)).getComponent()), action, data);
                }
            }
        }
    }

    private class LocalPrevListener
    implements ActionListener {
        private LocalPrevListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UniversalScreen.this.panel.getPrevButton().setEnabled(false);
            Action action = UniversalScreen.this.asd.getActionMap().getActionByType("prev");
            for (AdvancedScreenListener asl : UniversalScreen.this.listeners) {
                asl.onAction(UniversalScreen.this.asd.getDescription(), new ActionsCancelListener(UniversalScreen.this.panel.getPrevButton(), ((InputComponent)UniversalScreen.this.controls.get(0)).getComponent()), action, Helper.extractData(UniversalScreen.this.controls));
            }
        }
    }
}

