/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.advanced.screen;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ru.softlogic.input.model.ModelEnvironment;
import ru.softlogic.input.model.advanced.AdvancedScreenDescription;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.advanced.actions.ContextHelper;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.table.TableColumn;
import ru.softlogic.input.model.field.table.TableField;
import ru.softlogic.input.model.field.table.TableItem;
import ru.softlogic.rma.connector.model.MenuItem;
import ru.softlogic.rma.providers.advanced.Helper;
import ru.softlogic.rma.providers.advanced.panels.TableFieldTableModel;
import ru.softlogic.rma.providers.advanced.panels.TablePanel;
import ru.softlogic.rma.providers.advanced.screen.ActionsCancelListener;
import ru.softlogic.rma.providers.advanced.screen.AdvancedScreen;
import ru.softlogic.rma.providers.advanced.screen.AdvancedScreenListener;

public class TableScreen
implements AdvancedScreen {
    private TablePanel tablePanel;
    private JPanel main;
    private Set<AdvancedScreenListener> listeners = new HashSet<AdvancedScreenListener>();
    private AdvancedScreenDescription asd;
    private TableItem currentTableItem;

    public TableScreen() {
        this.tablePanel = new TablePanel();
        this.tablePanel.getNextButton().addActionListener(new LocalNextListener());
        this.tablePanel.getPrevButton().addActionListener(new LocalPrevListener());
        this.tablePanel.getTable().addMouseListener(new LocalMouseListener());
        this.tablePanel.addComponentListener(new ResizeHandler());
    }

    @Override
    public boolean init(MenuItem menuItem, AdvancedScreenDescription screen, Map<String, Object> data) throws InitException {
        if (!"table".equals(screen.getDescription().getType())) {
            throw new InitException("Wrong type of screen: " + screen.getDescription().getType());
        }
        if (!(screen.getDescription().getSequence().getFields().get(0) instanceof TableField)) {
            throw new InitException("Wrong field: " + ((IdentityField)screen.getDescription().getSequence().getFields().get(0)).getClass());
        }
        this.asd = screen;
        this.currentTableItem = null;
        Helper.processActionButton(this.tablePanel.getNextButton(), screen, "next");
        Helper.processActionButton(this.tablePanel.getPrevButton(), screen, "prev");
        ModelEnvironment me = new ModelEnvironment(data, null, 0.0, null);
        ((TableField)screen.getDescription().getSequence().getFields().get(0)).init(me);
        this.repaintScreen();
        return true;
    }

    @Override
    public void addListener(AdvancedScreenListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public JPanel getPanel() {
        return this.tablePanel;
    }

    private Map<String, Object> getData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ContextHelper.mergeData(data, this.currentTableItem != null ? this.currentTableItem.getData().getElements() : null);
        if (this.currentTableItem != null && this.currentTableItem.getData().getNestedData() != null) {
            data.put(this.currentTableItem.getData().getNestedData().getId(), this.currentTableItem.getData().getNestedData().getData());
        }
        return data;
    }

    private void repaintScreen() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableField tfield = (TableField)TableScreen.this.asd.getDescription().getSequence().getFields().get(0);
                List columns = tfield.getColumns();
                LinkedList<String> titles = new LinkedList<String>();
                for (TableColumn column : columns) {
                    titles.add(column.getTitle());
                }
                titles.toArray(new String[titles.size()]);
                TableFieldTableModel tftm = new TableFieldTableModel();
                tftm.setItems(tfield.getTableItems());
                tftm.setNames(tfield.getColumns());
                TableScreen.this.tablePanel.getTable().setModel(tftm);
                System.out.println("prefSize=" + TableScreen.this.tablePanel.getTable().getPreferredSize());
                System.out.println("Size=" + TableScreen.this.tablePanel.getTable().getSize());
                System.out.println("prefSize Scroll=" + TableScreen.this.tablePanel.getjScrollPane1().getPreferredSize());
                System.out.println("Size Scroll=" + TableScreen.this.tablePanel.getjScrollPane1().getSize());
                double widht = TableScreen.this.tablePanel.getjScrollPane1().getSize().getWidth();
                if (widht > 2.0) {
                    widht -= 2.0;
                }
                double percentWidht = widht / 100.0;
                int index = 0;
                for (TableColumn column : tfield.getColumns()) {
                    TableScreen.this.tablePanel.getTable().getColumnModel().getColumn(index).setPreferredWidth((int)(column.getWidth() * percentWidht));
                    ++index;
                }
                TableScreen.this.tablePanel.getTable().setAutoResizeMode(0);
            }
        });
    }

    private TableItem getTableItem(MouseEvent event) {
        int row = this.tablePanel.getTable().rowAtPoint(event.getPoint());
        if (row >= 0) {
            TableFieldTableModel ptm = (TableFieldTableModel)this.tablePanel.getTable().getModel();
            return ptm.getItemsArray()[row];
        }
        return null;
    }

    private class LocalMouseListener
    extends MouseAdapter {
        private LocalMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getButton() == 1) {
                TableScreen.this.currentTableItem = TableScreen.this.getTableItem(event);
                if (event.getClickCount() == 2) {
                    for (ActionListener listener : TableScreen.this.tablePanel.getNextButton().getActionListeners()) {
                        listener.actionPerformed(null);
                    }
                }
            }
        }
    }

    private class LocalNextListener
    implements ActionListener {
        private LocalNextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableScreen.this.tablePanel.getNextButton().setEnabled(false);
            Action action = TableScreen.this.asd.getActionMap().getActionByType("next");
            for (AdvancedScreenListener asl : TableScreen.this.listeners) {
                asl.onAction(TableScreen.this.asd.getDescription(), new ActionsCancelListener(TableScreen.this.tablePanel.getNextButton(), null), action, TableScreen.this.getData());
            }
        }
    }

    private class LocalPrevListener
    implements ActionListener {
        private LocalPrevListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableScreen.this.tablePanel.getPrevButton().setEnabled(false);
            Action action = TableScreen.this.asd.getActionMap().getActionByType("prev");
            for (AdvancedScreenListener asl : TableScreen.this.listeners) {
                asl.onAction(TableScreen.this.asd.getDescription(), new ActionsCancelListener(TableScreen.this.tablePanel.getPrevButton(), null), action, new HashMap<String, Object>());
            }
        }
    }

    private class ResizeHandler
    extends ComponentAdapter {
        private ResizeHandler() {
        }

        @Override
        public void componentResized(ComponentEvent ce) {
            TableScreen.this.repaintScreen();
        }
    }
}

