/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.advanced.screen;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.ModelEnvironment;
import ru.softlogic.input.model.advanced.AdvancedScreenDescription;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.advanced.actions.ContextHelper;
import ru.softlogic.input.model.field.FieldType;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.UniScreenDescription;
import ru.softlogic.rma.connector.model.MenuItem;
import ru.softlogic.rma.providers.advanced.Helper;
import ru.softlogic.rma.providers.advanced.panels.ComboBoxItem;
import ru.softlogic.rma.providers.advanced.panels.UniversalPanel;
import ru.softlogic.rma.providers.advanced.screen.ActionsCancelListener;
import ru.softlogic.rma.providers.advanced.screen.AdvancedScreen;
import ru.softlogic.rma.providers.advanced.screen.AdvancedScreenListener;
import ru.softlogic.rma.providers.advanced.screen.components.SelectorVariantInputComponent;

public class SelectorScreen
implements AdvancedScreen {
    private UniversalPanel listPanel;
    private JList list;
    private SelectorVariantInputComponent variant;
    private JPanel main;
    private Set<AdvancedScreenListener> listeners = new HashSet<AdvancedScreenListener>();
    private AdvancedScreenDescription asd;
    private SelectorField field;
    private ScreenDescription lastScreen;

    public SelectorScreen() {
        this.listPanel = new UniversalPanel();
        this.listPanel.getNextButton().addActionListener(new LocalNextListener());
        this.listPanel.getPrevButton().addActionListener(new LocalPrevListener());
        this.listPanel.getExitButton().addActionListener(new LocalExitListener());
        this.listPanel.getContentPanel().setLayout((LayoutManager)new TableLayout(new double[]{-1.0}, new double[]{-1.0}));
        this.list = new JList();
        this.list.addListSelectionListener(new LocalListListener());
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new LocalMouseListener());
        this.variant = new SelectorVariantInputComponent();
        this.main = new JPanel(new BorderLayout());
        this.main.add(this.listPanel);
    }

    @Override
    public boolean init(MenuItem menuItem, AdvancedScreenDescription screen, Map<String, Object> data) throws InitException {
        String[] type = screen.getDescription().getType().split("/");
        if (!"selector".equals(type[0])) {
            throw new InitException("Wrong type of screen: " + this.asd.getDescription().getType());
        }
        this.asd = screen;
        UniScreenDescription usd = (UniScreenDescription)this.asd.getDescription();
        if (usd.getSequence() == null || usd.getSequence().getFields() == null || usd.getSequence().getFields().isEmpty()) {
            throw new InitException("No Fields");
        }
        if (usd.getSequence().getFields().size() > 1) {
            throw new InitException("Too much fields");
        }
        if (((IdentityField)usd.getSequence().getFields().get(0)).getType() != FieldType.Selector) {
            throw new InitException("Wrong field type");
        }
        this.lastScreen = this.asd.getDescription();
        Helper.processActionButton(this.listPanel.getNextButton(), screen, "next");
        Helper.processActionButton(this.listPanel.getPrevButton(), screen, "prev");
        Helper.processActionButton(this.listPanel.getExitButton(), screen, "exit");
        this.field = (SelectorField)usd.getSequence().getFields().get(0);
        this.field.init(new ModelEnvironment(data, null, 0.0, null));
        this.listPanel.getNextButton().setVisible(true);
        this.listPanel.getPrevButton().setVisible(true);
        this.listPanel.getTitleLabel().setText(this.asd.getDescription().getTitle());
        this.listPanel.getContentPanel().removeAll();
        if (type.length > 1 && "variant".equals(type[1])) {
            this.listPanel.getNextButton().setVisible(false);
            this.listPanel.getPrevButton().setVisible(false);
            this.variant.init(this.field, data, this.listPanel.getNextButton());
            this.listPanel.getContentPanel().add((Component)this.variant.getComponent(), "0,0");
            this.listPanel.getContentPanel().setPreferredSize(new Dimension(50, (int)this.variant.getComponent().getPreferredSize().getHeight() + 50));
        } else {
            this.listPanel.getNextButton().setEnabled(false);
            this.listPanel.getContentPanel().add((Component)this.list, "0,0");
            ComboBoxItem[] items = new ComboBoxItem[this.field.getItems().size()];
            for (int i = 0; i < items.length; ++i) {
                ComboBoxItem cbi;
                SelectorItem si = (SelectorItem)this.field.getItems().get(i);
                items[i] = cbi = new ComboBoxItem(si.getValue(), si.getTitle(), si);
            }
            this.list.setModel(new DefaultComboBoxModel<ComboBoxItem>(items));
            if (data.get(this.field.getId()) != null && data.get(this.field.getId()) instanceof InputElement) {
                InputElement ie = (InputElement)data.get(this.field.getId());
                this.list.setSelectedValue(new ComboBoxItem(ie.getValue(), ie.getValueTitle(), null), true);
            }
            this.listPanel.getContentPanel().setPreferredSize(new Dimension(0, (int)this.list.getPreferredSize().getHeight() + 50));
        }
        return true;
    }

    @Override
    public void addListener(AdvancedScreenListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public JPanel getPanel() {
        return this.main;
    }

    private Map<String, Object> getData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (this.lastScreen != null) {
            String[] type = this.lastScreen.getType().split("/");
            if (type.length > 1 && "variant".equals(type[1])) {
                this.variant.putData(data);
            } else {
                Object obj = this.list.getSelectedValue();
                if (obj != null) {
                    ComboBoxItem cbi = (ComboBoxItem)obj;
                    SelectorItem si = cbi.getItem();
                    data.put(this.field.getId(), new InputElement(this.field.getId(), this.field.getTitle(), cbi.getValue(), cbi.getTitle(), this.field.getFlags()));
                    if (si.getData() != null) {
                        Data d = si.getData();
                        ContextHelper.mergeData(data, (List)d.getElements());
                        if (d.getNestedData() != null) {
                            data.put(d.getNestedData().getId(), d.getNestedData().getData());
                        }
                        if (d.getSum() != null) {
                            data.put("#sum", d.getSum());
                        }
                    }
                }
            }
        }
        return data;
    }

    private class LocalMouseListener
    extends MouseAdapter {
        private LocalMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getButton() == 1 && event.getClickCount() == 2) {
                for (ActionListener listener : SelectorScreen.this.listPanel.getNextButton().getActionListeners()) {
                    listener.actionPerformed(null);
                }
            }
        }
    }

    private class LocalNextListener
    implements ActionListener {
        private LocalNextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectorScreen.this.listPanel.getNextButton().setEnabled(false);
            Action action = SelectorScreen.this.asd.getActionMap().getActionByType("next");
            for (AdvancedScreenListener asl : SelectorScreen.this.listeners) {
                asl.onAction(SelectorScreen.this.asd.getDescription(), new ActionsCancelListener(SelectorScreen.this.listPanel.getNextButton(), SelectorScreen.this.list), action, SelectorScreen.this.getData());
            }
        }
    }

    private class LocalExitListener
    implements ActionListener {
        private LocalExitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectorScreen.this.listPanel.getExitButton().setEnabled(false);
            Action action = SelectorScreen.this.asd.getActionMap().getActionByType("exit");
            for (AdvancedScreenListener asl : SelectorScreen.this.listeners) {
                asl.onAction(SelectorScreen.this.asd.getDescription(), new ActionsCancelListener(SelectorScreen.this.listPanel.getExitButton(), SelectorScreen.this.list), action, SelectorScreen.this.getData());
            }
        }
    }

    private class LocalPrevListener
    implements ActionListener {
        private LocalPrevListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectorScreen.this.listPanel.getPrevButton().setEnabled(false);
            Action action = SelectorScreen.this.asd.getActionMap().getActionByType("prev");
            for (AdvancedScreenListener asl : SelectorScreen.this.listeners) {
                asl.onAction(SelectorScreen.this.asd.getDescription(), new ActionsCancelListener(SelectorScreen.this.listPanel.getPrevButton(), SelectorScreen.this.list), action, SelectorScreen.this.getData());
            }
        }
    }

    private class LocalListListener
    implements ListSelectionListener {
        private LocalListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            SelectorScreen.this.listPanel.getNextButton().setEnabled(SelectorScreen.this.list.getSelectedValue() != null);
        }
    }
}

