/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.advanced.screen;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.AdvancedScreenDescription;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.field.FieldType;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.text.TextField;
import ru.softlogic.input.model.screen.description.UniScreenDescription;
import ru.softlogic.rma.connector.model.MenuItem;
import ru.softlogic.rma.providers.advanced.Helper;
import ru.softlogic.rma.providers.advanced.panels.UniversalPanel;
import ru.softlogic.rma.providers.advanced.screen.ActionsCancelListener;
import ru.softlogic.rma.providers.advanced.screen.AdvancedScreen;
import ru.softlogic.rma.providers.advanced.screen.AdvancedScreenListener;

public class MessageScreen
implements AdvancedScreen {
    private UniversalPanel panel;
    private AdvancedScreenDescription asd;
    private Set<AdvancedScreenListener> listeners;
    private JTextArea textArea = new JTextArea();
    private TextField field;

    public MessageScreen() {
        this.textArea.setLineWrap(true);
        this.textArea.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.panel = new UniversalPanel();
        this.panel.getContentPanel().setLayout(new BorderLayout());
        this.panel.getNextButton().addActionListener(new LocalNextListener());
        this.panel.getPrevButton().addActionListener(new LocalPrevListener());
        this.panel.getScrollPane().setViewportBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.panel.getScrollPane().setViewportView(this.textArea);
        this.listeners = new HashSet<AdvancedScreenListener>();
    }

    @Override
    public boolean init(MenuItem menuItem, AdvancedScreenDescription screen, Map<String, Object> data) throws InitException {
        this.asd = screen;
        UniScreenDescription usd = (UniScreenDescription)screen.getDescription();
        if (usd.getSequence() == null || usd.getSequence().getFields() == null || usd.getSequence().getFields().isEmpty()) {
            throw new InitException("No fields");
        }
        if (usd.getSequence().getFields().size() > 1) {
            throw new InitException("Too much fields");
        }
        if (((IdentityField)usd.getSequence().getFields().get(0)).getType() != FieldType.Letter) {
            throw new InitException("Wrong type of field");
        }
        this.field = (TextField)usd.getSequence().getFields().get(0);
        this.textArea.setText("");
        Helper.processActionButton(this.panel.getNextButton(), screen, "next");
        Helper.processActionButton(this.panel.getPrevButton(), screen, "prev");
        this.panel.getNextButton().setEnabled(true);
        this.panel.getTitleLabel().setText(usd.getTitle());
        return true;
    }

    @Override
    public void addListener(AdvancedScreenListener listener) {
        if (this.listeners != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    private Map<String, Object> getData() {
        InputElement ie = new InputElement(this.field.getId(), this.field.getTitle(), this.textArea.getText(), this.textArea.getText(), this.field.getFlags());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.field.getId(), ie);
        return map;
    }

    private class LocalNextListener
    implements ActionListener {
        private LocalNextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MessageScreen.this.panel.getNextButton().setEnabled(false);
            Action action = MessageScreen.this.asd.getActionMap().getActionByType("next");
            for (AdvancedScreenListener asl : MessageScreen.this.listeners) {
                asl.onAction(MessageScreen.this.asd.getDescription(), new ActionsCancelListener(MessageScreen.this.panel.getNextButton(), MessageScreen.this.panel.getNextButton()), action, MessageScreen.this.getData());
            }
        }
    }

    private class LocalPrevListener
    implements ActionListener {
        private LocalPrevListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MessageScreen.this.panel.getPrevButton().setEnabled(false);
            Action action = MessageScreen.this.asd.getActionMap().getActionByType("prev");
            for (AdvancedScreenListener asl : MessageScreen.this.listeners) {
                asl.onAction(MessageScreen.this.asd.getDescription(), new ActionsCancelListener(MessageScreen.this.panel.getPrevButton(), MessageScreen.this.panel.getPrevButton()), action, MessageScreen.this.getData());
            }
        }
    }
}

