/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.advanced.screen;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import rmai18n.LocBundle;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.AdvancedScreenDescription;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.barcode.BarcodeData;
import ru.softlogic.input.model.field.barcode.BarcodeException;
import ru.softlogic.input.model.field.barcode.BarcodeParser;
import ru.softlogic.input.model.screen.description.InfoScreenDescription;
import ru.softlogic.rma.RmaApp;
import ru.softlogic.rma.app.Configuration;
import ru.softlogic.rma.connector.model.MenuItem;
import ru.softlogic.rma.providers.advanced.Helper;
import ru.softlogic.rma.providers.advanced.panels.BarcodePanelMini;
import ru.softlogic.rma.providers.advanced.panels.UniversalPanel;
import ru.softlogic.rma.providers.advanced.screen.ActionsCancelListener;
import ru.softlogic.rma.providers.advanced.screen.AdvancedScreen;
import ru.softlogic.rma.providers.advanced.screen.AdvancedScreenListener;
import ru.softlogic.rma.providers.universal.form.BarcodeField;
import ru.softlogic.rma.utils.GuiUtils;

public class InfoScreen
implements AdvancedScreen {
    private UniversalPanel panel;
    private JLabel infoLabel;
    private AdvancedScreenDescription asd;
    private Set<AdvancedScreenListener> listeners;
    private Logger log;
    private Color errorColor = new Color(204, 0, 0);
    private Color successColor = new Color(0, 204, 0);
    private ResourceMap resourceMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getResourceMap(BarcodePanelMini.class);
    private BarcodePanelMini bpm;

    public InfoScreen() {
        this.panel = new UniversalPanel();
        this.panel.getContentPanel().setLayout(new BorderLayout());
        this.panel.getNextButton().addActionListener(new LocalNextListener());
        this.panel.getPrevButton().addActionListener(new LocalPrevListener());
        this.infoLabel = new JLabel();
        this.infoLabel.setVerticalAlignment(1);
        this.panel.getContentPanel().add((Component)this.infoLabel, "North");
        this.bpm = new BarcodePanelMini();
        this.bpm.getBarcodeTextField().addKeyListener(new BarcodeKeyListener());
        this.panel.getContentPanel().add((Component)this.bpm.getComponent(), "South");
        this.listeners = new HashSet<AdvancedScreenListener>();
        this.log = Logger.getLogger((String)"pay");
    }

    @Override
    public boolean init(MenuItem menuItem, AdvancedScreenDescription screen, Map<String, Object> data) throws InitException {
        this.asd = screen;
        InfoScreenDescription isd = (InfoScreenDescription)screen.getDescription();
        Object obj = data.get(isd.getKey());
        String text = "";
        if (obj != null) {
            if (!(obj instanceof InputElement)) {
                throw new InitException("wrong type of varible " + isd.getKey());
            }
            text = ((InputElement)obj).getValue();
        } else if (isd.getInfo() != null) {
            text = isd.getInfo();
        } else {
            throw new InitException("Varible with name " + isd.getKey() + " is not found");
        }
        if (text.startsWith("<html>")) {
            this.infoLabel.setText(text);
        } else {
            this.infoLabel.setText("<html>" + text);
        }
        if (isd.getBarcodeScanner() != null && Configuration.getInstance().getData().isBarcodeScannerPresent()) {
            BarcodeField bf = new BarcodeField("#barcode", isd.getBarcodeScanner().getParser(), "");
            this.bpm.getBarcodeTextField().setText(bf.getValue());
            this.bpm.getErrorLabel().setVisible(false);
            this.bpm.getDataLabel().setVisible(false);
            this.bpm.getBarcodeTextField().putClientProperty("barcode_field", (Object)bf);
            this.bpm.setVisible(true);
        } else {
            this.bpm.setVisible(false);
        }
        Helper.processActionButton(this.panel.getNextButton(), screen, "next");
        Helper.processActionButton(this.panel.getPrevButton(), screen, "prev");
        this.panel.getNextButton().setEnabled(true);
        this.panel.getTitleLabel().setText(isd.getTitle());
        return true;
    }

    @Override
    public void addListener(AdvancedScreenListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    private Map<String, Object> formElements() {
        HashMap<String, Object> elements = new HashMap<String, Object>();
        this.bpm.putData(elements);
        return elements;
    }

    private void onBarcodeResult(JTextField fld) {
        BarcodeField bf = (BarcodeField)((Object)fld.getClientProperty("barcode_field"));
        String barcode = fld.getText();
        fld.setText("");
        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.adv.datawasreaded") + " " + barcode));
        BarcodeParser parser = bf.getParser();
        try {
            BarcodeData data = parser.parse(barcode);
            this.log.info((Object)(LocBundle.getMessageLog((String)"rma.adv.barcoderes") + " " + data));
            this.bpm.setData(data);
            this.bpm.getErrorLabel().setForeground(this.successColor);
            this.bpm.getErrorLabel().setText(this.resourceMap.getString("AdvancedProvider.panels.barcode.errorLabel.success", new Object[0]));
            StringBuilder sb = new StringBuilder();
            sb.append("<html><table>");
            for (InputElement el : data.getElements()) {
                sb.append("<tr><td>").append(el.getKeyTitle()).append(": ").append("</td><td>").append(el.getValueTitle()).append("</td></tr>");
            }
            sb.append("</table>");
            this.bpm.getDataLabel().setText(sb.toString());
            this.bpm.getDataLabel().setVisible(true);
            GuiUtils.requestFocus(this.panel.getNextButton());
        }
        catch (BarcodeException ex) {
            GuiUtils.requestFocus(this.bpm.getBarcodeTextField());
            this.log.error((Object)(LocBundle.getMessageLog((String)"rma.adv.errparsing") + " " + ex.getMessage()));
            this.bpm.getErrorLabel().setForeground(this.errorColor);
            this.bpm.getErrorLabel().setText(this.resourceMap.getString("AdvancedProvider.panels.barcode.errorLabel.error", new Object[0]));
        }
        this.bpm.getErrorLabel().setVisible(true);
    }

    private class BarcodeKeyListener
    extends KeyAdapter {
        private BarcodeKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent evt) {
            if (evt.getKeyCode() == 10 && evt.getSource() instanceof JTextField) {
                final JTextField tfield = (JTextField)evt.getSource();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        InfoScreen.this.onBarcodeResult(tfield);
                    }
                });
            }
        }
    }

    private class LocalNextListener
    implements ActionListener {
        private LocalNextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InfoScreen.this.panel.getNextButton().setEnabled(false);
            Action action = InfoScreen.this.asd.getActionMap().getActionByType("next");
            for (AdvancedScreenListener asl : InfoScreen.this.listeners) {
                asl.onAction(InfoScreen.this.asd.getDescription(), new ActionsCancelListener(InfoScreen.this.panel.getNextButton(), InfoScreen.this.panel.getNextButton()), action, InfoScreen.this.formElements());
            }
        }
    }

    private class LocalPrevListener
    implements ActionListener {
        private LocalPrevListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InfoScreen.this.panel.getPrevButton().setEnabled(false);
            Action action = InfoScreen.this.asd.getActionMap().getActionByType("prev");
            for (AdvancedScreenListener asl : InfoScreen.this.listeners) {
                asl.onAction(InfoScreen.this.asd.getDescription(), new ActionsCancelListener(InfoScreen.this.panel.getPrevButton(), InfoScreen.this.panel.getPrevButton()), action, new HashMap<String, Object>());
            }
        }
    }
}

