/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.advanced.screen;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import rmai18n.LocBundle;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.TransactionSum;
import ru.softlogic.input.model.advanced.AdvancedScreenDescription;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.description.ConfirmScreenDescription;
import ru.softlogic.rma.connector.model.MenuItem;
import ru.softlogic.rma.providers.advanced.Helper;
import ru.softlogic.rma.providers.advanced.panels.UniversalPanel;
import ru.softlogic.rma.providers.advanced.screen.ActionsCancelListener;
import ru.softlogic.rma.providers.advanced.screen.AdvancedScreen;
import ru.softlogic.rma.providers.advanced.screen.AdvancedScreenListener;
import ru.softlogic.rma.utils.GuiUtils;
import ru.softlogic.rma.utils.SumFormatter;

public class ConfirmScreen
implements AdvancedScreen {
    private UniversalPanel panel = new UniversalPanel();
    private Set<AdvancedScreenListener> listeners;
    private AdvancedScreenDescription asd;

    public ConfirmScreen() {
        this.panel.getNextButton().addActionListener(new LocalNextListener());
        this.panel.getPrevButton().addActionListener(new LocalPrevListener());
        this.listeners = new HashSet<AdvancedScreenListener>();
    }

    @Override
    public boolean init(MenuItem menuItem, AdvancedScreenDescription screenDescription, Map<String, Object> data) throws InitException {
        if (!"confirm".equals(screenDescription.getDescription().getType()) && !"confirm/multiple".equals(screenDescription.getDescription().getType())) {
            throw new InitException("Wrong screen type");
        }
        this.asd = screenDescription;
        ConfirmScreenDescription screen = (ConfirmScreenDescription)screenDescription.getDescription();
        Helper.processActionButton(this.panel.getNextButton(), this.asd, "next");
        Helper.processActionButton(this.panel.getPrevButton(), this.asd, "prev");
        this.panel.getTitleLabel().setText(screen.getTitle());
        JPanel content = this.panel.getContentPanel();
        content.setVisible(false);
        content.removeAll();
        TableLayout layout = new TableLayout(new double[]{-1.0, 16.0}, new double[0]);
        content.setLayout((LayoutManager)layout);
        Collection<String> keys = null;
        keys = screen.getFields() != null && !screen.getFields().isEmpty() ? screen.getFields() : data.keySet();
        int heigth = 0;
        for (String key : keys) {
            InputElement ie;
            Object obj = data.get(key);
            System.out.println(key + "->" + obj);
            if (obj == null || !(obj instanceof InputElement) || (ie = (InputElement)obj).hasFlag(1)) continue;
            JLabel label = new JLabel(ie.getKeyTitle() + ":");
            layout.insertRow(layout.getNumRow(), 22.0);
            content.add((Component)label, "0," + (layout.getNumRow() - 1));
            JTextField field = new JTextField();
            field.setEditable(false);
            field.setText(ie.getValueTitle());
            layout.insertRow(layout.getNumRow(), 22.0);
            content.add((Component)field, "0," + (layout.getNumRow() - 1) + ",1," + (layout.getNumRow() - 1));
            heigth += 44;
        }
        if (data.get("#sum") != null) {
            TransactionSum ts = (TransactionSum)data.get("#sum");
            JLabel label = new JLabel(LocBundle.getMessage((String)"rma.adv.servsumm"));
            layout.insertRow(layout.getNumRow(), 22.0);
            content.add((Component)label, "0," + (layout.getNumRow() - 1));
            JTextField field = new JTextField();
            field.setEditable(false);
            field.setText(SumFormatter.format((double)ts.getSum() * Math.pow(10.0, -ts.getFractionDigits())));
            layout.insertRow(layout.getNumRow(), 22.0);
            content.add((Component)field, "0," + (layout.getNumRow() - 1) + ",1," + (layout.getNumRow() - 1));
            heigth += 44;
        }
        content.setPreferredSize(new Dimension(0, heigth + 50));
        content.setVisible(true);
        GuiUtils.requestFocus(this.panel.getNextButton());
        return true;
    }

    @Override
    public void addListener(AdvancedScreenListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    private class LocalNextListener
    implements ActionListener {
        private LocalNextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfirmScreen.this.panel.getNextButton().setEnabled(false);
            Action action = ConfirmScreen.this.asd.getActionMap().getActionByType("next");
            for (AdvancedScreenListener asl : ConfirmScreen.this.listeners) {
                asl.onAction(ConfirmScreen.this.asd.getDescription(), new ActionsCancelListener(ConfirmScreen.this.panel.getNextButton(), ConfirmScreen.this.panel.getNextButton()), action, new HashMap<String, Object>());
            }
        }
    }

    private class LocalPrevListener
    implements ActionListener {
        private LocalPrevListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfirmScreen.this.panel.getPrevButton().setEnabled(false);
            Action action = ConfirmScreen.this.asd.getActionMap().getActionByType("prev");
            for (AdvancedScreenListener asl : ConfirmScreen.this.listeners) {
                asl.onAction(ConfirmScreen.this.asd.getDescription(), new ActionsCancelListener(ConfirmScreen.this.panel.getPrevButton(), ConfirmScreen.this.panel.getPrevButton()), action, new HashMap<String, Object>());
            }
        }
    }
}

