/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.advanced.screen;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.NestedData;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.advanced.AdvancedScreenDescription;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.description.CommunalScreenDescription;
import ru.softlogic.rma.connector.model.MenuItem;
import ru.softlogic.rma.providers.advanced.Helper;
import ru.softlogic.rma.providers.advanced.panels.BasketPanel;
import ru.softlogic.rma.providers.advanced.panels.SimpleDataPanel;
import ru.softlogic.rma.providers.advanced.screen.ActionsCancelListener;
import ru.softlogic.rma.providers.advanced.screen.AdvancedScreen;
import ru.softlogic.rma.providers.advanced.screen.AdvancedScreenListener;
import ru.softlogic.rma.utils.SumFormatter;

public class BasketScreen
implements AdvancedScreen {
    private BasketPanel panel;
    private JPanel main;
    private Set<AdvancedScreenListener> listeners = new HashSet<AdvancedScreenListener>();
    private AdvancedScreenDescription asd;
    private LinkedList<SimpleDataPanel> selected = new LinkedList();
    private LinkedList<SimpleDataPanel> notSelected = new LinkedList();

    public BasketScreen() {
        this.panel = new BasketPanel();
        this.panel.getNextButton().addActionListener(new LocalNextListener());
        this.panel.getPrevButton().addActionListener(new LocalPrevListener());
        this.panel.addComponentListener(new LocalComponentListener());
        this.main = new JPanel(new BorderLayout());
        this.main.add(this.panel);
    }

    @Override
    public boolean init(MenuItem menuItem, AdvancedScreenDescription screen, Map<String, Object> data) throws InitException {
        if (!"communal".equals(screen.getDescription().getType())) {
            throw new InitException("Wrong type of screen: " + screen.getDescription().getType());
        }
        this.asd = screen;
        CommunalScreenDescription csd = (CommunalScreenDescription)screen.getDescription();
        Object obj = data.get(csd.getKey());
        NestedData nd = null;
        if (!(obj instanceof List)) {
            throw new InitException("Wrong data type");
        }
        nd = new NestedData(csd.getKey(), (List)((LinkedList)obj));
        Helper.processActionButton(this.panel.getNextButton(), screen, "next");
        Helper.processActionButton(this.panel.getPrevButton(), screen, "prev");
        this.panel.getTitleLabel().setText(csd.getTitle());
        this.repaintScreen(nd.getData(), data);
        return true;
    }

    private double calcSum(String summ) {
        if (summ != null && !summ.isEmpty()) {
            return Double.parseDouble(summ);
        }
        return 0.0;
    }

    @Override
    public void addListener(AdvancedScreenListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public JPanel getPanel() {
        return this.main;
    }

    private Map<String, Object> getData() {
        return this.getData(null);
    }

    private Map<String, Object> getData(Data data) {
        HashMap<String, Object> data2 = new HashMap<String, Object>();
        Map map = StoreHelper.convert((List)data.getElements());
        if (data != null && map.get("selected") != null) {
            if ("1".equals(((InputElement)map.get("selected")).getValue())) {
                data2.put("#removed", data);
            } else {
                data2.put("#selected", data);
            }
        }
        return data2;
    }

    private void repaintScreen(final List<Data> items, final Map<String, Object> data) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImageIcon icon = null;
                double sum = 0.0;
                TableLayout layout1 = new TableLayout(new double[]{-1.0, -3.0}, new double[0]);
                TableLayout layout2 = new TableLayout(new double[]{-1.0, 100.0}, new double[0]);
                BasketScreen.this.panel.getjPanel1().removeAll();
                BasketScreen.this.panel.getjPanel1().setLayout((LayoutManager)layout1);
                BasketScreen.this.panel.getjPanel2().setLayout((LayoutManager)layout2);
                for (Data item : items) {
                    SimpleDataPanel sdp = new SimpleDataPanel();
                    sdp.setData(item);
                    sdp.getEditButton().addActionListener(new LocalEditListener(item));
                    if (sdp.getSelected() != null && "1".equals(sdp.getSelected().getValue())) {
                        icon = new ImageIcon(this.getClass().getResource("/ru/softlogic/rma/resources/icon/32/remove.png"));
                        sdp.getEditButton().setIcon(icon);
                        layout2.insertRow(layout2.getNumRow(), -3.0);
                        BasketScreen.this.panel.getjPanel2().add((Component)sdp, "0," + (layout2.getNumRow() - 1) + ",1," + (layout2.getNumRow() - 1));
                        BasketScreen.this.selected.add(sdp);
                        sum += BasketScreen.this.calcSum(sdp.getSum() != null ? sdp.getSum().getValue() : "0");
                        continue;
                    }
                    if (data.get("serv_" + sdp.getId().getValue()) != null) {
                        layout2.insertRow(layout2.getNumRow(), 100.0);
                        BasketScreen.this.panel.getjPanel2().add((Component)sdp, "0," + (layout2.getNumRow() - 1) + ",1," + (layout2.getNumRow() - 1));
                        icon = new ImageIcon(this.getClass().getResource("/ru/softlogic/rma/resources/icon/32/remove.png"));
                        sdp.getEditButton().setIcon(icon);
                        BasketScreen.this.selected.add(sdp);
                        sum += BasketScreen.this.calcSum(sdp.getSum() != null ? sdp.getSum().getValue() : "0");
                        continue;
                    }
                    icon = new ImageIcon(this.getClass().getResource("/ru/softlogic/rma/resources/icon/32/add.png"));
                    sdp.getEditButton().setIcon(icon);
                    layout1.insertRow(layout1.getNumRow(), -3.0);
                    BasketScreen.this.panel.getjPanel1().add((Component)sdp, "0," + (layout1.getNumRow() - 1));
                    BasketScreen.this.notSelected.add(sdp);
                }
                System.out.println("tt" + layout1.preferredLayoutSize((Container)BasketScreen.this.panel.getjPanel1()));
                System.out.println("tt" + layout1.minimumLayoutSize((Container)BasketScreen.this.panel.getjPanel1()));
                BasketScreen.this.panel.getjPanel1().setPreferredSize(layout1.minimumLayoutSize((Container)BasketScreen.this.panel.getjPanel1()));
                BasketScreen.this.panel.getSumAll().setText(SumFormatter.format(sum));
                boolean height = false;
            }
        });
    }

    private class BasketMouseInputAdapter
    extends MouseInputAdapter {
        private BasketMouseInputAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JList list;
            int idx;
            if (e.getSource() instanceof JList && (idx = (list = (JList)e.getSource()).locationToIndex(e.getPoint())) >= 0 && list.getModel().getElementAt(idx) instanceof SimpleDataPanel) {
                SimpleDataPanel el = (SimpleDataPanel)list.getModel().getElementAt(idx);
                Point point = e.getPoint();
                point.y -= list.getCellBounds((int)idx, (int)idx).y;
                if (el.getEditButton().getBounds().contains(point)) {
                    el.getEditButton().doClick();
                }
            }
        }
    }

    private class LocalEditListener
    implements ActionListener {
        private Data data;

        public LocalEditListener(Data data) {
            this.data = data;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Action action = BasketScreen.this.asd.getActionMap().getActionByType("edit");
            for (AdvancedScreenListener asl : BasketScreen.this.listeners) {
                asl.onAction(BasketScreen.this.asd.getDescription(), new ActionsCancelListener((JButton)e.getSource(), null), action, BasketScreen.this.getData(this.data));
            }
        }
    }

    private class LocalComponentListener
    implements ComponentListener {
        private LocalComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Dimension d = BasketScreen.this.panel.getjPanel1().getLayout().minimumLayoutSize(BasketScreen.this.panel.getjPanel1());
            BasketScreen.this.panel.getjPanel1().setPreferredSize(new Dimension(d.width, (int)((double)d.height + (double)d.height * 0.01)));
            d = BasketScreen.this.panel.getjPanel2().getLayout().minimumLayoutSize(BasketScreen.this.panel.getjPanel2());
            BasketScreen.this.panel.getjPanel2().setPreferredSize(new Dimension(d.width, (int)((double)d.height + (double)d.height * 0.01)));
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }
    }

    private class LocalNextListener
    implements ActionListener {
        private LocalNextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasketScreen.this.panel.getNextButton().setEnabled(false);
            Action action = BasketScreen.this.asd.getActionMap().getActionByType("next");
            for (AdvancedScreenListener asl : BasketScreen.this.listeners) {
                asl.onAction(BasketScreen.this.asd.getDescription(), new ActionsCancelListener(BasketScreen.this.panel.getNextButton(), null), action, new HashMap<String, Object>());
            }
        }
    }

    private class LocalPrevListener
    implements ActionListener {
        private LocalPrevListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasketScreen.this.panel.getPrevButton().setEnabled(false);
            Action action = BasketScreen.this.asd.getActionMap().getActionByType("prev");
            for (AdvancedScreenListener asl : BasketScreen.this.listeners) {
                asl.onAction(BasketScreen.this.asd.getDescription(), new ActionsCancelListener(BasketScreen.this.panel.getPrevButton(), null), action, new HashMap<String, Object>());
            }
        }
    }
}

