/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.advanced.screen;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import rmai18n.LocBundle;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.ModelEnvironment;
import ru.softlogic.input.model.advanced.AdvancedScreenDescription;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.advanced.actions.ContextHelper;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.barcode.BarcodeData;
import ru.softlogic.input.model.field.barcode.BarcodeException;
import ru.softlogic.input.model.field.barcode.BarcodeParser;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.rma.RmaApp;
import ru.softlogic.rma.app.Configuration;
import ru.softlogic.rma.app.ConfigurationData;
import ru.softlogic.rma.connector.model.MenuItem;
import ru.softlogic.rma.providers.advanced.Helper;
import ru.softlogic.rma.providers.advanced.panels.BarcodePanel;
import ru.softlogic.rma.providers.advanced.screen.ActionsCancelListener;
import ru.softlogic.rma.providers.advanced.screen.AdvancedScreen;
import ru.softlogic.rma.providers.advanced.screen.AdvancedScreenListener;
import ru.softlogic.rma.providers.universal.form.BarcodeField;
import ru.softlogic.rma.utils.GuiUtils;

public class BarcodeScreen
implements AdvancedScreen {
    private BarcodePanel panel;
    private Set<AdvancedScreenListener> listeners;
    private Color errorColor = new Color(204, 0, 0);
    private Color successColor = new Color(0, 204, 0);
    private BarcodeScreenDescription screen;
    private BarcodeData data;
    private Logger log;
    private ResourceMap resourceMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getResourceMap(BarcodePanel.class);
    private AdvancedScreenDescription asd;

    public BarcodeScreen() {
        this.panel = new BarcodePanel();
        this.panel.getBarcodeTextField().addKeyListener(new KeyListener());
        this.panel.getSkipButton().addActionListener(new LocalSkipListener());
        this.panel.getNextButton().addActionListener(new LocalNextListener());
        this.listeners = new HashSet<AdvancedScreenListener>();
        this.log = Logger.getLogger((String)"pay");
    }

    @Override
    public boolean init(MenuItem menuItem, AdvancedScreenDescription screen, Map<String, Object> data) throws InitException {
        if (!"barcode".equals(screen.getDescription().getType())) {
            throw new InitException("Wrong screen type");
        }
        this.screen = (BarcodeScreenDescription)screen.getDescription();
        this.asd = screen;
        ConfigurationData conf = Configuration.getInstance().getData();
        if (!conf.isBarcodeScannerPresent()) {
            new LocalSkipListener().actionPerformed(null);
            return false;
        }
        ModelEnvironment me = new ModelEnvironment(data, null, 0.0, null);
        this.screen.getBarcodeField().init(me);
        this.panel.getBarcodeTextField().setText(null);
        this.panel.getErrorLabel().setVisible(false);
        this.panel.getDataLabel().setText("");
        if (this.screen.getBarcodeField().getHelp() != null && !this.screen.getBarcodeField().getHelp().isEmpty()) {
            this.panel.getHelpLabelPanel().getHelpLabel().setText(this.screen.getBarcodeField().getHelp());
        } else {
            this.panel.getHelpLabelPanel().setVisible(false);
        }
        if (this.screen.getTitle() != null && !this.screen.getTitle().isEmpty()) {
            this.panel.getBarcodeLabel().setText(this.screen.getTitle());
        }
        data = null;
        Helper.processActionButton(this.panel.getNextButton(), screen, "next");
        Helper.processActionButton(this.panel.getSkipButton(), screen, "skip");
        this.panel.getNextButton().setEnabled(false);
        GuiUtils.requestFocus(this.panel.getBarcodeTextField());
        return true;
    }

    @Override
    public void addListener(AdvancedScreenListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    private void onBarcodeResult(String barcode) {
        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.adv.datawasreaded") + " " + barcode));
        BarcodeParser parser = this.screen.getBarcodeField().getParser();
        try {
            this.data = parser.parse(barcode);
            this.log.info((Object)(LocBundle.getMessageLog((String)"rma.adv.barcoderes") + " " + this.data));
            this.panel.getErrorLabel().setForeground(this.successColor);
            this.panel.getErrorLabel().setText(this.resourceMap.getString("AdvancedProvider.panels.barcode.errorLabel.success", new Object[0]));
            this.panel.getNextButton().setEnabled(true);
            StringBuilder sb = new StringBuilder();
            sb.append("<html><table>");
            for (InputElement el : this.data.getElements()) {
                sb.append("<tr><td>").append(el.getKeyTitle()).append(": ").append("</td><td>").append(el.getValueTitle()).append("</td></tr>");
            }
            sb.append("</table>");
            this.panel.getDataLabel().setText(sb.toString());
            GuiUtils.requestFocus(this.panel.getNextButton());
        }
        catch (BarcodeException ex) {
            GuiUtils.requestFocus(this.panel.getBarcodeTextField());
            this.log.error((Object)(LocBundle.getMessageLog((String)"rma.adv.errparsing") + " " + ex.getMessage()));
            this.panel.getErrorLabel().setForeground(this.errorColor);
            this.panel.getErrorLabel().setText(this.resourceMap.getString("AdvancedProvider.panels.barcode.errorLabel.error", new Object[0]));
            this.panel.getNextButton().setEnabled(false);
            this.panel.getDataLabel().setText("");
        }
        this.panel.getErrorLabel().setVisible(true);
    }

    private class BarcodeScreenDescription
    extends ScreenDescription {
        private BarcodeField barcodeField;

        public BarcodeScreenDescription() {
            this.setType("barcode");
        }

        public BarcodeField getBarcodeField() {
            return this.barcodeField;
        }

        public void setBarcodeField(BarcodeField barcodeField) {
            this.barcodeField = barcodeField;
        }

        public String toString() {
            return "BarcodeScreen{barcodeField=" + (Object)((Object)this.barcodeField) + ", actionMap=" + '}';
        }
    }

    private class KeyListener
    extends KeyAdapter {
        private KeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent evt) {
            if (evt.getKeyCode() == 10) {
                final String barcode = BarcodeScreen.this.panel.getBarcodeTextField().getText();
                BarcodeScreen.this.panel.getBarcodeTextField().setText("");
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BarcodeScreen.this.onBarcodeResult(barcode);
                    }
                });
            }
        }
    }

    private class LocalSkipListener
    implements ActionListener {
        private LocalSkipListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BarcodeScreen.this.panel.getSkipButton().setEnabled(false);
            Action action = BarcodeScreen.this.asd.getActionMap().getActionByType("skip");
            for (AdvancedScreenListener asl : BarcodeScreen.this.listeners) {
                asl.onAction(BarcodeScreen.this.screen, new ActionsCancelListener(BarcodeScreen.this.panel.getSkipButton(), BarcodeScreen.this.panel.getBarcodeTextField()), action, new HashMap<String, Object>());
            }
        }
    }

    private class LocalNextListener
    implements ActionListener {
        private LocalNextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BarcodeScreen.this.panel.getNextButton().setEnabled(false);
            Action action = BarcodeScreen.this.asd.getActionMap().getActionByType("next");
            for (AdvancedScreenListener asl : BarcodeScreen.this.listeners) {
                asl.onAction(BarcodeScreen.this.screen, new ActionsCancelListener(BarcodeScreen.this.panel.getNextButton(), BarcodeScreen.this.panel.getBarcodeTextField()), action, ContextHelper.createData((List)BarcodeScreen.this.data.getElements()));
            }
        }
    }
}

