/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.advanced.panels;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import rmai18n.LocBundle;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.table.TableColumn;
import ru.softlogic.input.model.field.table.TableItem;

public class TableFieldTableModel
implements TableModel {
    private String[] names = new String[]{LocBundle.getMessage((String)"rma.model.sumfrom"), "%", LocBundle.getMessage((String)"rma.model.sumfix"), "Min", "Max"};
    private List<TableItem> items;
    private TableItem[] itemsArray;
    private Set<TableModelListener> listeners = new HashSet<TableModelListener>();
    private Map<Integer, String> keysMap = new HashMap<Integer, String>();

    public void setNames(List<TableColumn> columns) {
        LinkedList<String> names = new LinkedList<String>();
        int index = 0;
        for (TableColumn column : columns) {
            names.add(column.getTitle());
            this.keysMap.put(index, column.getKey());
            ++index;
        }
        this.names = names.toArray(new String[names.size()]);
        for (TableModelListener l : this.listeners) {
            l.tableChanged(new TableModelEvent(this));
        }
    }

    public TableItem[] getItemsArray() {
        return this.itemsArray;
    }

    public void setItems(List<TableItem> items) {
        this.items = items;
        this.itemsArray = items == null ? null : items.toArray(new TableItem[items.size()]);
        for (TableModelListener l : this.listeners) {
            l.tableChanged(new TableModelEvent(this));
        }
    }

    @Override
    public int getRowCount() {
        return this.items == null ? 0 : this.items.size();
    }

    @Override
    public int getColumnCount() {
        return this.names.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.names[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TableItem item = this.itemsArray[rowIndex];
        if (this.keysMap.get(columnIndex) != null) {
            String key = this.keysMap.get(columnIndex);
            return ((InputElement)item.getElements().get(key)).getValue();
        }
        return "";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }
}

