/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.advanced.panels;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.rma.RmaApp;
import ru.softlogic.rma.utils.SumFormatter;

public class SimpleDataPanel
extends JPanel {
    private Data data;
    private InputElement id;
    private InputElement not_editible;
    private InputElement selected;
    private InputElement sum;
    private InputElement title;
    private JLabel descLabel;
    private JButton editButton;

    public SimpleDataPanel() {
        this.initComponents();
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(SimpleDataPanel.this.descLabel.getText());
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.descLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editButton)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descLabel, GroupLayout.Alignment.TRAILING, -2, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.editButton, 38, 38, 38).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public JLabel getDescLabel() {
        return this.descLabel;
    }

    public JButton getEditButton() {
        return this.editButton;
    }

    public Data getData() {
        return this.data;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public void setData(Data data) {
        this.sum = null;
        this.selected = null;
        this.not_editible = null;
        this.id = null;
        for (InputElement ie : data.getElements()) {
            if ("name".equals(ie.getKey())) {
                this.id = ie;
            }
            if ("selected".equals(ie.getKey())) {
                this.selected = ie;
            }
            if ("not_editible".equals(ie.getKey())) {
                this.not_editible = ie;
            }
            if ("summ".equals(ie.getKey())) {
                this.sum = ie;
            }
            if (!"name".equals(ie.getKey())) continue;
            this.title = ie;
        }
        if (this.id == null) {
            throw new NullPointerException("id service not set");
        }
        this.data = data;
        this.update();
    }

    public InputElement getId() {
        return this.id;
    }

    public InputElement getNot_editible() {
        return this.not_editible;
    }

    public InputElement getSelected() {
        return this.selected;
    }

    public InputElement getSum() {
        return this.sum;
    }

    public void setId(InputElement id) {
        this.id = id;
    }

    public void setNot_editible(InputElement not_editible) {
        this.not_editible = not_editible;
    }

    public void setSelected(InputElement selected) {
        this.selected = selected;
    }

    public void setSum(InputElement sum) {
        this.sum = sum;
    }

    public void update() {
        this.descLabel.setText("<html>" + (this.title == null ? "" : this.title.getValue()) + "<br>" + (this.data.getSum() == null ? "" : "\u0421\u0443\u043c\u043c\u0430: " + SumFormatter.format(this.data.getSum().getSum()) + " \u0440\u0443\u0431.<br>") + (this.sum == null || this.sum.getValue().isEmpty() ? "" : " \u041a \u043e\u043f\u043b\u0430\u0442\u0435: " + SumFormatter.format(Float.parseFloat(this.sum.getValue())) + " \u0440\u0443\u0431."));
        if (this.not_editible != null) {
            this.editButton.setEnabled(false);
        }
    }

    private void initComponents() {
        this.descLabel = new JLabel();
        this.editButton = new JButton();
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.setName("Form");
        this.setPreferredSize(new Dimension(91, 70));
        ResourceMap resourceMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getResourceMap(SimpleDataPanel.class);
        this.descLabel.setText(resourceMap.getString("descLabel.text", new Object[0]));
        this.descLabel.setBorder(null);
        this.descLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.descLabel.setMinimumSize(new Dimension(0, 0));
        this.descLabel.setName("descLabel");
        this.editButton.setIcon(resourceMap.getIcon("editButton.icon"));
        this.editButton.setText(resourceMap.getString("editButton.text", new Object[0]));
        this.editButton.setHorizontalAlignment(11);
        this.editButton.setName("editButton");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.descLabel, -1, 26, Short.MAX_VALUE).addGap(5, 5, 5).addComponent(this.editButton)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.editButton).addComponent(this.descLabel, -1, 44, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

