/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.advanced.panels;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.advanced.actions.dialog.DialogAction;

public class Dialog
extends JDialog {
    private DialogAction dialogAction;
    private Icon error;
    private Icon warning;
    private Icon info;
    private Icon question;
    private JPanel buttonPanel;
    private JLabel iconLabel;
    private JLabel textLabel;

    public Dialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.info = new ImageIcon(this.getClass().getResource("/ru/softlogic/rma/resources/icon/48/info.png"));
        this.error = new ImageIcon(this.getClass().getResource("/ru/softlogic/rma/resources/icon/48/error.png"));
        this.warning = new ImageIcon(this.getClass().getResource("/ru/softlogic/rma/resources/icon/48/warning.png"));
        this.question = new ImageIcon(this.getClass().getResource("/ru/softlogic/rma/resources/icon/48/question.png"));
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dialog.this.setVisible(false);
                Dialog.this.dialogAction.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    public void show(DialogAction da) {
        if (da == null) {
            throw new NullPointerException("Showing DialogAction");
        }
        this.dialogAction = da;
        switch (da.getType()) {
            case Error: {
                this.iconLabel.setIcon(this.error);
                break;
            }
            case Info: {
                this.iconLabel.setIcon(this.info);
                break;
            }
            case Warning: {
                this.iconLabel.setIcon(this.warning);
                break;
            }
            case Question: {
                this.iconLabel.setIcon(this.question);
            }
        }
        this.setTitle(da.getTitle());
        this.textLabel.setText(da.getMessage());
        this.buttonPanel.setVisible(false);
        this.buttonPanel.removeAll();
        for (Action act : da.getActionMap().getActions()) {
            JButton but = new JButton(act.getTitle());
            but.putClientProperty("action", act.getType());
            but.addActionListener(new LocalButtonListener());
            this.buttonPanel.add(but);
        }
        this.buttonPanel.setVisible(true);
        this.pack();
        this.setVisible(true);
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.textLabel = new JLabel();
        this.iconLabel = new JLabel();
        this.setDefaultCloseOperation(0);
        this.buttonPanel.setMinimumSize(new Dimension(20, 20));
        this.buttonPanel.setLayout(new FlowLayout(1, 10, 5));
        this.textLabel.setText("jLabel1");
        this.textLabel.setVerticalAlignment(1);
        this.iconLabel.setText("jLabel1");
        this.iconLabel.setMaximumSize(new Dimension(48, 48));
        this.iconLabel.setMinimumSize(new Dimension(48, 48));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.iconLabel, -2, 48, -2).addGap(18, 18, 18).addComponent(this.textLabel, -1, 386, Short.MAX_VALUE)).addComponent(this.buttonPanel, -1, 452, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.iconLabel, -2, 48, -2).addComponent(this.textLabel, -1, 170, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.buttonPanel, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private class LocalButtonListener
    implements ActionListener {
        private LocalButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Dialog.this.setVisible(false);
            JButton button = (JButton)e.getSource();
            button.setEnabled(false);
            String action = (String)button.getClientProperty("action");
            Dialog.this.dialogAction.onSelectAction(action);
        }
    }
}

