/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.advanced;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jdesktop.swingx.JXDatePicker;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.AdvancedScreenDescription;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.field.date.DateField;
import ru.softlogic.input.model.field.numeric.NumericField;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.field.text.TextField;
import ru.softlogic.rma.app.components.MultipleMaskTextField;
import ru.softlogic.rma.providers.advanced.screen.components.InputComponent;
import ru.softlogic.rma.providers.universal.form.SetField;
import ru.softlogic.rma.providers.universal.general.ComboBoxTextItem;
import ru.softlogic.rma.utils.GuiUtils;

public class Helper {
    public static void processActionButton(JButton button, AdvancedScreenDescription screen, String actionType) {
        if (button == null) {
            throw new NullPointerException("button");
        }
        if (screen == null) {
            throw new NullPointerException("screen");
        }
        if (actionType == null) {
            throw new NullPointerException("type");
        }
        Action action = screen.getActionMap().getActionByType(actionType);
        button.setVisible(action != null);
        button.setEnabled(true);
        button.setText(action == null ? "" : action.getTitle());
    }

    public static Map<String, Object> extractData(List components) {
        return Helper.extractData(components, null);
    }

    public static Map<String, Object> extractData(List components, List<String> params) {
        HashMap<String, Object> elements = new HashMap<String, Object>();
        for (Object obj : components) {
            JXDatePicker datePicker;
            if (obj instanceof InputComponent) {
                InputComponent ic = (InputComponent)obj;
                ic.putData(elements);
                continue;
            }
            if (obj instanceof JTextField) {
                String val;
                JTextField textField = (JTextField)obj;
                if (textField.getClientProperty("field") instanceof TextField) {
                    TextField tif = (TextField)textField.getClientProperty("field");
                    val = textField.getText();
                    if (params != null && !params.contains(tif.getId()) && !params.contains("$all")) continue;
                    elements.put(tif.getId(), new InputElement(tif.getId(), tif.getTitle(), val, ((MultipleMaskTextField)textField).getTextTitle(), tif.getFlags()));
                    continue;
                }
                if (!(textField.getClientProperty("field") instanceof NumericField)) continue;
                NumericField nf = (NumericField)textField.getClientProperty("field");
                val = textField.getText();
                if (params != null && !params.contains(nf.getId()) && !params.contains("$all")) continue;
                elements.put(nf.getId(), new InputElement(nf.getId(), nf.getTitle(), val, textField.getText().trim(), nf.getFlags()));
                continue;
            }
            if (obj instanceof JComboBox) {
                JComboBox comboBox = (JComboBox)obj;
                if (!(comboBox.getClientProperty("field") instanceof SelectorField)) continue;
                SelectorField selector = (SelectorField)comboBox.getClientProperty("field");
                SelectorItem item = null;
                if (comboBox.getSelectedItem() == null) continue;
                item = ((ComboBoxTextItem)comboBox.getSelectedItem()).getItem();
                if (params != null && !params.contains(selector.getId()) && !params.contains("$all")) continue;
                elements.put(selector.getId(), new InputElement(selector.getId(), selector.getTitle(), item.getValue(), item.getTitle(), selector.getFlags()));
                continue;
            }
            if (obj instanceof JLabel) {
                JLabel label = (JLabel)obj;
                SetField sf = (SetField)((Object)label.getClientProperty("field"));
                if (params != null && !params.contains(sf.getId()) && !params.contains("$all")) continue;
                elements.put(sf.getId(), new InputElement(sf.getId(), sf.getTitle(), sf.getValue(), sf.getValue(), sf.getFlags()));
                continue;
            }
            if (!(obj instanceof JXDatePicker) || !((datePicker = (JXDatePicker)obj).getClientProperty((Object)"field") instanceof DateField)) continue;
            DateField df = (DateField)datePicker.getClientProperty((Object)"field");
            if (params != null && !params.contains(df.getId()) && !params.contains("$all")) continue;
            elements.put(df.getId(), new InputElement(df.getId(), df.getTitle(), df.getFormater().format(datePicker.getDate()), df.getFormaterTitle().format(datePicker.getDate()), df.getFlags()));
        }
        return elements;
    }

    public static boolean checkData(List<InputComponent> components) {
        boolean valid = true;
        InputComponent selected = null;
        for (InputComponent c : components) {
            boolean cv = c.isValid();
            if (!cv && selected == null) {
                selected = c;
            }
            valid &= cv;
        }
        if (selected != null) {
            GuiUtils.requestFocus(selected.getComponent());
        }
        return valid;
    }

    public static boolean checkFailData(List<InputComponent> components) {
        boolean valid = true;
        InputComponent selected = null;
        for (InputComponent c : components) {
            boolean cv = c.isValid();
            if (!cv) {
                cv = c.isFailValid();
            }
            if (!cv && selected == null) {
                selected = c;
            }
            valid &= cv;
        }
        if (selected != null) {
            GuiUtils.requestFocus(selected.getComponent());
        }
        return valid;
    }
}

