/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers.advanced;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.CRC32;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import rmai18n.LocBundle;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.TransactionSum;
import ru.softlogic.input.model.advanced.AdvancedCommissionCalculator;
import ru.softlogic.input.model.advanced.AdvancedHardwareApi;
import ru.softlogic.input.model.advanced.AdvancedScreenDescription;
import ru.softlogic.input.model.advanced.AsyncTask;
import ru.softlogic.input.model.advanced.MethodType;
import ru.softlogic.input.model.advanced.OpenUrlTarget;
import ru.softlogic.input.model.advanced.PaymentParams;
import ru.softlogic.input.model.advanced.Printer;
import ru.softlogic.input.model.advanced.Scenario;
import ru.softlogic.input.model.advanced.SimpleEnvironment;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ContextHelper;
import ru.softlogic.input.model.advanced.actions.dialog.DialogAction;
import ru.softlogic.input.model.advanced.actions.hdw.CardDispenserHandler;
import ru.softlogic.input.model.advanced.actions.hdw.CardReaderHandler;
import ru.softlogic.input.model.advanced.actions.hdw.SmartCardHandler;
import ru.softlogic.input.model.advanced.actions.request.ServerConnector;
import ru.softlogic.input.model.field.Field;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.field.text.TextField;
import ru.softlogic.input.model.form.Form;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.adv.Parser;
import ru.softlogic.rma.Environment;
import ru.softlogic.rma.RmaApp;
import ru.softlogic.rma.RmaAppContext;
import ru.softlogic.rma.RmaCancelOperationDialog;
import ru.softlogic.rma.RmaPaymentJob;
import ru.softlogic.rma.app.CommissionCalculator;
import ru.softlogic.rma.app.Configuration;
import ru.softlogic.rma.app.components.MultipleMaskTextField;
import ru.softlogic.rma.app.docs.SumDocument;
import ru.softlogic.rma.app.docs.listener.SumIncomeListener;
import ru.softlogic.rma.app.docs.listener.SumOutcomeListener;
import ru.softlogic.rma.connector.model.CurrentUser;
import ru.softlogic.rma.connector.model.MenuItem;
import ru.softlogic.rma.connector.model.References;
import ru.softlogic.rma.connector.ws.stub.VerifyResult;
import ru.softlogic.rma.connector.ws.stub.VerifyResultType;
import ru.softlogic.rma.model.add.BankRecord;
import ru.softlogic.rma.persistence.DocType;
import ru.softlogic.rma.persistence.PersistenceException;
import ru.softlogic.rma.persistence.Record;
import ru.softlogic.rma.persistence.RmaAttribute;
import ru.softlogic.rma.persistence.v2.PersistenceManager;
import ru.softlogic.rma.print.PrintMode;
import ru.softlogic.rma.print.queue.CustomData;
import ru.softlogic.rma.print.queue.RequestData;
import ru.softlogic.rma.providers.FildsChangedListener;
import ru.softlogic.rma.providers.InitData;
import ru.softlogic.rma.providers.PrintCallBackListener;
import ru.softlogic.rma.providers.ProviderHelper;
import ru.softlogic.rma.providers.ServiceProvider;
import ru.softlogic.rma.providers.VerifyResultListener;
import ru.softlogic.rma.providers.advanced.ConnectorAdapter;
import ru.softlogic.rma.providers.advanced.TaskAdapter;
import ru.softlogic.rma.providers.advanced.panels.Dialog;
import ru.softlogic.rma.providers.advanced.screen.AdvancedScreen;
import ru.softlogic.rma.providers.advanced.screen.AdvancedScreenListener;
import ru.softlogic.rma.providers.advanced.screen.BarcodeScreen;
import ru.softlogic.rma.providers.advanced.screen.BasketScreen;
import ru.softlogic.rma.providers.advanced.screen.ConfirmScreen;
import ru.softlogic.rma.providers.advanced.screen.InfoScreen;
import ru.softlogic.rma.providers.advanced.screen.SelectorScreen;
import ru.softlogic.rma.providers.advanced.screen.TableScreen;
import ru.softlogic.rma.providers.advanced.screen.UniversalScreen;
import ru.softlogic.rma.providers.advanced.screen.VoidScreen;
import ru.softlogic.rma.providers.panels.SumPanelHelper;
import ru.softlogic.rma.providers.universal.form.SetField;
import ru.softlogic.rma.providers.universal.general.ControlData;
import ru.softlogic.rma.providers.universal.general.GeneralPanel;
import ru.softlogic.rma.providers.universal.general.InterfaceListener;
import ru.softlogic.rma.shift.ShiftManager;
import ru.softlogic.rma.utils.BikAccountVerifier;
import ru.softlogic.rma.utils.DocSequence;
import ru.softlogic.rma.utils.GuiUtils;
import ru.softlogic.rma.utils.IM7FormUtils;
import ru.softlogic.rma.utils.PathUtils;
import ru.softlogic.rma.utils.RSParser;
import ru.softlogic.rma.utils.SumFormatter;

public class AdvancedProvider
implements ServiceProvider {
    private RmaAppContext context;
    private MenuItem menuItem;
    private Scenario scenario;
    private Logger log = Logger.getLogger((String)"pay");
    private JPanel main = new JPanel(new BorderLayout());
    private SumDocument sumIncomeDocument;
    private SumIncomeListener sumIncomeListener;
    private SumDocument sumOutcomeDocument;
    private SumOutcomeListener sumOutcomeListener;
    private Map<String, Object> data;
    private ru.softlogic.input.model.advanced.Environment environment = new LocalEnviroment();
    private Dialog dialog;
    private GeneralPanel sumPanel;
    private Map<String, AdvancedScreen> screens = new HashMap<String, AdvancedScreen>();
    private Form sum1Form;
    private Form sum2Form;
    private Form sum3Form;
    private Form cardForm;
    private boolean showAll;
    private Map<String, IdentityField> sum1Fields;
    private Map<String, IdentityField> sum2Fields;
    private Map<String, IdentityField> sum3Fields;
    private Map<String, IdentityField> pd4Fields;
    private Map<String, IdentityField> cardFields;
    private Map<Field, Object> sum1Values;
    private Map<Field, Object> sum2Values;
    private Map<Field, Object> sum3Values;
    private Map<Field, Object> values;
    private InterfaceListener interfaceListener;
    private References references;
    private String prevScreen;
    private String currentScreen;
    private Map<String, BankRecord> bankRecords;
    private boolean needIdentification;
    private boolean needBudgetFields;
    private Map<String, Object> verifiedIElements;
    private boolean needSplitPayments;
    private boolean needGroupPaymentDividedCommission;
    private DocSequence docSequence;
    private PaymentParams paymentParams;
    private Map<String, String> aliases;
    private short typeCashSourcePayment;
    private Integer sum1;
    private Integer sum2;
    private PrintCallBackListener printResultListener;
    private RmaPaymentJob currentJob;
    private boolean isPrinted;
    private boolean isFieldsChanged;

    public AdvancedProvider() {
        AdvancedScreen as = new BarcodeScreen();
        as.addListener(new ScreenListener());
        this.screens.put("barcode", as);
        as = new UniversalScreen();
        as.addListener(new ScreenListener());
        this.screens.put("letter", as);
        as = new UniversalScreen();
        as.addListener(new ScreenListener());
        this.screens.put("digital", as);
        as = new UniversalScreen();
        as.addListener(new ScreenListener());
        this.screens.put("group", as);
        as = new ConfirmScreen();
        as.addListener(new ScreenListener());
        this.screens.put("confirm", as);
        as = new ConfirmScreen();
        as.addListener(new ScreenListener());
        this.screens.put("confirm/multiple", as);
        as = new VoidScreen();
        as.addListener(new ScreenListener());
        this.screens.put("void", as);
        as = new SelectorScreen();
        as.addListener(new ScreenListener());
        this.screens.put("selector", as);
        as = new InfoScreen();
        as.addListener(new ScreenListener());
        this.screens.put("info", as);
        as = new BasketScreen();
        as.addListener(new ScreenListener());
        this.screens.put("communal", as);
        as = new TableScreen();
        as.addListener(new ScreenListener());
        this.screens.put("table", as);
        this.aliases = new HashMap<String, String>();
        this.aliases.put("numeric", "digital");
        this.interfaceListener = new LocalInterfaceListener();
        this.sumPanel = new GeneralPanel();
        this.sumPanel.addListener(this.interfaceListener);
        this.sumIncomeListener = new SumIncomeListener(this.sumPanel.getSumPanel().getSumOutcomeField(), this.sumPanel.getSumPanel().getSumCommField());
        this.sumIncomeDocument = new SumDocument();
        this.sumIncomeDocument.addDocumentListener(this.sumIncomeListener);
        this.sumPanel.getSumPanel().getSumIncomeField().setDocument(this.sumIncomeDocument);
        this.sumOutcomeListener = new SumOutcomeListener(this.sumPanel.getSumPanel().getSumIncomeField(), this.sumPanel.getSumPanel().getSumCommField());
        this.sumOutcomeDocument = new SumDocument();
        this.sumOutcomeDocument.addDocumentListener(this.sumOutcomeListener);
        this.sumPanel.getSumPanel().getSumOutcomeField().setDocument(this.sumOutcomeDocument);
        this.sumIncomeListener.setSumOutcomeListener(this.sumOutcomeListener);
        this.sumOutcomeListener.setSumIncomeListener(this.sumIncomeListener);
        LocalSumOutcomeFieldsListener sumFiledsListener = new LocalSumOutcomeFieldsListener();
        this.sumIncomeListener.setChangeListener(sumFiledsListener);
        this.sumOutcomeListener.setChangeListener(sumFiledsListener);
        ResourceMap resMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getResourceMap();
        this.sumPanel.getSumPanel().getPrintRequestButton().setText(resMap.getString("action.prev", new Object[0]));
        this.sumPanel.getSumPanel().getPrintRequestButton().addActionListener(new LocalSumPrevActionListener());
        this.sumPanel.getSumPanel().getPrintRequestButton().setVisible(true);
        this.sumPanel.getSumPanel().getPayButton().addActionListener(new ProcessActionListener());
        this.sumPanel.getSumPanel().getCancelButton().addActionListener(new ProcessExitListener());
        this.values = new HashMap<Field, Object>();
        this.sum1Values = new HashMap<Field, Object>();
        this.sum2Values = new HashMap<Field, Object>();
        this.sum3Values = new HashMap<Field, Object>();
        this.sum1Fields = new LinkedHashMap<String, IdentityField>();
        this.sum2Fields = new LinkedHashMap<String, IdentityField>();
        this.sum3Fields = new LinkedHashMap<String, IdentityField>();
        this.pd4Fields = new HashMap<String, IdentityField>();
        this.needSplitPayments = false;
        this.needGroupPaymentDividedCommission = false;
        this.cardFields = new HashMap<String, IdentityField>();
        this.sumPanel.getSumPanel().getPrintButton().addActionListener(new LocalPrintRequestListener());
        try {
            this.sum1 = Integer.parseInt(Environment.getInstance().getProperty("sum1")) * 100;
        }
        catch (Exception ex) {
            this.log.info((Object)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0441\u043f\u0430\u0440\u0441\u0438\u0442\u044c sum1=null");
            this.sum1 = null;
        }
        try {
            this.sum2 = Integer.parseInt(Environment.getInstance().getProperty("sum2")) * 100;
        }
        catch (Exception ex) {
            this.log.info((Object)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0441\u043f\u0430\u0440\u0441\u0438\u0442\u044c sum2=null");
            this.sum2 = null;
        }
        this.printResultListener = new PrintCallBackListener(){

            @Override
            public void onPrintResult(boolean isPrinted) {
                AdvancedProvider.this.isPrinted = isPrinted;
                AdvancedProvider.this.sumPanel.getSumPanel().getPrintButton().setEnabled(!isPrinted);
                AdvancedProvider.this.sumPanel.getSumPanel().getPayButton().setEnabled(isPrinted);
            }
        };
    }

    @Override
    public void init(InitData initData) {
        this.context = initData.getContext();
        this.menuItem = initData.getMenuItem();
        this.references = initData.getReferences();
        this.sumIncomeListener.init(this.menuItem, null);
        this.sumOutcomeListener.init(this.menuItem, null);
        this.verifiedIElements = null;
        this.typeCashSourcePayment = this.references.getPoint().getTypeCashSourcePoint();
        this.sum1Form = IM7FormUtils.tryToLoadForm(new File(PathUtils.getAppHome() + File.separator + "resources" + File.separator + "addforms" + File.separator + "sum1.xml"), this.log);
        this.sum2Form = IM7FormUtils.tryToLoadForm(new File(PathUtils.getAppHome() + File.separator + "resources" + File.separator + "addforms" + File.separator + "sum2.xml"), this.log);
        this.sum3Form = IM7FormUtils.tryToLoadForm(new File(PathUtils.getAppHome() + File.separator + "resources" + File.separator + "addforms" + File.separator + "terr.xml"), this.log);
        this.cardForm = IM7FormUtils.tryToLoadForm(new File(PathUtils.getAppHome() + File.separator + "resources" + File.separator + "addforms" + File.separator + "card.xml"), this.log);
        if (this.sum2Form == null || IM7FormUtils.getFieldsFromForm(this.sum2Form) == null || IM7FormUtils.getFieldsFromForm(this.sum2Form).isEmpty()) {
            this.log.info((Object)LocBundle.getMessageLog((String)"rma.payment.nosumfldsfound"));
            JOptionPane.showMessageDialog(initData.getContext().getMainFrame(), LocBundle.getMessageEx((String)"rma.payment.nosumfldsfound"), LocBundle.getMessage((String)"rma.hk.erronaddpay"), 0);
            initData.getContext().toMainMenu();
        } else if (this.sum3Form == null || IM7FormUtils.getFieldsFromForm(this.sum3Form) == null || IM7FormUtils.getFieldsFromForm(this.sum3Form).isEmpty()) {
            this.log.info((Object)LocBundle.getMessageLog((String)"rma.payment.nosumfldsfound"));
            JOptionPane.showMessageDialog(initData.getContext().getMainFrame(), LocBundle.getMessageEx((String)"rma.payment.nosumfldsfound"), LocBundle.getMessage((String)"rma.hk.erronaddpay"), 0);
            initData.getContext().toMainMenu();
        }
        this.sum1Fields.clear();
        this.sum1Values.clear();
        for (IdentityField ff : IM7FormUtils.getFieldsFromForm(this.sum1Form)) {
            this.sum1Fields.put(ff.getId(), ff);
        }
        this.sum2Fields.clear();
        this.sum2Values.clear();
        for (IdentityField ff : IM7FormUtils.getFieldsFromForm(this.sum2Form)) {
            this.sum2Fields.put(ff.getId(), ff);
        }
        this.sum3Fields.clear();
        this.sum3Values.clear();
        for (IdentityField ff : IM7FormUtils.getFieldsFromForm(this.sum3Form)) {
            this.sum3Fields.put(ff.getId(), ff);
        }
        if (this.references.getPoint().getTypeCashSourcePoint() != 1 && this.cardForm != null) {
            this.cardFields.clear();
            for (IdentityField ff : IM7FormUtils.getFieldsFromForm(this.cardForm)) {
                this.cardFields.put(ff.getId(), ff);
            }
        }
        this.sumPanel.getSumPanel().getPayButton().setEnabled(true);
        this.sumPanel.getSumPanel().getCancelButton().setEnabled(true);
        this.sumPanel.getSumPanel().getSumIncomeField().setText("");
        this.sumPanel.getSumPanel().getSumOutcomeField().setText("");
        this.sumPanel.getSumPanel().getSumCommField().setText("");
        this.sumPanel.getSumPanel().getPrintRequestCheckBox().setSelected(Boolean.TRUE.equals(initData.getPrintRequest()));
        this.sumPanel.getSumPanel().getPrintDocumentCheckBox().setSelected(Boolean.TRUE.equals(initData.getPrintDocument()));
        this.currentScreen = null;
        this.data = new HashMap<String, Object>();
        if (initData.getParams() != null) {
            this.data.putAll(initData.getParams());
        }
        long d1 = System.currentTimeMillis();
        try {
            String path = PathUtils.getAppHome() + File.separator + "resources" + File.separator + "scenario" + File.separator + initData.getMenuItem().getService().getCode() + ".xml";
            this.log.info((Object)(LocBundle.getMessageLog((String)"rma.adv.srparsing") + " " + path));
            this.scenario = Parser.parse((File)new File(path));
            this.log.info((Object)MessageFormat.format(LocBundle.getMessageLog((String)"rma.adv.timeparsing"), System.currentTimeMillis() - d1));
            this.log.info((Object)(LocBundle.getMessageLog((String)"rma.adv.result") + " " + this.scenario));
            if (this.scenario.getPaymentParams() != null) {
                this.paymentParams = this.scenario.getPaymentParams();
                this.needSplitPayments = true;
            } else {
                this.paymentParams = null;
                this.needSplitPayments = false;
            }
            this.log.info((Object)("---init needSplitPayments=" + this.needSplitPayments));
            this.showScreen(this.scenario.getBegin());
        }
        catch (ParseException ex) {
            this.log.error((Object)MessageFormat.format(LocBundle.getMessageLog((String)"rma.adv.cntgetscr"), System.currentTimeMillis() - d1), (Throwable)ex);
            ErrorInfo info = new ErrorInfo(LocBundle.getMessage((String)"rma.adv.errparsing"), ex.getMessage(), null, null, (Throwable)ex, Level.ALL, null);
            JXErrorPane.showDialog((Component)this.context.getMainFrame(), (ErrorInfo)info);
            this.context.toMainMenu();
        }
        this.sumPanel.getSumPanel().getCheckButton().addActionListener(new LocalCheckButtonListener());
        this.sumPanel.getSumPanel().getPrintButton().setEnabled(true);
        this.sumPanel.getSumPanel().getPayButton().setEnabled(false);
        this.isPrinted = false;
        this.prevScreen = null;
        this.bankRecords = initData.getBankRecords();
        this.needIdentification = RSParser.getInstance().checkRS(initData.getMenuItem().getService().getBankRs());
        ProviderHelper.prefillStore(this.scenario.getPrefillItem(), initData.getReferences(), this.data);
        System.out.println("data=" + this.data);
        if (this.menuItem.getService().getVerifyType() == 0 || this.menuItem.getService().getVerifyType() == 1 || this.menuItem.getService().getProcessingType() == 2) {
            this.sumPanel.getSumPanel().getCheckButton().setEnabled(true);
        } else {
            this.sumPanel.getSumPanel().getCheckButton().setEnabled(false);
        }
        this.isFieldsChanged = false;
    }

    @Override
    public JPanel getPanel() {
        return this.main;
    }

    private void showScreen(String screenName) {
        String oldPrev = this.prevScreen;
        this.prevScreen = this.currentScreen;
        this.currentScreen = screenName;
        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.adv.showscr") + " " + screenName));
        if ("pay".equals(screenName)) {
            if (this.isPrinted && this.currentJob != null) {
                RmaCancelOperationDialog dialog = new RmaCancelOperationDialog((Frame)this.context.getMainFrame(), true);
                dialog.setTitle(LocBundle.getMessage((String)"rma.canseloperating.actuallycancel"));
                dialog.setVisible(true);
                if (dialog.isCanselled()) {
                    this.log.info((Object)"\u0423\u0441\u043e\u0432\u0435\u0440\u0448\u0435\u043d\u0441\u0442\u0432\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440, \u041a\u0430\u0441\u0441\u0438\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b\u0441\u044f \u0432\u0432\u043e\u0434\u0438\u0442\u044c \u043f\u0440\u0438\u0447\u0438\u043d\u044b \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438");
                    this.currentScreen = this.prevScreen;
                    this.prevScreen = oldPrev;
                    return;
                }
                String comment = dialog.getComment();
                this.log.info((Object)("\u0423\u0441\u043e\u0432\u0435\u0440\u0448\u0435\u043d\u0441\u0442\u0432\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440, \u041a\u0430\u0441\u0441\u0438\u0440 \u0432\u0432\u0451\u043b " + comment));
                this.currentJob.getRecord().setComment(comment);
            }
            TransactionSum sum = (TransactionSum)this.data.get("#sum");
            this.log.info((Object)("---TransactionSum = " + sum));
            this.data.remove("#sum");
            this.data.remove("#from");
            this.values.clear();
            this.sum1Fields.clear();
            this.sum1Values.clear();
            for (IdentityField ff : IM7FormUtils.getFieldsFromForm(this.sum1Form)) {
                this.sum1Fields.put(ff.getId(), ff);
            }
            this.sum2Fields.clear();
            this.sum2Values.clear();
            for (IdentityField ff : IM7FormUtils.getFieldsFromForm(this.sum2Form)) {
                this.sum2Fields.put(ff.getId(), ff);
            }
            this.sum3Fields.clear();
            this.sum3Values.clear();
            for (IdentityField ff : IM7FormUtils.getFieldsFromForm(this.sum3Form)) {
                this.sum3Fields.put(ff.getId(), ff);
            }
            for (String key : this.data.keySet()) {
                this.sum1Fields.remove(key);
                this.sum2Fields.remove(key);
                this.sum3Fields.remove(key);
            }
            this.interfaceListener.onChange(this.values);
            this.sumPanel.getSumPanel().getCheckButton().setVisible(this.prevScreen != null);
            this.sumPanel.getSumPanel().getCardPanel().setVisible(this.references.getPoint().getTypeCashSourcePoint() != 1);
            this.sumPanel.getSumPanel().setDefaultButtonState();
            this.showPanel(this.sumPanel);
            if (sum != null) {
                this.sumPanel.getSumPanel().getSumOutcomeField().setEnabled(false);
                this.sumPanel.getSumPanel().getSumIncomeField().setEnabled(false);
                this.sumPanel.getSumPanel().getSumOutcomeField().setText(SumFormatter.format(sum.getSum()));
            } else {
                this.sumPanel.getSumPanel().getSumOutcomeField().setEnabled(true);
                this.sumPanel.getSumPanel().getSumIncomeField().setEnabled(true);
            }
            GuiUtils.requestFocus(this.sumPanel.getSumPanel().getSumIncomeField());
        } else {
            if ("exit".equals(screenName) || "previos".equals(screenName)) {
                this.log.info((Object)LocBundle.getMessageLog((String)"rma.view.gotomainm"));
                this.context.toMainMenu();
                return;
            }
            this.log.info((Object)("---goto->" + screenName + " needSplitPayments=" + this.needSplitPayments));
            AdvancedScreenDescription asd = this.scenario.getScreenById(screenName);
            if (asd != null && asd.getDescription() != null) {
                String type = this.getScreenAlias(asd.getDescription().getType());
                AdvancedScreen as = this.screens.get(type);
                if (as != null) {
                    try {
                        Action before;
                        boolean needShow;
                        if (as instanceof UniversalScreen) {
                            ((UniversalScreen)as).setBankRecords(this.bankRecords);
                            ((UniversalScreen)as).addListener(this.interfaceListener);
                        }
                        if (needShow = as.init(this.menuItem, asd, this.data)) {
                            this.showPanel(as.getPanel());
                        }
                        if ((before = asd.getActionMap().getActionByType("before")) != null) {
                            ActionContext cnt = new ActionContext(this.environment, null, before.getSequence(), this.data, this.menuItem.getService().getId());
                            cnt.execute();
                        }
                    }
                    catch (InitException ex) {
                        ErrorInfo info = new ErrorInfo(LocBundle.getMessage((String)"rma.adv.errscrinit") + " " + screenName, ex.getMessage(), null, null, (Throwable)ex, Level.ALL, null);
                        JXErrorPane.showDialog((Component)this.context.getMainFrame(), (ErrorInfo)info);
                        this.context.toMainMenu();
                    }
                } else {
                    ErrorInfo info = new ErrorInfo(LocBundle.getMessage((String)"rma.adv.erropencsr"), LocBundle.getMessage((String)"rma.adv.ntfndscrwtype") + " " + asd.getDescription().getType(), null, null, null, Level.ALL, null);
                    JXErrorPane.showDialog((Component)this.context.getMainFrame(), (ErrorInfo)info);
                    this.context.toMainMenu();
                }
            } else {
                ErrorInfo info = new ErrorInfo(LocBundle.getMessage((String)"rma.adv.erropencsr"), LocBundle.getMessage((String)"rma.adv.ntfndscrwtype") + " " + screenName, null, null, null, Level.ALL, null);
                JXErrorPane.showDialog((Component)this.context.getMainFrame(), (ErrorInfo)info);
                this.context.toMainMenu();
            }
        }
    }

    private void showPanel(JPanel panel) {
        this.main.setVisible(false);
        this.main.removeAll();
        this.main.add(panel);
        this.main.setVisible(true);
    }

    private void printData(String title, Map<String, Object> map) {
        this.log.info((Object)"===========================================================");
        this.log.info((Object)title);
        for (String key : map.keySet()) {
            this.log.info((Object)("    " + key + " -> " + map.get(key)));
        }
        this.log.info((Object)"====");
    }

    private RmaPaymentJob getJob(Map<String, String> form, Map<String, String> views, Map<String, String> titles) {
        return this.getJob(form, views, titles, DocType.PD4);
    }

    private RmaPaymentJob getJob(Map<String, String> form, Map<String, String> views, Map<String, String> titles, DocType docType) {
        RmaAttribute atr;
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.adv.dopaywdata"));
        this.data.remove("#sum");
        LinkedList<InputElement> fields = new LinkedList<InputElement>();
        for (String key : this.data.keySet()) {
            Object obj = this.data.get(key);
            if (!key.startsWith("#") && obj instanceof InputElement) {
                InputElement ie = (InputElement)obj;
                this.log.info((Object)(key + "->" + ie));
                fields.add(ie);
                continue;
            }
            this.log.error((Object)(LocBundle.getMessageLog((String)"rma.adv.datawrongtype") + " " + key + "->" + obj));
        }
        int sumIncome = SumFormatter.parce(this.sumPanel.getSumPanel().getSumIncomeField().getText(), 0);
        int sumOutcome = SumFormatter.parce(this.sumPanel.getSumPanel().getSumOutcomeField().getText(), 0);
        int sumComm = SumFormatter.parce(this.sumPanel.getSumPanel().getSumCommField().getText(), 0);
        RmaPaymentJob job = new RmaPaymentJob();
        Record record = new Record();
        record.setProviderName(this.menuItem.getService().getProv().getName());
        job.setRecord(record);
        record.setServiceId(this.menuItem.getService().getId());
        record.setServiceName(this.menuItem.getService().getName());
        record.setCommissionId(this.menuItem.getCommission().getId());
        LinkedHashMap<String, RmaAttribute> attrs = new LinkedHashMap<String, RmaAttribute>();
        for (InputElement field : fields) {
            if ("id1".equals(field.getKey()) && field.getValue() != null) {
                record.setAccount(field.getValue());
                record.setAccountTitle(field.getKeyTitle());
                record.setAccountValueTitle(field.getValueTitle());
                continue;
            }
            if ("id2".equals(field.getKey()) && field.getValue() != null) {
                record.setAccount2(field.getValue());
                record.setAccount2Title(field.getKeyTitle());
                record.setAccount2ValueTitle(field.getValueTitle());
                continue;
            }
            if (field.getKey() != null && field.getValue() != null) {
                atr = new RmaAttribute();
                atr.setKey(field.getKey());
                atr.setKeyTitle(field.getKeyTitle());
                atr.setValue(field.getValue());
                atr.setValueTitle(field.getValueTitle());
                attrs.put(atr.getKey(), atr);
                continue;
            }
            this.log.error((Object)("\u041d\u0435\u043a\u043e\u043e\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0430\u0442\u0440\u0438\u0431\u0443\u0442: " + field));
        }
        if (form != null && views != null && titles != null) {
            for (String key : form.keySet()) {
                atr = new RmaAttribute();
                atr.setKey(key);
                atr.setKeyTitle(titles.get(key));
                atr.setValue(form.get(key));
                atr.setValueTitle(views.get(key));
                attrs.put(key, atr);
            }
        }
        record.setAttributes(attrs);
        record.setSumIncome(sumIncome);
        record.setSumOutcome(sumOutcome);
        record.setSumComm(sumComm);
        record.setComment(this.sumPanel.getSumPanel().getCommentField().getText());
        record.setDocType(Configuration.getInstance().getData().getDocType());
        record.setCreated(new Date());
        record.setIdShift(ShiftManager.getInstance().getShiftId());
        job.setPrintDocument(this.sumPanel.getSumPanel().getPrintDocumentCheckBox().isSelected());
        job.setPrintRequest(this.sumPanel.getSumPanel().getPrintRequestCheckBox().isSelected());
        job.setMenuItem(this.menuItem);
        job.setOperatorName(CurrentUser.getInstance().getKassirFio());
        return job;
    }

    private RmaPaymentJob _splitPayments(Map<String, String> form, Map<String, String> views, Map<String, String> titles, DocType docType) throws Exception {
        this.sumPanel.getSumPanel().getPayButton().setEnabled(false);
        LinkedList<Record> records = new LinkedList<Record>();
        LinkedList<InputElement> fields = new LinkedList<InputElement>();
        for (String key : this.data.keySet()) {
            Object obj = this.data.get(key);
            if (!key.startsWith("#") && obj instanceof InputElement) {
                InputElement ie = (InputElement)obj;
                this.log.info((Object)(key + "->" + ie));
                fields.add(ie);
                continue;
            }
            this.log.error((Object)(LocBundle.getMessageLog((String)"rma.adv.datawrongtype") + " " + key + "->" + obj));
        }
        List<Data> nd = this.getNestedData();
        int sumIncome = SumFormatter.parce(this.sumPanel.getSumPanel().getSumIncomeField().getText(), 0);
        int sumOutcome = SumFormatter.parce(this.sumPanel.getSumPanel().getSumOutcomeField().getText(), 0);
        if (!SumPanelHelper.verify(this.context.getMainFrame(), this.menuItem, this.sumPanel.getSumPanel())) {
            this.sumPanel.getSumPanel().getPayButton().setEnabled(true);
            return null;
        }
        short serviceId = this.menuItem.getService().getId();
        short commissionId = this.menuItem.getCommission().getId();
        String providerName = this.menuItem.getService().getProvider();
        Date date = new Date();
        String serviceName = this.menuItem.getService().getName();
        if (this.docSequence == null) {
            this.docSequence = new DocSequence("" + this.references.getPoint().getId());
        }
        short doc = this.docSequence.nextDoc();
        Map mapFields = StoreHelper.convert(fields);
        String control = "" + (mapFields.get("id1") != null ? ((InputElement)mapFields.get("id1")).getValue() : "") + new SimpleDateFormat("ddMMyyyHHmmss").format(date) + SumFormatter.format(sumIncome) + SumFormatter.format(sumOutcome) + SumFormatter.format(sumIncome - sumOutcome);
        CRC32 cs = new CRC32();
        cs.reset();
        cs.update(control.getBytes());
        long crc = cs.getValue();
        int count = 0;
        int sumOutAll = 0;
        int sumCommAll = 0;
        for (Data d : nd) {
            RmaAttribute atr;
            ++count;
            Map map = StoreHelper.convert((List)d.getElements());
            if (map.get("selected") == null || !"1".equals(((InputElement)map.get("selected")).getValue())) continue;
            Record record = new Record();
            record.setServiceId(serviceId);
            record.setServiceName(serviceName);
            record.setCommissionId(commissionId);
            record.setDoc(doc);
            record.setCreated(date);
            record.setIdShift(ShiftManager.getInstance().getShiftId());
            LinkedHashMap<String, RmaAttribute> attrs = new LinkedHashMap<String, RmaAttribute>();
            for (InputElement field : fields) {
                if ("id1".equals(field.getKey()) && field.getValue() != null) {
                    record.setAccount(field.getValue());
                    record.setAccountTitle(field.getKeyTitle());
                    record.setAccountValueTitle(field.getValueTitle());
                    continue;
                }
                if ("id2".equals(field.getKey()) && field.getValue() != null) {
                    record.setAccount2(field.getValue());
                    record.setAccount2Title(field.getKeyTitle());
                    record.setAccount2ValueTitle(field.getValueTitle());
                    continue;
                }
                if (field.getKey() != null && field.getValue() != null) {
                    atr = new RmaAttribute();
                    atr.setKey(field.getKey());
                    atr.setKeyTitle(field.getKeyTitle());
                    atr.setValue(field.getValue());
                    atr.setValueTitle(field.getValueTitle());
                    attrs.put(atr.getKey(), atr);
                    continue;
                }
                this.log.error((Object)("\u041d\u0435\u043a\u043e\u043e\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0430\u0442\u0440\u0438\u0431\u0443\u0442: " + field));
            }
            if (form != null && views != null && titles != null) {
                for (String key : form.keySet()) {
                    atr = new RmaAttribute();
                    atr.setKey(key);
                    atr.setKeyTitle(titles.get(key));
                    atr.setValue(form.get(key));
                    atr.setValueTitle(views.get(key));
                    attrs.put(key, atr);
                }
            }
            boolean overwrite = this.paymentParams != null && this.paymentParams.isFirstParamsContext();
            for (InputElement ie : d.getElements()) {
                RmaAttribute atr2;
                if ("summ".equals(ie.getKey()) && ie.getValue() != null) {
                    record.setSumOutcome(SumFormatter.parce(ie.getValue().replace(",", ".")));
                    continue;
                }
                if (ie.getKey() == null || ie.getValue() == null) continue;
                if ("id1".equals(ie.getKey()) && overwrite) {
                    record.setAccount(ie.getValue());
                    record.setAccountTitle(ie.getKeyTitle());
                    record.setAccountValueTitle(ie.getValueTitle());
                    continue;
                }
                if ("id2".equals(ie.getKey()) && overwrite) {
                    record.setAccount2(ie.getValue());
                    record.setAccount2Title(ie.getKeyTitle());
                    record.setAccount2ValueTitle(ie.getValueTitle());
                    continue;
                }
                if (attrs.get(ie.getKey()) == null) {
                    atr2 = new RmaAttribute();
                    atr2.setKey(ie.getKey());
                    atr2.setKeyTitle(ie.getKeyTitle());
                    atr2.setValue(ie.getValue());
                    atr2.setValueTitle(ie.getValueTitle());
                    attrs.put(atr2.getKey(), atr2);
                    continue;
                }
                if (!overwrite) continue;
                atr2 = new RmaAttribute();
                atr2.setKey(ie.getKey());
                atr2.setKeyTitle(ie.getKeyTitle());
                atr2.setValue(ie.getValue());
                atr2.setValueTitle(ie.getValueTitle());
                attrs.put(atr2.getKey(), atr2);
            }
            if (this.needGroupPaymentDividedCommission) {
                record.setSumIncome(CommissionCalculator.calculateIncome(record.getSumOutcome(), this.menuItem.getCommission(), this.menuItem.getService().getCommission(), this.menuItem.getService().getMinCommission(), null, null));
                record.setSumComm(record.getSumIncome() - record.getSumOutcome());
            } else if (count == 1) {
                int sumIncomeForFirstPayment = 0;
                int sumCommForPayment = sumIncome - sumOutcome;
                sumIncomeForFirstPayment = record.getSumOutcome() + sumCommForPayment;
                record.setSumIncome(sumIncomeForFirstPayment);
                record.setSumComm(sumCommForPayment);
            } else {
                record.setSumIncome(record.getSumOutcome());
                record.setSumComm(0);
            }
            record.setAttributes(attrs);
            record.setComment(this.sumPanel.getSumPanel().getCommentField().getText());
            record.setDocType(Configuration.getInstance().getData().getDocType());
            record.setState((short)0);
            record.setSubstate((short)0);
            record.setLocalState((short)-5);
            record.setId(-1L);
            record.setSumFee(this.menuItem.getFee() != null ? (long)CommissionCalculator.calculateFee(record.getSumOutcome(), this.menuItem.getFee()) : 0L);
            record.setCrc(crc);
            records.add(record);
            sumOutAll += record.getSumOutcome();
            sumCommAll += record.getSumComm();
        }
        RmaPaymentJob job = new RmaPaymentJob(records);
        job.setPrintDocument(this.sumPanel.getSumPanel().getPrintDocumentCheckBox().isSelected());
        job.setPrintRequest(this.sumPanel.getSumPanel().getPrintRequestCheckBox().isSelected());
        job.setMenuItem(this.menuItem);
        job.setSumOutAll(sumOutAll);
        job.setSumCommAll(sumCommAll);
        RmaPaymentJob tempJob = this.getJob(form, views, titles);
        tempJob.getRecord().setCrc(crc);
        tempJob.getRecord().setDocType(Configuration.getInstance().getData().getDocType());
        tempJob.getRecord().setCreated(date);
        tempJob.getRecord().setDoc(doc);
        tempJob.getRecord().setSumComm(tempJob.getRecord().getSumIncome() - tempJob.getRecord().getSumOutcome());
        tempJob.getRecord().setSumFee(this.menuItem.getFee() != null ? (long)CommissionCalculator.calculateFee(tempJob.getRecord().getSumOutcome(), this.menuItem.getFee()) : 0L);
        job.setRecord(tempJob.getRecord());
        return job;
    }

    private List<Data> getNestedData() {
        List nd = (List)this.data.get("#services");
        return nd;
    }

    private void checkFields(Map<String, Object> inputElements, Map<String, String> form, Map<String, String> views, Map<String, String> titles, boolean userReplaces, List<ControlData> data) throws Exception {
        SelectorItem tsi;
        SelectorField textSelector;
        TextField inputField;
        Field ff;
        if (!this.showAll) {
            throw new Exception(LocBundle.getMessageEx((String)"rma.prov.feelall"));
        }
        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.univers.workflds") + " "));
        HashMap<String, String> tvs = new HashMap<String, String>();
        for (ControlData cd : data) {
            ff = cd.getField();
            if (ff instanceof TextField) {
                inputField = (TextField)ff;
                tvs.put(inputField.getId(), (String)cd.getData());
                continue;
            }
            if (!(ff instanceof SelectorField)) continue;
            textSelector = (SelectorField)ff;
            tsi = (SelectorItem)cd.getData();
            tvs.put(textSelector.getId(), tsi == null ? "" : tsi.getValue());
        }
        for (ControlData cd : data) {
            this.log.info((Object)("\t" + cd));
            ff = cd.getField();
            if (ff instanceof TextField) {
                inputField = (TextField)ff;
                String number = (String)cd.getData();
                boolean valid = false;
                if (inputField.getValidator() != null) {
                    valid = inputField.getValidator().validate(number);
                }
                if (!valid) {
                    GuiUtils.requestFocus(cd.getComponent());
                    if (inputField.getExampleValue() != null && !inputField.getExampleValue().trim().isEmpty()) {
                        throw new Exception(MessageFormat.format(LocBundle.getMessageEx((String)"rma.prov.wrongnumb2"), inputField.getTitle(), inputField.getExampleValue()));
                    }
                    throw new Exception(MessageFormat.format(LocBundle.getMessageEx((String)"rma.prov.wrongnumb"), inputField.getTitle()));
                }
                inputElements.put(inputField.getId(), new InputElement(inputField.getId(), inputField.getTitle(), number, ((MultipleMaskTextField)cd.getComponent()).getTextTitle(), inputField.getFlags()));
                form.put(inputField.getId(), number);
                if (views != null) {
                    views.put(inputField.getId(), number);
                }
                if (titles == null) continue;
                titles.put(inputField.getId(), inputField.getTitle());
                continue;
            }
            if (ff instanceof SelectorField) {
                textSelector = (SelectorField)ff;
                if (cd.getData() == null) {
                    GuiUtils.requestFocus(cd.getComponent());
                    throw new Exception(MessageFormat.format(LocBundle.getMessageEx((String)"rma.prov.wrongnumb"), textSelector.getTitle()));
                }
                tsi = (SelectorItem)cd.getData();
                inputElements.put(textSelector.getId(), new InputElement(textSelector.getId(), textSelector.getTitle(), tsi.getValue(), tsi.getTitle(), textSelector.getFlags()));
                form.put(textSelector.getId(), tsi.getValue());
                if (views != null) {
                    views.put(textSelector.getId(), tsi.getTitle());
                }
                if (titles == null) continue;
                titles.put(textSelector.getId(), textSelector.getTitle());
                continue;
            }
            if (!(ff instanceof SetField)) continue;
            SetField sf = (SetField)ff;
            form.put(sf.getId(), sf.getValue());
            if (views != null) {
                views.put(sf.getId(), sf.getValue());
            }
            if (titles != null) {
                titles.put(sf.getId(), sf.getTitle());
            }
            String val = sf.getValue() == null ? "" : sf.getValue();
            for (String key : tvs.keySet()) {
                val = val.replace("${" + key + "}", (CharSequence)tvs.get(key));
            }
            if (("id1".equals(sf.getId()) || "id2".equals(sf.getId())) && val.length() > 40) {
                val = val.substring(0, 40);
            }
            inputElements.put(sf.getId(), new InputElement(sf.getId(), sf.getTitle(), val, val, sf.getFlags()));
        }
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.univers.resform"));
        for (String key : form.keySet()) {
            this.log.info((Object)("\t" + key + "->" + form.get(key) + (views != null ? ",view=" + views.get(key) : "") + (titles != null ? ",title=" + titles.get(key) : "")));
        }
    }

    private void checkBikAccount(List<ControlData> data) throws Exception {
        block6: {
            String bik = null;
            String account = null;
            JComponent accountComponent = null;
            for (ControlData cd : data) {
                Field ff = cd.getField();
                if (!(ff instanceof TextField)) continue;
                TextField inputField = (TextField)ff;
                if ("recipient_acc".equals(inputField.getId())) {
                    account = (String)cd.getData();
                    accountComponent = cd.getComponent();
                }
                if (!"corr_bik".equals(inputField.getId())) continue;
                bik = (String)cd.getData();
            }
            if (bik != null && account != null) {
                try {
                    BankRecord rec = this.bankRecords.get(bik);
                    if (!BikAccountVerifier.verify(bik, account, rec != null && (rec.getKs() == null || rec.getKs().trim().isEmpty()) ? 1 : 2)) {
                        throw new Exception(LocBundle.getMessageEx((String)"provider.pd4.bikaccountnotvalid"));
                    }
                    break block6;
                }
                catch (Exception e) {
                    GuiUtils.requestFocus(accountComponent);
                    throw e;
                }
            }
            this.log.error((Object)LocBundle.getMessageLog((String)"provider.pd4.bikorrsnotfound"));
        }
    }

    private List<IdentityField> getCurrentFields() {
        if (this.data.get("#need-more-fields") != null || this.verifiedIElements != null && this.verifiedIElements.get("#need-more-fields") != null) {
            System.out.println("#need-more-fields");
            LinkedList<IdentityField> flds = new LinkedList<IdentityField>();
            flds.addAll(this.sum3Fields.values());
            return flds;
        }
        boolean fields1 = false;
        boolean fields2 = false;
        int sumOutcome = SumFormatter.parce(this.sumPanel.getSumPanel().getSumOutcomeField().getText(), 0);
        if (this.sum2 != null && sumOutcome >= this.sum2) {
            fields2 = true;
        } else if (this.sum1 != null && (sumOutcome >= this.sum1 || this.needIdentification)) {
            fields1 = true;
        }
        LinkedList<IdentityField> flds = new LinkedList<IdentityField>();
        if (fields2) {
            flds.addAll(this.sum2Fields.values());
        } else if (fields1) {
            flds.addAll(this.sum1Fields.values());
        }
        return flds;
    }

    private Map<Field, Object> getCurrentValues(Map<Field, Object> values) {
        HashMap<Field, Object> cardValues = new HashMap<Field, Object>();
        for (Field ff : values.keySet()) {
            if (!(ff instanceof IdentityField)) continue;
            IdentityField iff = (IdentityField)ff;
            Field ff1 = (Field)this.sum1Fields.get(iff.getId());
            if (ff1 != null) {
                this.sum1Values.put(ff1, values.get(ff));
            }
            if ((ff1 = (Field)this.sum2Fields.get(iff.getId())) != null) {
                this.sum2Values.put(ff1, values.get(ff));
            }
            if ((ff1 = (Field)this.sum3Fields.get(iff.getId())) != null) {
                this.sum3Values.put(ff1, values.get(ff));
            }
            if ((ff1 = (Field)this.cardFields.get(iff.getId())) == null) continue;
            cardValues.put(ff1, values.get(ff));
        }
        values.putAll(this.sum1Values);
        values.putAll(this.sum2Values);
        values.putAll(this.sum3Values);
        values.putAll(cardValues);
        return values;
    }

    public String getScreenAlias(String path) {
        if (this.aliases.get(path) != null) {
            this.log.info((Object)("Alias found: " + path));
            return this.aliases.get(path);
        }
        String[] parts = path.split("/");
        if (this.aliases.get(parts[0]) != null) {
            this.log.info((Object)("Alias found: " + path));
            return this.aliases.get(parts[0]);
        }
        if (this.screens.get(parts[0]) != null) {
            this.log.info((Object)("Screen found: " + path));
            return parts[0];
        }
        return path;
    }

    private class LocalPrintRequestListener
    implements ActionListener {
        String comment;

        private LocalPrintRequestListener() {
            this.comment = AdvancedProvider.this.currentJob != null ? AdvancedProvider.this.currentJob.getRecord().getComment() : null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SumPanelHelper.verify(AdvancedProvider.this.context.getMainFrame(), AdvancedProvider.this.menuItem, AdvancedProvider.this.sumPanel.getSumPanel())) {
                AdvancedProvider.this.sumPanel.getSumPanel().getPrintButton().setEnabled(true);
                AdvancedProvider.this.sumPanel.getSumPanel().getPayButton().setEnabled(false);
                return;
            }
            if (AdvancedProvider.this.isFieldsChanged) {
                RmaCancelOperationDialog dialog = new RmaCancelOperationDialog((Frame)AdvancedProvider.this.context.getMainFrame(), true);
                dialog.setTitle(LocBundle.getMessage((String)"rma.canseloperating.postprintchanges"));
                dialog.setVisible(true);
                if (dialog.isCanselled()) {
                    AdvancedProvider.this.log.info((Object)"\u0423\u043d\u0438\u0432\u0435\u0440\u0441\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440, \u041a\u0430\u0441\u0441\u0438\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b\u0441\u044f \u043e\u0442 \u043e\u0442\u043c\u0435\u043d\u044b \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438");
                    return;
                }
                this.comment = dialog.getComment();
                AdvancedProvider.this.isFieldsChanged = false;
            }
            AdvancedProvider.this.log.info((Object)LocBundle.getMessageLog((String)"rma.beginprintrequest"));
            LinkedHashMap form = new LinkedHashMap();
            LinkedHashMap views = new LinkedHashMap();
            LinkedHashMap titles = new LinkedHashMap();
            LinkedHashMap<String, Object> inputElements = new LinkedHashMap<String, Object>();
            try {
                AdvancedProvider.this.checkFields(inputElements, form, views, titles, false, AdvancedProvider.this.sumPanel.getData());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(AdvancedProvider.this.context.getMainFrame(), ex.getMessage(), LocBundle.getMessageLog((String)"rma.view.verifyerr"), 0);
                return;
            }
            if (AdvancedProvider.this.menuItem.getService().getVerifyType() == 0) {
                AdvancedProvider.this.log.info((Object)"\u0414\u0435\u043b\u0430\u044e \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438");
                AdvancedProvider.this.context.toVerify(AdvancedProvider.this.menuItem.getService().getId(), inputElements, new VerifyAfterPayResultListener(this.comment), true);
            } else {
                AdvancedProvider.this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0431\u0435\u0437 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438");
                RmaPaymentJob job = AdvancedProvider.this.getJob(form, views, titles, null);
                job.setPrintMode(PrintMode.PrintCopy);
                job.getRecord().setPrintInfo(3);
                AdvancedProvider.this.currentJob = job;
                AdvancedProvider.this.currentJob.getRecord().setComment(this.comment);
                AdvancedProvider.this.context.addRequestPrint(new RequestData(job, AdvancedProvider.this.references), AdvancedProvider.this.printResultListener);
            }
        }
    }

    private class LocalSumPrevActionListener
    implements ActionListener {
        private LocalSumPrevActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AdvancedProvider.this.prevScreen != null) {
                AdvancedProvider.this.showScreen(AdvancedProvider.this.prevScreen);
                AdvancedProvider.this.sumPanel.getSumPanel().getPrintButton().setEnabled(true);
                AdvancedProvider.this.sumPanel.getSumPanel().getPayButton().setEnabled(false);
            }
        }
    }

    private class LocalSumOutcomeFieldsListener
    implements Runnable {
        private int value = 0;

        private LocalSumOutcomeFieldsListener() {
        }

        @Override
        public void run() {
            int sumOutcome = SumFormatter.parce(AdvancedProvider.this.sumPanel.getSumPanel().getSumOutcomeField().getText(), 0);
            if (AdvancedProvider.this.sum1 != null && AdvancedProvider.this.sum2 != null) {
                boolean needReinit;
                boolean bl = needReinit = this.value < AdvancedProvider.this.sum1 && sumOutcome >= AdvancedProvider.this.sum1 || this.value < AdvancedProvider.this.sum2 && sumOutcome >= AdvancedProvider.this.sum2 || this.value >= AdvancedProvider.this.sum1 && sumOutcome < AdvancedProvider.this.sum1 || this.value >= AdvancedProvider.this.sum2 && sumOutcome < AdvancedProvider.this.sum2;
                if (needReinit) {
                    this.value = sumOutcome;
                    Component focusOwner = FocusManager.getCurrentManager().getFocusOwner();
                    AdvancedProvider.this.sumPanel.reinitFields(null);
                    if (focusOwner instanceof JComponent) {
                        GuiUtils.requestFocus((JComponent)focusOwner);
                    }
                }
            }
        }
    }

    private class VerifyClientListener
    implements VerifyResultListener {
        private VerifyClientListener() {
        }

        @Override
        public void onVerifyResultError(String error) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void onVerifyResult(VerifyResult result, Map<String, Object> ielements) {
        }
    }

    private class LocalCheckButtonListener
    implements ActionListener {
        private LocalCheckButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SumPanelHelper.verify(AdvancedProvider.this.context.getMainFrame(), AdvancedProvider.this.menuItem, AdvancedProvider.this.sumPanel.getSumPanel())) {
                AdvancedProvider.this.sumPanel.getSumPanel().getPayButton().setEnabled(false);
                AdvancedProvider.this.sumPanel.getSumPanel().getPrintButton().setEnabled(true);
                return;
            }
            LinkedHashMap form = new LinkedHashMap();
            LinkedHashMap views = new LinkedHashMap();
            LinkedHashMap titles = new LinkedHashMap();
            LinkedHashMap<String, Object> inputElements = new LinkedHashMap<String, Object>();
            try {
                AdvancedProvider.this.checkFields(inputElements, form, views, titles, false, AdvancedProvider.this.sumPanel.getData());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(AdvancedProvider.this.context.getMainFrame(), ex.getMessage(), LocBundle.getMessageLog((String)"rma.view.verifyerr"), 0);
                return;
            }
            AdvancedProvider.this.log.info((Object)LocBundle.getMessageLog((String)"rma.mobile.ndonlineverfio"));
            AdvancedProvider.this.context.toVerify(AdvancedProvider.this.menuItem.getService().getId(), inputElements, null, false);
        }
    }

    private class LocalInterfaceListener
    implements InterfaceListener {
        private LocalInterfaceListener() {
        }

        @Override
        public void onChange(final Map<Field, Object> values) {
            Logger logUni = Logger.getLogger((String)"uni");
            logUni.info((Object)(LocBundle.getMessageLog((String)"rma.univers.newctrlsst") + " "));
            Integer sumPurchase = null;
            for (Field ff : values.keySet()) {
                SelectorItem tsi;
                logUni.info((Object)("\t" + ff + "->" + values.get(ff)));
                if (!(ff instanceof SelectorField) || (tsi = (SelectorItem)values.get(ff)).getData() == null || tsi.getData().getSum() == null) continue;
                sumPurchase = tsi.getData().getSum().getSum();
                AdvancedProvider.this.log.info((Object)(LocBundle.getMessageLog((String)"rma.univers.setnewsumm") + " " + sumPurchase));
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AdvancedProvider.this.log.info((Object)"\u0412\u044b\u0432\u043e\u0436\u0443 \u043f\u043e\u043b\u044f");
                    AdvancedProvider.this.showAll = AdvancedProvider.this.sumPanel.showFields(AdvancedProvider.this.getCurrentFields(), AdvancedProvider.this.getCurrentValues(values));
                    if (AdvancedProvider.this.references.getPoint().getTypeCashSourcePoint() != 1) {
                        AdvancedProvider.this.showAll = AdvancedProvider.this.showAll && AdvancedProvider.this.sumPanel.showCardFields(AdvancedProvider.this.cardFields.values(), AdvancedProvider.this.getCurrentValues(values));
                    }
                    AdvancedProvider.this.log.debug((Object)(AdvancedProvider.this.showAll ? LocBundle.getMessageLog((String)"rma.univers.showallflds") : LocBundle.getMessageLog((String)"rma.univers.showntallflds")));
                }
            });
        }

        @Override
        public void setNeedIdentification(boolean _needIdentification) {
            AdvancedProvider.this.needIdentification = _needIdentification;
        }

        @Override
        public void onChangeClientField(String idField, String valueField) {
            AdvancedProvider.this.log.info((Object)LocBundle.getMessageLog((String)"rma.mobile.ndonlineverfio"));
            HashMap<String, Object> ielements = new HashMap<String, Object>();
            ielements.put("id1", new InputElement("id1", "id1", "id1", "id1", 0));
            ielements.put(idField, new InputElement(idField, idField, valueField, valueField, 0));
            AdvancedProvider.this.context.toVerify(AdvancedProvider.this.menuItem.getService().getId(), ielements, new VerifyClientListener(), false);
        }

        @Override
        public void setNeedBudgetFields(boolean _needBudgetFields) {
            AdvancedProvider.this.needBudgetFields = _needBudgetFields;
        }
    }

    private class ScreenListener
    implements AdvancedScreenListener {
        private ScreenListener() {
        }

        @Override
        public void onAction(ScreenDescription screen, Runnable cancelListener, Action action, Map<String, Object> localData) {
            AdvancedProvider.this.log.info((Object)MessageFormat.format(LocBundle.getMessageLog((String)"rma.adv.reqtask"), screen.getType(), action));
            localData.put("#from", screen.getId());
            AdvancedProvider.this.printData(LocBundle.getMessageLog((String)"rma.adv.dataafrinput") + " ", localData);
            ActionContext context = new ActionContext(AdvancedProvider.this.environment, cancelListener, action.getSequence(), ContextHelper.mergeData((Map)AdvancedProvider.this.data, localData), AdvancedProvider.this.menuItem.getService().getId());
            context.execute();
        }
    }

    private class LocalEnviroment
    extends SimpleEnvironment {
        private LocalEnviroment() {
        }

        public void showDialog(final DialogAction dialogAction) {
            AdvancedProvider.this.log.info((Object)LocBundle.getMessageLog((String)"rma.adv.showdlg"));
            if (AdvancedProvider.this.dialog == null) {
                AdvancedProvider.this.dialog = new Dialog((Frame)AdvancedProvider.this.context.getMainFrame(), true);
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AdvancedProvider.this.dialog.setLocationRelativeTo(AdvancedProvider.this.context.getMainFrame());
                    AdvancedProvider.this.dialog.show(dialogAction);
                }
            });
        }

        public void showScreen(String screen, Map<String, Object> screenData) {
            AdvancedProvider.this.printData(LocBundle.getMessageLog((String)"rma.adv.dataafrscript") + " ", screenData);
            if (screen != null) {
                if (screenData != null) {
                    AdvancedProvider.this.data.putAll(screenData);
                    LinkedHashMap result = new LinkedHashMap();
                    for (String key : AdvancedProvider.this.data.keySet()) {
                        if (AdvancedProvider.this.data.get(key) == null) continue;
                        result.put(key, AdvancedProvider.this.data.get(key));
                    }
                    AdvancedProvider.this.data = result;
                }
                AdvancedProvider.this.printData(LocBundle.getMessageLog((String)"rma.adv.datagarr") + " ", AdvancedProvider.this.data);
                AdvancedProvider.this.showScreen(screen);
            }
        }

        public void showError(Exception ex) {
            AdvancedProvider.this.log.error((Object)(LocBundle.getMessageLog((String)"rma.adv.waserr") + " "), (Throwable)ex);
            ErrorInfo info = new ErrorInfo(LocBundle.getMessage((String)"rma.adv.errscript"), ex.getMessage(), null, null, (Throwable)ex, Level.ALL, null);
            JXErrorPane.showDialog((Component)AdvancedProvider.this.context.getMainFrame(), (ErrorInfo)info);
        }

        public void execute(AsyncTask task) {
            AdvancedProvider.this.log.info((Object)(LocBundle.getMessageLog((String)"rma.adv.dotask") + " " + task));
            AdvancedProvider.this.context.getTaskExecutor().execute(new TaskAdapter(task));
        }

        public ServerConnector getConnector() {
            return new ConnectorAdapter(AdvancedProvider.this.context.getConnector());
        }

        public void openService(int serviceId) {
            AdvancedProvider.this.context.openService(serviceId);
        }

        public void openService(short serviceId, Map<String, Object> map) {
            AdvancedProvider.this.context.openService(serviceId, map);
        }

        public AdvancedCommissionCalculator getCommissionCalculator() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public AdvancedHardwareApi getHardwareApi() {
            return new AdvancedHardwareApi(){

                public SmartCardHandler getSmartCardHandler() {
                    return null;
                }

                public CardReaderHandler getCardReaderHandler() {
                    return null;
                }

                public CardDispenserHandler getCardDispenserHandler() {
                    return null;
                }

                public Printer getPrinter() {
                    return new Printer(){

                        public void printCustom(String templateName, Map<String, Object> data) {
                            CustomData customData = new CustomData(templateName, data);
                            customData.setMenuItem(AdvancedProvider.this.menuItem);
                            AdvancedProvider.this.context.addCustomPrint(customData);
                        }
                    };
                }
            };
        }

        public InputElement getValue(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getOffer(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Map<String, String> getPointParams() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Short getOperator(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void handleError(Exception excptn) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void openUrl(String string, OpenUrlTarget out, MethodType mt, String string1, Map<String, String> map) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class VerifyAfterPayResultListener
    implements VerifyResultListener {
        String comment;

        public VerifyAfterPayResultListener(String comment) {
            this.comment = comment;
        }

        @Override
        public void onVerifyResultError(String error) {
        }

        @Override
        public void onVerifyResult(VerifyResult result, Map<String, Object> ielements) {
            if (result.getRt() == VerifyResultType.OK) {
                AdvancedProvider.this.log.info((Object)"\u0421 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0432\u0435\u0440\u043d\u0443\u043b\u0441\u044f \u0443\u0441\u043f\u0435\u0445, \u043e\u0442\u043a\u0440\u044b\u0432\u0430\u044e \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u043f\u0435\u0440\u0435\u043d\u043e\u0441\u0430 \u0432 \u043a\u043e\u0440\u0437\u0438\u043d\u0443");
                LinkedHashMap form = new LinkedHashMap();
                LinkedHashMap views = new LinkedHashMap();
                LinkedHashMap titles = new LinkedHashMap();
                LinkedHashMap inputElements = new LinkedHashMap();
                try {
                    AdvancedProvider.this.checkFields(inputElements, form, views, titles, false, AdvancedProvider.this.sumPanel.getData());
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(AdvancedProvider.this.context.getMainFrame(), ex.getMessage(), LocBundle.getMessageLog((String)"rma.view.verifyerr"), 0);
                    return;
                }
                RmaPaymentJob job = AdvancedProvider.this.getJob(form, views, titles, null);
                job.setPrintMode(PrintMode.PrintCopy);
                job.getRecord().setPrintInfo(3);
                AdvancedProvider.this.currentJob = job;
                AdvancedProvider.this.currentJob.getRecord().setComment(this.comment);
                AdvancedProvider.this.context.addRequestPrint(new RequestData(job, AdvancedProvider.this.references), AdvancedProvider.this.printResultListener);
            }
        }
    }

    private class ProcessActionListener
    implements ActionListener {
        private ProcessActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (AdvancedProvider.this.currentJob == null) {
                    throw new IllegalArgumentException("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0440\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u043f\u043b\u0430\u0442\u0451\u0436\u043d\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
                }
                if (!SumPanelHelper.verify(AdvancedProvider.this.context.getMainFrame(), AdvancedProvider.this.menuItem, AdvancedProvider.this.sumPanel.getSumPanel())) {
                    AdvancedProvider.this.sumPanel.getSumPanel().getPrintButton().setEnabled(true);
                    AdvancedProvider.this.sumPanel.getSumPanel().getPayButton().setEnabled(false);
                    return;
                }
                LinkedHashMap form = new LinkedHashMap();
                LinkedHashMap views = new LinkedHashMap();
                LinkedHashMap titles = new LinkedHashMap();
                LinkedHashMap inputElements = new LinkedHashMap();
                AdvancedProvider.this.checkFields(inputElements, form, views, titles, true, AdvancedProvider.this.sumPanel.getData());
                AdvancedProvider.this.context.toPayment(AdvancedProvider.this.currentJob);
                AdvancedProvider.this.context.clearPrintedOperationData();
            }
            catch (Exception ex) {
                AdvancedProvider.this.sumPanel.getSumPanel().getPayButton().setEnabled(true);
                AdvancedProvider.this.log.info((Object)(LocBundle.getMessageLog((String)"rma.adv.dopayerr") + " "), (Throwable)ex);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(AdvancedProvider.this.context.getMainFrame(), ex.getMessage(), LocBundle.getMessage((String)"rma.adv.dopayerr"), 0);
                    }
                });
            }
        }
    }

    public class LocalChangedFieldsListener
    implements FildsChangedListener {
        @Override
        public void fieldsChanged() {
            AdvancedProvider.this.isFieldsChanged = AdvancedProvider.this.isPrinted;
        }
    }

    private class ProcessExitListener
    implements ActionListener {
        private ProcessExitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AdvancedProvider.this.log.info((Object)("\u0423\u0441\u043e\u0432\u0435\u0440\u0448\u0435\u043d\u0441\u0442\u0432\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440, \u0424\u043b\u0430\u0433 \u043f\u0435\u0447\u0430\u0442\u0438 = " + AdvancedProvider.this.isPrinted));
            if (AdvancedProvider.this.isPrinted && AdvancedProvider.this.currentJob != null) {
                RmaCancelOperationDialog dialog = new RmaCancelOperationDialog((Frame)AdvancedProvider.this.context.getMainFrame(), true);
                dialog.setTitle(LocBundle.getMessage((String)"rma.canseloperating.actuallycancel"));
                dialog.setVisible(true);
                if (dialog.isCanselled()) {
                    AdvancedProvider.this.log.info((Object)"\u0423\u043d\u0438\u0432\u0435\u0440\u0441\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440, \u041a\u0430\u0441\u0441\u0438\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b\u0441\u044f \u0432\u0432\u043e\u0434\u0438\u0442\u044c \u043f\u0440\u0438\u0447\u0438\u043d\u044b \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438");
                    return;
                }
                String comment = dialog.getComment();
                AdvancedProvider.this.log.info((Object)("\u0423\u0441\u043e\u0432\u0435\u0440\u0448\u0435\u043d\u0441\u0442\u0432\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440, \u041a\u0430\u0441\u0441\u0438\u0440 \u0432\u0432\u0451\u043b " + comment));
                try {
                    AdvancedProvider.this.currentJob.getRecord().setComment(comment);
                    AdvancedProvider.this.currentJob.getRecord().setState((short)80);
                    AdvancedProvider.this.currentJob.getRecord().setSubstate((short)2);
                    if (AdvancedProvider.this.currentJob.getRecord().getAccount() == null) {
                        AdvancedProvider.this.currentJob.getRecord().setAccount("");
                    }
                    PersistenceManager.getInstance().canselByCart(AdvancedProvider.this.currentJob.getRecord(), CurrentUser.getInstance().getUserId());
                    AdvancedProvider.this.context.clearPrintedOperationData();
                }
                catch (PersistenceException ex) {
                    AdvancedProvider.this.log.error((Object)"\u0423\u0441\u043e\u0432\u0435\u0440\u0448\u0435\u043d\u0441\u0442\u0432\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440, \u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043c\u0435\u043d\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u043e\u0442 \u043e\u0442\u043a\u0430\u0437\u0435", (Throwable)ex);
                }
            }
            AdvancedProvider.this.context.toMainMenu();
        }
    }
}

